/*----------------------------------------------------------------------
 *			 TMS340 Graphics Library
 *       Copyright (c) 1987-1990 Texas Instruments Incorporated.
 *                         All Rights Reserved
 *----------------------------------------------------------------------
 * Demonstration Program
 *
 *   Test pie arc functions.  This program tests the pen_piearc and
 *   fill_piearc functions.  It draws a pie chart with one slice
 *   displaced from the rest of the pie.  The pie is drawn to appear
 *   three dimensional, more or less.
 *----------------------------------------------------------------------
 * Revision History:
 *   03/23/87...Original version written...................J.R. Van Aken
 *   07/02/87...Modified for redefined arc functions.......J.R. Van Aken
 *   03/27/90...Modified for general portability...........J.R. Van Aken
 *----------------------------------------------------------------------
 */
#include <gsptypes.h>
#include "patterns.h"

/* If MODE not defined at preprocessor command line, set to default. */
#ifndef  MODE
#define  MODE	  0	  /* default graphics mode */
#endif

#define  NCOLORS  12	  /* number of colors used */
#define  NSLICES  8	  /* number of pie slices */

typedef struct { short theta, arc; } PIESLICE;	/* pie slice angles */

static CONFIG cfg;

static PALET palet[NCOLORS] = {
    { 0x00, 0x00, 0x00, 0x00 }, 	/*  0 = black	      */
    { 0x00, 0xFF, 0x00, 0x00 }, 	/*  1 = green	      */
    { 0xFF, 0xAA, 0x00, 0x00 }, 	/*  2 = yellow-orange */
    { 0xFF, 0x00, 0x00, 0x00 }, 	/*  3 = red	      */
    { 0x00, 0x00, 0x99, 0x00 }, 	/*  4 = dark blue     */
    { 0x00, 0x00, 0xFF, 0x00 }, 	/*  5 = blue	      */
    { 0xFF, 0x00, 0xFF, 0x00 }, 	/*  6 = magenta       */
    { 0x77, 0xAA, 0xFF, 0x00 }, 	/*  7 = cyan	      */
    { 0xBB, 0x77, 0x11, 0x00 }, 	/*  8 = brown	      */
    { 0x66, 0x66, 0x66, 0x66 }, 	/*  9 = dark gray     */
    { 0xBB, 0xBB, 0xBB, 0xBB }, 	/* 10 = light gray    */
    { 0xFF, 0xFF, 0xFF, 0xFF }		/* 11 = white	      */
};

/* Define shape of each slice of pie. */
static PIESLICE pieslice[NSLICES] =
{
    { 258,  49 },
    { 307,  23 },
    { 330,  70 },
    { 400,  35 },
    { 161,  97 },
    { 131,  30 },
    {  98,  33 },
    { 435,  23 },
};


main()
{
    int hres, vres, i, j, k, w, h, x, y, xin, xout, theta, arc;

    /* Initialize graphics environment. */
    if (!set_config(MODE, 1))
	exit(1);		 /* invalid graphics mode number */
    clear_screen(0);  /* black */
    set_palet(NCOLORS, 0, palet);
    get_config(&cfg);
    hres = cfg.mode.disp_hres;	 /* horizontal resolution */
    vres = cfg.mode.disp_vres;	 /* vertical resolution */

    /* Draw patterned border around screen. */
    if (cfg.mode.palet_size >= NCOLORS)
	set_colors(9, 10);	 /* dark and light gray */
    else
	set_colors(1, 0);	 /* black and white */
    j = hres/256;
    current_patn.data = (PTR)&patnbits[0];
    set_patn(&current_patn);
    patnframe_rect(hres+15&~15, vres+15&~15, 0, 0, j*16, j*16);

    /* Adjust dimensions of pie chart to screen dimensions. */
    w = 3*hres/4;
    h = 2*vres/5;
    k = vres/5;
    xin = hres/12;
    xout = hres - xin - w;
    y = 2*vres/7;

    /* Draw eight pie slices. */
    for (i = 0; i < NSLICES; i++) {
	x = (i == 2) ? xout : xin;  /* pull slice #2 out to right */
	set_pensize(1, k);
	if (cfg.mode.palet_size >= NCOLORS) {	 /* color display */
	    set_fcolor(i+1);
	    pen_piearc(w, h, x, y, pieslice[i].theta, pieslice[i].arc);
	    fill_piearc(w, h, x, y, pieslice[i].theta, pieslice[i].arc);
	} else {				 /* not enough colors */
	    current_patn.data = (PTR)&patnbits[i+15];
	    set_patn(&current_patn);
	    patnpen_piearc(w, h, x, y, pieslice[i].theta,
							pieslice[i].arc);
	    patnfill_piearc(w, h, x, y, pieslice[i].theta,
							pieslice[i].arc);
	}
	set_fcolor(11);  /* white */
	set_pensize(j, j);
	pen_piearc(w, h, x, y, pieslice[i].theta, pieslice[i].arc);
    }
}

