/*-----------------------------------------------------------------------*/
/*                                 TIGA                                  */
/*       Copyright (c) 1989-1990 Texas Instruments Incorporated.         */
/*                         All Rights Reserved                           */
/*-----------------------------------------------------------------------*/
/*  TMS340 Graphics Library						 */
/*-----------------------------------------------------------------------*/
/*  oem.h - 34020 SDB version                                            */
/*                                                                       */
/*  This file contains the hardware-specific constants                   */
/*                                                                       */
/* 10/20/89   Modified for 34020 Software Development board Graham Short */
/* 04/26/90   Modified for TMS340 Graphics Library........Jerry Van Aken */
/*-----------------------------------------------------------------------*/
/*-----------------------------------------------------------------------*/
/* Define GSP part number as either 34010 or 34020.			             */
/*-----------------------------------------------------------------------*/
#define GSP_34010  0	     /* Set to 1 if GSP part number is 34010 */
#define GSP_34020  1	     /* Set to 1 if GSP part number is 34020 */
/*-----------------------------------------------------------------------*/
/* Define board identifier                         			             */
/*-----------------------------------------------------------------------*/
#define SDB10      0	     /* Set to 1 if board is 34010 SDB              */
#define SDB20      1	     /* Set to 1 if board is 34020 SDB              */

#define VIDEO_MEMORY_START      0x00000000l 
#define VIDEO_MEMORY_END        0x007FFFFFl
#define PALET_ENTRIES           256
#define SHARED_MEM_SIZE         0
#define SHARED_HOST_ADDR        0
#define SHARED_GSP_ADDR         0

/*--------------------------------------------------------------------------*/
/*  SETUP structure definition                                              */
/*                                                                          */
/*      This structure contains all the mode-dependent information          */
/*      that will be downloaded from host to GSP when the current           */
/*      mode is changed.                                                    */
/*      All the information here is also duplicated on the host side.       */
/*      Changing the information below must be duplicated on the host side. */
/*                                                                          */
/*--------------------------------------------------------------------------*/
#define MAX_PAGES               2     /* maximum number of display pages   */
#define MAX_OFFSCREEN           4     /* maximum number of offscreen areas */

typedef struct
{
   ushort         Monitor;
   ushort         Mode_Info_offset;
   ushort         Monitor_Info_offset;
   ushort         Page_Info_offset;
   ushort         Off_Screen_offset;
   ushort         OEM_Data_offset;                                       
   ushort         endsetup_offset;
} HEADER;

typedef struct
{
   ushort         status;
} OEMDATA;

typedef struct
{
   HEADER         header;
   MODEINFO       Mode_Info;
   MONITORINFO20  Monitor_Info;
   PAGE 	  Page_Info[MAX_PAGES];
   OFFSCREEN_AREA Off_Screen[MAX_OFFSCREEN];
   OEMDATA        OEM_Data;                                     
} SETUP;

/* Miscellaneous defs */
#define TIGA_VERSION_NUMBER     11 

/* Definitions specific to the 34020 SDB */
#define PALET_WRITE_ADDR      0xD0000000l
#define PALET_RAM             0xD0000020l
#define PALET_READ_MASK       0xD0000040l
#define PALET_READ_ADDR       0xD0000060l
#define PALET_OVLY_WRITE_ADDR 0xD0000080l
#define PALET_OVLY_REGS       0xD00000A0l
#define PALET_OVLY_READ_ADDR  0xD00000E0l

#define HARDWARE_SPACE        0xE0000000l
#define VGA                   0x8
#define RATE                  0x4
#define BIT4                  0x2
#define BIT8                  0x1

