;-------------------------------------------------------------------------;
;                                  TIGA                                   ;
;        Copyright (c) 1989-1990  Texas Instruments Incorporated.         ;
;			   All Rights Reserved				  ;
;-------------------------------------------------------------------------;
;   TIGA - Graphics Manager                                               ;
;-------------------------------------------------------------------------;
;                                                                         ;
; void clear_frame_buffer(color)                                          ;
; long  color;                                                            ;
;                                                                         ;
; This function clears the entire VRAM to the color specified             ;
; using shift-register transfers.                                         ;
;                                                                         ;
;-------------------------------------------------------------------------;
;  01/30/89  Original Version Written                      Graham Short   ;
;            based on new_scrn from MGFL written by        Jerry VanAken  ;
;  06/21/89  Modified for 34020 SDB                        Graham Short   ;
;-------------------------------------------------------------------------;
;
        .include gspreg.inc
        .include gsptypes.inc            
        .include gspglobs.inc            
        .mlib    gspmac.lib
;
;     DECLARE GLOBAL FUNCTION NAME
;
        .globl  _clear_frame_buffer
        .globl  _dm_clear_frame_buffer
;
;     GLOBAL REFERENCES
;
        .globl  _set_fcolor        
;
;   Register usage
Rtmp    .set    A8
Rsave1  .set    A0
Rsave2  .set    A1
Rsave3  .set    A2
Rsave4  .set    A3
;
;   C-PACKET ENTRY POINT
;
_clear_frame_buffer:
        mmtm    SP,A0,A1,A2,A3
        mmtm    SP,B2,B3,B7,B9
        Popc    Rtmp                    ;get color index        
        jruc    common_ep        
;
;   DIRECT MODE ENTRY POINT
;
_dm_clear_frame_buffer:
        mmtm    SP,A0,A1,A2,A3
        mmtm    SP,B2,B3,B7,B9
        Popc    Rtmp                    ;get pointer to dm-data
        move    *Rtmp,Rtmp,1            ;get color index
;
;   COMMON ENTRY POINT
;
common_ep:
        cmpi    -1,Rtmp
        jreq    use_color0
;-----------------------------------------------------------------------;
;   Call set_fcolor() to convert color index to actual color            ;    
;-----------------------------------------------------------------------;
        Push    STK
        Pushc   Rtmp
        callr   _set_fcolor
        jruc    color_is_set
;-----------------------------------------------------------------------;
;   Use background color                                                ;    
;-----------------------------------------------------------------------;
use_color0:
        move    COLOR0,COLOR1
;-----------------------------------------------------------------------;
;   Clear the frame with the indicated color                            ;    
;-----------------------------------------------------------------------;
color_is_set:        
        setf    16,0,0               
        move    @CONTROL,Rsave1,0     
        move    @PMASK,Rsave2,0
        move    @DPYCTL,Rsave3,0
        move    @PSIZE,Rsave4,0
;
; Disable window checking, turn off transparency, set ppop = replace.
        clrs    Rtmp
        setf    10,0,0              
        move    Rtmp,@CONTROL+5,0     
; clear PMASK
        move    Rtmp,@PMASK,1
; psize of 32
        setf    16,0,0               
        movk    32,Rtmp
        move    A8,@PSIZE,0
; initialize first two rows since 0-2000h has the IO registers in it
        movi    0,DADDR
        movi    04000h,DPTCH
        movi    [2,512],DYDX
        vlcol
        vfill   l
;
; Set SRT=1.  This converts pixel accesses to VRAM SR transfer cycles.
        move    Rsave3,Rtmp
        andni   SRE_MASK+ENV_MASK,Rtmp
        ori     SRT_MASK,Rtmp          
        move    Rtmp,@DPYCTL,0         
        mwait
;  
; Load frame buffer for 1st row into VRAM shift registers.
        movi    04000h,DADDR                  
        pixt    *DADDR,DADDR              
;
; Transfer contents of VRAM shift registers to rest of frame buffer.
        movi    08000h,DADDR
        movi    [510,1],DYDX
        fill    L                  ;510 SR-to-memory transfers
;
; Restore IO registers
        move    Rsave4,@PSIZE,0
        move    Rsave3,@DPYCTL,0
        move    Rsave2,@PMASK,0
        move    Rsave1,@CONTROL,0     
; restore registers
        mmfm    SP,B2,B3,B7,B9
        mmfm    SP,A0,A1,A2,A3
        rets    2
;
        end
