;-------------------------------------------------------------------------;
;                                  TIGA                                   ;
;        Copyright (c) 1989-1990  Texas Instruments Incorporated.         ;
;			   All Rights Reserved				  ;
;-------------------------------------------------------------------------;
;   TIGA - Graphics Manager                                               ;
;-------------------------------------------------------------------------;
;                                                                         ;
; void clear_frame_buffer(color)                                          ;
; long  color;                                                            ;
;                                                                         ;
; This function clears the entire VRAM of the SDB to the color specified  ;
; except the region where the palet data is stored using shift-register   ;
; transfers.                                                              ;
;                                                                         ;
;-------------------------------------------------------------------------;
;  01/30/89  Original Version Written                      Graham Short   ;
;            based on new_scrn from MGFL written by        Jerry VanAken  ;
;-------------------------------------------------------------------------;
        .title  'clear frame'
        .file   'clearfrm.asm'
;
;   Include files
        include gspreg.inc
        include gsptypes.inc            
        include gspglobs.inc            
        include gsptiga.inc            
        .mlib   gspmac.lib
;
;   Define Functions        
        def     _clear_frame_buffer
        def     _dm_clear_frame_buffer
;
;   Register usage
Rtmp    .set    A8
Rsave1  .set    A0
Rsave2  .set    A1
Rsave3  .set    A2
Rcolor  .set    A3

;
; C-packet entry point      
_clear_frame_buffer:
        mmtm    SP,A0,A1,A2,A3
        mmtm    SP,B2,B4,B7,B9
        Popc    Rcolor
        jruc    common_ep
;
; Direct mode entry point
_dm_clear_frame_buffer:
        mmtm    SP,A0,A1,A2,A3
        mmtm    SP,B2,B4,B7,B9
        Popc    Rtmp                    ;get pointer to dm-data
        move    *Rtmp,Rcolor,1          ;get color index
;
; save CONTROL, PMASK and DPYCTL IO registers
common_ep:
        setf    16,0,0               
        move    @CONTROL,Rsave1,0     
        move    @PMASK,Rsave2,0
        move    @DPYCTL,Rsave3,0
;
; Disable window checking, turn off transparency, set ppop = replace.
        clrs    Rtmp
        setf    10,0,0              
        move    Rtmp,@CONTROL+5,0     
;
; Enable all color planes.
        setf    16,0,0              
        move    Rtmp,@PMASK,0         
;
; Special case color of -1
        cmpi    -1,Rcolor
        jreq    use_color0
;
;   Call set_fcolor() to convert color index to actual color           
        Push    STK
        Pushc   Rcolor
        callr   _set_fcolor
        jruc    color_is_set
;
;   Use background color                                               
use_color0:
        move    COLOR0,COLOR1
;
; Clear offset
color_is_set:
        clrs    OFFSET
;
; Set scan line 0 from palet onwards to the selected color
        movi    [0,64],DADDR
        movi    [1,960],DYDX 
        fill    XY
;
; Set scan line 256 from palet onwards to the selected color
        movi    [256,64],DADDR
        movi    [1,960],DYDX 
        fill    XY
;
; Set SRT=1.  This converts pixel accesses to VRAM SR transfer cycles.
        move    Rsave3,Rtmp          
        andni   SRE_MASK+ENV_MASK,Rtmp  ; 4161 need shifting disabled
        ori     SRT_MASK,Rtmp          
        move    Rtmp,@DPYCTL,0         
        move    @DPYCTL,Rtmp,0         
;  
; Load frame buffer for 1st line into VRAM shift registers.
        clr     DADDR                  
        pixt    *DADDR,DADDR              
;
; Transfer contents of VRAM shift registers to rest of frame buffer.
        movi    [1,0],DADDR
        movi    [255,4],DYDX
        fill    XY                  ;255 SR-to-memory transfers
;
; Restore IO registers
        move    Rsave3,@DPYCTL,0
        move    Rsave2,@PMASK,0
        move    Rsave1,@CONTROL,0     
;
; If more than one page, assume palet has been destroyed, so reset it
        move    @(_config+CONFIG_NUM_PAGES),Rtmp,0 ;number of display pages
        dec     Rtmp
        jrz     return
        Push    STK
	movi	_palet,Rtmp
        Pushc   Rtmp
        clrs    Rtmp
        Pushc   Rtmp
        move    @_config+CONFIG_PALET_SIZE,Rtmp,1 
        Pushc   Rtmp
	callr	_set_palet
;
; Restore registers
return:
        mmfm    SP,B2,B4,B7,B9
        mmfm    SP,A0,A1,A2,A3
        rets    2
;
        end
