;-------------------------------------------------------------------------;
;                                  TIGA                                   ;
;        Copyright (c) 1989-1990  Texas Instruments Incorporated.         ;
;			   All Rights Reserved				  ;
;-------------------------------------------------------------------------;
;   TIGA - Graphics Manager Extension                                     ;
;-------------------------------------------------------------------------;
;  text_width - Return the width of the given string as if it were drawn  ;
;  using the currently selected font using the active text drawing        ;
;  attributes.                                                            ;
;                                                                         ;
;-------------------------------------------------------------------------;
;  01/23/89   Original Version Written                     J.G.Littleton  ;
;  03/21/90   Modified to use default character            JGL            ;
;-------------------------------------------------------------------------;
;  TMS340 register Definitions
        .copy   "gspreg.inc"
	.copy	"gsptypes.inc"
	.copy	"gspglobs.inc"

;  TMS340 Macro Definitions
        .mlib   "gspmac.lib"


;  Global Definitions
        .globl  _text_width 
;
;  Local register usage
Rptr    .set      A0                  ;pointer to font structure
Rfirst  .set      A1                  ;first character code defined in font
Rextra  .set      A2                  ;additional intercharacter spacing
Rpow    .set      A3                  ;pointer to offset/width table
Rcode   .set      A4                  ;holds ASCII character code
Rlast   .set      A5                  ;last character code defined in font
Rdflt   .set      A6                  ;default character code               
;
_text_width:
        mmtm    SP,A0,A1,A2,A3,A4,A5,A6
        setf    16,0,0
        Popc    Rptr                  ;pop string pointer
;  Get font parameters in registers
        move    @_envtext+ENVTEXT_SELECTED,A8,1 ;Get pointer to font record
        move    *A8(FONT_FIRST),Rfirst,0
        move    *A8(FONT_LAST),Rlast,0
        move    *A8(FONT_DEFLT),Rdflt,0
        move    *A8(FONT_OOWTBL),Rpow,1    ;offset to offset/width table
        move    *A8(FONT_CHARWIDE),Rextra,0
    	add	A8,Rpow
        move    Rextra,Rextra
        jrz     pentry
;------------------------------------------------------------------------;
;  Entry: Monospaced fonts                                               ;
;------------------------------------------------------------------------;                
mentry:
        clr     A8        
        setf    8,0,0
mloop:
        move    *Rptr+,Rcode,0      ;get a character from string
        jrz     exitTextWidth       ;if (EOS) then exit
        cmp     Rcode,Rlast
        jrc     musedflt	    ;use default char
        sub     Rfirst,Rcode        ;index = char code - first char
        jrn     musedflt	    ;use default char
        jruc    mdefined
musedflt:
        move    Rdflt,Rdflt         ;if no default character defined    
        jrz     mloop               ;   add no width for this character
mdefined:
        add     Rextra,A8
        jruc    mloop
;------------------------------------------------------------------------;
;  Entry: Proportional fonts                                             ;
;------------------------------------------------------------------------;
pentry:
;
;  get additional intercharacter spacing
;
        move    @_envtext+ENVTEXT_CHAREXTRA,Rextra,0    
        sext    Rextra,0
        clr     A8                  ;clear width counter
ploop:
        setf    8,0,0
        move    *Rptr+,Rcode,0      ;get a character from string
        setf    16,0,0
        jrz     exitTextWidth       ;if (EOS) then exit
;------------------------------------------------------------------------;
;  If the character is not defined in the font, then the width of the    ;
;  default character is used, if defined. If not, then the character has ;
;  NULL width. A character is not defined if its ASCII code is less than ;
;  the first character or greater than the last defined in the font. or  ;
;  if its offset width entry is -1.                                      ;       ;
;------------------------------------------------------------------------;
        cmp     Rcode,Rlast
        jrc     pusedflt            ;not defined
        sub     Rfirst,Rcode        ;index = char code - first char
        jrn     pusedflt            ;not defined
        jruc    pdefined
pusedflt:
        move    Rdflt,Rcode
        jrz     ploop
        sub     Rfirst,Rcode
pdefined:        
        sll     4,Rcode             ;index into offset/width table
        add     Rpow,Rcode          ;add address of offset/width table
        move    *Rcode,Rcode,0      ;get offset/width value for character
        sext    Rcode,0
        cmpi    -1,Rcode            ;if (offset/width == -1) not defined
        jrz     pusedflt            ;not defined...	
;   Add character width 
        sll     24,Rcode            ;isolate width from offset:width entry
        srl     24,Rcode
        add     Rextra,Rcode        ;add extra interchar spacing
        add     Rcode,A8            ;add character width
        jruc    ploop
exitTextWidth:
        mmfm    SP,A0,A1,A2,A3,A4,A5,A6
        rets    2
        .end

