/*-----------------------------------------------------------------------*/
/*                                 TIGA                                  */
/*       Copyright (c) 1986-1990 Texas Instruments Incorporated.         */
/*                         All Rights Reserved                           */
/*-----------------------------------------------------------------------*/
/*  TIGA - Graphics Manager Extension                                    */
/*-----------------------------------------------------------------------*/
/*                                                                       */
/* patnpen_point function                                                */
/*                                                                       */
/*   Draw the pen at the specified point using the current pattern.  The */
/*   point coordinates coincide with the top left corner of the pen.     */
/*   The pattern is drawn in colors 0 and 1.                             */
/*-----------------------------------------------------------------------*/
/* Usage:  patnpen_point(x, y);                                          */
/*                                                                       */
/* Description of the arguments:                                         */
/*   short x, y;  // x-y coordinates at point //                         */
/*-----------------------------------------------------------------------*/
/* Revision history:                                                     */
/*   3/18/86...Original version written...................Jerry Van Aken */
/*   5/14/86...Added TI copyright notice..................JV             */
/*   9/22/86...Changed int's to short's and long's........Stanley Acton  */
/*   9/18/88...Added TIGA dm, globals.....................Graham Short   */
/*-----------------------------------------------------------------------*/

#include <gsptypes.h>
#include <gspglobs.h>

/* Declare external functions */
extern void patnfill_rect();

void dm_patnpen_point(data_ptr)
register short *data_ptr;
{
    register short x, y;

    x = data_ptr[0];
    y = data_ptr[1];
    data_ptr[0] = env.pensize & 0x0000FFFFl;
    data_ptr[1] = env.pensize>>16;
    data_ptr[2] = x;
    data_ptr[3] = y;
    dm_patnfill_rect(data_ptr);
}

void patnpen_point(x, y)
short x, y;
{
    patnfill_rect(env.pensize & 0x0000FFFFl, env.pensize>>16, x, y);
}

