/*-----------------------------------------------------------------------*/
/*                                 TIGA                                  */
/*       Copyright (c) 1986-1990 Texas Instruments Incorporated.         */
/*                         All Rights Reserved                           */
/*-----------------------------------------------------------------------*/
/*  TIGA - Graphics Manager Extension                                    */
/*-----------------------------------------------------------------------*/
/*                                                                       */
/* patnframe_rect function                                               */
/*                                                                       */
/*   Draw a pattern-filled rectangular frame given the coordinates at    */
/*   the top left corner of the frame, the width and height of the       */
/*   frame, and the thickness of the frame border in the horizontal and  */
/*   vertical dimensions.  The frame border is filled with the current   */
/*   pattern in colors 0 and 1.  The portion of the screen enclosed by   */
/*   the frame is not altered.                                           */
/*-----------------------------------------------------------------------*/
/* Usage:  patnframe_rect(w, h, x0, y0, deltax, deltay);                 */
/*                                                                       */
/* Description of the arguments:                                         */
/*   long w, h;                                                          */
/*   long x0, y0;  /* x-y coord's at top left corner of outer frame //   */
/*   long deltax, deltay;  /* horiz. & vert. thickness of border //      */
/*-----------------------------------------------------------------------*/
/* Revision history:                                                     */
/*   3/12/86...Original version written...................Jerry Van Aken */
/*   5/14/86...Added TI copyright notice..................JV             */
/*   3/16/87...Added check for frame without hole.........JV             */
/*   9/16/88...Added TIGA direct mode, dstbm check........JV             */
/*-----------------------------------------------------------------------*/

#include <gsptypes.h>
#include <gspglobs.h>

/* Declare external functions */
 extern void patnfill_rect();


 void patnframe_rect(w, h, x0, y0, deltax, deltay)
 long w, h, x0, y0, deltax, deltay;
 {
     long wprime, hprime, yprime;

    /* abort if the drawing bitmap is not pointing to the screen */
    if( env.dstbm )
         return;

     wprime = w - (deltax << 1);
     hprime = h - (deltay << 1);
     if (wprime <= 0 || hprime <= 0) {
         patnfill_rect(w, h, x0, y0);
         return;
     }
     yprime = y0 + deltay;
     patnfill_rect(w, deltay, x0, y0);
     patnfill_rect(w, deltay, x0, y0+h-deltay);
     patnfill_rect(deltax, hprime, x0, yprime);
     patnfill_rect(deltax, hprime, x0+w-deltax, yprime);
 }

 dm_patnframe_rect(data_ptr)
 register short *data_ptr;
 {
    register long w, h, x0, y0, deltax, deltay;

    w      = *data_ptr++;
    h      = *data_ptr++;
    x0     = *data_ptr++;
    y0     = *data_ptr++;
    deltax = *data_ptr++;
    deltay = *data_ptr;
    patnframe_rect(w, h, x0, y0, deltax, deltay);
}
