;-------------------------------------------------------------------------;
;                               TIGA 2.0                                  ;
;        Copyright (c) 1986-1990  Texas Instruments Incorporated.         ;
;			   All Rights Reserved				  ;
;-------------------------------------------------------------------------;
;   TIGA 2-D Graphics Library                                             ;
;-------------------------------------------------------------------------;
;                                                                         ;
; move_pixel function                                                     ;
;                                                                         ;
;   Moves the pixel at the specified source coordinates to the specified  ;
;   destination coordinates.  Pixel coordinates are specified relative    ;
;   to the current drawing origin.                                        ;
;-------------------------------------------------------------------------;
; Usage:  move_pixel(xs, ys, xd, yd);                                     ;
;                                                                         ;
; Description of stack arguments:                                         ;
;   short xs, ys;     /* source pixel coordinates */                      ;
;   short xd, yd;     /* destination pixel coordinates */                 ;
;                                                                         ;
; Returned in register A8:  void (undefined)                              ;
;                                                                         ;
; Registers altered:  A8                                                  ;
*-------------------------------------------------------------------------;
* Revision history:                                                       ;
*   11/02/86...Original version written...................J.R. Van Aken   ;
;   01/03/90...Added TIGA direct mode.....................J.R.V.          ;
;-------------------------------------------------------------------------;
;
        .title    'move pixel'
        .file     'movpixel.asm'
;
;
;     DECLARE GLOBAL FUNCTION NAME
;
        .def      _move_pixel
        .def      _dm_move_pixel
;
;     REFERENCE EXTERNAL GLOBALS
;
        include gsptypes.inc
        include gspglobs.inc          
;
;     ENTRY POINT
;
_move_pixel:
        MOVE      A0,*-SP,1           ;save register
* Pop first two arguments off stack.
        MOVE      *-A14,A8,1          ;get argument 'xs'
        MOVE      *-A14,A0,1          ;get argument 'ys'
* Calculate memory address of source pixel.
        SLL       16,A0               ;
        MOVY      A0,A8               ;concatenate xs, ys
* Pop last two arguments off stack.
        MOVE      *-A14,A0,1          ;get argument 'xd'
        MOVE      *-A14,A14,1         ;get argument 'yd'
* Calculate memory address of source pixel.
        SLL       16,A14              ;
        MOVY      A14,A0              ;concatenate xd, yd
        jruc      common_ep

_dm_move_pixel:
        MOVE      A0,*-SP,1           ;save register
* Get arguments from command buffer data area
        MOVE      *-A14,A14,1         ;get pointer to data area
        MOVE      *A14+,A8,1          ;get concatenated args ys::xs
        MOVE      *A14+,A0,1          ;get concatenated args yd::xd

* Common entry point
common_ep:
        MOVE      @_env+ENVIRONMENT_XYORIGIN,A14,1  ;drawing origin
        ADDXY     A14,A0              ;make yd::xd screen-relative coord's
        ADDXY     A14,A8              ;make ys::xs screen-relative coord's
        CVXYL     A8,A8               ;convert xs::ys to memory address
* Move pixel from source to destination.
        PIXT      *A8,A8              ;read source pixel
        PIXT      A8,*A0.XY           ;write to destination
* Restore register and return.
        MOVE      *SP+,A0,1           ;restore register
        MOVE      *SP(32),A14,1       ;restore program stack pointer
        RETS      2                   ;
        .end

