;-------------------------------------------------------------------------;
;                                  TIGA                                   ;
;        Copyright (c) 1987-1990  Texas Instruments Incorporated.         ;
;			   All Rights Reserved				  ;
;-------------------------------------------------------------------------;
;   TIGA - Graphics Manager Extension                                     ;
;-------------------------------------------------------------------------;
;                                                                         ;
; get_pixel function                                                      ;
;                                                                         ;
;   Returns the value of the pixel at the specified coordinates.  The     ;
;   coordinates are specified relative to top left corner of viewport.    ; 
;   Given a pixel size of n bits, the pixel is contained in the n LSBs    ;
;   of the return value; the 32-n MSBs are 0s.                            ;
;-------------------------------------------------------------------------;
; Usage:  get_pixel(xs, ys);                                              ;
;                                                                         ;
; Description of stack arguments:                                         ;
;         long xs, ys;         /* coordinates of source pixel */          ; 
;                                                                         ; 
; Returned in register A8:  Pixel value                                   ;
;                                                                         ;
; Registers altered:  A8                                                  ;
;-------------------------------------------------------------------------;
; Revision history:                                                       ;
;    3/18/87...Original version written..................Jerry Van Aken   ;
;    9/23/88...Added TIGA direct mode....................Graham Short     ;
;-------------------------------------------------------------------------;
;
        .title    'get pixel'
        .file     'getpixel.asm'
;
;
;     DECLARE GLOBAL FUNCTION NAME
;
        .globl    _get_pixel
        .globl    _dm_get_pixel
;
;     REFERENCE EXTERNAL GLOBALS
;
       .include gsptypes.inc
       .include gspglobs.inc          
;
;     ENTRY POINT
;
_get_pixel:
        MOVE      A0,*-SP,1           ;save register
* Pop arguments off stack.
        MOVE      *-A14,A0,1          ;get argument 'xs'
        MOVE      *-A14,A8,1          ;get argument 'ys'
* Calculate memory address of pixel.
        SLL       16,A8               ;
        MOVX      A0,A8               ;concatenate xs, ys
        jruc      common_ep
_dm_get_pixel:
        MOVE      A0,*-SP,1           ;save register
* Get arguments from command buffer data area
        MOVE      *-A14,A8,1          ;get pointer to data area
        MOVE      *A8,A8,1            ;get argument ys:xs
* Calculate memory address of pixel.
common_ep:
        MOVE      @_env+ENVIRONMENT_XYORIGIN,A0,1     ;viewport origin displacement
        ADDXY     A0,A8                       ;convert to screen coord's
        CVXYL     A8,A8                       ;get memory address of pixel
* Read pixel.
        PIXT      *A8,A8              
* Restore register and return.
        MOVE      *SP+,A0,1           ;restore register
        RETS      2                   ;return
        .end

