;-------------------------------------------------------------------------;
;                                  TIGA                                   ;
;        Copyright (c) 1986-1990  Texas Instruments Incorporated.         ;
;			   All Rights Reserved				  ;
;-------------------------------------------------------------------------;
;   TIGA - Graphics Manager Extension                                     ;
;-------------------------------------------------------------------------;
;                                                                         ;
; fill_rect function                                                      ;
;                                                                         ;
;   Draw a filled-in rectangle.  The dimensions of the rectangle are      ;
;   specified in the first two input arguments, width and height.         ;
;   The location of the rectangle is specified in terms of the            ;
;   coordinates of its upper left corner, which are contained in input    ;
;   arguments xleft and ytop.  The rectangle is filled in solid color 1.  ;
;-------------------------------------------------------------------------;
; Usage:  fill_rect(width, height, xleft, ytop);                          ;
;                                                                         ;
; Stack arguments:                                                        ;
;         long width, height;  /* rectangle dimensions */                 ;
;         long xleft, ytop;  /* coordinates at top left corner */         ;
;                                                                         ;
; Registers altered:  A8                                                  ;
;-------------------------------------------------------------------------;
; Revision history:                                                       ;
;  02/05/86...Original version written...................John Black       ;
;  10/20/86...Added TI copyright notice..................Stanley Acton    ;
;  03/18/87...Eliminated unnecessary operations..........Jerry Van Aken   ;
;  07/12/88...Added TIGA direct mode and dstbm check.....W.S.Egr          ;
;  09/07/88...Access globals thru env struct.............W.S.Egr          ;
;  07/10/89...Add 34020 support..........................A. Sharp         ;
;  09/14/89...Found error in mode checks for VFILL.......G. Short         ;
;  11/16/89...Added CLIP prior to VFILL..................G. Short         ;                  
;-------------------------------------------------------------------------;
;
        .title    'fill rectangle'
        .file     'fillrect.asm'
        .include  gsptypes.inc          ;offsets into environment struct
        .include  gspglobs.inc          
        .include  gspreg.inc
        .include  oem.inc
;
;     DECLARE GLOBAL FUNCTION NAME
;
        .globl      _fill_rect, _dm_fill_rect
;
;    DIRECT-MODE ENTRY POINT
;
_dm_fill_rect:
        move      A0,*-SP,1           ;save register
        mmtm      SP,B2,B7,B10,B11,B12,B13,B14
        move      -*A14,A8,1          ;get dm-data area address
        move      *A8+,A0,1           ;1st dword is height::width
        move      A0,B7               ;load height::width into DYDX
        move      *A8,A0,1            ;2nd dword is ytop::xleft
        jruc      common_ep           ;jump to common entry point
;
;    C-PACKET ENTRY POINT
;
_fill_rect:
* Save registers
        MOVE      A0,*-SP,1           ;save register
        MMTM      SP,B2,B7,B10,B11,B12,B13,B14
        MOVE      *-A14,A0,1          ;get width
        MOVE      *-A14,A8,1          ;get height
        SLL       16,A8               ;
        MOVY      A8,A0               ;concatenate width & height
        MOVE      A0,B7               ;load DYDX
        MOVE      *-A14,A0,1          ;get xleft
        MOVE      *-A14,A8,1          ;get ytop
        SLL       16,A8               ;
        MOVY      A8,A0               ;concatenate xleft & ytop
;
;    2 ENTRY POINTS JOIN UP HERE
;
common_ep:
;
;    Check for destination bitmap pointing to the screen.  If not, abort for
;    now.  Linear drawing capability will be added at a later time.
;
        move      @(_env+ENVIRONMENT_DSTBM),A8,1    ;destination bit-map global variable
        jrnz      EXIT                ;if zero, dstbm is set to screen
* Convert from viewport relative coord's to screen coord's
        MOVE      @(_env+ENVIRONMENT_XYORIGIN),A8,1     ;viewport origin displacement
        ADDXY     A8,A0               ;convert to screen coord's
        MOVE      A0,B2               ;load DADDR

        .if     GSP_34020 ; Code used if the processor is a 34020
        SETF      1,0,0
; Check the VRAM_BLOCK_WRITE flag in the CONFIG register, 
; This is set by the OEM to indicate whether the system contains 1 MEG
; VRAMs that support the block write capability and whether the 
; current mode has a DPTCH and PSIZE which will allow block write
        MOVE      @(_config+CONFIG_VRAM_BLOCK_WRITE),A8,0 
        JRZ       NO_VFILL
        SETF      10,0,0
; Check PPOP and Transparency in control
; These mus be both zero for correct VFILL operation
        MOVE      @CONTROL+5,A8,0      ;T,W,PBH,PBV,PPOP
        ANDI      3E7h,A8              ;T,PPOP must be zero for VFILL
        CMPI      6,A8                 ;and W must be 11 for CLIP
        JRNE      NO_VFILL
        CLRC                           ;Temporary fix for bug in silicon
        CLIP
        JRZ       EXIT
        CVDXYL    B2                   ;convert to linear dest address
        VLCOL                          ;load VRAM color latches
        VFILL     L                    ;perform linear fill
        JRUC      EXIT
NO_VFILL:
        .endif
;
        FILL      XY                  ;fill the rectangle
* All done.  Restore registers and return
EXIT:
        MMFM      SP,B2,B7,B10,B11,B12,B13,B14
        MOVE      *SP+,A0,1           ;restore register
        MOVE      *SP(32),A14,1       ;restore program stack pointer
        RETS      2                   ;
        .end

