;-------------------------------------------------------------------------;
;                                  TIGA                                   ;
;          Copyright (c) 1990  Texas Instruments Incorporated.            ;
;			   All Rights Reserved				  ;
;-------------------------------------------------------------------------;
;   TIGA - Graphics Manager Extension                                     ;
;-------------------------------------------------------------------------;
;  decode_rect - decode buffer into rectangle of pixel data               ;
;                                                                         ;
;  This is the companion function to encode_rect.                         ;
;                                                                         ;
;-------------------------------------------------------------------------;
;  03/26/90   Original Version Written                     J.G.Littleton  ;
;-------------------------------------------------------------------------;
;  TMS340 register Definitions
        .copy   "gspreg.inc"
	.copy	"gsptypes.inc"
	.copy	"gspglobs.inc"

;  TMS340 Macro Definitions
        .mlib   "gspmac.lib"

;  Global Definitions
        .globl  _decode_rect    
;
;  Local register usage
Rwide   .set    A0              
Rtall   .set    A1              
Rposn   .set    A2
Rbuf    .set    A3      
Rsiz    .set    A4
Rcnt    .set    A5
Rpix    .set    A6
Rtposn  .set    A7
Rtmp    .set    A9
Rrepsiz .set    A10

;------------------------------------------------------------------------;
;  Header for an encoded rectangle                                       ;
;------------------------------------------------------------------------;
smMAGIC    .set   0                   ;(ushort) Magic number  
smLENGTH   .set   010h                ;(ulong)  Length of data in bytes  
smSCHEME   .set   030h                ;(ushort) Encoding scheme
smWIDTH    .set   040h                ;(short)  Width of encoded rect
smHEIGHT   .set   050h                ;(short)  Height of encoded rect
smPSIZE    .set   060h                ;(short)  Pixel size of encoded rect
smFLAGS    .set   070h                ;(ushort) Flags
smCLIPADJ  .set   080h                ;(ulong)  Y:X clip adjustment
smDATA     .set   0A0h                ;data starts here
HDRSIZ     .set   20                  ;header size in bytes
MAGIC      .set   08101h              ;Encode rect hdr magic number

;------------------------------------------------------------------------;
;  decode_rect( x, y, buf )                                              ;
;------------------------------------------------------------------------;
_decode_rect:
        mmtm    SP,A0,A1,A2,A3,A4,A5,A6,A7,A9,A10
        mmtm    SP,B9,B13
        move    @(_env+ENVIRONMENT_DSTBM),A8,1  
        jrnz    exit_decode_rect        ;if not screen, exit...
        setf    16,0,0
;
        Popc    Rposn                   ;Pop DstX                 
        Popc    A8                      ;Pop DstY
        sll     16,A8
        movy    A8,Rposn                ;merge into DstY:DstX
        Popc    Rbuf                    ;Pop ptr to encoded buffer
;
        move    *Rbuf(smMAGIC),A8,0     ;get magic number
        cmpi    MAGIC,A8                ;q: is this really ours?
        jrnz    exit_decode_rect        ;n: exit...

        move    *Rbuf(smWIDTH),Rwide,0  ;get width of encoded rect
        move    *Rbuf(smHEIGHT),Rtall,0 ;get height of encoded rect
        move    *Rbuf(smPSIZE),Rpix,0   ;get saved image PSIZE
        move    @PSIZE,A8,0             ;get real psize
        cmp     A8,Rpix                 ;q: encoded psize == psize?
        jrnz    exit_decode_rect        ;n: exit...
        move    *Rbuf(smLENGTH),Rsiz,1  ;get length of encoded buffer
        move    *Rbuf(smSCHEME),A8,0    ;get encoding scheme
        jrnz    exit_decode_rect      
        move    @_env+ENVIRONMENT_XYORIGIN,A8,1   
        addxy   A8,Rposn
        move    *Rbuf(smCLIPADJ),A8,1
        addxy   A8,Rposn
        addi    smDATA,Rbuf             ;skip past encode header
;------------------------------------------------------------------------;
;  Decode the rectangle                                                  ;
;------------------------------------------------------------------------;
        movi    [1,0],DYDX              
        move    Rpix,A8
        Mpyl    A8,Rwide                ;convert width to bits
dl_nextrow:
        move    Rposn,Rtposn
        move    Rwide,Rcnt
        setf    3,0,0
        move    *Rbuf+,A8,0             ;get repeating data magnitude
        movk    1,Rrepsiz               ;(convert magnitude to usable
        sll     A8,Rrepsiz              ; FS, either 1,2,4,8,16 or 32)
        setf    5,0,0                   
        move    *Rbuf+,A8,0             ;get opcode field size
        ori     020h,A8                 ;make it sign extended
;
        exgf    A8,0                    ;Use FS0 to read opcode
        move    Rrepsiz,A8
        exgf    A8,1
dl_nextrun:
        move    *Rbuf+,Rtmp,0           ;get opcode
        jrn     dl_absrun
;  Decode a repeating run of data
dl_reprun:
        move    Rrepsiz,@PSIZE,0
        move    Rtposn,DADDR
        move    Rtmp,B10
        movx    B10,DYDX
        move    Rrepsiz,A8
        Mpyl    A8,Rtmp
        move    *Rbuf+,A8,1             ;get repeating data
        move    A8,COLOR1
        RepC1
        fill    XY
        move    Rtmp,B10
        move    Rpix,B11
        Divl    B11,B10
        move    B10,A8
        addxy   A8,Rtposn
        jruc    dl_rundone
;  Decode an absolute run of pixels
dl_absrun:
        move    Rbuf,SADDR
        move    Rtposn,DADDR
        move    Rpix,@PSIZE,0
        neg     Rtmp
        move    Rtmp,B10
        movx    B10,DYDX
        addxy   Rtmp,Rtposn
        move    Rpix,A8
        Mpyl    A8,Rtmp
        add     Rtmp,Rbuf
        pixblt  L,XY
dl_rundone:
        sub     Rtmp,Rcnt
        jrgt    dl_nextrun
        movi    [1,0],A8
        addxy   A8,Rposn
        dsj     Rtall,dl_nextrow
exit_decode_rect:
        setf    32,0,1
        mmfm    SP,B9,B13
        mmfm    SP,A0,A1,A2,A3,A4,A5,A6,A7,A9,A10
        rets    2
