;-------------------------------------------------------------------------;
;                                  TIGA                                   ;
;    Copyright (c) 1986-1990  Texas Instruments.  All Rights Reserved     ;
;-------------------------------------------------------------------------;
;   TIGA - Graphics Manager Core                                          ;
;-------------------------------------------------------------------------;
; transp_on, transp_off, get_transp, and set_transp functions             ;
;                                                                         ;
;   The transp_on and transp_off functions turn the transparency          ;
;   attribute on and off.  These functions set and clear, respectively,   ;
;   the T (transparency) bit in the 34010's CONTROL register.             ;
;                                                                         ;
;   The get_transp function returns a 1 if transparency is enabled, and   ;
;   a 0 if transparency is disabled.  It does not affect the T            ;
;   (transparency) bit in the 34010's CONTROL register.                   ;
;                                                                         ;
;   The set_transp function sets the 34020's transparency mode to the     ;
;   value specified in the single argument, mode.  Currently, the modes   ;
;   supported on TMS34020 systems are:                                    ;
;       mode = 0     Transparent if result is equal to 0                  ;
;       mode = 1     Transparent if source is equal to COLOR0             ;
;       mode = 5     Transparent if destination is equal to COLOR0        ;
;   Other mode values are invalid and may result in undefined behavior.   ;
;   If this function is called on a TMS34010 system, it returns           ;
;   immediately; only transparency mode 0 is supported on TMS34010        ;
;   systems.                                                              ;
;                                                                         ;
;   The following is a brief description of transparency:  If             ;
;   transparency is enabled (on), and the result of a pixel processing    ;
;   operation is zero, the destination pixel is not altered.  If          ;
;   transparency is disabled (off), the destination pixel is replaced by  ;
;   the result of the pixel processing operation regardless of the value  ;
;   of that result.  For more detail, consult the TMS34010 User's Guide.  ;
;-------------------------------------------------------------------------;
; Usage:  extern void transp_on(), transp_off();                          ;
;         transp_on();                                                    ;
;         transp_off();                                                   ;
;                                                                         ;
; Returned in register A8:  void (undefined)                              ;
;-------------------------------------------------------------------------;
; Usage:  extern int get_transp();                                        ;
;         long k;                                                         ;
;         k = get_transp();                                               ;
;                                                                         ;
; Returned in register A8:  Current value of T bit (0 or 1)               ;
;-------------------------------------------------------------------------;
; Stack arguments:  None                                                  ;
;                                                                         ;
; Registers altered:  A8                                                  ;
;-------------------------------------------------------------------------;
; Revision history:                                                       ;
;  02/10/86...Original version written...................Gwyn Guidy       ;
;  05/12/86...Added TI copyright notice..................Jerry Van Aken   ;
;  11/04/86...Added get_transp...........................Stanley Acton    ;
;  03/03/87...Modified source file header................Jerry Van Aken   ;
;  07/12/88...Modified header for TIGA compatibility.....W.S.Egr          ;
;  11/22/89...Added set_transp function for 34020........Graham Short     ;
;  10/05/90...If 34010, set_transp returns immediately...Jerry Van Aken   ;
;-------------------------------------------------------------------------;
;
        .title    'transparency'
        .file     'transp.asm'
;                                            
;     INCLUDE FILES   
        .include  gspreg.inc
        .include  gsptypes.inc
        .include  gspglobs.inc
        .mlib     gspmac.lib    
;
;     DECLARE GLOBAL FUNCTION NAMES
;
        .globl  _transp_on,_transp_off,_get_transp  
        .globl  _set_transp,_dm_set_transp
;
_transp_on:
        setf    1,0,0               
        movk    1,A8                
        move    A8,@CONTROL+5,0     
        rets    0                   
;
_transp_off:
        setf    1,0,0             
        clr     A8                
        move    A8,@CONTROL+5,0   
        rets    0                    
;
_get_transp:
        setf    1,0,0
        move    @CONTROL+5,A8,0
        rets    0
;
_dm_set_transp:
        popc    A8              ;get dm-data area address
        move    *A8,A8,1        ;1st dword is mode
        jruc    common_ep       ;
;
;   C-packet entry point
;
_set_transp:
        popc    A8              ;pop mode
;
;   2 entry points join up here
;
common_ep:

        setf    1,0,0           ;set up to move 1-bit field
        move    @(_config+CONFIG_DEVICE_REV+REV_34010),A14,0 ;silicon rev
        jrnz    done            ;jump if processor is 34010, not 34020

        setf    3,0,0           ;set up to move 3-bit field
        move    A8,@CONTROL,0   ;update TM bits in 34020 CONTROL register
done:
        move    *SP(32),A14,1   ;restore C program stack pointer
        rets    2               ;
        .end

