;-------------------------------------------------------------------------;
;                                  TIGA                                   ;
;        Copyright (c) 1986-1990  Texas Instruments Incorporated.         ;
;			   All Rights Reserved				  ;
;-------------------------------------------------------------------------;
;   TIGA - Graphics Manager Core                                          ;
;-------------------------------------------------------------------------;
; set_ppop function                                                       ;
;                                                                         ;
;   Selects the pixel processing operation.  The operation selected       ;
;   determines the manner in which pixels are combined (logically or      ;
;   arithmetically) during pixel move instructions.  This function loads  ;
;   the specified pixel processing operation code (legal range from 0 to  ;
;   21, but no checking is done by this function) into the PPOP field of  ;
;   the GSP's CONTROL register.  The effects of the 22 different PPOP     ;
;   values are described in the TMS34010 User's Manual.                   ;
;-------------------------------------------------------------------------;
; Usage:  set_ppop(ppop_code)                                             ;
;                                                                         ;
; Description of stack arguments:                                         ;
;   short ppop_code;  /* pixel processing operation code */               ;
;                                                                         ;
; Returned in register A8:  Void (undefined).                             ;
;                                                                         ;
; Registers altered:  A8                                                  ;
;-------------------------------------------------------------------------;
; Revision history:                                                       ;
;  03/03/86...Original version written...................Jerry Van Aken   ;
;  07/12/88...Added TIGA direct mode.....................W.S.Egr          ;
;-------------------------------------------------------------------------;
;
        .title    'set ppop'
        .file     'setppop.asm'
;
;
;     DECLARE GLOBAL FUNCTION NAME
;
        .globl    _set_ppop
        .globl    _dm_set_ppop
;
;
;     DEFINE CONSTANTS
        .include  gspreg.inc
;
;    DIRECT-MODE ENTRY POINT
;
_dm_set_ppop:
        move    -*A14,A8,1          ;get dm-data area address
        setf    16,1,0              ;parm is word length
        move    *A8,A8,0            ;1st word parm is ppop_code
        jruc    common_ep           ;jump to common entry point
;
;    C-PACKET ENTRY POINT
;
_set_ppop:
        move    *-A14,A8,1          ;pop ppop_code from stack
;
;    2 ENTRY POINTS JOIN UP HERE
;
common_ep:
        setf    5,0,0               
        move    A8,@CONTROL+10,0    
        rets    2                   
        .end

