;-------------------------------------------------------------------------;
;                                  TIGA                                   ;
;        Copyright (c) 1987-1990  Texas Instruments Incorporated.         ;
;			   All Rights Reserved				  ;
;-------------------------------------------------------------------------;
;   TIGA - Graphics Manager Core                                          ;
;-------------------------------------------------------------------------;
;                                                                         ;
; lmo and rmo functions                                                   ;
;                                                                         ;
;   The lmo function computes the bit number of the leftmost one in the   ;
;   argument.  The rmo function computes the bit number of the rightmost  ;
;   one in the argument.  The argument is treated as a 32-bit number      ;
;   whose bits are numbered from 0 to 31, where bit 0 is the LSB and bit  ;
;   31 is the MSB.                                                        ;
;                                                                         ;
;   The return value is in the range 0 to 31.  If the argument is all     ;
;   0s, a value of -1 is returned.                                        ;
;-------------------------------------------------------------------------;
; Usage:  lmo(n);                                                         ;
;         rmo(n);                                                         ;
;                                                                         ;
; Description of stack arguments:                                         ;
;         long n;   /* 32-bit integer */                                  ;
;                                                                         ;
; Returned in register A8:  Bit number                                    ;
;                                                                         ;
; Registers altered:  A8                                                  ;
;-------------------------------------------------------------------------;
;  09/14/87  Original Version Written                      Jerry Van Aken ;
;  07/07/89  Modified to use 34020 instruction.............A.Sharp        ;
;-------------------------------------------------------------------------;

;
         .title   'left/rightmost one'
         .file    'lmormo.asm'
         .include oem.inc
;
;
;     DECLARE GLOBAL FUNCTION NAME
;
         .globl    _lmo,_dm_lmo
         .globl    _rmo,_dm_rmo
;
;     ENTRY POINTS
;
_dm_lmo:
         MOVE     *-A14,A8,1               ;get pointer to data area
         MOVE     *A8,A8,1
         JRUC     COMMON_EP_LMO
_lmo:
         MOVE     *-A14,A8,1               ;get arg
COMMON_EP_LMO:   
         JRZ      ALLZEROS                 ;jump if argument = 0
         LMO      A8,A8                    ;
         XORI     31,A8                    ;convert to positive bit no.
         MOVE      *SP(32),A14,1           ;restore program stack pointer
         RETS     2                        
ALLZEROS:
         NOT      A8                       ;set return value = -1
         RETS     2                        ;


_dm_rmo:
         MOVE     *-A14,A8,1               ;get pointer to data area
         MOVE     *A8,A8,1                 ;
         JRUC     COMMON_EP_RMO            ;
_rmo:
         MOVE     *-A14,A8,1               ;get arg
COMMON_EP_RMO:   
         JRZ      ALLZEROS                 ;jump if argument = 0
        .if     GSP_34010 ;  Code used if the processor is a 34010
         MOVE     A0,*-SP,1                ;save register
         MOVE     A8,A0                    ;copy arg
         NEG      A0                       ;
         AND      A0,A8                    ;isolate rightmost one
         LMO      A8,A8                    ;
         MOVK     31,A0                    ;
         XOR      A0,A8                    ;convert to positive bit no.
         MOVE     *SP+,A0,1                ;restore register
        .endif
        .if GSP_34020
         RMO      A8,A8                    
        .endif
         RETS     2                        ;
         .end


