        .width    132
;---------------------------------------------------------------------------;
;                                    TIGA                                   ;
;           Copyright (c) 1990  Texas Instruments Incorporated.             ;
;                          All Rights Reserved                              ;
;---------------------------------------------------------------------------;
;                                                                           ;
; field_extract and field_insert functions				    ;
;                                                                           ;
;---------------------------------------------------------------------------;
; History:								    ;
;   02/07/90...Original functions written...................J.R. Van Aken   ;
;---------------------------------------------------------------------------;
;
;   DECLARE GLOBAL FUNCTION NAMES
;
        .global   _field_extract,_field_insert

;---------------------------------------------------------------------------;
;   Function: _field_extract	    Extract Field from GSP Memory
;
;   Syntax:
;	unsigned long field_extract(gptr, fs)
;	unsigned long gptr;	 /* pointer to GSP memory address */
;	unsigned short fs;	 /* field size */
;
;   Description:
;	The field_extract function returns the contents of a location in
;	memory.  Argument gptr is a pointer containing the 32-bit address
;	of a field in the GSP's memory. Argument fs specifies the length
;	of the field, and is restricted to values in the range 1 to 32
;	bits. The function definition places no restrictions on the
;	alignment of the address. Given an fs value of N, and a gptr
;	value of A, the field consisting of contiguous bits A through
;	A+N-1 in memory are returned in the N LSBs of the return value.
;	The result is zero-extended.
;---------------------------------------------------------------------------;
;
;   ENTRY POINT
;
_field_extract:

        MOVE      -*A14,A8,1          ;get argument gptr
        MOVE      -*A14,A14,1         ;get argument fs
        EXGF      A14,0               ;load FE and FS for field 0
	MOVE	  *A8,A8,0	      ;extract field from memory
	ZEXT	  A8,0		      ;just in case FE = 1
        MOVE      *SP(32),A14,1       ;restore program stack pointer
        RETS      2                   ;


;---------------------------------------------------------------------------;
;   Function:  _field_insert	    Insert Field into GSP Memory
;
;	void field_insert(gptr,fs,data)
;	unsigned long  gptr;		/* pointer to GSP memory address
;	unsigned short fs;		/* field size
;	unsigned long  data;		/* data to be inserted
;
;   Description:
;	The field_insert function writes the value of data into the
;	GSP memory specified by gptr. The field size parameter fs must be
;	between 1 and 32 inclusive, and specifies the number of bits to
;	be written. Bit 0 (the least significant bit) of data is written
;	first, followed by bit 1 and so on until the specified number of
;	bits have been written. There are no restrictions as to the
;	alignment of the GSP address.
;---------------------------------------------------------------------------;
;
;   ENTRY POINT
;
_field_insert:

	MOVE	  *A14(-64),A8,1      ;get argument fs
	EXGF	  A8,0		      ;load FE and FS for field 0
        MOVE      -*A14,A8,1          ;get argument gptr
	MOVE	  *A14(-64),A14,1     ;get argument data
	MOVE	  A14,*A8,0	      ;insert field into memory
        MOVE      *SP(32),A14,1       ;restore program stack pointer
        RETS      2                   ;
        .end

