;-------------------------------------------------------------------------;
;                                  TIGA                                   ;
;        Copyright (c) 1986-1990  Texas Instruments Incorporated.         ;
;                          All Rights Reserved                            ;
;-------------------------------------------------------------------------;
;   TIGA - Graphics Manager Core                                          ;
;-------------------------------------------------------------------------;
; cpw function                                                            ;
;                                                                         ;
;   Compare point to window function.  Returns 4-bit outcode value.       ;
;   Outcode value is 0000 if specified coordinates lie within             ;
;   current window.  Outcode is 01xx if point is above window, 10xx if    ;
;   point is below window, xx01 if point is to left of window, and xx10   ;
;   if point is to right of window.  Window is defined as intersection    ;
;   of three rectangles:  (1) the screen, (2) the viewport, and (3) the   ;
;   clipping rectangle.                                                   ;
;                                                                         ;
;   This function is designed to be called from a GSP-C program.          ;
;-------------------------------------------------------------------------;
; Usage:  cpw(x, y)                                                       ;
;                                                                         ;
; Description of stack arguments:                                         ;
;     int x, y;  /* coordinates of point to be compared to window */      ;
;                                                                         ;
; Returned in register A8:  Outcode in 4 LSBs                             ;
;                                                                         ;
; Registers altered:  A8                                                  ;
;-------------------------------------------------------------------------;
; Revision history:                                                       ;
;  09/04/86...Original version written...................Jerry Van Aken   ;
;  01/31/89...Converted to TIGA function.................Graham Short     ;
;-------------------------------------------------------------------------;
;
        .title    'compare point'
        .file     'cpw.asm'
;
;     DECLARE GLOBAL FUNCTION NAME
;
        .globl    _cpw
        .globl    _dm_cpw
;
;     INCLUDE FILES
;
        .include  gspreg.inc
        .include  gsptypes.inc
        .include  gspglobs.inc
        .mlib     gspmac.lib
;
;     C-PACKET ENTRY POINT
;
_cpw:
        Push      A0                  ;Save register
        Popc      A0                  ;Read x coordinate value
        Popc      A8                  ;Read y coordinate value
        sll       16,A8               ;Form XY address
        movy      A8,A0               ;
        jruc      common_ep
;
;     C-PACKET ENTRY POINT
;
_dm_cpw:
        Push      A0                  ;Save register
        Popc      A0                  ;Pop pointer to data area
        Move      *A0,A0,1            ;Read y::x coordinate value
;
;    ENTRY POINTS JOIN UP HERE
;
common_ep:
        MOVE      @(_env+ENVIRONMENT_XYORIGIN),A8,1     
        addxy     A8,A0                         ;
        cpw       A0,A8                         ;Compare point to window
        srl       5,A8                          ;Right justify 4-bit outcode
        Pop       A0                            ;Restore register
        rets      2
        .end

