/*****************************************************************************/
/*  EXAMPLE.C                                                                */
/*                                                                           */
/*  This file contains an sample program that is used to illustrate analyzer */
/*  examples.  It is not intended to represent a real program.  The program  */
/*  contains calls to the function write_number() in 4 different places to   */
/*  simulate situations in real programs where functions are called from     */
/*  multiple places.  This program writes random numbers to random places    */
/*  in an array called results.  Examples in the TMS320C30 trace analyzer    */
/*  addendum reference this sample  program.                                 */
/*                                                                           */
/*****************************************************************************/

#define SEED 1
extern meminit();
extern xf0_on();
extern xf0_off();

int results[256];                /* data storage area */
int previous[2] = { 0, 1};       /* previous 2 random numbers */
int rnum = SEED;                 /* random number */

main()
{
   meminit();

   for ( ; ; )
   {
      previous[0] = previous[1];  /* save the two previous random numbers */
      previous[1] = rnum;

      random(&rnum);  /* generate a random number */

	  /***********************************************/
	  /* switch on the two least significant bits of */
	  /* previous random number                      */
	  /***********************************************/
      switch(rnum & 3)
      {
         case 0 : write_number();
                  break;

         case 1 : write_number();
		          break;

         case 2 : write_number();
                  xf0_on();
                  break;

         case 3 : write_number();
                  xf0_off();
		          break;
      }
   }
}

write_number()
{
   results[previous[0]] = rnum;
}

random(r)
int *r;
{
   *r = rand() & 0xFF;
}
