
***************************************************************
* BOOT v2.00  - C startup routine
* Copyright (c) 1989 Texas Instruments Inc.
***************************************************************
*
* This is the initial boot routine for TMS320C30 C Programs.
* It must be linked and loaded with all C programs.  The
* entry point for C programs is called "_c_int00", defined
* in this module.
*
* This module performs the following actions:
*    1) Allocate and initialize the system stack
*    2) Perform auto-initialization
*    3) Call the function _main to start the user's program
***************************************************************

STACK_SIZE  .set  100h		  ;size of system stack
FP          .set  AR3             ;frame pointer

            .global cinit, .bss, _main, _exit
            .global _c_int00

;
; Allocate space for the system stack.
; Initialize the first words in .text to point to the stack
; and initialization tables.
;
stack       .usect  ".stack",STACK_SIZE

            .text
stack_addr  .word  stack          ;address of stack
init_addr   .word  cinit          ;address of init tables

***************************************************************
* _C_INT00 - C entry point function
***************************************************************
_c_int00:
;
; Set up the initial stack pointer
;
        LDP     stack_addr        ;get page of stored address
        LDI     @stack_addr,SP    ;load the address into SP
        LDI     SP,FP             ;and into FP too
;
; Do autoinitialization
;
        LDP     init_addr         ;get page of stored address
        LDI     @init_addr,AR0    ;get address of init tables
        CMPI    -1,AR0            ;if RAM model, skip init
        BEQ     done
        LDI     *AR0++,RC         ;get first count
        BZD     done              ;if 0, nothing to do
        LDI     *AR0++,AR1        ;get dest address
        LDI     *AR0++,R0         ;get first word
        SUBI    1,RC              ;count - 1
do_init:
        RPTB    init              ;block copy
init:   STI     R0,*AR1++
    ||  LDI     *AR0++,R0
        LDI     R0,RC             ;move next count into RC
        OR      R0,R0             ;test r0 for zero
        BNZD    do_init           ;if there is more, repeat
        LDI     *AR0++,AR1        ;get next dest address
        LDI     *AR0++,R0         ;get next first word
        SUBI    1,RC              ;count - 1
done:
;
; For the small model, set up the DP to point to the .bss section
;
        LDP     .bss
;
; Call main()
;
        CALL    _main
        CALL    _exit
        RETI
        .end

