************************************************************************
*
*    C31BOOT - TMS320C31 BOOT LOADER PROGRAM
*              (C) COPYRIGHT TEXAS INSTRUMENTS INC., 1990
*
*    NOTE:    1. AFTER DEVICE RESET, THE PROGRAM IS SETTING TO WAIT
*                FOR THE EXTERNAL INTERRUPTS. THE FUNCTION SELECTION
*                OF THE EXTERNAL INTERRUPTS ARE AS FOLLOWINGS:
*                ---------------------------------------------------
*                 INTERRUPT PIN |             FUNCTION
*                ---------------|-----------------------------------
*                       0       | EPROM boot loader from 1000H
*                ---------------|-----------------------------------
*                       1       | EPROM boot loader from 80A000H
*                ---------------|-----------------------------------
*                       2       | EPROM boot loader from FFF000H
*                ---------------|-----------------------------------
*                       3       | Serial port 0 boot loader
*                ---------------------------------------------------
*
*             2. EPROM BOOT LOADER LOADS WORD, HALF-WORD, OR BYTE
*                WIDE PROGRAM TO DIFFERENT SPECIFIED LOCATIONS. THE
*                8 LSBs OF FIRST MEMORY SPECIFIES THE MEMORY WIDTH OF
*                THE EPROM. IF THE HALF-WORD OR BYTE WIDE PROGRAM IS
*                SELECTED, THE LSBs IS LOADING FIRST AND THEN MSBs.
*                THE FOLLOWING WORD CONTAINS THE CONTROL WORD FOR
*                THE LOCAL MEMORY REGISTER. THE NEXT ARE THE PROGRAM
*                BLOCKS. FIRST TWO WORD OF EACH PROGRAM BLOCK CONTAIN
*                BLOCK SIZE AND MEMORY ADDRESS TO BE LOADED INTO.
*                WHEN THE ZERO BLOCK SIZE IS READ, THE PROGRAM BLOCK
*                LOADING IS TERMINATED. THE PC WILL BRANCH TO THE
*                STARTING ADDRESS OF THE FIRST PROGRAM BLOCK.
*
*             3. IF SERIAL PORT 0 IS SELECTED FOR BOOT LOADING,
*                PROCESSOR WILL WAIT FOR THE INTERRUPT FROM THE
*                RECEIVE SERIAL PORT 0 AND TO PERFORM THE DOWNLOAD.
*                SIMILAR TO THE EPROM LOADER, PROGRAM CAN BE LOADED
*                INTO DIFFERENT MEMORY BLOCKS. FIRST TWO WORD OF EACH
*                PROGRAM BLOCK CONTAIN BLOCK SIZE AND MEMORY ADDRESS
*                TO BE LOADED INTO. WHEN THE ZERO BLOCK SIZE IS READ,
*                THE PROGRAM BLOCK LOADING IS TERMINATED. IN THE OTHER
*                WORDS, IN ORDER TO TERMINATE THE PROGRAM BLOCK LOADING,
*                A ZERO HAS TO BE ADDED AT THE END OF PROGRAM BLOCK.
*                AFTER THE BOOT LOADING IS COMPLETED, THE PC WILL BRANCH
*                TO THE STARTING ADDRESS OF THE FIRST PROGRAM BLOCK.
*
*                DANIEL CHEIN-CHUNG CHEN      JANUARY, 1990
*
*    CHANGES: A. INTERRUPT AND TRAP VECTORS CHANGED TO POINT TO ON CHIP
*                RAM.  INTERRUPTS POLLED TO DETERMINE SOURCE OF LOAD.
*
*             B. LOAD ADDRESSES MODIFIED TO MAP ONTO THE C31 MEMORY MAP.
*
*                JAY REIMER                   MARCH, 1990
*
*    MEMORY:	 100h : 040h for interrupt and trap vectors
*			05Dh for program
*
************************************************************************
            .global check
	    .sect  "vectors"
reset	    .word  check
int0	    .word  809FC1h
int1	    .word  809FC2h
int2	    .word  809FC3h
int3	    .word  809FC4h
xint0	    .word  809FC5h
rint0	    .word  809FC6h
xint1	    .word  809FC7h
rint1	    .word  809FC8h
tint0	    .word  809FC9h
tint1	    .word  809FCAh
dint	    .word  809FCBh
	    .word  809FCCh	      ; Reserved Area
	    .word  809FCDh	      ; Reserved Area
	    .word  809FCEh	      ; Reserved Area
	    .word  809FCFh	      ; Reserved Area
	    .word  809FD0h	      ; Reserved Area
	    .word  809FD1h	      ; Reserved Area
	    .word  809FD2h	      ; Reserved Area
	    .word  809FD3h	      ; Reserved Area
	    .word  809FD4h	      ; Reserved Area
	    .word  809FD5h	      ; Reserved Area
	    .word  809FD6h	      ; Reserved Area
	    .word  809FD7h	      ; Reserved Area
	    .word  809FD8h	      ; Reserved Area
	    .word  809FD9h	      ; Reserved Area
	    .word  809FDAh	      ; Reserved Area
	    .word  809FDBh	      ; Reserved Area
	    .word  809FDCh	      ; Reserved Area
	    .word  809FDDh	      ; Reserved Area
	    .word  809FDEh	      ; Reserved Area
	    .word  809FDFh	      ; Reserved Area

***************************************************************************
 
trap0	    .word  809FE0h
trap1	    .word  809FE1h
trap2	    .word  809FE2h
trap3	    .word  809FE3h
trap4	    .word  809FE4h
trap5	    .word  809FE5h
trap6	    .word  809FE6h
trap7	    .word  809FE7h
trap8	    .word  809FE8h
trap9	    .word  809FE9h
trap10	    .word  809FEAh
trap11	    .word  809FEBh
trap12	    .word  809FECh
trap13	    .word  809FEDh
trap14	    .word  809FEEh
trap15	    .word  809FEFh
trap16	    .word  809FF0h
trap17	    .word  809FF1h
trap18	    .word  809FF2h
trap19	    .word  809FF3h
trap20	    .word  809FF4h
trap21	    .word  809FF5h
trap22	    .word  809FF6h
trap23	    .word  809FF7h
trap24	    .word  809FF8h
trap25	    .word  809FF9h
trap26	    .word  809FFAh
trap27	    .word  809FFBh
	    .word  809FFCh	      ; Reserved
	    .word  809FFDh	      ; Reserved
	    .word  809FFEh	      ; Reserved
	    .word  809FFFh	      ; Reserved
 
***************************************************************************

	    .space 7
 
check:      LDI    4040h,AR0          ; load periferal mem. map
	    LSH    9,AR0	      ; start addr. 808000h
	    LDI    404Ch,SP	      ; initialize stack pointer to
	    LSH    9,SP 	      ; ram0 addr. 809800h
	    LDI    0,R0 	      ; set start address flag off

intloop     TSTB   8,IF 	      ; test for ext int3
	    BNZ    serial	      ; on int3 go to serial

	    LDI    8,AR1	      ; load 001000h / 2^9 -> AR1
	    TSTB   1,IF 	      ; test for int0
	    BNZ    eprom_load	      ; branch to eprom_load if int0 = 1

	    LDI    4050h,AR1	      ; load 80A000h / 2^9 -> AR1
	    TSTB   2,IF 	      ; test for int1
	    BNZ    eprom_load	      ; branch to eprom_load if int1 = 1

	    LDI    7FF8h,AR1	      ; load FFF000h / 2^9 -> AR1
	    TSTB   4,IF 	      ; test for int2
	    BZ	   intloop	      ; if no intX go to intloop

eprom_load  LSH    9,AR1	      ; eprom address = AR1 * 2^9
	    LDI    *AR1++(1),R1       ; load eprom mem. width

	    LDI    sub_w,AR3	      ; full-word size subroutine address -> AR3
	    LSH    26,R1	      ; test bit 5 of mem. width word
	    BN	   load0	      ; if '1' start PGM loading (32 bits width)

	    NOP    *AR1++(1)	      ; jump last half word from mem. word
	    LDI    sub_h,AR3	      ; half-word size subroutine address -> AR3
	    LSH    1,R1 	      ; test bit 4 of mem. width word
	    BN	   load0	      ; if '1' start PGM loading (16 bits width)

	    LDI    sub_b,AR3	      ; byte size subroutine address -> AR3
	    ADDI   2,AR1	      ; jump last 2 bytes from mem. word

load0	    CALLU  AR3		      ; load new word according to mem. width
	    STI    R1,*+AR0(64h)      ; set primary bus control

load2	    CALLU  AR3		      ; load new word according to mem. width
	    LDI    R1,RC	      ; set block size for repeat loop
	    CMPI   0,RC 	      ; if 0 block size start PGM
	    BZ	   AR2
	    SUBI   1,RC 	      ; block size -1

	    CALLU  AR3		      ; load new word according to mem. width
	    LDI    R1,AR4	      ; set destination address
	    LDI    R0,R0	      ; test start address loaded flag
	    LDIZ   R1,AR2	      ; load start address if flag off
	    LDI    -1,R0	      ; set start & dest. address flag on
	    SUBI   1,AR3	      ; sub address with loop

	    CALLU  AR3		      ; load new word according to mem. width
	    LDI    1,R0 	      ; set dest. address flag off
	    ADDI   1,AR3	      ; sub address without loop
	    B	   load2	      ; jump to load a new block when loop
				      ; completed

	    .space 1

serial	    LDI    sub_s,AR3	      ; serial words subroutine address -> AR3
	    LDI    111h,R1	      ; R1 = 0000111h
	    STI    R1,*+AR0(43h)      ; set CLKR,DR,FSR as serial port pins
	    LDI    0A30h,R2
	    LSH    16,R2	      ; R2 = A300000h
	    STI    R2,*+AR0(40h)      ; set serial port global ctrl. register
	    B	   load2	      ; jump to load 1st block

	    .space 29

loop_s	    RPTB   load_s	      ; PGM load loop
sub_s	    TSTB   20h,IF
	    BZ	   sub_s	      ; wait for receive buffer full
	    AND    0FDFh,IF	      ; reset interrupt flag
	    LDI    *+AR0(4Ch),R1
	    LDI    R0,R0	      ; test load address flag
	    BNN    sub_end
load_s	    STI    R1,*AR4++(1)       ; store new word to dest. address
	    RETSU		      ; return from subroutine

	    .space 22

loop_h	    RPTB   load_h	      ; PGM load loop
sub_h	    LDI    *AR1++(1),R1       ; load LSB half-word
	    AND    0FFFFh,R1
	    LDI    *AR1++(1),R2       ; load MSB half-word
	    LSH    16,R2
	    OR	   R2,R1	      ; R1 = a new 32 bits word
	    LDI    R0,R0	      ; test load address flag
	    BNN    sub_end
load_h	    STI    R1,*AR4++(1)       ; store new word to dest. address
	    RETSU		      ; return from subroutine

	    .space 26

loop_w	    RPTB   load_w	      ; PGM load loop
sub_w	    LDI    *AR1++(1),R1       ; read a new 32 bits word
	    LDI    R0,R0	      ; test load address flag
	    BNN    sub_end
load_w	    STI    R1,*AR4++(1)       ; store new word to dest. address
	    RETSU		      ; return from subroutine

	    .space 14

loop_b	    RPTB   load_b	      ; PGM load loop
sub_b	    LDI    *AR1++(1),R1
	    AND    0FFh,R1	      ; load 1st byte ( LSB )
	    LDI    *AR1++(1),R2
	    AND    0FFh,R2
	    LSH    8,R2
	    OR	   R2,R1	      ; load 2nd byte
	    LDI    *AR1++(1),R2
	    AND    0FFh,R2
	    LSH    16,R2
	    OR	   R2,R1	      ; load 3rd byte
	    LDI    *AR1++(1),R2       ; load 4th byte ( MSB )
	    LSH    24,R2
	    OR	   R2,R1	      ; R1 = a new 32 bits word
	    LDI    R0,R0	      ; test load address flag
	    BNN    sub_end
load_b	    STI    R1,*AR4++(1)       ; store new word to dest. address
sub_end     RETSU		      ; return from subroutine

	    .space 1
 
	    .end
