/****************************************************************************/
/* C.CMD -  v3.00   COMMAND FILE FOR LINKING C30 C PROGRAMS                 */
/*                                                                          */
/*    Usage:       lnk30 <obj files...>  -o <out file> -m <map file> c.cmd  */
/*                                                                          */
/*    Description: This file is a sample command file that can be used      */
/*                 for linking programs built with the TMS320C30 C          */
/*                 Compiler.   Use it a guideline; you may want to change   */
/*                 the allocation scheme according to the size of your      */
/*                 program and the memory layout of your target system.     */
/*                                                                          */
/*    Notes: (1)   You must specify the directory in which rts.lib is       */
/*                 located.  Either add a "-i<directory>" line to this      */
/*                 file, or use the system environment variable C_DIR to    */
/*                 specify a search path for libraries.                     */
/*                                                                          */
/*           (2)   When using the small (default) memory model, be sure     */
/*                 that the ENTIRE .bss section fits within a single page.  */
/*                 To satisfy this, .bss must be smaller than 64K words and */
/*                 must not cross any 64K boundaries.                       */
/****************************************************************************/
-c                                         /* LINK USING C CONVENTIONS      */
-lrts.lib                                  /* GET RUN-TIME SUPPORT          */

/* SPECIFY THE SYSTEM MEMORY MAP */

MEMORY
{
   VECS:   org = 0        len = 0x40
   ROM:    org = 0x40     len = 0x7fffc0
   RAM0:   org = 0x809800 len = 0x400      /* RAM BLOCK 0                   */
   RAM1:   org = 0x809c00 len = 0x1400     /* RAM BLOCK 1, PLUS 4K OF EXT   */
}

/* SPECIFY THE SECTIONS ALLOCATION INTO MEMORY */

SECTIONS
{
   .text:   {} > ROM                 /* CODE                                */
   .cinit:  {} > ROM                 /* INITIALIZATION TABLES               */
   .stack:  {} > RAM0                /* SYSTEM STACK                        */
   .bss:    {} > RAM1                /* GLOBAL & STATIC VARS (SEE NOTE 2)   */
   .sysmem: {} > RAM1                /* DYNAMIC MEMORY - DELETE IF NOT USED */
}
