/*************************************************************************/
/* time.h v2.10                                                          */
/* Copyright (c) 1989 Texas Instruments Inc.                             */
/*************************************************************************/
#ifndef CLK_TCK

#define CLK_TCK   1000

typedef unsigned long clock_t;
typedef unsigned long time_t;

struct tm {
	    unsigned int tm_sec;      /* seconds after the minute   - [0,59]  */
	    int          tm_min;      /* minutes after the hour     - [0,59]  */
	    int          tm_hour;     /* hours after the midnight   - [0,23]  */
	    int          tm_mday;     /* day of the month           - [1,31]  */
	    int          tm_mon;      /* months since January       - [0,11]  */
	    int          tm_year;     /* years since 1900                     */
	    int          tm_wday;     /* days since Sunday          - [0,6]   */
	    int          tm_yday;     /* days since Jan 1st         - [0,365] */
	    int          tm_isdst;    /* Daylight Savings Time flag           */
	  };

extern time_t     time();    /* SYSTEM SPECIFIC  */
extern clock_t    clock();   /* SYSTEM SPECIFIC  */

extern double     difftime();
extern time_t     mktime();
extern char      *asctime();
extern char      *ctime();
extern struct tm *gmtime();
extern struct tm *localtime();
extern int        strftime();
#endif

