/************************************************************************/
/*  ctype.h v4.00                                                       */
/*  Copyright (c) 1990 Texas Instruments Incorporated                   */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*  CHARACTER TYPING FUNCTIONS AND MACROS                               */
/*                                                                      */
/*  Note that in this implementation, either macros or functions may    */
/*  be used.  Macros are prefixed with an underscore.                   */
/*                                                                      */
/************************************************************************/
#ifndef _CTYPE
#define _CTYPE

extern unsigned char _ctypes_[];

#define _UC_   0x01           /* UPPER CASE  */
#define _LC_   0x02           /* LOWER CASE  */
#define _NM_   0x04           /* NUMERICAL   */
#define _SP_   0x08           /* SPACE       */
#define _PU_   0x10           /* PUNCTUATION */
#define _CL_   0x20           /* CONTROL     */
#define _HX_   0x40           /* HEX DIGIT   */
#define _BL_   0x80           /* BLANK       */

/************************************************************************/
/*   FUNCTION DEFINITIONS                                               */
/************************************************************************/
int isalnum(int _c);
int isalpha(int _c);
int iscntrl(int _c);
int isdigit(int _c);
int isgraph(int _c);
int islower(int _c);
int isprint(int _c);
int ispunct(int _c);
int isspace(int _c);
int isupper(int _c);
int isxdigit(int _c);
int isascii(int _c);

int toupper(int _c);
int tolower(int _c);
int toascii(int _c);

/************************************************************************/
/*  MACRO DEFINITIONS                                                   */
/************************************************************************/
#define _isalnum(a)  (_ctypes_[(a)+1] & (_UC_ | _LC_ | _NM_))
#define _isalpha(a)  (_ctypes_[(a)+1] & (_UC_ | _LC_))
#define _iscntrl(a)  (_ctypes_[(a)+1] & _CL_)
#define _isdigit(a)  (_ctypes_[(a)+1] & _NM_)
#define _isgraph(a)  (_ctypes_[(a)+1] & (_UC_ | _LC_ | _NM_ | _PU_))
#define _islower(a)  (_ctypes_[(a)+1] & _LC_)
#define _isprint(a)  (_ctypes_[(a)+1] & (_BL_ | _UC_ | _LC_ | _NM_ | _PU_))
#define _ispunct(a)  (_ctypes_[(a)+1] & _PU_)
#define _isspace(a)  (_ctypes_[(a)+1] & _SP_)
#define _isupper(a)  (_ctypes_[(a)+1] & _UC_)
#define _isxdigit(a) (_ctypes_[(a)+1] & _HX_)
#define _isascii(a)  (((a) & ~0x7F) == 0)

#define _toupper(b)  ((_islower(b)) ? (b) - ('a' - 'A') : (b))
#define _tolower(b)  ((_isupper(b)) ? (b) + ('a' - 'A') : (b))
#define _toascii(a)  ((a) & 0x7F)

#endif
