* Variable declaration file for Flash algorithms and            *
* c2xxprog.asm                                                  *
*                                                               *
*Note:                                                          *
*DLOOP is a delay loop variable used in flash algorithms. This  *
*is a function of CLKOUT1. If the F206 device runs at any other *
*CLKOUT1 speed other than 20MHz, DLOOP value should be defined  *
*as per the equation, explained below. Use of current DLOOP     *
*for flash programming at speeds other than 20Mhz is not        *
*recommended!.                                                  *        
*                                                                *
* Rev 1.20                                                      *
* Modified for F2xx: Sam Saba                     12/24/96      *
*****************************************************************
*
        .mmregs
BASE    .set    0300h            ; Base address for variables
B2_0    .set    BASE+0           ; can be changed to relocate
B2_1    .set    BASE+1           ; variable space in RAM
B2_2    .set    BASE+2
B2_3    .set    BASE+3
B2_4    .set    BASE+5
B2_5    .set    BASE+6
B2_6    .set    BASE+7
SPAD1   .set    BASE+8           ; Scatch pad registers
SPAD2   .set    BASE+9

FL_ADRS .set    BASE+10         ;FLASH LOAD ADRS
FL_DATA .set    BASE+11         ;FLASH LOAD DATA
FL_CTRL .set    BASE+12         ;FLASH CTRL REG ADRS
FL_BYTE .set    BASE+13         ;BYTE TO BE FLASHED
PGM_MASK .set   BASE+14         ;BITS TO BE FLASHED
ERROR    .set   BASE+15         ;ERROR flag register

*Variables for CLEAR
NRPG    .set    BASE+10         ;
RPG1    .set    BASE+11         ;
RPG2    .set    BASE+12         ;
RPG5    .set    BASE+13         ;
RPG10   .set    BASE+14         ;

*Variables for ERASE
SEG_ST  .set    BASE+11         ;
SEG_END .set    BASE+12         ;

*
*CONSTANTS
PARMS   .set    6h
*
* Delay variables for CLEAR,ERASE and PROGRAM
D5	.set	1		;5us delay
D10     .set    2               ;10us delay
D100	.set	20		;100us delay
D2K5    .set    500             ;2.5ms delay
D5K     .set    1000            ;5ms delay
D7K5    .set    1500            ;7.5ms delay
D50K    .set    10000           ;50ms delay
D25K    .set    5000            ;25ms delay
D75K    .set    15000           ;75ms delay
D100K   .set    20000           ;100ms delay
DMAX    .set    0FFFFh          ;3001ms delay

*DLOOP	.set	63		;5us delay loop @ 5MIPs
*DLOOP	.set	127		;5us delay loop @ 10MIPs
DLOOP  .set     100             ;5us delay loop @ 20MIPs
*
*DLOOP variable for variable CLKOUT1
*Calculate DLOOP in decimal using the equation 
* DLOOP=5us*CLKOUT1;
*Examples
*a. @15Mhz,  DLOOP= 5us*15Mhz = 75;
*b. @9.8304Mhz,  DLOOP= 5us*9.8304Mhz = 49;
*c. @16.384Mhz,  DLOOP= 5us*16.384Mhz = 81;

* On-chip I/O registers
F_ACCESS0 .set    0FFE0h  ;206 access REGISTER 0
F_ACCESS1 .set    0FFE1h  ;206 access register 1
PMST      .set    0FFE4h  ;Defines SARAM in PM/DM and MP/MC bit

*
* Flash control register
* 15-8    - 7     6  5  4    3    2     1     0
* Seg_bits  Busy  Key   ver0 ver1 Write Erase Exe

