*************************************************************
** FLASH Programming utilities                             **
**                                                         **
** Called by: These utilites are used by CLEAR,ERASE,      **
**            PROGRAM algorithms written for F2xx devices  **
**            c2xxprog.asm                                 ** 
** Function : DELAY - Delay loop specified by AR6          **
**            REGS  - Activates F_ACCESS 0/1 registers to  **
**                    access Flash array control registers **                              
**            ARRAY - Deactivates F_ACCESS0/1 register to  **
**                    the Flash array in array mode        **
** Version : 1.10                                          **
** Modified for F2xx : Sam Saba                 12/24/96   **
**	    for F240 : David Figoli		15 Jan 97        **
*************************************************************
        .include "svar0.h"
        .def DELAY,REGS,ARRAY
        .ref FL_ST
	.sect	"DLY"
DELAY
	LAR	AR6,B2_1	;AR6 = OUTER LOOP COUNT
DLY_LP  RPT	#DLOOP		;WASTE 257 CYCLES
        NOP
	BANZ	DLY_LP,*-	;LOOP UNTIL DONE
	RET			;RETURN TO CALLING SEQUENCE

        .sect   "REG"
REGS
	OUT	SPAD2, 0FF0Fh	;Enable Reg mode  (DAF)
        RET                     ;RETURN TO CALLING SEQUENCE
				;Note: SPAD2 is only a dummy var here

	.sect	"ARY"
ARRAY
	IN	SPAD2, 0FF0Fh	;Enable Array mode (DAF)
        RET                     ;RETURN TO CALLING SEQUENCE
				;Note: SPAD2 is only a dummy var here
           .end         


