*************************************************************
** FLASH register utilities                                **
**                                                         **
** Called by: These utilites are used by CLEAR,ERASE,      **
**            PROGRAM algorithms written for F2xx devices  **
**            c2xxprog.asm and other flash application     **
**            programs                                     **
** Function : DELAY - Delay loop specified by AR6          **
**            REGS  - Activates F_ACCESS 0/1 registers to  **
**                    access Flash array control registers **                              
**            ARRAY - Deactivates F_ACCESS0/1 registers to **
**                    access Flash array in array mode     **
** Version : 1.20                                          **
** Modified for F2xx : Sam Saba                 4/17/97    **
*************************************************************
        .include "svar1.h"
        .def DELAY,REGS,ARRAY
        .ref FL_ST
	.sect	"DLY"
DELAY
	LAR	AR6,B2_1	;AR6 = OUTER LOOP COUNT
DLY_LP  RPT	#DLOOP		;WASTE 257 CYCLES
        NOP
	BANZ	DLY_LP,*-	;LOOP UNTIL DONE
	RET			;RETURN TO CALLING SEQUENCE

        .sect   "REG"
REGS
        SPLK    #0000h,SPAD2
        sacl    SPAD1
        lacc    FL_ST
        sub     #4000h
        bcnd    reg1, geq       ;if address>= 4000h,set
                                ;set reg mode for flash1 array
        OUT     SPAD2,F_ACCESS0
        lacc    SPAD1
        RET
reg1    OUT     SPAD2,F_ACCESS1
        lacc    SPAD1
        RET                     ;RETURN TO CALLING SEQUENCE
        

	.sect	"ARY"
ARRAY
        SPLK    #0001h,SPAD2
        sacl    SPAD1
        lacc    FL_ST
        sub     #4000h
        bcnd    ary1, geq       ;if address>= 4000h,set
                                ;set reg mode for flash1 array
        OUT     SPAD2,F_ACCESS0
        lacc    SPAD1
        RET
ary1    OUT     SPAD2,F_ACCESS1
        lacc    SPAD1
        RET                     ;RETURN TO CALLING SEQUENCE
           .end         
                     




























