XDS510PP Useage and Installation

HW Install
==========
See the XDS510 Emulator Installation Guide.

OR  
   1. Turn off your PC
   2. Plug the printer cable into the back of your PC.
   3. Connect the printer cable to the XDS510PP.
   4. Connect the 14 pin cable into your target.  If your target can supply
      5 volts @300 mA on the XDS PD pin then the target has enough power
      to run the XDS510PP.  If not, then plug in the standard XDS510WS power
      supply plus 2.1 mm power adapter into the XDS510PP 5 volt input.
      Note that the ACTIVE light on the pod only goes on when the emulator
      software is running, not when power is on (so don't panic 'cause the
      light isn't on).

SW Install
==========
1.  Check your BIOS to see what printer setup you have.  You should
    select one of the following modes:  Note: XDS510PP.INI goes in the
    directory you run the debugger from.

        4-bit mode unidirectional mode (spp4 or SPP4)
        8-bit bidirectional mode (spp8 or SPP8)
        EPP, Enhanced Printer Port (epp or EPP)

     EPP mode is the recommended choice and provides the best performance.
     If your BIOS offers the option "EPP+ECP" and "EPP+SPP" then select
     "EPP+SPP".  The "EPP+ECP" option is not supported.

     Record the port address of your printer.  The default is usually port
     address 378.

     If all this is confusing then just leave the default mode for now.

2.  Create a file named XDS510PP.INI if it does not exist.  In this
    file you will need to setup the printer address, printer mode and
    optional speed parameters.
    Following is an example:

       port  = 378   
       mode  = epp
       speed = 10  
       
     Where:
        port       is the i/o address of your printer port.  Address 378 is
                   generally the default.

        mode       is the printer port mode.  Enter one of the following:
                    SPP4 or spp4  4-bit mode unidirectional mode
                    SPP8 or spp8  8-bit bidirectional mode
                    EPP  or epp   Enhanced Printer Port

        speed      is a delay parameter that may be required on some systems.
                   It is recommended that you set this to 10 initially.  Once
                   you get your XDS510PP up and running you can reduce this
                   number or delete the parameter entirely and see if your
                   system still works.
                    
3.   The executable EMURSTPP.EXE should be used to reset the XDS510PP following
     a PC or target power-on condition just like EMURST.EXE does for the XDS510.
     The port address for EMURSTPP.EXE, PRG2XXWM.EXE, and EMU2XXWM.EXE is
     picked up from the file XDS510PP.INI.

4.   It is possible that the printer port chip in your computer and the
     SMC chip in the XDS510PP may get confused during power cycles.  If
     EMURSTPP.EXE does not cause the XDS510PP to reset then try "SMCMODE -r".
     If your computer has a SMC chip this will reset and intialize this device
     for proper operation.  NOTE: SMCMODE will only work if your computer uses
     a SMC printer port controller. How do you know?  Just run "SMCMODE"
     with no parameters and it will tell you if SMC chip is installed and
     it's configuration.

Additional Notes
================
1.   Also included is the file "NSCMODE.EXE" which is similar to
     "SMCMODE.EXE" except that it is intended for NSC chips rather
     than SMC chips.
     
     Try "SMCMODE -h" and "NSCMODE -h" to get abbreviated help.

     In some cases, you may have to use the -m x option for nscmode.exe
     or smcmode.exe to set the mode.


     National Port Configuration Utility Version 1.1
     (c) Copyright 1996 Spectrum Digital Inc.

     nscmode [options]
         -h     help
         -m x   set to mode x = 0..4

         Mode 0 -> Compatible mode
         Mode 1 -> Extended mode
         Mode 2 -> EPP mode
         Mode 3 -> ECP mode
         Mode 4 -> ECP and EPP mode


     SMC Port Configuration Program Version 1.10
     (c) Copyright 1994,1995,1996 Spectrum Digital Inc.

     smcmode [options]
         -h     help
         -r     reset status register
         -m x   set to mode x = 0..4

         Mode 0 -> Standard bidirectional mode
         Mode 1 -> EPP and SPP mode
         Mode 2 -> ECP mode
         Mode 3 -> ECP and EPP mode
         Mode 4 -> Non bidirectional mode


2.   Do not use the -p Debugger option when using the XDS510PP.  The
     Debugger reads the xds510pp.ini file just as emurstpp.exe does.
     Here are the typical parameters for EMU2XXWM:

     emu2xxwm -ncpu_a

3.   The default BOARD.DAT files was composed from the BOARD.CFG file.  If
     your board has more than one scannable device, use COMPOSER.EXE to build
     a new BOARD.DAT file from your own custom configuration file.

4.   The default XDS510PP.INI file has the following parameters:

     port  = 378
     mode  = epp
     speed = 10

     If this does not work, read the descriptions above to determine how
     to change it or your CMOS settings.
