;
; DESCENDING WHISTLE FOR COP800.
; TIMER INTERRUPT IS USED.
; OUTPUT ON TIMER I/O (TIO) PIN.  
; USE 20MHz XTAL, 1us INSTR CYCLE FOR THIS DEMO.	
;
; WRITTEN BY:  JERRY LEVENTER
; DATE:        OCTOBER 4, 1989  
;
	.TITLE WHISTLE1
	.CHIP	820
	.SECT  MAIN,ROM,ABS=0
;
	PORTGC	=   0D5 	; PORT G CONFIGURATION
	SIOR	=   0E9 	; SIO SHIFT REGISTER
	TMRLO	=   0EA 	; TIMER LOW BYTE
	TMRHI	=   0EB 	; TIMER HIGH BYTE
	TAULO	=   0EC 	; TIMER REGISTER LOW BYTE
	TAUHI	=   0ED 	; TIMER REGISTER HIGH BYTE
	CNTRL	=   0EE 	; CONTROL REGISTER
	PSW	=   0EF 	; PSW REGISTER
	TRUN	=   4
	TPND	=   5
	BUSY	=   2
	GIE	=   0	
; 
; ****  SPECIAL REGISTERS AND CONSTANTS  ****
;
	WSLO	=	02F	;TIMER VALUES
	WSLHI	=	000
	FCNTR	=	0F0	;FREQUENCY COUNT REGISTER
	  FCNT	=	000
	MINFREQ =	0FF	;MIN FREQUENCY CONSTANT
;
; *********************************
; **** BEGIN DEMO PROGRAM HERE ****
; *********************************
;
MAIN:	LD	SP,#02F 	; DEFAULT INITIALIZATION OF SP
	JSR	WHISTLE		; ***CALLING ROUTINE FOR DEMO***
	JP	.		
WHISTLE:LD	PORTGC,#008	;TIO PIN (G3) AS OUTPUT
	LD	CNTRL,#0A2	;PWM WITH TIO TOGGLE, 8Tc
	LD	TMRLO,#WSLO	;WHISTLE VALUE FOR TIMER
	LD	TMRHI,#WSLHI
	LD	TAULO,#WSLO
	LD	TAUHI,#WSLHI
	LD	FCNTR,#FCNT	;INIT FREQ COUNT
LUP:	LD	PSW,#011	;ENTI, GIE = 1, TPND = 0
	SBIT	TRUN,CNTRL	;START TIMER
	JP	.		;SELF LOOP TIL TIMER INTERRUPT
	JP	LUP		;RUN TIL LAST WHISTLE FREQ
;
;  **** INTERRUPT ROUTINE ****
;
	.=0FF
	IFBIT	TPND,PSW	;TEST TIMER PENDING FLAG
	JP	TIMOUT	
	JP	.		;ERROR
TIMOUT:	RBIT	TRUN,CNTRL	;STOP THE TIMER
	IFBIT	5,FCNTR		;COUNT CYCLES
	JP	TM
	LD	A,FCNTR		;INCREMENT COUNT
	INC	A
	X	A,FCNTR
	RETSK
TM:	LD	FCNTR,#FCNT	;RESET COUNT
	LD	B,#TAULO		
	LD	A,[B]		;CHANGE FREQUENCY
	IFEQ	A,#MINFREQ	;TIMER = MIN FREQ ?
	JP	DONE		;YES
	INC	A			
	X	A,[B]		;STORE FREQ IN AUTO RELOAD
	RETSK
DONE:	LD	[B],#WSLO	;ROUTINE IS DONE
	LD	A,SP		;*** RESTORE STACK POINTER ***
	ADD	A,#002		;*** AND RETURN TO CALLING ***
	X 	A,SP		;*** ROUTINE.              ***
	RET 			
	.END
