; LASER GUN SOUND EFFECT FOR COP820.
; TIMER INTERRUPT IS USED.
; THE SERIAL OUTPUT PIN (SO) AND THE TIO PIN MUST BE 
; TIED TOGETHER.
; OUTPUT IS ON SO AND TIO.
; 
; TO ALTER THE DURATION OF THE LASER SHOT CHANGE THE 
; "EXIT" VALUE, HOWEVER, DO NOT EXCEED 03F HEX.
; THE TIMER VALUES (TVALO, TVALHI) COMBINED WITH THE 
; TONE COUNT (TCNTR) CAN BE ADJUSTED TO ACHIEVE A 
; VARIETY OF SOUNDS.
;
; USE 20MHZ XTAL, 1uS INSTR CYCLE TIME FOR THIS DEMO.
;
;
; WRITTEN BY:  JERRY LEVENTER
; DATE:        OCTOBER 4, 1989 
;
; EDITTED MAY 11, 1994 - REVISED FOR NEW ASSEMBLER (ASMCOP v4.2) 
;
;
	.TITLE LASER8	
	.CHIP	820
        .SECT   MAIN,ROM,ABS=0

;
	PORTGC	=   0D5 	; PORT G CONFIGURATION
	SIOR	=   0E9 	; SIO SHIFT REGISTER
	TMRLO	=   0EA 	; TIMER LOW BYTE
	TMRHI	=   0EB 	; TIMER HIGH BYTE
	TAULO	=   0EC 	; TIMER REGISTER LOW BYTE
	TAUHI	=   0ED 	; TIMER REGISTER HIGH BYTE
	CNTRL	=   0EE 	; CONTROL REGISTER
	PSW	=   0EF 	; PSW REGISTER
	TRUN	=   4
	TPND	=   5
	BUSY	=   2
;
; ****  SPECIAL REGISTERS AND COUNTERS  ****
; ANY REGISTER THAT IS USED FOR THE  DRSZ TEST,
; MUST BE INITIALIZED TO AT LEAST "1" .
;
	EXITR	= 	0F7	; ROUTINE DURATION REGISTER
	  EXIT	=	03F	;   EXIT CONSTANT
	RNGVAL	=	002	; HOLDS CURRENT RANDOM #
	TCNTR	=	0F8	; TONE DURATION REGISTER
	  TCNT	=	020	;   TONE CONSTANT 
	LUPREG	=	0F9	; EXTRACTION RATE REGISTER
	  XTRCT	=	003	;   EXTRACT CONSTANT
	LUPCNT	=	0FA	; EXTRACTION VARIABLE REGISTER
	TVALO	=       0FF	; TIMER VALUES
	TVALHI	=       000
;
; ******************************
; ****	BEGIN PROGRAM HERE  ****
; ******************************
;
MAIN:	LD	SP,#02F 	 ; DEFAULT INITIALIZATION OF SP
LUP:	LD	EXITR,#EXIT	; INITIALIZE SHOT DURATION 
	JSR	LASER8		; **** LASER CALLING ROUTINE ****
	LD	EXITR,#EXIT
	JSR	LASER8
	LD	EXITR,#EXIT
	JSR	LASER8
	LD	EXITR,#015	; EXIT COUNT CAN BE INITIALIZED
	JSR	LASER8		; INSIDE PROGRAM IF SHOT RATE
	LD	EXITR,#015	; DOES NOT CHANGE.
	JSR	LASER8
	NOP
	JP	LUP		; **** LOOP FOR DEMO ****
;
LASER8:	LD	PORTGC,#030
	LD	CNTRL,#0AA	; SK = DIV BY 8, PWM/TIO TIMER
	LD 	PSW,#011	; ENABLE TIMER INTERRUPT
	LD	TMRLO,#TVALO	; INITIALIZE TIMER
	LD	TMRHI,#TVALHI
	LD	TAULO,#TVALO
	LD	TAUHI,#TVALHI
; 	LD	EXITR,#EXIT 	; INITIALIZE EXIT COUNT
	LD	TCNTR,#TCNT	; INITIALIZE TONE COUNT
	LD	LUPCNT,#XTRCT	; INITIALIZE EXTRACTION RATE
	SBIT	TRUN,CNTRL	; START TIMER
NOISE:	SC			; INIT. STAGE 1
	LD	B,#RNGVAL	; POINT TO RANDOM NUMBER
	LD	[B],#0FF	; INIT RANDOM #
START:	X	A,SIOR		; LOAD AND START SIOR
	SBIT	BUSY,PSW
	LD	A,LUPCNT	; RESTORE EXTRACTION COUNT
	X	A,LUPREG
;    
;--------------------------------------------------------------
;    RING COUNTER 
;
;    THIS IS A NINE STAGE RING COUNTER (LINEAR
;    FEEDBACK SHIFT REGISTER) WITH THE RRC COMMAND.
;    THE COUNTER'S 8th AND 9th STAGES, THROUGH AN             
;    EXCLUSIVE-OR SERVE AS THE FEEDBACK FUNCTION. 
;    SINCE THE EXCLUSIVE OR OCCURS AFTER THE ROTATE, 
;    IT IS THE 1st AND 9th STAGES THAT ARE XOR'D, 
;    (THE CARRY FLAG AND BIT 0).
;
;	CARRY BIT = STAGE 1
;	LOW ORDER BIT = STAGE 9 
;-----------------------------------------------------     
RING:	LD	A,[B]		; GET RANDOM #
	RRC	A		; ROTATE UPPER BYTE	
	X	A,[B]		;
	LD	A,#000		; PERFORM XOR	
	AND	A,[B]
	IFEQ	A,#000
	JP	TSTLUP
	IFC
	JP	RC
	SC
	JP	TSTLUP
RC:	RC
TSTLUP:	DRSZ	LUPREG		; EXTRACT THIS # ?
	JP	RING		; NO, KEEP ROTATING
	LD      A,[B]   	; YES
	JP	START
;
; *****	TIMER INTERRUPT ROUTINE ******
;
	.=	0FF
	IFBIT	TPND,PSW	; TEST TIMER PND FLAG
	JP	TMOUT
	JP	.		; ERROR
;
TMOUT:	RBIT	TRUN,CNTRL	; STOP TIMER
	LD	B,#LUPCNT
	DRSZ	TCNTR		; TEST FOR NEW TONE 
	JP	NXT		; NO
	JP	NEWF
NXT:	SBIT	4,PSW		; ENABLE TIMER INTERRUPT
	RBIT	5,PSW		; RESET TPND FLAG
	LD	B,#RNGVAL	; POINT TO RANDOM #
	SBIT	TRUN,CNTRL	; RESTART TIMER
	RETI			; RETURN 
NEWF:	DRSZ	EXITR		; EXIT COUNT = 0 ?
	JP	NF		; NO
NLST:	LD	A,SP		; *** RESTORE STACK POINTER ***
	ADD	A,#002		; *** FROM TIMER INTERRUPT  ***
	X	A,SP		; *** AND RETURN TO MAIN    ***
	RET
NF:	LD	A,[B]		; NEW TONE
	ADD	A,#04		; INCR EXTRACTION VALUE
	X	A,[B]
	LD	TCNTR,#TCNT	; REINITIALIZE TONE TIME
	JP 	NXT
	.END
