;*****************************************************
;*       NATIONAL SEMICONDUCTOR CORPORATION          *
;*        Microcontroller Application Lab            *
;*                                                   *
;*         COP800  Microcontroller Family            *
;*                                                   *
;* Programm Name: BINBCD16                           *
;* Source File  : BINBCD16.ASM                       *
;*                                                   *
;* Operation    : 16 BIT BINARY TO BCD CONVERSION    *
;*                                                   *
;* Input Param. : BINLO: RAM ADRESS BINARY LOW BYTE  *
;*              : BCDLO: RAM ADRESS BCD LOW BYTE     *
;*              : COUNT: RAM ADRESS SHIFT COUNTER    *
;*              :        (0F0...0FB,0FF)             *
;*                                                   *  
;* Results      : BCD NUMBER IN BCDLO,BCDLO+1,BCDLO+2*
;*                                                   *
;* Programmer   : VOLKER SOFFEL                      *
;* Date         : 27.01.89                           *
;*                                                   *
;*****************************************************
;
; EDITTED MAY 11, 1994 - REVISED FOR NEW ASSEMBLER (ASMCOP v4.2) 
;
;THE MEMORY ASSIGNMEMTS ARE AS FOLLOWS:
;
;MEMORY ADRESS        M(BINLO+1)  M(BINLO)
;DATA                 BINARY HB   BINARY LOW BYTE
;
;MEMORY ADRESS        M(BCDLO+2)  M(BCDLO+1)  M(BCDLO)
;DATA                 BCD HB      BCD         BCD LOW BYTE
;

	.TITLE  BIN2BCD
	.CHIP	ANYCOP
        .SECT   MAIN,ROM,INPAGE


        .LOCAL
        $BCDT = (BCDLO + 3) & 0F
        $BINT = (BINLO + 2) & 0F
BINBCD:
        LD      COUNT,#16 ;LOAD CONTROL REGISTER WITH
                          ;NUMBER OF LEFTSHIFTS TO 
                          ;EXECUTE
        LD      B,#BCDLO  ;LOAD BCD-NUMBER LOWEST BYTE
                          ;ADRESS

$CBCD:                    ;CLEAR BCD RAM-REGISTERS
        LD      [B+],#00
        IFBNE   #$BCDT
        JP      $CBCD
$LSH:                     ;LEFTSHIFT BINARY NUMBER
        LD      B,#BINLO
        RC
$LSHFT:
        LD      A,[B]
        ADC     A,[B]     ;IF MSB IS SET, SET CARRY
        X       A,[B+]
        IFBNE   #$BINT
        JP      $LSHFT
        LD      B,#BCDLO
$BCDADD:
        LD      A,[B]
        ADD     A,#066    ;ADD CORRECTION FACTOR
        ADC     A,[B]     ;LEFTSHIFT BCD NUMBER
                          ;(BCD=2**WEIGHT OF 
                          ;BINARY BIT(=CARRY BIT))
        DCOR    A         ;DECIMAL CORRECT ADDITION
        X       A,[B+]
        IFBNE   #$BCDT
        JP      $BCDADD
        DRSZ    COUNT     ;DECREMENT SHIFT COUNTER
        JP      $LSH
        RET
        .LOCAL
        .END
