//  Caution : Compiler is NC30WA.
#include <stdio.h>
#include <string.h>
#include "sfr.h"

void DMACint(void){

  dm0con = 0x03;                // 00000011 - DMA0 control register
                                // ||||||||
                                // |||||||+--    1 - 8 bit tranfer unit
                                // ||||||+---    1 - repeated transfer
                                // |||||+----    0 - DMA request bit (DMA not requested)
                                // ||||+-----    0 - disable DMA0
                                // |||+------    0 - source address direction is fixed
                                // ||+-------    0 - destination address direction is fixed
                                // ++--------    Not used

  dm0sl  = 0x0b;                // 00001011 - DMA0 request cause register
                                // ||||||||
                                // ||||++++-- 1011 - start DMA upon UART0 receive
                                // ++++------ Not used

  sar0   = (far)&u0rb;          // DMAC will read from UART0 receive buffer register
  dar0   = (far)&u0tb;          // DMAC will send data to UART0 transmit buffer register
  tcr0   = 0x00;                // DMAC counter (one less than count)

  dm0con &= 0xfb;               // DMA not requested, precautionary measure
  dm0con |= 0x08;               // DMA enabled
}


void UART0int(void){            // Initialize UART0

  u0brg = 0x40;                 // 9600 bps @ 10MHz on f1

  u0mr  = 0x05;                 // 00000101 - UART0 mode register
                                // ||||||||
                                // |||||+++--  101 - UART mode, 8 bit tranfer unit
                                // ||||+-----    0 - Use internal clock
                                // |||+------    0 - One stop select
                                // ||+-------    Not used
                                // |+--------    0 - Parity disabled
                                // +---------    Not used

  u0c0  = 0x10;                 // 00010000 - UART0 control register 0
                                // ||||||||
                                // ||||||++--   00 - use f1 count source
                                // |||||+----    Not used
                                // ||||+-----    Read only bit
                                // |||+------    1 - CTS/RTS disabled
                                // |++-------    Nothing is assigned
                                // +---------    0 - transfer LSB first

  ucon  = 0x00;                 // 00000000 - UART0 control register 2
                                // ||||||||
                                // |||||||+--    0 - interrupt on transmit buffer empty
                                // ||+++++---    Not used
                                // |+--------    CTS/RTS shared pin
                                // +---------    Nothing is assigned

  u0c1  = 0x05;                 // 00000101 - UART0 control register 1
                                // ||||||||
                                // |||||||+--    1 - Enabled transmission
                                // ||||||+---    Transmit buffer empty flag (Read Only)
                                // |||||+----    1 - Enabled reception
                                // ||||+-----    Receive complet flag (Read Only)
                                // ++++------    Nothing is assigned
}

void print(char *text){
int temp;

    temp = strlen(text);

    while(temp--){
      while((u0c1 & 0x02) == 0);        // Wait for transmission complete
      u0tb = (unsigned short)*text++;
    }
}
