	INCLUDE PAGE.INC
	SUBTTL	VGA BIOS Power On Diagnostics
;****************************************************************
;
;	$Workfile:   vgapod.asm  $
; 
; 	Copyright 1989, 1990 Quadtel Corporation.
; 	All rights reserved.
; 
;	Contents:
;	This module is the POST module for the VGA BIOS. The
;	VGA POST is called during initialization of the computer
;	system and is responsible for testing and initializing
;	the video system.
;
; 	Modification History:
; 	$Log:   M:/vcs/vga/vgapod.asv  $
;      
;         Rev 1.2   09 Jul 1991 16:34:54   dale
;      Version 2.12 - Changed alternate monitor test to start
;      the cursor pattern test with an AAH, instead of FFH.
;      
;      Version 2.12 - The feature control register is not written
;      to zero to maintain IBM compatibility.
;      
;         Rev 1.1   03 Jun 1991 17:01:56   Darryl
;      $UPDATE:VGA BIOS core revision 11 modifications.
;      VGA BIOS modifications for core hook support.
;      $
;      
;         Rev 1.0   21 Dec 1990 11:01:02   Darryl
;      Initial checkin to VCS.
;
;	01/02/90  Support was added for the new VCP structure.
;		  The copyright check was deleted.
;
;	12/05/89  The Test_Video_Memory routine now restores the
;		  color compare register back to FF after the
;		  memory test.
;
;	05/15/89  Modifications were made to breakout the memory
;		  test for the VGA dependent code. This was
;		  needed for cards that support more than 256K
;
;****************************************************************


cgroup	group	VGA_Segment	

VGA_Segment	SEGMENT PUBLIC byte

	ASSUME	CS:VGA_Segment
	ASSUME	DS:VGA_Data_Area
	ASSUME	ES:NOTHING

	.XLIST
	INCLUDE VGADATA.INC
	include	config.inc
	include	options.inc
	.LIST

	%OUT	Assembling VGA BIOS Power On Diagnostics

IFDEF ADAPTER
	EXTRN	EGA_Video_Interface:NEAR
ENDIF

ifndef ADAPTER
	extrn	  Mode6845Parameters:byte
endif	;ADAPTER

	EXTRN	Clear_Screen:NEAR
	EXTRN	C8x8_Character_Set:BYTE
	EXTRN	C8x8_Character_Set_High:BYTE

	EXTRN	Configure_OEM_Options:NEAR
	EXTRN	Configure_Chip_Options:NEAR
	EXTRN	Disable_DAC_Video:NEAR
	EXTRN	Display_Signon_Message:NEAR
	EXTRN	Enable_DAC_Video:NEAR
	EXTRN	Enable_8Bit_Memory:NEAR
	EXTRN	Enable_VGA:NEAR
	EXTRN	Error_Beep:NEAR
ifndef	(REMOVE_MEMORY_TEST)
	EXTRN	Extended_Test_Video_Memory:NEAR
endif	;(REMOVE_MEMORY_TEST)
	EXTRN	Get_Mode_Table:NEAR
	EXTRN	Init_Extended_Regs:NEAR
	EXTRN	Monitor_Type:NEAR

IFDEF DIGITAL
	EXTRN	Set_Secondary_Mode:NEAR
	EXTRN	Set_Primary_Mode:NEAR
ENDIF

	EXTRN	Set_VGA_Registers:NEAR
	EXTRN	Read_Reg:NEAR
	EXTRN	Read_Reg_NI:NEAR
	EXTRN	VGA_Video_Interface:NEAR
	EXTRN	VGA_Options3:BYTE
;	EXTRN	Video_Configuration_Parameters:BYTE
	EXTRN	Video_Off:NEAR
	EXTRN	Write_DAC:NEAR
	EXTRN	out_DAC:NEAR		;(3/22/93) V1.204
;khu
	extrn	pset_ptr:near		; returns ROM SAVE_PTR
	extrn	cfg_tbl:byte
	extrn	table_ptrs:byte
	extrn	get_crtc_addr:near
 if (CHIP_FAMILY eq CONDOR)
	extrn	getext:near
 endif	;(CHIP_FAMILY eq CONDOR)
	extrn	getreg:near
	extrn	xxx:near		;(v1.205)
	extrn	ana_ptr_tbl_c000:dword	; ana save area
	extrn	red_confbyte:byte
	extrn	green_confbyte:byte
	extrn	blue_confbyte:byte

	PUBLIC	BIOS_Address
	PUBLIC	Compute_DCC_Index
	PUBLIC	Determine_Analog_Monitor
	PUBLIC	Establish_Video_Type
	PUBLIC	Int_Address
	PUBLIC	POD_Video_Off
	PUBLIC	Power_On_Diagnostics
	PUBLIC	Power_On_Start
;gdl	PUBLIC	Read_Monitor_Sense
;gdl	PUBLIC	Read_Feature_Bits
	PUBLIC	Segment_A000
	PUBLIC	Setup_Planar_Vectors
ifndef	(REMOVE_MEMORY_TEST)
	PUBLIC	Test_Video_Memory
endif	;(REMOVE_MEMORY_TEST)
if PEACOCK eq YES
	extrn	peaven_fixup:near
endif
	extrn	rd_block:near
	extrn	wr_block:near
	extrn	wait_vretrace:near

;****************************************************************
BIOS_Address	DW	VGA_Data_Area		;BIOS data area address
INT_Address	DW	Interrupt_Vector_Area	;Interrupt area address
Segment_A000	DW	0A000H			;For fast video access

;****************************************************************
; pointer to OEMSI-specific table structure
;****************************************************************
		dw	'CL'				;v0.071
		dw	offset cgroup:ana_ptr_tbl_c000	;v0.071
pointers	dw	offset cgroup:table_ptrs; array of table pointers
		dw	offset cgroup:cfg_tbl	; ptr to configuration table

;****************************************************************
;   Start of the Power on Diagnostics. Called from the system
;   BIOS during power-on or soft reset, the POD is responsible
;   for initializing and verifying the VGA adapter is functioning
;   properly.
;
;   Exit: BP - 1 (On error condition only)
;****************************************************************

Power_On_Diagnostics	PROC	FAR
Power_On_Start:
	CLI
	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	SI
	PUSH	DI
	PUSH	BP
	PUSH	ES
	PUSH	DS				;Save callers registers
;chj:01/24/92 - Don't need this, and it makes us corrupt stack frame
;	SUB	SP,02				;Allocate temporary work space
	CLD					;Set to known state
	MOV	BP,SP				;Use BP as stack mark

;gdl:03/03/92 Init error return code to 0000h
	MOV	BP_Stack,00H			;Mark BP with no error code

ifdef Port80Status
	mov	al,80h
	out	80h,al
endif	;Port80Status

ifdef BeepStatus
	mov	al,01h
	call	Error_Beep
endif	;BeepStatus

;****************************************************************
;  Verify VCP is not corrupted
;****************************************************************
if VCP_CHKSUM	eq YES
	MOV	AX,CS
	MOV	DS,AX
	MOV	SI,OFFSET Video_Configuration_Parameters
	CMP	WORD PTR[SI],066BBH		;Verify header on VCP
	JNE	Checksum_Failed 		;Not there-Invalid BIOS
	MOV	CX,[SI+02]			;Get length of BCP
	XOR	BL,BL				;Initialize checksum

Checksum_VCP_Loop:
	LODSB					;Get byte from VCP
	ADD	BL,AL				;Add to checksum
	LOOP	Checksum_VCP_Loop		;Repeat for VCP
	JE	Exit_VCP_Check			;Exit if VCP is correct

Checksum_Failed:
	MOV	AL,03				;Ring 1 long bell followed
	CALL	Error_Beep
	MOV	BP_Stack,01H			;Mark BP with error code
	JMP	Exit_VGA_Post			;Exit if invalid VCP

Exit_VCP_Check:
endif	; VCP_CHKSUM

	MOV	DS,BIOS_Address 		;Setup DS to VGA data area
;****************************************************************
IFDEF	(PCI)
	mov	ax,0B101h		;PCI BIOS present?
	int	1Ah
	jc	AllDone
	or	ah,ah
	jnz	AllDone
.386
	cmp	edx,20494350h		;EDX contains "Blank, I,   C, & P  "
.186
	jnz	AllDone			;             "20h, 49h, 43h, & 50h"
;
	call	get_crtc_addr
	mov	al,27h
	call	getreg			;read CR27 ID Register
	and	ah,0FCh
	cmp	ah,0A0h			;GD-5430?
	jnz	short AllDone
;
	xor	al,al
	xchg	ah,al
	mov	cx,ax			;DID = 00A0h
	mov	ax,0B102h		;find PCI device
	mov	dx,1013h		;VID
	xor	si,si
	int	1Ah
;
	or	ah,ah			;successful?
	jnz	short AllDone
	mov	ax,0B108h		;read configuration byte
	mov	di,0030h
	int	1Ah
;
	or	ah,ah			;successful?
	jnz	short AllDone
	and	cl,0FEh			;reset b0 for EPROM disabled
	mov	ax,0B10Bh		;write configuration byte
	mov	di,0030h
	int	1Ah
AllDone:
ENDIF
;****************************************************************
ifdef (ADAPTER)
  ifdef (MICROCHANNEL_ADAPTER)
	xor	al,al			; Disable access to adapter setup
	out	096h,al
	mov	al,0DFh
	out	094h,al			; Disable microchannel motherboard
	mov	dx,102h			; so that microchannel adapter will
	get1reg				; work
	and	al,0FEh
	set1reg
	mov	al,0FFh
	out	094h,al
  else   ;(MICROCHANNEL_ADAPTER)
	mov	ax,1201h		; Disable any other VGA
	mov	bl,032h 		; adapters which may be
	int	10h			; in the system
  endif  ;(MICROCHANNEL_ADAPTER)
else
;gdl:04/09/92 Sleep adapter at E000 POST, to insure out POST doesn't muck
;	up the other guy.
	mov	dx,46E8h		;Adapter sleep port address
	xor	al,al			;Put adapter to sleep.
	out	dx,al
ENDIF

ifdef Port80Status
	mov	al,82h
	out	80h,al
endif	;Port80Status

ifdef BeepStatus
	mov	al,01h
	call	Error_Beep
endif	;BeepStatus

	CALL	Enable_VGA	  	;Enable VGA Adapter

if (PROG_46E8_BUG eq YES)
	mov	dx,46E8h		;Adapter sleep port address
	mov	al,10h			;Put adapter to sleep.
	out	dx,al
	out	dx,al

	mov	dx,102h
	mov	al,1
	out	dx,al
	out	dx,al

	mov	dx,46E8h		;Adapter sleep port address
	mov	al,08h			;Put adapter to sleep.
	out	dx,al
	out	dx,al
endif ; (PROG_46E8_BUG eq YES)
;#5434(4)#{
	mov	dx, 3c4h
	mov	al, 16h
	out	dx, al
	inc	dx
	mov	al, 058h
	out	dx, al
;#5434(4)#}
	CALL	Init_Extended_Regs		;Enable any extended regs
	MOV	DX,Miscellaneous		;Now-Setup miscellaneous reg
	MOV	AL,23H				;Set base to 3Dx
	OUT	DX,AL				;Write temporary misc reg

ifdef BeepStatus
	mov	al,01h
	call	Error_Beep
endif	;BeepStatus

;****************************************************************
;   Read the VGA feature and switch settings and store in the
;   BIOS data area for later use. Also caputure all interrupt
;   vectors used by the VGA BIOS. Interrupt 10 is captured by
;   the VGA BIOS and interrupt 42H is set to F000:F065 (the
;   start of the system BIOS video). Interrupt 1F is setup to
;   the VGA 8x8 character set for the last 128 characters, and
;   interrupt 43H is set to the 8x8 256 character set.
;****************************************************************

	XOR	AL,AL				;Clear any previous info
	MOV	Video_Mode,AL			;Clear video mode
	MOV	EGA_StatusA,EGA_Memory_Size	;Always have 64K of ram
	MOV	VGA_StatusA,00			;Clear VGA variables
	CALL	Setup_Interrupt_Vectors 	;Setup our interrupt vectors
;gdl:11/26/91 Include support in motherboard for co-resident CMGA card
;gdlIFDEF ADAPTER
	CALL	Setup_VGA_Base			;Determine base address
	MOV	AX,0B07H			;Set default base
	TEST	EGA_StatusA,EGA_Monochrome	;Are we monochrome
	JNE	VGA_Mono_Mode			;Yes-Setup temp as mono
	MOV	AX,0903H			;No -Setup as color

VGA_Mono_Mode:
;ELSE
;	MOV	DX,CRT_3D4			;Assume 3Dx for now
;	MOV	M6845_Address,DX		;Save current CRT base address
;	AND	BYTE PTR Equipment_Installed,0CFH   ;Clear old mon type
;	OR	BYTE PTR Equipment_Installed,20H    ;Set 80x25 color
;	OR	VGA_StatusA,All_Active		;System can be both
;	MOV	AX,0903H			;Always setup as color
;ENDIF

	MOV	EGA_StatusB,AH			;Save switch type
	XOR	AH,AH				;Perform initial mode command
	INT	10H
	CALL	POD_Video_Off			;Keep video disabled
	OR	VGA_StatusA,Scans_400		;Clear VGA variables

ifdef Port80Status
	mov	al,88h
	out	80h,al
endif	;Port80Status

ifdef BeepStatus
	mov	al,01h
	call	Error_Beep
endif	;BeepStatus

	TEST	VGA_StatusA,All_Active		;Are we only adapter in system
	JNE	No_Alt_Monitor			;Yes-No alternate monitor
	MOV	AX,Equipment_Installed		;Get current equipment info
	PUSH	AX				;Save it for now
	MOV	BL,03H				;Setup current video mode
	MOV	AX,3007H			;Get mode and equip for alt mon
	TEST	EGA_StatusA,EGA_Monochrome	;Are we configured for mono
	JE	Init_Alt_Monitor		;No -Go initialize mono
	MOV	AX,2003H			;Yes-Initialize CGA
	MOV	BL,07H				;Set mono mode when done

Init_Alt_Monitor:
	AND	BYTE PTR Equipment_Installed,0CFH ;Clear old monitor type
	OR	BYTE PTR Equipment_Installed,AH   ;Set new monitor type
	XOR	AH,AH				;Intialize mono or CGA
	INT	42H				;with old interrupt 10
	POP	AX				;Restore equipment config
	MOV	Equipment_Installed,AX		;Save back in BIOS data area
	MOV	AL,BL				;Now reinitialize the VGA
	XOR	AH,AH				;Do VGA mode set with INT 10
	INT	10H				;Initialize VGA
	CALL	POD_Video_Off			;Immediately turn off video

No_Alt_Monitor:
;gdl:01/27/92 Removed function because it didn't do anything anyway
;	CALL	Read_Feature_Bits		;Read feature bits
;ifdef ADAPTER
	mov	al,0F0h
;else	;ADAPTER
;	mov	al,00h
;endif	;ADAPTER
	OR	EGA_StatusB,AL			;Save in bits 4-7

;****************************************************************
;   Test the DAC by performing a read/write test on all 256
;   registers.
;****************************************************************

ifdef Port80Status
	mov	al,90h
	out	80h,al
endif	;Port80Status

ifdef PortMCAStatus
	mov	dx,180h
	mov	al,90h
	out	dx,al
endif	;PortMCAStatus

ifdef BeepStatus
	mov	al,01h
	call	Error_Beep
endif	;BeepStatus

ifndef	(REMOVE_DAC_TEST)
    if (WRITE_DAC_SLOWLY eq YES)
	call	get_crtc_addr		; turn off crt
	mov	al,020h
	call	getreg
	push	ax
	or 	ah,20h
	and	ah,not 40h
	setreg
	
	mov	al,01Ch			; select low powr sense amplifer RAM
	call	getreg
	push	ax
	or	ah,10h
	setreg

	mov	al,01Eh			; ensure NTSC weighting for DAC RGB
	call	getreg
	push	ax
	and	ah,not 0C0h
	setreg

	mov	dx,SEQIDX		; select clocks to lower than 10MHz
	mov	al,00Ch
	call	getreg
	push	ax
	mov	ah,002h
	setreg

	mov	al,01Ch
	call	getreg
	push	ax
	mov	ah,005h
	setreg
    endif ;(WRITE_DAC_SLOWLY eq YES)

Test_DAC:
	TEST	VGA_Options3,01 		;Are we to skip DAC test
	JNE	DAC_Passed			;Yes-Skip the DAC test
	CALL	Disable_DAC_Video		;Make sure DAC is disabled
	MOV	DX,DAC_Pel_Mask
	MOV	BX,0FFFFH			;Starting pattern
	mov	al,bl				;Clear Pel mask register
	OUT	DX,AL				;for register test
	MOV	Dl,Low(DAC_Write_Index)		;Get DAC write index addr

Next_DAC_Write_Reg:
	MOV	AL,BH				;Test from 255 to 0
	OUT	DX,AL				;Select DAC register
	INC	DX				;Move to data reg
	MOV	CX,03				;Write 3 6 bit pattern
	MOV	AL,BL				;Get current pattern

Write_DAC_Reg_Loop:
	OUT	DX,AL				;Write the DAC register
	LOOP	Write_DAC_Reg_Loop		;Repeat for red,green blue
	DEC	DX				;Move back to write index
	SUB	BH,01				;Move down to next reg
	JNC	Next_DAC_Write_Reg		;Repeat until 0 written
	DEC	DX				;Move to read index reg

    if (WRITE_DAC_SLOWLY eq YES)
	mov	dx,SEQIDX		; SR1C
	pop	ax
	setreg

	pop	ax			; SR0C
	setreg

	call	get_crtc_addr
	pop	ax			; CR1E
	setreg

	pop	ax	     		; CR1C
	setreg

	pop	ax			; CR20
	setreg

	MOV	Dl,Low(DAC_Write_Index)		;Get DAC write index addr
	dec	dx
    endif ;(WRITE_DAC_SLOWLY eq YES)

Next_DAC_Read_Reg:
	MOV	AL,BH				;Read from 255 to 00
	OUT	DX,AL				;Select DAC register
	ADD	DX,02				;Move to data reg
	MOV	CX,03				;Read red, green, blue
	MOV	AH,BL				;Get current pattern
	AND	AH,03FH 			;Bit 6 and 7 unused

Read_DAC_Reg_Loop:
	IN	AL,DX				;Read DAC register
	AND	AL,03FH 			;Clear unused bits
	CMP	AL,AH				;Test against pattern
	LOOPE	Read_DAC_Reg_Loop		;Repeat for red, green, blue
	JNE	DAC_Failed			;Go -If match failed
	SUB	DX,02				;Move back to read index reg
	SUB	BH,01				;Move to next DAC register
	JNC	Next_DAC_Read_Reg		;Repeat until 00 read
	INC	DX				;Move to write index reg
	SUB	BL,055H 			;Use patterns FF,AA,55,00
	JNC	Next_DAC_Write_Reg		;Repeat until 00 tested
	JMP	SHORT DAC_Passed		;Go to next text

DAC_Failed:
	MOV	AL,03				;1 long, 3 short beeps
	CALL	Error_Beep			;if DAC failed
	MOV	BP_Stack,01H			;Mark BP with error code

DAC_Passed:
endif	;(REMOVE_DAC_TEST)

ifdef Port80Status
	mov	al,0A0h
	out	80h,al
endif	;Port80Status

ifdef PortMCAStatus
	mov	dx,180h
	mov	al,0a0h
	out	dx,al
endif	;PortMCAStatus

ifdef Port80Status
	mov	al,0B0h
	out	80h,al
endif	;Port80Status

ifndef	(REMOVE_MEMORY_TEST)
;****************************************************************
;   Test the memory on the VGA card. Memory is banked into
;   four planes and tested plane-wise for speed. A preliminary
;   check for memory is done before the complete test is done.
;   If the preliminary test passes but the complete test fails
;   then the bell will beep 1 long and 3 short to signal
;   the error.
;****************************************************************

Test_VGA_Memory:
	TEST	VGA_Options3,04 		;Are we to skip Mem Test
	JNE	Exit_Mem_Test			;Yes-Skip the Mem test

	MOV	AL,0EH				;Get table entry for CG
	TEST	EGA_StatusA,EGA_Monochrome	;Test if VGA attached to mono
	JE	Set_Test_Base			;No -Use CG base for testing
	MOV	AL,0FH				;Yes-Use mode F table

Set_Test_Base:
	CALL	Get_Mode_Table			;Get pointer to mode table
	CALL	Set_VGA_Registers		;Load VGA registers with table

ifdef Port80Status
	mov	al,0B4h
	out	80h,al
endif	;Port80Status

	CALL	Disable_DAC_Video		;Make sure screen is blank

	MOV	AX,0A000H			;All memory testing will be
	MOV	ES,AX				;done at A000H segment
	MOV	AX,0805H			;Enable the color compare
	MOV	DX,Graphics_Controller
	OUT	DX,AX				;registers by writing mode reg
	MOV	AX,0F02H			;Enable all 4 planes on color
	OUT	DX,AX				;compare for testing
	MOV	Dl,Low(Sequencer)
	OUT	DX,AX				;by enabling map mask in seq
	MOV	SI,8000H			;Assume 256K of video ram
if 0
	CALL	Test_Color_Compare		;Test the color compare reg
	JNE	VGA_Ram_Failed			;Exit if color compare failed
endif	;0

ifdef Port80Status
	mov	al,0B8h
	out	80h,al
endif	;Port80Status

ifdef PortMCAStatus
	mov	dx,180h
	mov	al,0b8h
	out	dx,al
endif	;PortMCAStatus

	CALL	Test_Video_Memory
	JNE	VGA_Ram_Failed			;Exit if it failed

ifdef Port80Status
	mov	al,0BCh
	out	80h,al
endif	;Port80Status

ifdef PortMCAStatus
	mov	dx,180h
	mov	al,0bch
	out	dx,al
endif	;PortMCAStatus

 	CALL	Extended_Test_Video_Memory
	JNE	VGA_Ram_Failed			;Exit if it failed
	XOR	DL,DL				;Set test passed
	JMP	SHORT Ram_Test_Passed		;Go to next test

VGA_Ram_Failed:
	MOV	DL,03				;Set bell count for error

Ram_Test_Passed:
endif	;(REMOVE_MEMORY_TEST)

;ifdef Port80Status
;	mov	al,0C0h
;	out	80h,al
;endif	;Port80Status

	PUSH	DX

;ifdef PortMCAStatus
;	mov	dx,180h
;	mov	al,0c0h
;	out	dx,al
;endif	;PortMCAStatus

	MOV	AL,03H				;Get table entry for CG
	TEST	EGA_StatusA,EGA_Monochrome	;Test if VGA attached to mono
	JE	Restore_Test_Base		;No -Use CG base for testing
	MOV	AL,07H				;Yes-Use mode F table

Restore_Test_Base:
	CALL	Get_Mode_Table			;Get pointer to mode table
	CALL	Set_VGA_Registers		;Load VGA registers with table
;##5434(1)## {
;v1.10A3mov	ax,1c1fh
;v1.10A3mov	dx,3c4h
;v1.10A3out	dx, ax
;##5434(1)## }
	POP	DX				;Restore error bell

Test_VGA_Error:
	OR	DL,DL				;Test for VGA ram error
	JNE	VGA_Test_Failed 		;Yes-Dont do anymore VGA tests

Exit_Mem_Test:

ifdef Port80Status
	mov	al,0D0h
	out	80h,al
endif	;Port80Status

ifdef PortMCAStatus
	mov	dx,180h
	mov	al,0d0h
	out	dx,al
endif	;PortMCAStatus

;gdl:12/30/91 Remove test to conserve code space.
;***;****************************************************************
;***;   Verify that horizontal and vertical retrace is occuring
;***;   on the VGA adapter. If a monochrome or hi resolution
;***;   monitor is attached to the VGA then change the horizontal
;***;   scan length to a smaller value so our test can recognize
;***;   the transition.
;***;****************************************************************
;***
;***Test_VGA_Retrace:
;***	TEST	VGA_Options3,08 		;Are we to skip Retrace test
;***	JNE	VGA_Retrace_Passed		;Yes-Skip the retrace test
;***	MOV	DX,CRT_3D4			;Assume VGA at CGA address
;***	TEST	EGA_StatusA,EGA_Monochrome	;Test if VGA attached to mono
;***	JE	Set_Retrace_Base		;No -Use CGA base for testing
;***	MOV	DX,CRT_3B4			;Yes-Set mono address
;***
;***Set_Retrace_Base:
;***	MOV	AX,50 * 100H + 01H		;Adjust horizontal display
;***	OUT	DX,AX				;so we can see retrace
;***	ADD	DX,06				;Advance to status register
;***	CALL	Horizontal_Test 		;Perform horizontal test
;***	JNE	VGA_Test_Failed 		;Beep if failed
;***	CALL	Vertical_Test			;Perform vertical test
;***	JE	VGA_Retrace_Passed		;Go to next test if passed


	jmp	short VGA_Retrace_Passed

VGA_Test_Failed:
	MOV	AL,03				;Ring 1 long, 3 short
	CALL	Error_Beep			;to signal ram error
	MOV	BP_Stack,01H			;Mark BP with error code

VGA_Retrace_Passed:



;****************************************************************
;   Determine the monitor type currently attached to the VGA
;   by using the voltage comparators. If a Monochrome (or no
;   monitor) is detected then the VGA_Monochrome and Gray_Shades
;   will be set to force gray summing on all color mode.
;****************************************************************

	TEST	VGA_Options3,02 		;Are we to skip Monitor detection
	JNE	Monitor_Type_Exit		;Yes-Skip the Monitor test
	XOR	AL,AL				;Make sure DCC is cleared
	MOV	VGA_DCC_Index,AL		;Might get set by monitor type
	CALL	Monitor_Type			;Determine monitor
;	JE	Monitor_Type_Exit		;Continue if no error
;	MOV	AL,03				;1 long, 3 short beeps
;	CALL	Error_Beep			;if monitor detection failed
;	MOV	BP_Stack,01H			;Mark BP with error code

Monitor_Type_Exit:

ifdef Port80Status
	mov	al,0E0h
	out	80h,al
endif	;Port80Status

ifdef PortMCAStatus
	mov	dx,180h
	mov	al,0e0h
	out	dx,al
endif	;PortMCAStatus

;gdl:11/26/91 Include support in motherboard for co-resident CMGA card
;gdlIFDEF ADAPTER
;****************************************************************
;   Test if a color graphics or a monochrome card is installed,
;   and if so, verify that the memory on the card is functioning.
;****************************************************************

Test_Old_Card:

	TEST	VGA_Options3,10H		;Are we to skip Alt adapter
	JNE	Set_Power_Up_Mode		;Yes-Dont test mem or retrace
	TEST	VGA_StatusA,All_Active		;Can we switch
	JnE	Set_Power_Up_Mode		;No -May be other monitor

Could_Have_Old_Card:
	MOV	AX,0B800H			;Yes-Other card must be CG
	MOV	SI,2000H			;Length of video for CG
	MOV	DX,CRT_3D4 + 6			;Get CRT status for CG
	TEST	EGA_StatusA,EGA_Monochrome	;Is VGA attached to mono
	JE	Test_Old_Memory			;No -Other card must be mono

Test_Mono_Adapter:
	MOV	Ah,0B0H				;Get monochrome mem address
	MOV	SI,0800H			;Get length of video ram
	MOV	Dl,Low(CRT_3B4 + 6)		;Get CRT status for Mono

Test_Old_Memory:
	MOV	ES,AX				;Set ES to base memory
	MOV	CX,SI				;Get size of video
	XOR	DI,DI				;Start at zero in segment
	MOV	AX,54ABH			;Write a pattern
	STOSW					;at zero location
	DEC	CX				;Set CX to last word in seg
	MOV	DI,CX				;Get offset to last word
	ADD	DI,CX				;Compute byte location
	XCHG	AL,AH				;Swap byte in pattern
	STOSW					;Write pattern at other end
	XOR	DI,DI				;Go back to zero
	MOV	AX,ES:[DI]			;Read back the pattern
	MOV	DI,CX				;Go back to end pattern
	ADD	DI,CX				;Compute byte location
	ADD	AX,ES:[DI]			;Read and add to zero value
	INC	AX				;Should now go to zero
	JNE	Set_Power_Up_Mode		;No -Dont do any testing
	XOR	BX,BX				;Yes-Only clear if doing
	CMP	Soft_Reset_Flag,01234H		;a soft reset
	JE	Clear_Old_Ram			;Yes-Just clear ram
	DEC	BX				;No -Test 2 patterns

Clear_Old_Ram:
	XOR	DI,DI				;Start at zero
	MOV	AX,BX				;Get pattern to write
	MOV	CX,SI				;Get size of ram
	REP	STOSW				;Write ram as fast as possible
	XOR	DI,DI				;Move back to start
	MOV	CX,SI				;Restore plane size
	REPE	SCASW				;Verify what was written
	JNE	Old_Adapter_Failed		;Exit if it failed
	INC	BX				;Go to next pattern
	JE	Clear_Old_Ram			;Repeat if now zero else done

;gdl:12/30/91 Remove test to conserve code space.
;***;****************************************************************
;***;   Verify that the horizontal retrace is occurring on the
;***;   old video adapter. If the old adapter is a color graphics
;***;   adapter, then verify that the vertical retrace is occurring.
;***;****************************************************************
;***
;***	CALL	Horizontal_Test 		;Verify horiz retrace occuring
;***	JNE	Old_Adapter_Failed		;No -Ring bell twice
;***	CMP	DX,CRT_3B4 + 6			;Are we testing mono card
;***	JE	Set_Power_Up_Mode		;Yes-Dont do vert test
;***	CALL	Vertical_Test			;Test vertical retrace
;***	JE	Set_Power_Up_Mode		;Continue if it passed

	jmp	short Set_Power_Up_Mode

Old_Adapter_Failed:
	MOV	AL,02				;Ring 1 long bell followed
	CALL	Error_Beep			;by 2 short beeps
	MOV	BP_Stack,01H			;Mark BP with error code
;gdlENDIF

ifdef Port80Status
	mov	al,0F0h
	out	80h,al
endif	;Port80Status

;****************************************************************
;   Establish the proper video type (monochrome or color)
;   and initialize the default video mode. Once the video
;   type is established, then the DCC index can be computed.
;   Display a logon message if desired and then exit the
;   VGA power on diagnostics.
;****************************************************************

Set_Power_Up_Mode:
	CALL	Establish_Video_Type		;Establish/init video type
	CMP	VGA_DCC_Index,00		;Was DCC already setup?
	JNE	Skip_DCC_Init			;Yes-Its already been done
	CALL	Compute_DCC_Index		;Get the index value

Skip_DCC_Init:
	CALL	Configure_Chip_Options		;Hook for chip features
	CALL	Configure_OEM_Options		;Hook for OEM features

if PEACOCK eq YES
	call	peaven_fixup
endif

;v1.00B1{
extrn	Detect5430:near

	call	Detect5430
	jnz	short Not5430
;
	mov	dx,3CEh				;5430 exists, GR18 = 03h.
	mov	ax,0318h
	out	dx,ax
Not5430:
	mov	dx,03CEh			;set HSync & VSync active.
	mov	al,0Eh
	call	getreg
	and	ah,0F9h				;reset b2 & b1 in GR0E
	out	dx,ax
;v1.10B1{
;v1.10B5mov	dl,0C4h				;set ON mode &640X480@75Hz
;v1.10B5mov	ax,0814h			; as default!!!
;v1.10B5out	dx,ax
;v1.10B1}
;v1.00B1}

	CALL	Display_Signon_Message		;Display sign on message

ifdef Port80Status
	mov	al,00h
	out	80h,al
endif	;Port80Status

Exit_VGA_Post:

ifdef PostPatchF000F065
	%out "WARNING: Including end-of-POST patch up of INT 10h back to F000:f065."
	xor	ax,ax
	mov	ds,ax
	mov	word ptr ds:[4*10h  ],0F065h
	mov	word ptr ds:[4*10h+2],0F000h
endif	;PostPatchF000F065

	MOV	SP,BP				;Clear any garbage away
;chj:01/24/92 - Don't need this, and it makes us corrupt stack frame
;	ADD	SP,02				;Remove temporary storage
	POP	DS				;Restore all registers
	POP	ES
	POP	BP
	POP	DI
	POP	SI
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	RET
Power_On_Diagnostics	ENDP

;****************************************************************
;   Establish the base address for the VGA card now that all
;   the facts are known. Reinitialize the VGA adapter. If the
;   VGA adapter is not the primary adapter then initialize
;   the alternate adapter as the primary.
;****************************************************************

Establish_Video_Type PROC NEAR

IFDEF DIGITAL
	EXTRN	Digital_Environment_Table:BYTE

	CMP	WORD PTR Env_Ptr,OFFSET Digital_Environment_Table
	JNE	Analog_Environment
	CALL	Set_Secondary_Mode		;Initialize 2ndary setting
	CALL	Set_Primary_Mode		;Initialize primary
	RET

Analog_Environment:
ENDIF

	TEST	VGA_StatusA,All_Active		;Can we be either CGA or mono
	JNE	Only_One_Adapter
	MOV	AX,Equipment_Installed		;Get current equipment info
	PUSH	AX				;Save it for now
	MOV	BL,03H				;Setup current video mode
	MOV	AX,3007H			;Get mode and equip for alt mon
	TEST	EGA_StatusA,EGA_Monochrome	;Are we configured for mono
	JE	Init_Alt_MonitorA		;No -Go initialize mono
	MOV	AX,2003H			;Yes-Initialize CGA
	MOV	BL,07H				;Set mono mode when done

Init_Alt_MonitorA:
	AND	BYTE PTR Equipment_Installed,0CFH ;Clear old monitor type
	OR	BYTE PTR Equipment_Installed,AH   ;Set new monitor type
	XOR	AH,AH				;Intialize mono or CGA
	INT	42H				;with old interrupt 10
	POP	AX				;Restore equipment config
	MOV	Equipment_Installed,AX		;Save back in BIOS data area
	JMP	short Video_Type_Established		;No -We have established base

Only_One_Adapter:
	TEST	VGA_StatusA,VGA_Monochrome	;Yes-Did we detect mono mon
	JNE	Set_VGA_To_Mono 		;Yes-Go power up in mode 7
	TEST	EGA_StatusA,EGA_Passive 	;Are we passive and CGA
	JNE	Set_VGA_To_Mono 		;Yes-Set mono base
	AND	EGA_StatusA,NOT EGA_Monochrome	;No -Make sure we are CGA base
	JMP	SHORT Video_Type_Established	;Base has been established

Set_VGA_To_Mono:
	OR	EGA_StatusA,EGA_Monochrome	;Set monichrome base

Video_Type_Established:
	MOV	AX,02009H			;Initialize VGA video
	MOV	BL,03H				;Assume we will be CGA base
	TEST	EGA_StatusA,EGA_Monochrome	;Is are base CGA
	JE	Set_Video_Type			;Yes-Setup for CGA init
	MOV	AX,0300BH			;Get configuration for
	MOV	BL,07H				;monochrome init

Set_Video_Type:
	AND	EGA_StatusB,0F0H		;Clear prior switches
	OR	EGA_StatusB,AL			;Save new switch value
	AND	BYTE PTR Equipment_Installed,0CFH ;Clear prior active monitor
	OR	BYTE PTR Equipment_Installed,AH   ;Set new active monitor
	MOV	AH,VGA_StatusA			;Also clear All_Active
	AND	AH,All_Active			;for initialization only
	AND	VGA_StatusA,NOT All_Active	;but we will restore later
	PUSH	AX				;Save EGA_Passive & All_Active
	XOR	AH,AH				;Perform mode command
	MOV	AL,BL				;Get mode type
	INT	10H				;Perform mode init
	POP	AX				;Restore All_Active bit
	OR	VGA_StatusA,AH			;Write back to VGA_StatusA

	RET
Establish_Video_Type ENDP

;****************************************************************
;   Set the display combination code for the current video
;   configuration.
;****************************************************************

VGA_DCC_Index_Table	LABEL	BYTE
	DB	0CH				;DCC Pair 08, 01
	DB	0BH				;	  08, 00
	DB	0EH				;	  07, 02
	DB	0DH				;	  07, 00

Compute_DCC_Index PROC NEAR
	MOV	AL,EGA_StatusA			;EGA monochrome is bit 2
	AND	AL,EGA_Monochrome		;Merge with All_Active bits
	MOV	AH,VGA_StatusA			;All_Active bit is
	AND	AH,All_Active			;Isolate the bit
	OR	AL,AH				;Merge together for table
	XOR	AH,AH				;index. Clear high byte
	MOV	BX,AX				;Use BX for index
	MOV	AL,CS:VGA_DCC_Index_Table[BX]	;Get DCC index code
	MOV	VGA_DCC_Index,AL		;Save in BIOS area

	RET
Compute_DCC_Index ENDP

;gdl:11/26/91 Include support in motherboard for co-resident CMGA card
;gdlIFDEF ADAPTER
;****************************************************************
;   Test the cursor position register to determine if a video
;   adapter is present at the specified CRT base address.
;
;   Entry: DX - CRT Base address
;   Exit:   Z - Adapter is present at CRT base address
;	   NZ - No adapter exists at CRT base address
;****************************************************************

Test_If_Installed	PROC	NEAR
	MOV	BL,0AAH 			;Start with FF pattern

Next_Cursor_Pattern:
	MOV	BH,BL
	AND	BH,00FH
	MOV	AL,00EH 			;Start with cursor location
	MOV	AH,BL				;high register
	OUT	DX,AX				;Write pattern to regiter
	INC	AL
	OUT	DX,AX				;Write pattern to cursor lo
	MOV	AL,00EH 			;Now read the register back
	CALL	Read_Reg			;and compare results
	AND	AH,00FH
	CMP	AH,BH				;Does it match what we wrote
	JNE	Exit_TIF			;No -Adapter does not exist
	CALL	Read_Reg			;Read cursor lo location reg
	AND	AH,00FH
	CMP	AH,BH				;Did the data stick
	JNE	Exit_TIF			;No -Adapter is not there
	SUB	BL,055H 			;Use patterns FF,AA,55,00
	JNC	Next_Cursor_Pattern		;Repeat until 00 completed
	XOR	BL,BL				;Returned test passed

Exit_TIF:
	RET
Test_If_Installed	ENDP

;****************************************************************
;   Determine whether the base VGA address is to be color graphics
;   or monochrome. Program and miscellaneous register to the
;   base determined by the switch settings and setup the CRTC
;   emulation register.
;****************************************************************

Setup_VGA_Base	PROC	NEAR
	PUSH	AX				;Save switch settings
	MOV	DX,CRT_3B4			;Test for mono card installed
	CALL	Test_If_Installed		;by checking cursor loc reg
	JE	Mono_Installed			;Yes-VGA must state at 3Dx
	MOV	DX,Miscellaneous		;No -No switch VGA to mono
	MOV	AL,0A6H 			;and test if a CGA card
	OUT	DX,AL				;is installed
	MOV	DX,CRT_3D4			;Get CGA base address
	CALL	Test_If_Installed		;Test cursor loc registers
	JE	CGA_Installed			;Yes-VGA must stay at 3Bx
	MOV	DX,Miscellaneous		;No -Put VGA back at 3Dx
	MOV	AL,023H 			;and allow VGA to change
	OUT	DX,AL				;between 3Dx and 3Bx.
	MOV	DX,CRT_3D4			;Assume 3Dx for now
	MOV	M6845_Address,DX		;Save current CRT base address
	AND	BYTE PTR Equipment_Installed,0CFH   ;Clear old mon type
	OR	BYTE PTR Equipment_Installed,20H    ;Set 80x25 color
	OR	VGA_StatusA,All_Active		;Allow emul on both addresses
	POP	AX
	RET

CGA_Installed:
	OR	EGA_StatusA,EGA_Monochrome	  ;Force VGA to monochrome
	OR	BYTE PTR Equipment_Installed,30H  ;Set VGA to mono
	MOV	DX,CRT_3B4			;CGA installed VGA is 3Bx
	MOV	M6845_Address,DX		;Save current CRT base address
	CALL	Enable_8Bit_Memory		; set memcs16 to enable
	POP	AX
	RET

Mono_Installed:
	AND	BYTE PTR Equipment_Installed,0CFH ;Clear old mon type
	OR	BYTE PTR Equipment_Installed,20H  ;Set 80x25 color
	MOV	DX,CRT_3D4			;Mono installed,VGA is 3Dx
	MOV	M6845_Address,DX		;Save current CRT base address
	CALL	Enable_8Bit_Memory		; set memcs16 to enable
	POP	AX
	RET
Setup_VGA_Base	ENDP
;gdlENDIF

;****************************************************************
;   Initialize all interrupt vectors used by the VGA BIOS.
;   The VGA BIOS uses interrupt 10H, 1FH, 42H, and 43H.
;   Also setup the VGA environment table in the BIOS data area.
;****************************************************************

Setup_Interrupt_Vectors PROC	NEAR
	CLI					;No interrupts here
	MOV	ES,INT_Address			;Access with ES register
	MOV	BX,0F000H			;First setup interrupt 42 to

IFDEF ADAPTER
	MOV	DI,42H * 4			;system bios video routine
	MOV	AX,0F065H			;located at F000:F065
	CALL	Set_Vector			;Setup interrupt 42H
	MOV	BX,CS				;All others are in our code
	MOV	DI,06DH * 4			;Set interrupt 6DH to actual
	MOV	AX,OFFSET VGA_Video_Interface	;interrupt handler
	CALL	Set_Vector
	MOV	DI,10H * 4			;Setup interrupt 10 to
	MOV	AX,OFFSET VGA_Video_Interface	;video function dispatcher
;	MOV	AX,OFFSET EGA_Video_Interface	;video function dispatcher
	CALL	Set_Vector			;Setup interrupt 10 vector

	mov	ax,1280h		;AltSlct:Check if dispsw supported
	mov	bl,35h			; Display Switch functions
	int	42h			;Call motherboard BIOS to check

	MOV	BX,CS				;All others are in our code
	test	VGA_StatusA,Planar_Video
	jz	Setup_Planar_Vectors

	MOV	DI,10H * 4			;Setup interrupt 10 to
	MOV	AX,OFFSET EGA_Video_Interface	;video function dispatcher
	and	VGA_StatusA,not Planar_Video
	CALL	Set_Vector			;Setup interrupt 10 vector

ELSE
	MOV	DI,42H * 4			;system bios video routine
	MOV	AX,0F065H			;located at F000:F065
	CALL	Set_Vector			;Setup interrupt 42H
	MOV	BX,CS				;All others are in our code
	MOV	DI,06DH * 4			;Set interrupt 6DH to actual
	MOV	AX,OFFSET VGA_Video_Interface	;interrupt handler
	CALL	Set_Vector
	MOV	DI,10H * 4			;Setup interrupt 10 to
	MOV	AX,OFFSET VGA_Video_Interface	;video function dispatcher
	CALL	Set_Vector			;Setup interrupt 10 vector

	MOV	DI,1DH * 4			;Setup interrupt 1D to
	MOV	AX,OFFSET Mode6845Parameters	;6845 parameter pointer
	CALL	Set_Vector			;Setup interrupt 1D vector
ENDIF

Setup_Planar_Vectors:
	CLI					;No interrupts here
	MOV	ES,BIOS_Address 		;Access BIOS data area

;khu 
;note that pset_ptr updates the segments in the save area

	call	pset_ptr			; es:di==SAVE_PTR
	MOV	WORD PTR Env_Ptr,di		;Set offset to env
	MOV	WORD PTR Env_Ptr + 2,CS 	;Setup default env pointer

set_gvector:
	MOV	ES,INT_Address			;Access with ES register
	MOV	DI,1FH * 4			;Setup 1F to last 128 graphic
	MOV	AX,OFFSET C8x8_Character_Set_High ;characters located in VGA
	CALL	Set_Vector			;Set interrupt 1F vector
	MOV	DI,43H * 4			;Set 43H to pointer to 256
	MOV	AX,OFFSET C8x8_Character_Set	;8x8 character set

Set_Vector:
	STOSW					;Save vector offset
	MOV	AX,BX				;Get segment address
	STOSW					;Save segment address
	RET
Setup_Interrupt_Vectors ENDP

;gdl:01/27/92 Removed function because it didn't do anything anyway
;***;****************************************************************
;***;   Read the feature bits from the miscellaneous registers
;***;   and save in EGA status B.
;***;
;***;   Exit: AL - Bits 4-7 contain feature bits
;***;****************************************************************
;***
;***Read_Feature_Bits	PROC	NEAR
;***	XOR	AH,AH				;Feature value in AH
;***	MOV	CX,0202H			;Read 2 sets of 2 bits
;***	MOV	DX,CRT_3D4 + 6
;***	TEST	EGA_StatusA,EGA_Monochrome
;***	JE	Next_Feature_Bit
;***	MOV	DX,CRT_3B4 + 6
;***
;***Next_Feature_Bit:
;***	ROL	AH,CL				;Make room for next set
;***	MOV	AL,CH				;Get switch set being read
;***	OUT	DX,AL
;***	PUSH	DX
;***	MOV	DX,Miscellaneous		;Move to miscellaneous reg
;***	IN	AL,DX				;Read the feature bit set
;***	POP	DX
;***	AND	AL,060H 			;Isolate the bits
;***	OR	AH,AL				;Add to current value
;***	SHR	CH,1				;Test if done 2nd set
;***	JNC	Next_Feature_Bit		;No -Read the second pair
;***	XOR     AL,AL                           ;Clear the register
;***	OUT     DX,AL                           ;Leave 0 in the register
;***	CLC
;***	MOV	AL,AH				;Now in bits 1 and 5-7
;***	ROR	AL,1				;Return in bits 4-7
;***	AND	AL,0F0H
;***	RET
;***Read_Feature_Bits	ENDP

;****************************************************************
;   Disable both the VGA video and any other video card that
;   might currently be installed.
;****************************************************************

POD_Video_Off	PROC	NEAR
	CALL	Video_Off			;Disable VGA video

;gdl:11/26/91 Include support in motherboard for co-resident CMGA card
;gdlIFDEF ADAPTER
	PUSH	DX				;Save callers DX
	MOV	DX,CRT_3D4 + 4			;Assume other card in CG
	XOR	AL,AL				;Set CG to zero
	TEST	EGA_StatusA,EGA_Monochrome	;Is VGA attached to mono
	JNE	Disable_CG			;Yes-Go disable CG
	MOV	DX,CRT_3B4 + 4			;No -Get mono mode address
	INC	AL				;Keep hi res enabled

Disable_CG:
	OUT	DX,AL				;Disable non-VGA card
	POP	DX				;Restore callers registers
;gdlENDIF
	RET
POD_Video_Off	ENDP

if 0
;****************************************************************
;   Test that the color compare register is functioning properly
;   by writing a value to ram, reading it with a matching and
;   non-matching value, and verifying that it compares properly.
;
;   Exit: Z - Color compare test passed
;****************************************************************

Test_Color_Compare	PROC	NEAR
	XOR	DI,DI				;Write to memory zero
	MOV	DX,Graphics_Controller		;Set color compare register
	MOV	BX,00FFH			;Use opposite patterns
	MOV	ES:[DI],BL			;Write an FF to memory
	MOV	AL,02				;to our current pattern
	MOV	AH,BH				;Write a zero color compare
	OUT	DX,AX				;Set color compare register
	CMP	BH,ES:[DI]			;Do we match an FF
	JNE	Color_Compare_Failed		;Yes-Color compare failed
	MOV	AL,02				;No -Now write an FF
	MOV	AH,BL				;to the color compare and
	OUT	DX,AX				;we should match
	CMP	BL,ES:[DI]			;Do we match now ?
	JNE	Color_Compare_Failed		;No -Color compare failed
	RET

Color_Compare_Failed:
	OR	BL,BL				;Set NZ condition
	RET
Test_Color_Compare	ENDP
endif	;0

ifndef	(REMOVE_MEMORY_TEST)
;****************************************************************
;   Test the memory on the video card. Memory is banked into
;   four planes and tested plane-wise for speed. A preliminary
;   check for memory is done before the complete test is done.
;
;	Entry:	SI - 8000H
;		ES - A000H
;
;		Graphics Controller set for color-compare reads.
;
;	Exit:	 Z - Passed Test
;		NZ - Failed Test
;****************************************************************

Test_Video_Memory	PROC NEAR

	MOV	Ax,0002h			;Set Color Cmp to our pattern
	MOV	DX,Graphics_Controller
	OUT	DX,AX				;Write color compare register

	mov	ax,0AA55h
	jmp	short TestVideoRam		;542x Microchannel warmboot

ClearRamTest:
	xor	ax,ax
TestVideoRam:
	XOR	DI,DI				;Start at zero
	mov	cx,si
	rep	stosw

	or	ax,ax
	jz	TestRamDone		;ZF = true

	xchg	ah,al
	mov	cx,si
	repe	scasw
	jne	VideoRamFailed		;ZF = false

	cmp	ax,0aa55h
	je	ClearRamTest
	jmp	short TestVideoRam

VideoRamFailed:				;ZF = false
TestRamDone:				;ZF = true
	MOV	AX,0FF02H			;Restore color compare reg
	OUT	DX,AX
	RET

Test_Video_Memory	ENDP
endif	;(REMOVE_MEMORY_TEST)

;gdl:12/30/91 Remove test to conserve code space.
;***;****************************************************************
;***;   Verify that the horizontal retrace bit is toggling as
;***;   the display enters and exits the retrace window.
;***;
;***;   Exit: Z - Retrace passed
;***;****************************************************************
;***
;***Horizontal_Test PROC	NEAR
;***	XOR	CX,CX				;Initialize in retrace counter
;***
;***In_Horiz_Loop:
;***	IN	AL,DX				;Read retrace status
;***	TEST	AL,01				;Test if in retrace
;***	LOOPE	In_Horiz_Loop			;No -Keep waiting for retrace
;***	JCXZ	Horizontal_Failed		;Error-Never happened
;***	XOR	CX,CX				;Reset counter
;***
;***Out_Horiz_Loop:
;***	IN	AL,DX				;Read retrace status
;***	TEST	AL,01				;Test for out of retrace
;***	LOOPNE	Out_Horiz_Loop			;No -Keep waiting for exit
;***	JCXZ	Horizontal_Failed		;Error if never left
;***	RET
;***
;***Horizontal_Failed:
;***	OR	AL,0FFH 			;Set test failed
;***	RET
;***Horizontal_Test ENDP

;gdl:12/30/91 Remove test to conserve code space.
;***;****************************************************************
;***;   Verify that the vertical retrace bit is toggling as
;***;   the display enters and exits the retrace window.
;***;
;***;   Exit: Z - Retrace passed
;***;****************************************************************
;***
;***Vertical_Test	PROC	NEAR
;***	MOV	AH,09H				;Wait long time for vert
;***	XOR	CX,CX				;retrace for fast cpus
;***
;***In_Vert_Loop:
;***	IN	AL,DX				;Get Vertical retrace
;***	TEST	AL,08				;Test for vertical retrace
;***	LOOPE	In_Vert_Loop			;No -Keep waiting for entry
;***	JNE	Out_Vert_Check			;Yes-Wait for it to exit
;***	DEC	AH				;Decrement outer counter
;***	JNE	In_Vert_Loop			;Repeat if time left
;***	JMP	short Vertical_Failed 		;Never entered vert retrace
;***
;***Out_Vert_Check:
;***	MOV	AH,02				;Set outer loop counter
;***	XOR	CX,CX				;Clear loop counter
;***
;***Out_Vert_Loop:
;***	IN	AL,DX				;Read vertical retrace status
;***	TEST	AL,08				;Are we still in retrace
;***	LOOPNE	Out_Vert_Loop			;Yes-Keep wait for exit
;***	JE	Vertical_Passed 		;Go if left retrace
;***	DEC	AH				;Decrement outer counter
;***	JNE	Out_Vert_Loop			;Repeat if time left
;***
;***Vertical_Failed:
;***	OR	AL,0FFH 			;Set retrace failed
;***
;***Vertical_Passed:
;***	RET
;***Vertical_Test	ENDP

;****************************************************************
;   Determine the analog monitor type. The monitor can be
;   either color, monochrome, or neither. An error is
;   returned if the monitor is not detected as color or
;   monochrome.
;
;   Exit: Z - Monitor determined
;	  BL = 0/1/2 => color/mono/none
;****************************************************************

Determine_Analog_Monitor PROC	 NEAR

Color_Type:

	push	dx		;Save EXTIDX
	call	get_crtc_addr	;Get CRTC Stat to reset AR flip-flop
	add	dl,6
	get1reg			;Reset AR flip-flop

	mov	dl,Low(3C0h)	;Read current AR11
;cth 12/23/93
	in	al,dx		; get current index 
	mov	bh,al		; save it
;

	mov	al,11h
	set1reg			;Index AR11
	inc	dx
	get1reg			;Read current AR11 contents
	mov	bl,al		;BL = current AR11
	xor	al,al		;Force screen blank w/color 0
	dec	dx		;DX = 3C0
	set1reg
	pop	dx		;DX = EXTIDX
	push	bx		;Save current ARX state

;	MOV	AH,014H 			;Verify all three guns
;	MOV	CX,01414H			;are responding
	mov	ah, red_confbyte
	mov	ch, green_confbyte
	mov	cl, blue_confbyte
	CALL	Read_Monitor_Sense		;Write DAC and read sense
	JE	Mono_Type			;Maybe it's a gray monitor

ifdef Port80Status
	mov	al,0h
	out	80h,al
endif	;Port80Status

	xor	bl,bl				;return value for color
	jmp	short DAM_Exit
;	RET					;Return Z if test passed

Mono_Type:
	MOV	AH,004H 			;Test green gun against
	mov	ch,green_confbyte
	mov	cl,004h

;	MOV	CX,01404H			;threshold, R, B below thres.
;	MOV	CX,01204H			;threshold, R, B below thres.
	CALL	Read_Monitor_Sense		;Write DAC and read sense
	JE	Null_Monitor_Type		;No monitor if no green
ifdef Port80Status
	mov	al,1h
	out	80h,al
endif	;Port80Status

	mov	bl,01h				; return value for 8503
	jmp	short DAM_Exit

Null_Monitor_Type:

;gdl	jmp	short Monitor_Failed		;no connect == color

Monitor_Failed:
ifdef Port80Status
	mov	al,2h
	out	80h,al
endif	;Port80Status

	mov	bl,02h				; return value for no connect
DAM_Exit:
	pop	cx		;Previous ARX state

	call	get_crtc_addr	;Get CRTC Stat to reset AR flip-flop
	add	dl,6
	get1reg			;Reset AR flip-flop

	mov	dl,Low(3C0h)	;Read current AR11
	mov	al,11h
	set1reg			;Index AR11
	mov	al,cl		;AL = previous AR11
	set1reg			;Index AR11
	mov	al,ch		;restore original index
	set1reg
	RET

Determine_Analog_Monitor ENDP

;****************************************************************
;   Write the specified values to the DAC controller and then
;   read the switch sense. Writing different values to the red,
;   green, and blue guns is used to do monitor sensing using
;   the voltage comparitors of the VGA system.
;
;   Entry: AH - Red DAC value
;	   CH - Green DAC value
;	   CL - Blue DAC value
;
;   Exit:   Z - Switch sense is zero
;	   NZ - Switch sense is a one
;****************************************************************

Read_Monitor_Sense	PROC	NEAR
	PUSH	AX
	PUSH	CX				;Save callers registers

	XOR	BX,BX				;Use DAC register 0

	pushf
	cli

	PUSH	AX
	PUSH	CX				;Save DAC values

	MOV	AH,08H				;Set in retrace timout
	call	get_crtc_addr
;	MOV	DX,M6845_Address		;Get CRT Base address
	ADD	DX,06H				;move to input status reg
;	XOR	CX,CX				;Clear inner loop counter

Vert_Out:
	DEC	AH				;wait a long time
 	Jz	Vert_In				;Skip if count exhausted

Vert_Out_Loop:
	IN	AL,DX				;Wait for retrace to complete
	TEST	AL,08				;and then catch it at the
	LOOPNE	Vert_Out_Loop			;start of the next retrace
	jne	Vert_Out
;	JE	Vert_In 			;cycle. We could be at the
;	DEC	AH				;end of the retrace
; 	JNE	Vert_Out_Loop			;Wait if time left

Vert_In:
;	XOR	CX,CX				;Clear inner counter

Vert_In_Loop:
	IN	AL,DX				;Get Vertical retrace
	TEST	AL,08				;Test for vertical retrace
	LOOPE	Vert_In_Loop			;No -Keep waiting for entry
	POP	CX				;Restore DAC values
	POP	AX

  if (WRITE_DAC_SLOWLY eq YES)

	call	Set_Low_Clk

  endif ;(WRITE_DAC_SLOWLY eq YES)

	call	out_DAC			;(3/22/93) V1.204

  if (WRITE_DAC_SLOWLY eq YES)

	call	Rstore_Regs

  endif ;(WRITE_DAC_SLOWLY eq YES)

	call	get_crtc_addr
;	MOV	DX,M6845_Address		;Wait for retrace. Get input
	ADD	DX,06H				;status register 0
	XOR	CX,CX
	MOV     AH,4                            ;Set Timeout 

	call	XXX				;(3/22/93) V1.204

	popf					;Restore interrupt enable status

	TEST	AL,10H				;Test sense bit
	PUSHF					;Save flag condition
	XOR	CX,CX
	XOR	AX,AX

	call	out_DAC				;(3/22/93) V1.204

	POPF					;Restore flags

	POP	CX				;Restore registers
	POP	AX
	RET
Read_Monitor_Sense	ENDP
;
;
  if (WRITE_DAC_SLOWLY eq YES)

	PUBLIC	Set_Low_Clk

Set_Low_Clk	PROC	near

	push	di
	mov	di,ax

	call	get_crtc_addr		; turn off crt
	mov	al,020h
	call	getreg
	push	ax
	and	ah,not 40h
	or 	ah,20h
	setreg
	
	mov	al,01Ch			; select low powr sense amplifer RAM
	call	getreg
	push	ax
	or	ah,10h
	setreg

	mov	al,01Eh			; ensure NTSC weighting for DAC RGB
	call	getreg
	push	ax
	and	ah,not 0C0h
	setreg

	mov	dx,SEQIDX		; select clocks to lower than 10MHz
	mov	al,00Ch
	call	getreg
	push	ax
	mov	ah,002h
	setreg

	mov	al,01Ch
	call	getreg
	push	ax
	mov	ah,005h
	setreg

	mov	ax,di
	ret

Set_Low_Clk	endp
;
;
	PUBLIC	Rstore_Regs

Rstore_Regs	PROC	near

	mov	dx,SEQIDX		; SR1C
	pop	ax
	setreg

	pop	ax			; SR0C
	setreg

	call	get_crtc_addr
	pop	ax			; CR1E
	setreg

	pop	ax	     		; CR1C
	setreg

	pop	ax			; CR20
	setreg

	pop	di
	ret

Rstore_Regs	endp

  endif ;(WRITE_DAC_SLOWLY eq YES)
;
;****************************************************************

VGA_Segment	ENDS

	END
