;************************************************************************
;
; 	$Workfile:   vgamode.inc  $
; 
; 	Copyright 1989, 1990 Quadtel Corporation.
; 	All rights reserved.
; 
; 	Modification History:
; 	$Log:   E:/vcs/vga/vgamode.inv  $
;      
;         Rev 1.0   21 Dec 1990 11:03:12   Darryl
;      Initial checkin to VCS.
;
;************************************************************************

	%OUT	Assembling VGA Mode Table

;****************************************************************
;   The following table contains the mode parameters for all
;   VGA video modes.  Modes 0-7 support the standard Color
;   graphics and monochrome tables. Modes B and C are used
;   by the character function routines to load character sets.
;   Modes D and E support 320 x 200 and 640 x 200 modes with
;   16 colors. There are 2 entries for modes F and 10. The
;   entry is for EGA cards with 64K of ram installed. Then
;   there are entries for modes 0-3 in enhanced text mode using
;   a 8x14 font. Finally, there are three modes to support
;   the VGA 9x16 text modes.
;****************************************************************
;khu
		public	ana_std_std
ana_std_std	label	byte

		PUBLIC	Mode_Parameters

Mode_Parameters LABEL	BYTE

;  Mode  0  --	40 x 25 Black and White (8x8)	Table Entry 0

	DB	028H,018H,008H,000H,008H,009H,003H,000H,002H,063H
	DB	02DH,027H,028H,090H,02BH,0A0H,0BFH,01FH,000H,0C7H
if (IRQ2VERTINT eq NO)
	DB	006H,007H,000H,000H,000H,000H,09CH,0aeh,08FH,014H
else	;(IRQ2VERTINT eq NO)
	DB	006H,007H,000H,000H,000H,000H,09CH,08Eh,08FH,014H
endif	;(IRQ2VERTINT eq NO)
	DB	01FH,096H,0B9H,0A3H,0FFH
	DB	000H,001H,002H,003H,004H,005H,006H,007H,010H,011H
	DB	012H,013H,014H,015H,016H,017H,008H,000H,00FH,000H
	DB	000H,000H,000H,000H,000H,010H,00EH,000H,0FFH

;  Mode  1  --	40 x 25 16 Color (8x8)		Table Entry 1

	DB	028H,018H,008H,000H,008H,009H,003H,000H,002H,063H
	DB	02DH,027H,028H,090H,02BH,0A0H,0BFH,01FH,000H,0C7H
if (IRQ2VERTINT eq NO)
	DB	006H,007H,000H,000H,000H,000H,09CH,0aeh,08FH,014H
else	;(IRQ2VERTINT eq NO)
	DB	006H,007H,000H,000H,000H,000H,09CH,08Eh,08FH,014H
endif	;(IRQ2VERTINT eq NO)
	DB	01FH,096H,0B9H,0A3H,0FFH
	DB	000H,001H,002H,003H,004H,005H,006H,007H,010H,011H
	DB	012H,013H,014H,015H,016H,017H,008H,000H,00FH,000H
	DB	000H,000H,000H,000H,000H,010H,00EH,000H,0FFH

;  Mode  2  --	80 x 25 Black and White (8x8)	Table Entry 2

	DB	050H,018H,008H,000H,010H,001H,003H,000H,002H,063H
	DB	05FH,04FH,050H,082H,055H,081H,0BFH,01FH,000H,0C7H
if (IRQ2VERTINT eq NO)
	DB	006H,007H,000H,000H,000H,000H,09CH,0aeh,08FH,028H
else	;(IRQ2VERTINT eq NO)
	DB	006H,007H,000H,000H,000H,000H,09CH,08Eh,08FH,028H
endif	;(IRQ2VERTINT eq NO)
	DB	01FH,096H,0B9H,0A3H,0FFH
	DB	000H,001H,002H,003H,004H,005H,006H,007H,010H,011H
	DB	012H,013H,014H,015H,016H,017H,008H,000H,00FH,000H
	DB	000H,000H,000H,000H,000H,010H,00EH,000H,0FFH

;  Mode  3  --	80 x 25 16 Color (8x8)		Table Entry 3

	DB	050H,018H,008H,000H,010H,001H,003H,000H,002H,063H
	DB	05FH,04FH,050H,082H,055H,081H,0BFH,01FH,000H,0C7H
if (IRQ2VERTINT eq NO)
	DB	006H,007H,000H,000H,000H,000H,09CH,0aeh,08FH,028H
else	;(IRQ2VERTINT eq NO)
	DB	006H,007H,000H,000H,000H,000H,09CH,08Eh,08FH,028H
endif	;(IRQ2VERTINT eq NO)
	DB	01FH,096H,0B9H,0A3H,0FFH
	DB	000H,001H,002H,003H,004H,005H,006H,007H,010H,011H
	DB	012H,013H,014H,015H,016H,017H,008H,000H,00FH,000H
	DB	000H,000H,000H,000H,000H,010H,00EH,000H,0FFH

;  Mode  4  --	320 x 200 4 Colors		Table Entry 4

	DB	028H,018H,008H,000H,040H,009H,003H,000H,002H,063H
	DB	02DH,027H,028H,090H,02BH,080H,0BFH,01FH,000H,0C1H
if (IRQ2VERTINT eq NO)
	DB	000H,000H,000H,000H,000H,000H,09CH,0aeh,08FH,014H
else	;(IRQ2VERTINT eq NO)
	DB	000H,000H,000H,000H,000H,000H,09CH,08Eh,08FH,014H
endif	;(IRQ2VERTINT eq NO)
	DB	000H,096H,0B9H,0A2H,0FFH
	DB	000H,013H,015H,017H,002H,004H,006H,007H,010H,011H
	DB	012H,013H,014H,015H,016H,017H,001H,000H,003H,000H
	DB	000H,000H,000H,000H,000H,030H,00FH,000H,0FFH

;  Mode  5  --	320 x 200 Black & White 	Table Entry 5

	DB	028H,018H,008H,000H,040H,009H,003H,000H,002H,063H
	DB	02DH,027H,028H,090H,02BH,080H,0BFH,01FH,000H,0C1H
if (IRQ2VERTINT eq NO)
	DB	000H,000H,000H,000H,000H,000H,09CH,0aeh,08FH,014H
else	;(IRQ2VERTINT eq NO)
	DB	000H,000H,000H,000H,000H,000H,09CH,08Eh,08FH,014H
endif	;(IRQ2VERTINT eq NO)
	DB	000H,096H,0B9H,0A2H,0FFH
	DB	000H,013H,015H,017H,002H,004H,006H,007H,010H,011H
	DB	012H,013H,014H,015H,016H,017H,001H,000H,003H,000H
	DB	000H,000H,000H,000H,000H,030H,00FH,000H,0FFH

;  Mode  6  --	640 x 200 Black & White 	Table Entry 6

	DB	050H,018H,008H,000H,040H,001H,001H,000H,006H,063H
	DB	05FH,04FH,050H,082H,054H,080H,0BFH,01FH,000H,0C1H
if (IRQ2VERTINT eq NO)
	DB	000H,000H,000H,000H,000H,000H,09CH,0aeh,08FH,028H
else	;(IRQ2VERTINT eq NO)
	DB	000H,000H,000H,000H,000H,000H,09CH,08Eh,08FH,028H
endif	;(IRQ2VERTINT eq NO)
	DB	000H,096H,0B9H,0C2H,0FFH
	DB	000H,017H,017H,017H,017H,017H,017H,017H,017H,017H
	DB	017H,017H,017H,017H,017H,017H,001H,000H,001H,000H
	DB	000H,000H,000H,000H,000H,000H,00DH,000H,0FFH

;  Mode  7  --	80 x 25 Monochrome (9x14)	Table Entry 7

	DB	050H,018H,00EH,000H,010H,000H,003H,000H,003H,0A6H
	DB	05FH,04FH,050H,082H,055H,081H,0BFH,01FH,000H,04DH
if (IRQ2VERTINT eq NO)
	DB	00BH,00CH,000H,000H,000H,000H,083H,0a5h,05DH,028H
else	;(IRQ2VERTINT eq NO)
	DB	00BH,00CH,000H,000H,000H,000H,083H,085h,05DH,028H
endif	;(IRQ2VERTINT eq NO)
	DB	00DH,063H,0BAH,0A3H,0FFH
	DB	000H,008H,008H,008H,008H,008H,008H,008H,010H,018H
	DB	018H,018H,018H,018H,018H,018H,00EH,000H,00FH,008H
	DB	000H,000H,000H,000H,000H,010H,00AH,000H,0FFH

;  Mode  8  --	Reserved			Table Entry 8

	DB	050H,018H,010H,000H,07DH,021H,00FH,000H,006H,063H
	DB	05FH,04FH,050H,082H,055H,081H,0BFH,01FH,000H,040H
if (IRQ2VERTINT eq NO)
	DB	000H,000H,000H,000H,000H,000H,09CH,0aeh,08FH,028H
else	;(IRQ2VERTINT eq NO)
	DB	000H,000H,000H,000H,000H,000H,09CH,08Eh,08FH,028H
endif	;(IRQ2VERTINT eq NO)
	DB	01FH,096H,0B9H,0E3H,0FFH
	DB	000H,001H,002H,003H,004H,005H,014H,007H,038H,039H
	DB	03AH,03BH,03CH,03DH,03EH,03FH,001H,000H,00FH,000H
	DB	000H,000H,000H,000H,000H,000H,005H,00FH,0FFH

;  Mode  9  --	Reserved			Table Entry 9

	DB	000H,000H,000H,000H,000H,000H,000H,000H,000H,000H
	DB	000H,000H,000H,000H,000H,000H,000H,000H,000H,000H
if (IRQ2VERTINT eq NO)
	DB	000H,000H,000H,000H,000H,000H,000H,020H,000H,000H
else	;(IRQ2VERTINT eq NO)
	DB	000H,000H,000H,000H,000H,000H,000H,000H,000H,000H
endif	;(IRQ2VERTINT eq NO)
	DB	000H,000H,000H,000H,000H
	DB	000H,000H,000H,000H,000H,000H,000H,000H,000H,000H
	DB	000H,000H,000H,000H,000H,000H,000H,000H,000H,000H
	DB	000H,000H,000H,000H,000H,000H,000H,000H,000H

;  Mode  A  --	Reserved			Table Entry 0AH
;		CR4 Bit 0 - 0=Digital Monitor, 1=Analog Monitor

	DB	028H,018H,008H,000H,040H,000H,000H,000H,003H,023H
	DB	037H,027H,02DH,037H,031H,015H,004H,011H,000H,047H
if (IRQ2VERTINT eq NO)
	DB	006H,007H,000H,000H,000H,000H,0E1H,024H,0C7H,014H
else	;(IRQ2VERTINT eq NO)
	DB	006H,007H,000H,000H,000H,000H,0E1H,004H,0C7H,014H
endif	;(IRQ2VERTINT eq NO)
	DB	008H,0E0H,0F0H,0A3H,0FFH
	DB	000H,001H,002H,003H,004H,005H,006H,007H,010H,011H
	DB	012H,013H,014H,015H,016H,017H,008H,000H,00FH,000H
	DB	000H,000H,000H,000H,000H,010H,00EH,000H,0FFH

;  Mode  B  --	Character Table Mode (3Dx Address) Table Entry 0BH

	DB	050H,000H,000H,000H,000H,029H,00FH,000H,006H,062H
	DB	05FH,04FH,050H,082H,055H,081H,0BFH,01FH,000H,040H
if (IRQ2VERTINT eq NO)
	DB	000H,000H,000H,000H,000H,000H,09CH,0aeh,08FH,028H
else	;(IRQ2VERTINT eq NO)
	DB	000H,000H,000H,000H,000H,000H,09CH,08Eh,08FH,028H
endif	;(IRQ2VERTINT eq NO)
	DB	01FH,096H,0B9H,0E3H,0FFH
	DB	000H,000H,000H,000H,000H,000H,000H,000H,000H,000H
	DB	000H,000H,000H,000H,000H,03FH,001H,000H,00FH,000H
	DB	000H,000H,00FH,000H,000H,008H,005H,00FH,0FFH

;  Mode  C  --	Character Table Mode (3Bx Address) Table Entry 0CH

	DB	050H,000H,000H,000H,000H,029H,00FH,000H,006H,063H
	DB	05FH,04FH,050H,082H,055H,081H,0BFH,01FH,000H,040H
if (IRQ2VERTINT eq NO)
	DB	000H,000H,000H,000H,000H,000H,09CH,0aeh,08FH,028H
else	;(IRQ2VERTINT eq NO)
	DB	000H,000H,000H,000H,000H,000H,09CH,08Eh,08FH,028H
endif	;(IRQ2VERTINT eq NO)
	DB	01FH,096H,0B9H,0E3H,0FFH
	DB	000H,000H,000H,000H,000H,000H,000H,000H,000H,000H
	DB	000H,000H,000H,000H,000H,03FH,001H,000H,00FH,000H
	DB	000H,000H,00FH,000H,000H,008H,005H,00FH,0FFH

;  Mode  D  --	320 x 200 16 Colors		Table Entry 0DH

	DB	028H,018H,008H,000H,020H,009H,00FH,000H,006H,063H
	DB	02DH,027H,028H,090H,02BH,080H,0BFH,01FH,000H,0C0H
if (IRQ2VERTINT eq NO)
	DB	000H,000H,000H,000H,000H,000H,09CH,0aeh,08FH,014H
else	;(IRQ2VERTINT eq NO)
	DB	000H,000H,000H,000H,000H,000H,09CH,08Eh,08FH,014H
endif	;(IRQ2VERTINT eq NO)
	DB	000H,096H,0B9H,0E3H,0FFH
	DB	000H,001H,002H,003H,004H,005H,006H,007H,010H,011H
	DB	012H,013H,014H,015H,016H,017H,001H,000H,00FH,000H
	DB	000H,000H,000H,000H,000H,000H,005H,00FH,0FFH

;  Mode  E  --	640 x 200 16 Colors		Table Entry 0EH

	DB	050H,018H,008H,000H,040H,001H,00FH,000H,006H,063H
	DB	05FH,04FH,050H,082H,054H,080H,0BFH,01FH,000H,0C0H
if (IRQ2VERTINT eq NO)
	DB	000H,000H,000H,000H,000H,000H,09CH,0aeh,08FH,028H
else	;(IRQ2VERTINT eq NO)
	DB	000H,000H,000H,000H,000H,000H,09CH,08Eh,08FH,028H
endif	;(IRQ2VERTINT eq NO)
	DB	000H,096H,0B9H,0E3H,0FFH
	DB	000H,001H,002H,003H,004H,005H,006H,007H,010H,011H
	DB	012H,013H,014H,015H,016H,017H,001H,000H,00FH,000H
	DB	000H,000H,000H,000H,000H,000H,005H,00FH,0FFH

;  Mode  F  --	640 x 350 Monochrome (64K ram only) Table Entry 0FH

	DB	050H,018H,00EH,000H,080H,005H,00FH,000H,000H,0A2H
	DB	060H,04FH,056H,01AH,050H,0E0H,070H,01FH,000H,000H
if (IRQ2VERTINT eq NO)
	DB	000H,000H,000H,000H,000H,000H,05EH,02EH,05DH,014H
else	;(IRQ2VERTINT eq NO)
	DB	000H,000H,000H,000H,000H,000H,05EH,00EH,05DH,014H
endif	;(IRQ2VERTINT eq NO)
	DB	000H,05EH,06EH,08BH,0FFH
	DB	000H,008H,000H,000H,018H,018H,000H,000H,000H,008H
	DB	000H,000H,000H,018H,000H,000H,00BH,000H,005H,000H
	DB	000H,000H,000H,000H,000H,010H,007H,00FH,0FFH

;  Mode 10  --	640 x 350 4 Colors (64K ram only)  Table Entry 10H

	DB	050H,018H,00EH,000H,080H,005H,00FH,000H,000H,0A7H
	DB	05BH,04FH,053H,017H,050H,0BAH,06CH,01FH,000H,000H
if (IRQ2VERTINT eq NO)
	DB	000H,000H,000H,000H,000H,000H,05EH,0abh,05DH,014H
else	;(IRQ2VERTINT eq NO)
	DB	000H,000H,000H,000H,000H,000H,05EH,08Bh,05DH,014H
endif	;(IRQ2VERTINT eq NO)
	DB	00FH,05FH,00AH,08BH,0FFH
	DB	000H,001H,000H,000H,004H,007H,000H,000H,000H,001H
	DB	000H,000H,004H,007H,000H,000H,001H,000H,005H,000H
	DB	000H,000H,000H,000H,000H,010H,007H,00FH,0FFH

;  Mode  F  --	640 x 350 Monochrome (More than 64K) Table Entry 11H

	DB	050H,018H,00EH,000H,080H,001H,00FH,000H,006H,0A2H
	DB	05FH,04FH,050H,082H,054H,080H,0BFH,01FH,000H,040H
if (IRQ2VERTINT eq NO)
	DB	000H,000H,000H,000H,000H,000H,083H,0a5h,05DH,028H
else	;(IRQ2VERTINT eq NO)
	DB	000H,000H,000H,000H,000H,000H,083H,085h,05DH,028H
endif	;(IRQ2VERTINT eq NO)
	DB	00FH,063H,0BAH,0E3H,0FFH
	DB	000H,008H,000H,000H,018H,018H,000H,000H,000H,008H
	DB	000H,000H,000H,018H,000H,000H,00BH,000H,005H,000H
	DB	000H,000H,000H,000H,000H,000H,005H,005H,0FFH

;  Mode 10  --	640 x 350 16 Colors (More than 64K) Table Entry 12H

	DB	050H,018H,00EH,000H,080H,001H,00FH,000H,006H,0A3H
	DB	05FH,04FH,050H,082H,054H,080H,0BFH,01FH,000H,040H
if (IRQ2VERTINT eq NO)
	DB	000H,000H,000H,000H,000H,000H,083H,0a5h,05DH,028H
else	;(IRQ2VERTINT eq NO)
	DB	000H,000H,000H,000H,000H,000H,083H,085h,05DH,028H
endif	;(IRQ2VERTINT eq NO)
	DB	00FH,063H,0BAH,0E3H,0FFH
	DB	000H,001H,002H,003H,004H,005H,014H,007H,038H,039H
	DB	03AH,03BH,03CH,03DH,03EH,03FH,001H,000H,00FH,000H
	DB	000H,000H,000H,000H,000H,000H,005H,00FH,0FFH

;  Mode  0  --	40 x 25 Black and White (8x14)	Table Entry 13H

	DB	028H,018H,00EH,000H,008H,009H,003H,000H,002H,0A3H
	DB	02DH,027H,028H,090H,02BH,0A0H,0BFH,01FH,000H,04DH
if (IRQ2VERTINT eq NO)
	DB	00BH,00CH,000H,000H,000H,000H,083H,0a5h,05DH,014H
else	;(IRQ2VERTINT eq NO)
	DB	00BH,00CH,000H,000H,000H,000H,083H,085h,05DH,014H
endif	;(IRQ2VERTINT eq NO)
	DB	01FH,063H,0BAH,0A3H,0FFH
	DB	000H,001H,002H,003H,004H,005H,014H,007H,038H,039H
	DB	03AH,03BH,03CH,03DH,03EH,03FH,008H,000H,00FH,000H
	DB	000H,000H,000H,000H,000H,010H,00EH,000H,0FFH

;  Mode  1  --	40 x 25 16 Color (8x14) 	Table Entry 14H

	DB	028H,018H,00EH,000H,008H,009H,003H,000H,002H,0A3H
	DB	02DH,027H,028H,090H,02BH,0A0H,0BFH,01FH,000H,04DH
if (IRQ2VERTINT eq NO)
	DB	00BH,00CH,000H,000H,000H,000H,083H,0a5h,05DH,014H
else	;(IRQ2VERTINT eq NO)
	DB	00BH,00CH,000H,000H,000H,000H,083H,085h,05DH,014H
endif	;(IRQ2VERTINT eq NO)
	DB	01FH,063H,0BAH,0A3H,0FFH
	DB	000H,001H,002H,003H,004H,005H,014H,007H,038H,039H
	DB	03AH,03BH,03CH,03DH,03EH,03FH,008H,000H,00FH,000H
	DB	000H,000H,000H,000H,000H,010H,00EH,000H,0FFH

;  Mode  2  --	80 x 25 Black and White (8x14)	Table Entry 15H

	DB	050H,018H,00EH,000H,010H,001H,003H,000H,002H,0A3H
	DB	05FH,04FH,050H,082H,055H,081H,0BFH,01FH,000H,04DH
if (IRQ2VERTINT eq NO)
	DB	00BH,00CH,000H,000H,000H,000H,083H,0a5h,05DH,028H
else	;(IRQ2VERTINT eq NO)
	DB	00BH,00CH,000H,000H,000H,000H,083H,085h,05DH,028H
endif	;(IRQ2VERTINT eq NO)
	DB	01FH,063H,0BAH,0A3H,0FFH
	DB	000H,001H,002H,003H,004H,005H,014H,007H,038H,039H
	DB	03AH,03BH,03CH,03DH,03EH,03FH,008H,000H,00FH,000H
	DB	000H,000H,000H,000H,000H,010H,00EH,000H,0FFH

;  Mode  3  --	80 x 25 16 Color (8x14) 	Table Entry 16H

	DB	050H,018H,00EH,000H,010H,001H,003H,000H,002H,0A3H
	DB	05FH,04FH,050H,082H,055H,081H,0BFH,01FH,000H,04DH
if (IRQ2VERTINT eq NO)
	DB	00BH,00CH,000H,000H,000H,000H,083H,0a5h,05DH,028H
else	;(IRQ2VERTINT eq NO)
	DB	00BH,00CH,000H,000H,000H,000H,083H,085h,05DH,028H
endif	;(IRQ2VERTINT eq NO)
	DB	01FH,063H,0BAH,0A3H,0FFH
	DB	000H,001H,002H,003H,004H,005H,014H,007H,038H,039H
	DB	03AH,03BH,03CH,03DH,03EH,03FH,008H,000H,00FH,000H
	DB	000H,000H,000H,000H,000H,010H,00EH,000H,0FFH

;  Mode  0,1  --  40 x 25 16 Color (9x16)	Table Entry 17H

	DB	028H,018H,010H,000H,008H,008H,003H,000H,002H,067H
	DB	02DH,027H,028H,090H,02BH,0A0H,0BFH,01FH,000H,04FH
if (IRQ2VERTINT eq NO)
	DB	00DH,00EH,000H,000H,000H,000H,09CH,0aeh,08FH,014H
else	;(IRQ2VERTINT eq NO)
	DB	00DH,00EH,000H,000H,000H,000H,09CH,08Eh,08FH,014H
endif	;(IRQ2VERTINT eq NO)
	DB	01FH,096H,0B9H,0A3H,0FFH
	DB	000H,001H,002H,003H,004H,005H,014H,007H,038H,039H
	DB	03AH,03BH,03CH,03DH,03EH,03FH,00CH,000H,00FH,008H
	DB	000H,000H,000H,000H,000H,010H,00EH,000H,0FFH

;  Mode  2,3  --  80 x 25 16 color (9x16)	Table Entry 18H

	DB	050H,018H,010H,000H,010H,000H,003H,000H,002H,067H
	DB	05FH,04FH,050H,082H,055H,081H,0BFH,01FH,000H,04FH
if (IRQ2VERTINT eq NO)
	DB	00DH,00EH,000H,000H,000H,000H,09CH,0aeh,08FH,028H
else	;(IRQ2VERTINT eq NO)
	DB	00DH,00EH,000H,000H,000H,000H,09CH,08Eh,08FH,028H
endif	;(IRQ2VERTINT eq NO)
	DB	01FH,096H,0B9H,0A3H,0FFH
	DB	000H,001H,002H,003H,004H,005H,014H,007H,038H,039H
	DB	03AH,03BH,03CH,03DH,03EH,03FH,00CH,000H,00FH,008H
	DB	000H,000H,000H,000H,000H,010H,00EH,000H,0FFH

;  Mode  7    --  80 x 25 Monochrome (9x16)	Table Entry 19H

	DB	050H,018H,010H,000H,010H,000H,003H,000H,002H,066H
	DB	05FH,04FH,050H,082H,055H,081H,0BFH,01FH,000H,04FH
if (IRQ2VERTINT eq NO)
	DB	00DH,00EH,000H,000H,000H,000H,09CH,0aeh,08FH,028H
else	;(IRQ2VERTINT eq NO)
	DB	00DH,00EH,000H,000H,000H,000H,09CH,08Eh,08FH,028H
endif	;(IRQ2VERTINT eq NO)
	DB	00FH,096H,0B9H,0A3H,0FFH
	DB	000H,008H,008H,008H,008H,008H,008H,008H,010H,018H
	DB	018H,018H,018H,018H,018H,018H,00EH,000H,00FH,008H
	DB	000H,000H,000H,000H,000H,010H,00AH,000H,0FFH

;  Mode 11  --	640 x 480 2 Colors		Table Entry 1AH

	DB	050H,01DH,010H,000H,0A0H,001H,00FH,000H,006H,0E3H
	DB	05FH,04FH,050H,082H,054H,080H,00BH,03EH,000H,040H
if (IRQ2VERTINT eq NO)
	DB	000H,000H,000H,000H,000H,000H,0EAH,0ach,0DFH,028H
else	;(IRQ2VERTINT eq NO)
	DB	000H,000H,000H,000H,000H,000H,0EAH,08Ch,0DFH,028H
endif	;(IRQ2VERTINT eq NO)
	DB	000H,0E7H,004H,0C3H,0FFH
	DB	000H,03FH,03FH,03FH,03FH,03FH,03FH,03FH,03FH,03FH
	DB	03FH,03FH,03FH,03FH,03FH,03FH,001H,000H,00FH,000H
	DB	000H,000H,000H,000H,000H,000H,005H,001H,0FFH

;  Mode 12  --	640 x 480 16 Colors		Table Entry 1BH

	DB	050H,01DH,010H,000H,0A0H,001H,00FH,000H,006H,0E3H
	DB	05FH,04FH,050H,082H,054H,080H,00BH,03EH,000H,040H
if (IRQ2VERTINT eq NO)
	DB	000H,000H,000H,000H,000H,000H,0EAH,0ach,0DFH,028H
else	;(IRQ2VERTINT eq NO)
	DB	000H,000H,000H,000H,000H,000H,0EAH,08Ch,0DFH,028H
endif	;(IRQ2VERTINT eq NO)
	DB	000H,0E7H,004H,0E3H,0FFH
	DB	000H,001H,002H,003H,004H,005H,014H,007H,038H,039H
	DB	03AH,03BH,03CH,03DH,03EH,03FH,001H,000H,00FH,000H
	DB	000H,000H,000H,000H,000H,000H,005H,00FH,0FFH

;  Mode 13  --	320 x 200 256 Colors		Table Entry 1CH

	DB	028H,018H,008H,000H,020H,001H,00FH,000H,00EH,063H
	DB	05FH,04FH,050H,082H,054H,080H,0BFH,01FH,000H,041H
if (IRQ2VERTINT eq NO)
	DB	000H,000H,000H,000H,000H,000H,09CH,0aeh,08FH,028H
else	;(IRQ2VERTINT eq NO)
	DB	000H,000H,000H,000H,000H,000H,09CH,08Eh,08FH,028H
endif	;(IRQ2VERTINT eq NO)
	DB	040H,096H,0B9H,0A3H,0FFH
	DB	000H,001H,002H,003H,004H,005H,006H,007H,008H,009H
	DB	00AH,00BH,00CH,00DH,00EH,00FH,041H,000H,00FH,000H
	DB	000H,000H,000H,000H,000H,040H,005H,00FH,0FFH

;****************************************************************
