	INCLUDE PAGE.INC
	SUBTTL	VGA BIOS Module J
;****************************************************************
;
;	$Workfile:   vgaj.asm  $
; 
; 	Copyright 1989, 1990 Quadtel Corporation.
; 	All rights reserved.
; 
;	Contents:
;	This module contains the environment, mode and DAC tables.
;
; 	Modification History:
; 	$Log:   E:/vcs/vga/vgaj.asv  $
;      
;         Rev 1.0   21 Dec 1990 11:00:54   Darryl
;      Initial checkin to VCS.
;
;	01/02/90  This module was changed from VGAK to VGAJ. This
;		  was done so the fonts would be at the end of the
;		  BIOS, allowing variable size fonts for VGAEDIT.
;
;	07/08/89  Speed optimizations made to the core VGA BIOS.
;		  No code changes to this module.
;
;****************************************************************

	.XLIST
	INCLUDE VGADATA.INC
	include config.inc
;gdl
	include	struc.inc	;Get supp_struc SIZE
	.LIST

	%OUT	Assembling VGA BIOS Module J

cgroup	group	VGA_Segment

VGA_Segment SEGMENT PUBLIC WORD


	PUBLIC	Default_DCC_Table
	PUBLIC	VGA_State_Table
;khu
	extrn	ana_ext_std:byte
	extrn	ana_ext_sup:byte

;gdl
	extrn	X_MODES:abs

	ASSUME	CS:VGA_Segment
	ASSUME	DS:NOTHING
	ASSUME	ES:NOTHING

;****************************************************************
;-----------------------------------------------------------------------
;
;	pset_ptr()
;
;	Function:
;	   Return a far pointer to the correct parameter set save area.
;
;	Input:
;	   Nothing.
;
;	Returns:
;	   di = save area offset
;	   es = save area segment
;
;	Remarks:
;	   This routine specifically returns the ROM pointer, and not
;	the pointer contained in 40:a8.
;
;-----------------------------------------------------------------------
pset_ptr	proc	near
		public	pset_ptr

		push	ds

		mov	di,cs
		mov	ds,di		; es = save area segment

		cmp	di,0c000h	; ROMBIOS at c000h ?
		mov	cx,offset ana_ptr_tbl_c000
     		je	pset_ptr_done	; yes
		cmp	di,0e000h	; ROMBIOS at e000h ?
		mov	cx,offset ana_ptr_tbl_e000
     		je	pset_ptr_done	; yes

		mov	cx,cs		; the code segment
		mov	di,offset ana_ptr_tbl_c000

if (EXTENDEDMODES eq YES)
		mov	[di-6],cx
		mov	[di-0Ah],cx
endif	;(EXTENDEDMODES eq YES)

		mov	[di+2],cx
		mov	[di+18],cx

		mov	di,offset sv2_area_c000
		mov	[di+4],cx

		mov	cx,offset ana_ptr_tbl_c000

pset_ptr_done:	mov	di,cx		; save area offset

		pop	ds

		ret			; and return

pset_ptr	endp

;-----------------------------------------------------------------------
;
;	ana_ptr_tbl()
;
;	Function:
;	   Define the save area for analog monitors.
;
;	Remarks:
;	   We export the symbol, ana_ptr_tbl only.  Although
;	the things that make up the pointer table are public
;	symbols, they are public only for convenience in make:
;	the symbols besides ana_ptr_tbl, are not, and should
;	not be referenced directly.
;
;-----------------------------------------------------------------------

ana_ptr_ext_extra_c000:
						;Additional fields here
		dw	$ - ana_ptr_ext_extra_c000
		dw	SIZE supp_struc		;gdl
if (EXTENDEDMODES eq YES)
		dw	offset cgroup:ana_ext_sup
		dw	0c000h			; romseg
		dw	offset cgroup:ana_ext_std
		dw	0c000h
else	;(EXTENDEDMODES eq YES)
		dw	0000h
		dw	0000h
		dw	0000h
		dw	0000h
endif	;(EXTENDEDMODES eq YES)
		dw	X_MODES			; number of extended modes
		dw	PRODUCT_ID		; signature word

ana_ptr_tbl_c000	label	dword	 	; start standard table
		public	ana_ptr_tbl_c000

		dw	offset cs:ana_std_std
		dw	0c000h
		dw	0,0			; dynamic save area
		dw	0,0			; alpha mode aux ptr
		dw	0,0			; graph mode aux ptr
		dw	offset cs:sv2_area_c000	; 2nd ary save area ptr
		dw	0c000h
		dw	0,0			; reserved
		dw	0,0			; reserved


ana_ptr_ext_extra_e000:
						;Additional fields here
		dw	$ - ana_ptr_ext_extra_e000
		dw	SIZE supp_struc		;gdl
if (EXTENDEDMODES eq YES)
		dw	offset cgroup:ana_ext_sup
		dw	0e000h			; romseg
		dw	offset cgroup:ana_ext_std
		dw	0e000h
else	;(EXTENDEDMODES eq YES)
		dw	0000h
		dw	0000h
		dw	0000h
		dw	0000h
endif	;(EXTENDEDMODES eq YES)
		dw	X_MODES			; number of extended modes
		dw	PRODUCT_ID		; signature word

ana_ptr_tbl_e000	label	dword	  	; start standard table
		public	ana_ptr_tbl_e000

		dw	offset cs:ana_std_std
		dw	0e000h
		dw	0,0			; dynamic save area
		dw	0,0			; alpha mode aux ptr
		dw	0,0			; graph mode aux ptr
		dw	offset cs:sv2_area_e000	; 2nd ary save area ptr
		dw	0e000h
		dw	0,0			; reserved
		dw	0,0			; reserved


;****************************************************************
;
; secondary save area
;
sv2_area_c000	label	dword
		public	sv2_area_c000

		dw	SEC_TBL_LEN		; table length
		dw	offset cgroup:Default_DCC_Table	; dcc table ptr
		dw	0c000h
		dw	0,0			; 2nd alpha mode aux ptr
		dw	0,0			; user palette profile ptr
		dw	0,0			; reserved
		dw	0,0			; reserved
		dw	0,0			; reserved
SEC_TBL_LEN	equ	$ - sv2_area_c000

sv2_area_e000	label	dword
		public	sv2_area_e000

		dw	SEC_TBL_LEN		; table length
		dw	offset cgroup:Default_DCC_Table	; dcc table ptr
		dw	0e000h
		dw	0,0			; 2nd alpha mode aux ptr
		dw	0,0			; user palette profile ptr
		dw	0,0			; reserved
		dw	0,0			; reserved
		dw	0,0			; reserved


;****************************************************************
;  Default Display Combination Code Table
;****************************************************************

Default_DCC_Table	LABEL	BYTE
	DB	10H				;Table Length
	DB	01H				;Table version
	DB	08H				;Maximum DCC code
	DB	00H				;Reserved
	DB	00H, 00H			;None, None  (DCC offset)
	DB	00H, 01H			;None, MDA
	DB	00H, 02H			;None, CGA
	DB	02H, 01H			;CGA , MDA
	DB	00H, 04H			;None, CEGA
	DB	04H, 01H			;CEGA, MDA
	DB	00H, 05H			;None, MEGA
	DB	02H, 05H			;CGA , MEGA
	DB	00H, 06H			;None, PGA
	DB	01H, 06H			;MDA , PGA
	DB	05H, 06H			;MEGA, PGA
	DB	00H, 08H			;None, CVGA
	DB	01H, 08H			;MDA , CVGA
	DB	00H, 07H			;None, MVGA
	DB	02H, 07H			;CGA , MVGA
	DB	06H, 07H			;PGA , MVGA

;****************************************************************
;  VGA State Information Table
;****************************************************************

VGA_State_Table LABEL	BYTE
	DB	0FFH				;Video modes 0-7
	DB	0E0H				;Video modes 8-F
	DB	00FH				;Video modes 10-13
	DB	000H, 000H, 000H, 000H		;Reserved
	DB	007H				;Support 200,350,400 lines
	DB	002H				;Character blocks in text
	DB	008H				;Maximum active char block
	DB	0FFH				;Functionality byte 0
	DB	00EH				;Functionality byte 1
	DB	000H, 000H			;Reserved
	DB	03FH				;Environment ptrs supported
	DB	000H				;Reserved

;****************************************************************


INCLUDE VGAMODE.INC				 ;Include VGA mode tables
INCLUDE VGADAC.INC				 ;Include DAC tables

;****************************************************************

VGA_Segment ENDS

	END
