	INCLUDE PAGE.INC
	SUBTTL	VGA BIOS Module I
;****************************************************************
;
;	$Workfile:   vgai.asm  $
; 
; 	Copyright 1989, 1990 Quadtel Corporation.
; 	All rights reserved.
; 
;	Contents:
;	This module contains Functions 1CH of the VGA BIOS.
;
; 	Modification History:
; 	$Log:   M:/vcs/vga/vgai.asv  $
;      
;         Rev 1.2   23 Jul 1991 20:51:30   dale
;      The DAC restore state routine was destroying the BX pointer
;      
;         Rev 1.1   03 Jun 1991 17:01:26   Darryl
;      $UPDATE:VGA BIOS core revision 11 modifications.
;      VGA BIOS modifications for core hook support.
;      $
;      
;         Rev 1.0   21 Dec 1990 11:00:48   Darryl
;      Initial checkin to VCS.
;
;	07/08/89  Speed optimizations made to the core VGA BIOS.
;		  No code changes to this module.
;
;****************************************************************

	.XLIST
	INCLUDE VGADATA.INC
	include	config.inc
	.LIST

	%OUT	Assembling VGA BIOS Module I

VGA_Segment SEGMENT PUBLIC WORD


	ASSUME	CS:VGA_Segment
	ASSUME	DS:VGA_Data_Area
	ASSUME	ES:NOTHING

	PUBLIC	Save_BIOS_Data_Area
	PUBLIC	Restore_BIOS_Data_Area

if CL_SAVE_RESTORE eq NO

	EXTRN	BIOS_Address:WORD
	EXTRN	Default_DCC_Table:BYTE
	EXTRN	Disable_DAC_Video:NEAR
	EXTRN	Enable_DAC_Video:NEAR
	EXTRN   Extended_Save_Size:NEAR
	EXTRN   Extended_Save_State:NEAR
	EXTRN   Extended_Restore_State:NEAR
	EXTRN	Get_Env_Ptr:NEAR
	EXTRN	INT_Address:WORD
	EXTRN	Read_DAC:NEAR
	EXTRN	Read_Palette:NEAR
	EXTRN	Read_Reg:NEAR
	EXTRN	Read_Reg_NI:NEAR
	EXTRN	Set_VGA_Registers:NEAR
	EXTRN	Video_Set_Cursor:NEAR
	EXTRN	Video_Write_Char_Attr:NEAR
	EXTRN	Video_Teletype_Write:NEAR
	EXTRN	Write_DAC:NEAR

	PUBLIC	Video_Save_Restore_State
	PUBLIC	Restore_State
	PUBLIC	Save_State
;****************************************************************
;   AH = 1C	Save or restore video state
;		AL = 0	Return save/restore buffer size
;			CX - Requested states to save
;			     Bit 0 - Video hardware state
;			     Bit 1 - BIOS data state
;			     Bit 2 - DAC state
;			Exit: AL = 1C
;			      BX - Number of 64b block required
;		AL = 1	Save current state
;			CX - Requested states to save
;			     Bit 0 - Video hardware state
;			     Bit 1 - BIOS data state
;			     Bit 2 - DAC state
;			ES:BX - Pointer to buffer
;			Exit: AL = 1C
;		AL = 2	Restore current state
;			CX - Requested states to save
;			     Bit 0 - Video hardware state
;			     Bit 1 - BIOS data state
;			     Bit 2 - DAC state
;			ES:BX - Pointer to buffer
;			Exit: AL = 1C
;****************************************************************

;	ALIGN	4

Video_State_Table	LABEL	WORD
	DW	Request_State
	DW	Save_State
	DW	Restore_State

Video_Save_Restore_State PROC	NEAR

IFDEF DIGITAL
	CMP	VGA_DCC_Index,07		;Are we a digital monitor
	JBE	Digital_Exit1C			;Yes-Exit immediately
ENDIF

	MOV	AL_Stack,000H			;Set to zero initially
	CMP	AL,02				;Is the command out of range
	JA	Bad_VSRS			;Yes-Exit with AL = zero
	XOR	AH,AH				;No -Extend command to AX
	SHL	AX,01				;Double for word access
	MOV	SI,AX				;Use SI as index
	JMP	CS:Video_State_Table[SI]	;Goto command

Bad_VSRS:
Digital_Exit1C:

	RET

;****************************************************************
;  Sub-Function 00  -  Return save/restore buffer size
;****************************************************************

;	ALIGN	4

Block_Size_Table	LABEL	WORD
	DW	00H				    ;Invalid entry
	DW	( 20H + 46H ) / 40H + 1 	    ;001
	DW	( 20H + 3AH ) / 40H + 1 	    ;010
	DW	( 20H + 46H + 3AH ) / 40H + 1	    ;011
	DW	( 20H + 303H ) / 40H + 1	    ;100
	DW	( 20H + 303H + 46H ) / 40H + 1	    ;101
	DW	( 20H + 303H + 3AH ) / 40H + 1	    ;110
	DW	( 20H + 303H + 3AH + 46H ) / 40H + 1;111

Request_State:
	AND	CL,07				;Isolate bit mask
	JE	Bad_VSRS			;Exit with AL=00
	MOV	AL_Stack,01CH			;Function was valid
	MOV	BL,CL				;Get bit pattern
	XOR	BH,BH				;Extend to BX
	SHL	BX,1				;Double for word offset
	MOV	AX,CS:Block_Size_Table[BX]	;Get block size from table
	CALL    Extended_Save_Size              ;Get Extended size
	MOV	BX_Stack,AX			;Return result in BX
	RET

;****************************************************************
;  Sub-Function 01  -  Save Current State
;****************************************************************

Save_State:
        CALL    Extended_Save_State             ;Call extended save state
	MOV	DI,BX				;Get pointer to address table
	ADD	DI,20H				;Move DI to actual data area
	TEST	CL,01				;Are saving hardware state
	JNE	Save_Hardware_State		;Yes-Go dump registers
	JMP	Save_BIOS_State 		;No -Go test BIOS save bit

Save_Hardware_State:
	MOV	ES:[BX],DI			;Save ptr to hardware state
	MOV	DX,Sequencer			;Save sequencer index reg
	IN	AL,DX				;Read the current index
	STOSB					;Save at relative offset 00
	MOV	DX,CRT_3D4			;Now save the CGA CRT index
	IN	AL,DX				;register, NOT M6845_Address
	STOSB					;Save at relative offset 01
	MOV	DX,Graphics_Controller		;Save graphics controller
	IN	AL,DX				;current index register
	STOSB					;Save at relative offset 02
	MOV	DX,M6845_Address		;Get current CRT base
	ADD	DX,06				;Advance to input status reg
	IN	AL,DX				;Clear attr flip-flop
	MOV	DX,Attribute_Controller 	;Now read current index
	IN	AL,DX				;for the attribute controller
	STOSB					;Save at relative offset 03
	MOV	DX,Read_Feature_Control 	;Now read feature control
	IN	AL,DX				;Read feature control
	STOSB					;Save at relative offset 04
	MOV	DX,Sequencer			;Now start dumping registers
	MOV	CX,04				;Dump 4 sequencers regs
	MOV	AL,01				;Start with register one

Read_Seq_Loop:
	CALL	Read_Reg			;Read the registers
	XCHG	AL,AH				;Swap for store operation
	STOSB					;Save it
	XCHG	AL,AH				;Restore index register
	LOOP	Read_Seq_Loop			;Repeat for 4 seq registers
	MOV	DX,Read_Miscellaneous		;Now read miscellaneous
	IN	AL,DX				;output register
	STOSB					;Store at offset 9
	MOV	DX,M6845_Address		;Get CRT base address
	MOV	CX,19H				;Now read 19H CRT registers
	MOV	AL,00				;Starting at offset 0

Read_CRT_Loop:
	CALL	Read_Reg			;Read the CRT register
	XCHG	AL,AH				;Swap for store operation
	STOSB					;Save CRT value
	XCHG	AL,AH				;Restore index register
	LOOP	Read_CRT_Loop			;Repeat for 19 CRT registers
	PUSH	DX				;Save current CRT base addr
	ADD	DX,06				;Move to input status reg
	IN	AL,DX				;Clear attribute flip-flop
	MOV	DX,Attribute_Controller 	;Move to attribute controller
	MOV	CX,14H				;Read 14 attribute registers
	PUSH	BX				;Save buffer pointer
	MOV	BL,00				;Start at palette 0

Read_Attr_Loop:
	CALL	Read_Palette			;Read the palette value
	MOV	AL,BH				;Get palette value
	STOSB					;Save it
	INC	BL				;Move to next register
	LOOP	Read_Attr_Loop			;Repeat for 14H registers
	POP	BX				;Restore buffer pointer
	MOV	DX,Graphics_Controller		;Now read graphics controller
	MOV	CX,09				;Read 8 registers
	MOV	AL,00				;Starting at offset 0

Read_Graphics_Loop:
	CALL	Read_Reg			;Read graphics register
	XCHG	AL,AH				;Swap for store operation
	STOSB					;Save it
	XCHG	AL,AH				;Restore index register
	LOOP	Read_Graphics_Loop		;Repeat for 0 through 7
	POP	AX				;Restore CRT base address
	STOSW					;Save at offset 40H

	PUSH	DS				;Save segment register
	MOV	AX,0A000H			;Setup DS to A000. Write
	MOV	DS,AX				;latches to FFFF then read
	MOV	DX,Sequencer			;from ram and write to buffer
	MOV	AL,02H				;Read plane mask register
	CALL	Read_Reg_NI			;from the sequencer
	PUSH	AX				;Save it, restore later
	MOV	AH,0FH				;Enable all 4 planes for write
	OUT	DX,AX				;Write the plane mask reg
	MOV	AL,04H				;Read the memory mode reg
	CALL	Read_Reg_NI			;from the sequencer
	PUSH	AX				;Save it, restore later
	MOV	AH,07				;Force text mode, not odd/even
	OUT	DX,AX				;Write to memory mode reg
	MOV	DX,Graphics_Controller		;Now setup the graphics contrl
	MOV	AL,04H				;Read the map select reg
	CALL	Read_Reg_NI			;from graphics controller
	PUSH	AX				;Save it, restore later
	MOV	AL,05H				;Read the mode register
	CALL	Read_Reg_NI			;from the graphics controller
	PUSH	AX				;Save it, restore later
	MOV	AH,01				;Set write mode for latches
	OUT	DX,AX				;Write the mode register
	MOV	AL,06H				;Read the miscellaneous reg
	CALL	Read_Reg_NI			;from the graphics controller
	PUSH	AX				;Save it, restore later
	MOV	AH,04H				;Enable video from A000-AFFF
	OUT	DX,AX				;Write misc register
	MOV	BYTE PTR DS:[0FFFFH],00 	;Dump latches to FFFF
	MOV	CX,04				;No read latches from Video mem
	MOV	AH,00				;Use map select to select plane

Read_Latches_Loop:
	MOV	AL,04				;Get map select register
	OUT	DX,AX				;Select the current plane
	INC	AH				;Advance plane pointer
	MOV	AL,DS:[0FFFFH]			;Read the latch data
	STOSB					;Save it in the buffer
	LOOP	Read_Latches_Loop		;Repeat for all four planes

	POP	AX				;Get misc reg and data
	OUT	DX,AX				;Restore miscellaneous reg
	POP	AX				;Get graphics mode reg and data
	OUT	DX,AX				;Restore graphics mode reg
	POP	AX				;Get map select reg and data
	OUT	DX,AX				;Restore read map select
	MOV	DX,Sequencer			;Now restore sequencer
	POP	AX				;Get memory mode reg and data
	OUT	DX,AX				;Restore memory mode register
	POP	AX				;Get plane map mask reg
	OUT	DX,AX				;Restore plane map mask reg
	POP	DS				;Restore DS register

Save_BIOS_State:
	TEST	CL_Stack,02			;Are we saving BIOS data area
	JE	Save_DAC_State			;No -Go check DAC save state
	MOV	ES:[BX+02],DI			;Yes-Save pointer to BIOS area
	CALL	Save_BIOS_Data_Area		;Save BIOS data area

Save_DAC_State:
	TEST	CL_Stack,04			;Are we saving DAC state
	JE	Exit_Save_State 		;No -Exit
	MOV	ES:[BX+04],DI			;Yes-Save ptr to DAC area
	MOV	AL_Stack,01CH			;BUG - Now set 1C in AL
	MOV	DX,DAC_Read_Index		;Determine state of DAC
	IN	AL,DX				;Read 3C7 to determine
	INC	DX				;read or write
	AND	AL,01				;Check last was read or write
	STOSB					;Save state
	IN	AL,DX				;Read index register
	JE	Get_DAC_Write_Index		;Go if DAC was in write mode
	DEC	AL				;Dec index for read mode

Get_DAC_Write_Index:
	STOSB					;Save current DAC index reg
	MOV	DX,DAC_Pel_Mask 		;Now read DAC pel mask
	IN	AL,DX				;Save at offset 02
	STOSB

	XOR	BX,BX				;Start reading DAC registers
	MOV	SI,100H 			;Read all 100H of them

Read_DAC_Loop:
	CALL	Read_DAC			;Read current DAC index
	MOV	AL,AH				;Get read value
	MOV	AH,CH				;Get green value
	STOSW					;Save in buffer
	MOV	AL,CL				;Get blue value
	STOSB					;Save in table
	DEC	SI				;Decremen DAC counter
	JNE	Read_DAC_Loop			;Repeat for all DAC regs

Exit_Save_State:
	RET

;****************************************************************
;  Sub-Function 02 -  Restore Current State
;****************************************************************

Restore_State:
        CALL    Extended_Restore_State          ;Call extended save state
	TEST	CL,01				;Are we restoring hardware
	JNE	Restore_Hardware_State		;Yes-Go restore VGA hardware
	JMP	Restore_BIOS_State		;No -Go check BIOS area

Restore_Hardware_State:
	MOV	SI,ES:[BX+00]			;Get hardware buffer pointer
	PUSH	DS				;Save BIOS data area
	MOV	DX,Graphics_Controller		;Make sure video is mapped
	MOV	AX,0005H
	OUT	DX,AX				;Write graphics mode register
	MOV	AX,0406H			;Now write the graphics
	OUT	DX,AX				;miscellaneous register
	MOV	DX,Sequencer			;Write memory mode register
	MOV	AX,0704H			;of the sequencer to text
	OUT	DX,AX				;and no odd/even
	MOV	AX,0A000H			;Setup DS to point
	MOV	DS,AX				;to A000 video regen
	MOV	DI,0FFFFH			;Write latches to FFFF
	MOV	CH,04				;then read them into latches
	MOV	CL,01				;Start with plane 0
	ADD	SI,042H 			;Move to latch data

Next_Latch_Loop:
	MOV	AL,02				;Get map mask register
	MOV	AH,CL				;Get current plane
	OUT	DX,AX				;Enable the plane
	LODS	BYTE PTR ES:[SI]		;Get latch data for plane
	MOV	[DI],AL 			;Write it to the plane
	SHL	CL,1				;Move to next plane
	DEC	CH				;Decrement counter
	JNE	Next_Latch_Loop 		;Repeat for all four planes
	MOV	AL,02				;Now enable all 4 planes
	MOV	AH,0FH				;in the map mask and read
	OUT	DX,AX				;the data into the latches
	MOV	AL,[DI] 			;Read data
	POP	DS				;Restore BIOS data area

	MOV	SI,ES:[BX+00]			;Get hardware buffer pointer
	MOV	AL,00				;Clear Gray summing and
	XCHG	VGA_StatusA,AL			;and Default palette bit
	PUSH	AX				;Save, will restore later
	PUSH	M6845_Address			;Save current CRT base
	CALL	Set_VGA_Registers		;Load the registers
	POP	M6845_Address			;Restore Base CRT address
	POP	AX				;Restore VGA_StatusA
	MOV	VGA_StatusA,AL

	MOV	SI,ES:[BX+00]			;Get hardware buffer pointer
	MOV	DX,Sequencer			;Restore sequencer index
	LODS	BYTE PTR ES:[SI]		;Get index value
	OUT	DX,AL				;Write to sequencer index
	MOV	DX,CRT_3D4			;Restore CGA CRT index
	LODS	BYTE PTR ES:[SI]		;Get index value
	OUT	DX,AL				;Write to CGA CRT index reg
	MOV	DX,Graphics_Controller		;Restore Graphics index
	LODS	BYTE PTR ES:[SI]		;Get index value
	OUT	DX,AL				;Write to graphics index
	MOV	DX,ES:[SI+40H-03H]		;Get buffer CRT base
	ADD	DX,06				;Advance to status register
	IN	AL,DX				;Clear flip-flop
	MOV	DX,Attribute_Controller 	;Restore attribute index
	LODS	BYTE PTR ES:[SI]		;Get index value
	OUT	DX,AL				;Select index

Restore_BIOS_State:
	TEST	CL_Stack,02			;Are we restore BIOS area
	JE	Restore_DAC_State		;No -Go check DAC state
	MOV	SI,ES:[BX+02]			;Yes-Get pointer to BIOS area
	CALL	Restore_BIOS_Data_Area		;Restore variables

Restore_DAC_State:
	TEST	CL_Stack,04			;Are we restoring DAC info
	JE	Exit_Restore_State		;No -Were done with restore
	MOV	SI,ES:[BX+04]			;Get pointer to DAC info
	MOV	AL_Stack,01CH			;Now set 1C completed
	MOV	DX,DAC_Pel_Mask 		;Restore DAC pel mask
	ADD	SI,02				;Advance to Pel Mask
	LODS	BYTE PTR ES:[SI]		;Get pel mask value
	OUT	DX,AL				;Write it

	CALL	Disable_DAC_Video		;Disable video during DAC load
	PUSH    BX
	XOR	BX,BX				;Start at index reg 00
	MOV	DX,100H 			;Write all 100H registers

Restore_DAC_Loop:
	PUSH	DX				;Save register counter
	LODS	WORD PTR ES:[SI]		;Get red,green values
	MOV	CH,AH				;Put green in CH
	MOV	AH,AL				;Put red in AH
	LODS	BYTE PTR ES:[SI]		;Get blue value
	MOV	CL,AL				;Put in CL
	CALL	Write_DAC			;Write the DAC register
	POP	DX				;Restore DAC counter
	DEC	DX				;Decrement
	JNE	Restore_DAC_Loop		;Repeat for 100H registers
	CALL	Enable_DAC_Video		;Enable the DAC video
	POP	BX
	MOV	SI,ES:[BX+04]			;Get pointer to DAC info
	MOV	DX,DAC_Read_Index		;Now restore DAC index reg
	LODS	BYTE PTR ES:[SI]		;Get read /write state
	OR	AL,AL				;Was it zero
	JNE	DAC_Read_State			;Yes-We were in a read state
	INC	DX				;Move to write index

DAC_Read_State:
	LODS	BYTE PTR ES:[SI]		;Get index register
	OUT	DX,AL				;Select index reg

Exit_Restore_State:
	RET
Video_Save_Restore_State ENDP
endif	;CL_SAVE_RESTORE eq NO

;****************************************************************
;   Save variables in the BIOS data area to the specifed buffer
;   The variables that are saved are:
;
;   BIOS Variable		      Offset   Size
;   -------------		      ------   ----
;   Equipment_Installed AND 30		00	01
;   Video_Mode to Video_Palette 	01	1E
;   Video_Rows to Video_DCC_Index	1F	07
;   Env_Ptr				26	04
;   Interrupt 5 			2A	04
;   Interrupt 1D			2E	04
;   Interrupt 1F			32	04
;   Interrupt 43			36	04
;
;   Entry: ES:DI - Buffer to place data
;****************************************************************

Save_BIOS_Data_Area PROC NEAR
	MOV	AL,BYTE PTR Equipment_Installed ;Get equipment status
	AND	AL,030H 			;Isolate monitor type
	STOSB					;And save at relative offset 0
	MOV	SI,OFFSET Video_Mode		;Save BIOS area from Video
	MOV	CX,01EH / 2			;mode to Video palette
	REP	MOVSW				;Move to buffer
	MOV	SI,OFFSET Video_Rows		;Now move 7 bytes starting
	MOV	CX,07				;at video_rows.
	REP	MOVSB				;Move to buffer
	MOV	SI,OFFSET Env_Ptr		;Now save environment ptr
	MOVSW					;Move offset address
	MOVSW					;Move segment address
	MOV	SI,005H * 4			;Get offset to print screen
	MOVSW					;Move offset address
	MOVSW					;Move segment address
	MOV	SI,01DH * 4			;Get video parameters vector
	MOVSW					;Move offset address
	MOVSW					;Move segment address
	MOV	SI,01FH * 4			;Get top 128 char set ptr
	MOVSW					;Move offset address
	MOVSW					;Move segment address
	MOV	SI,043H * 4			;Get current char set ptr
	MOVSW					;Move offset address
	MOVSW					;Move segment address
	RET
Save_BIOS_Data_Area ENDP

;****************************************************************
;   Restore variables to the BIOS data area from the specifed
;   buffer. The variables restored are the variables save in
;   Save_BIOS_Data_Area above.
;
;   Entry: ES:SI - Buffer containing BIOS data area
;****************************************************************

Restore_BIOS_Data_AREA PROC NEAR
	AND	BYTE PTR Equipment_Installed,NOT 30H ;Clear current monitor
	LODS	BYTE PTR ES:[SI]		;Read current monitor
	OR	BYTE PTR Equipment_Installed,AL ;Set new current monitor
	PUSH	ES				;Save buffer segment
	PUSH	DS				;Save BIOS data area
	MOV	AX,DS				;Get BIOS data segment
	MOV	DI,ES				;Get buffer segment
	XCHG	AX,DI				;Swap them
	MOV	DS,AX				;Set DS:SI to buffer data
	MOV	ES,DI				;and ES:DI to BIOS data area
	MOV	DI,OFFSET Video_Mode		;Restore at Video_Mode
	MOV	CX,01EH / 2			;Restore 1E bytes
	REP	MOVSW				;Restore the data
	MOV	DI,OFFSET Video_Rows		;Restore next block starting
	MOV	CX,07				;at video rows. Restore
	REP	MOVSB				;7 bytes
	POP	DS				;Put DS back to BIOS data area
	POP	ES				;ES points back to buffer
	LODS	WORD PTR ES:[SI]		;Get environment offset
	MOV	WORD PTR Env_Ptr,AX		;Save enviroment pointer
	LODS	WORD PTR ES:[SI]		;Get environment segment
	MOV	WORD PTR Env_Ptr+2,AX		;Restore environment segment

	MOV	DI,005H * 4			;Restore print screen first
	LODS	WORD PTR ES:[SI]		;Get vector offset
	MOV	[DI],AX 			;Save in interrupt area
	LODS	WORD PTR ES:[SI]		;Get vector segment
	MOV	[DI+02],AX			;Save in interrupt area
	MOV	DI,01DH * 4			;Restore video paramenters
	LODS	WORD PTR ES:[SI]		;Get vector offset
	MOV	[DI],AX 			;Save in interrupt area
	LODS	WORD PTR ES:[SI]		;Get vector segment
	MOV	[DI+02],AX			;Save in interrupt area
	MOV	DI,01FH * 4			;Restore top 128 char set
	LODS	WORD PTR ES:[SI]		;Get vector offset
	MOV	[DI],AX 			;Save in interrupt area
	LODS	WORD PTR ES:[SI]		;Get vector segment
	MOV	[DI+02],AX			;Restore in interrupt area
	MOV	DI,043H * 4			;Restore current char set ptr
	LODS	WORD PTR ES:[SI]		;Get vector offset
	MOV	[DI],AX 			;Save in interrupt area
	LODS	WORD PTR ES:[SI]		;Get vector segment
	MOV	[DI+02],AX			;Save in interrupt area
	RET
Restore_BIOS_Data_Area ENDP

;****************************************************************
VGA_Segment ENDS

	END
