	INCLUDE PAGE.INC
	SUBTTL	VGA BIOS Module G
;****************************************************************
;
;	$Workfile:   vgag.asm  $
; 
; 	Copyright 1989, 1990 Quadtel Corporation.
; 	All rights reserved.
; 
;	Contents:
;	This module contains Functions 10H and 11H of the VGA BIOS.
;
; 	Modification History:
; 	$Log:   E:/vcs/vga/vgag.asv  $
;      
;         Rev 1.0   21 Dec 1990 11:00:38   Darryl
;      Initial checkin to VCS.
;
;	07/08/89  Speed optimizations made to the core VGA BIOS.
;		  No code changes to this module.
;
;****************************************************************

	.XLIST
	INCLUDE VGADATA.INC
	include	config.inc
	include options.inc
	.LIST

	%OUT	Assembling VGA BIOS Module G

VGA_Segment SEGMENT PUBLIC WORD

	ASSUME	CS:VGA_Segment
	ASSUME	DS:VGA_Data_Area
	ASSUME	ES:NOTHING

	EXTRN	BIOS_Address:WORD
	EXTRN	Build_Character_Set:NEAR
	EXTRN	C8x8_Character_Set:BYTE
	EXTRN	C8x8_Character_Set_High:BYTE
	EXTRN	C8x14_Character_Set:BYTE
	EXTRN	C8x16_Character_Set:BYTE
	EXTRN	Default_Mode_Table:NEAR
	EXTRN	INT_Address:WORD
	EXTRN	Mono_9x14_Characters:BYTE
	EXTRN	Mono_9x16_Characters:BYTE
	EXTRN	Read_DAC:NEAR
	EXTRN	Read_DACF:NEAR
	EXTRN	Set_VGA_Registers:NEAR
	EXTRN	Set_Palette:NEAR
	EXTRN	Save_Palette_Value:NEAR
	EXTRN	Video_Cursor_Type:NEAR
	EXTRN	Write_DAC:NEAR
	EXTRN	Write_DACF:NEAR
	extrn	GetEnvPtr:near

	PUBLIC	Gray_Sum
	PUBLIC	Load_8x8_Set
	PUBLIC	Load_Char_Set
	PUBLIC	Load_Monochrome_Set
	PUBLIC	Read_Palette
	PUBLIC	Video_Load_Character
	PUBLIC	Video_Palette_Values
;gdl
	extrn	wait_vretrace:near
	extrn	get_crtc_addr:near
	extrn	getreg:near

;****************************************************************
;   AH = 10	Set palette register values
;		AL = 0	Set single palette register
;			BH - Palette value to set
;			BL - Register number
;		AL = 1	Set overscan value
;		AL = 2	Set all palette registers to 17 byte
;			array pointed to by ES:DX.
;		AL = 3	Set blinking/intensity bit
;			BL = 0 (Intensity)
;			BL = 1 (Blinking)
;		AL = 4	Reserved
;		AL = 5	Reserved
;		AL = 6	Reserved
;		AL = 7	Read palette register
;			BL - Palette register to read
;			Exit: BH - Palette value
;		AL = 8	Read overscan register
;			Exit: BH - Overscan register
;		AL = 9	Read palette register and overscan
;			ES:DX - Pointer to save area (17 bytes)
;			Exit: Bytes 0-F palette, 10 overscan
;		AL = A	Reserved
;		AL = B	Reserved
;		AL = C	Reserved
;		AL = D	Reserved
;		AL = E	Reserved
;		AL = F	Reserved
;		AL = 10 Set color register
;			BX - Register to set
;			DH - Red value
;			CH - Green value
;			CL - Blue value
;		AL = 11 Reserved
;		AL = 12 Set color register block
;			ES:DX - Pointer to color block
;				(DB red,green,blue,...)
;			BX    - First register to set
;			CX    - Number of registers to set
;		AL = 13 Select palette page
;			BL = 0 Select mode for paging
;			       BH = 0  4 blocks of 64 registers
;			       BH = 1  16 blocks of 16 registers
;			BL = 1 Select palette page
;			       BH = Page number (0-3 or 0-F)
;		AL = 14 Reserved
;		AL = 15 Read color register
;			BX - Color register to read
;			Exit: DH - Red value
;			      CH - Green value
;			      CL - Blue value
;		AL = 16 Reserved
;		AL = 17 Read color register block
;			ES:DX - Pointer to table
;			BX    - First register to read
;			CX    - Number of registers to read
;			Exit: ES:DX - (DB red,green,blue,...)
;		AL = 18 Reserved
;		AL = 19 Reserved
;		AL = 1A Read page state
;			Exit: BL - Paging mode
;			      BH - Current page set
;		AL = 1B Sum to gray shades
;			BX - Starting register to sum
;			CX - Number of registers to sum
;****************************************************************

;	ALIGN	4

Palette_Address_Table	LABEL	WORD
	DW	Set_Single_Palette		;Function 00
	DW	Set_Overscan_Value		;	  01
	DW	Set_All_Palettes		;	  02
	DW	Set_Blink_Or_Intensity		;	  03
	DW	Function10_Reserved		;	  04
	DW	Function10_Reserved		;	  05
	DW	Function10_Reserved		;	  06
	DW	Read_Palette_Register		;	  07
	DW	Read_Overscan_Register		;	  08
	DW	Read_Palette_And_Overscan	;	  09
	DW	Function10_Reserved		;	  0A
	DW	Function10_Reserved		;	  0B
	DW	Function10_Reserved		;	  0C
	DW	Function10_Reserved		;	  0D
	DW	Function10_Reserved		;	  0E
	DW	Function10_Reserved		;	  0F
	DW	Set_Color_Register		;	  10
	DW	Function10_Reserved		;	  11
	DW	Set_Color_Register_Block	;	  12
	DW	Set_Palette_Page		;	  13
	DW	Function10_Reserved		;	  14
	DW	Read_Color_Register		;	  15
	DW	Function10_Reserved		;	  16
	DW	Read_Color_Register_Block	;	  17
	DW	Write_DAC_Pel_Mask		;	  18
	DW	Read_DAC_Pel_Mask		;	  19
	DW	Read_Page_State 		;	  1A
	DW	Sum_To_Gray_Shades		;	  1B

Video_Palette_Values PROC NEAR
	CMP	AL,01BH 			;Test if function is in range
	JA	Function10_Reserved		;No -Just exit

IFDEF DIGITAL
	CMP	VGA_DCC_Index,03		;Are we CGA or MDA only
	JBE	Digital_Exit10			;Yes-Exit now
	CMP	AL,03H				;EGA supports 0 through 3
	JBE	Valid_Digital10 		;Go if valid for EGA
	CMP	VGA_DCC_Index,07		;Are we EGA
	JBE	Digital_Exit10			;Yes-Exit immediately

Valid_Digital10:
ENDIF

	XOR	AH,AH				;Yes-Extend to AX
	SHL	AX,1				;Double for word offset
	MOV	SI,AX				;Use SI as index
	JMP	CS:Palette_Address_Table[SI]	;Goto function
Video_Palette_Values ENDP

;****************************************************************
;   Function 00/01 - Set Single Palette/Overscan Register
;****************************************************************

Set_Overscan_Value	PROC	NEAR
	MOV	BL,11H

Set_Single_Palette:
	CALL	Set_Palette			;Set palette register
	CALL	Save_Palette_Value		;Save value in table

Function10_Reserved:
Digital_Exit10:
	RET
Set_Overscan_Value	ENDP

;****************************************************************
;   Function 02 - Set all Palette and Overscan Registers
;****************************************************************

Set_All_Palettes	PROC	NEAR
	MOV	CX,16				;Set first 16 registers
	XOR	BL,BL				;Reset to starting register
	MOV	SI,DX				;Get pointer to table

Write_Palettes_Loop:
	MOV	BH,ES:[SI]			;Get byte from table
	INC	SI				;Next position
	CALL	Set_Palette			;Write the palette register
	CALL	Save_Palette_Value		;Save the value in table
	INC	BL				;Next register
	LOOP	Write_Palettes_Loop		;Write next register
	MOV	BH,ES:[SI]			;Get byte from table
	CALL	Save_Palette_Value		;Save the value in table
	INC	BL				;Skip to overscan register
	CALL	Set_Palette			;Set the overscan register
	RET
Set_All_Palettes	ENDP

;****************************************************************
;   Function 03 - Set Blink / Intensity Register
;****************************************************************

Set_Blink_Or_Intensity	PROC	NEAR

IFDEF EMULATE
	CMP	VGA_DCC_Index,07
	JA	VGA_Way
	CALL	Default_Mode_Table		;Get pointer to table
	MOV	BH,ES:[SI+51]			;Get byte from table
	MOV	BL,10H
	JMP	SHORT EGA_Way

VGA_Way:
ENDIF

	MOV	BL,10H				;Read mode control
	CALL	Read_Palette			;from attribute controller

EGA_Way:
	CMP	BL_Stack,00			;Test for enable intensity
	JE	Intensity			;Enable intensity
	CMP	BL_Stack,01			;Test for enable blink
	JNE	Done_Palette			;Exit - invalid command
	OR	BH,08H				;Set bit for blink
	MOV	AL,Video_Mode_Set		;Current video mode byte
	OR	AL,020H 			;Set bit for blink
	JMP	SHORT Set_Palette_Mode		;Set the mode

Intensity:
	AND	BH,0F7H 			;Reset blink bit
	MOV	AL,Video_Mode_Set		;Current video mode byte
	AND	AL,0DFH 			;Reset blink bit

Set_Palette_Mode:
	MOV	Video_Mode_Set,AL		;Save new video mode
	CALL	Set_Palette			;Write the palette register

Done_Palette:
	RET
Set_Blink_Or_Intensity	ENDP

;****************************************************************
;   Function 07/08 - Read Palette Register / Read Overscan Register
;****************************************************************

Read_Overscan_Register	PROC	NEAR
	MOV	BL,11H				;Get overscan register

Read_Palette_Register:
	CALL	Read_Palette			;Read palette in BL
	MOV	BH_Stack,BH			;Save results on stack
	RET
Read_Overscan_Register	ENDP

;****************************************************************
;   Function 09 - Read Palette Register and Overscan
;****************************************************************

Read_Palette_And_Overscan	PROC	NEAR
	MOV	CX,16				;Set first 16 registers
	XOR	BL,BL				;Reset to starting register
	MOV	DI,DX				;Get pointer to table

Read_Palettes_Loop:
	CALL	Read_Palette			;Read the palette reg
	MOV	AL,BH				;Get value from register
	STOSB					;Save value in table
	INC	BL				;Move to next palette reg
	LOOP	Read_Palettes_Loop		;Repeat for 16 palette regs
	INC	BL				;Advance to overscan reg
	CALL	Read_Palette			;Read the overscan
	MOV	AL,BH				;Get result
	STOSB					;And save in table
	RET
Read_Palette_And_Overscan	ENDP

;****************************************************************
;   Function 10 - Write Color Register
;****************************************************************

Set_Color_Register	PROC	NEAR
	MOV	AH,DH				;AH/CH/CL has DAC values
	JMP	Set_Single_DAC			;Go set DAC value
Set_Color_Register	ENDP

;****************************************************************
;   Function 12 - Write Color Register Block
;****************************************************************

Set_Color_Register_Block PROC	NEAR
;gdl	CALL	Disable_DAC_Video		;Disable the video
	MOV	SI,DX				;Get buffer offset
	MOV	DI,CX				;Get block length
	push	bx				;Save BX
	mov	bl,1				;Wait 1 frame
	call	wait_vretrace			;Wait for VSync
	pop	bx				;Restore BX

Next_DAC_Set:
	LODS	WORD PTR ES:[SI]		;Get read and green values
	MOV	CH,AH				;Save green in CH
	MOV	AH,AL				;Save red in AH
	LODS	BYTE PTR ES:[SI]		;Get blue value
	MOV	CL,AL				;Save blue value in CL
	CALL	Gray_Sum			;Gray sum if necessary
	CALL	Write_DAC			;Write to DAC
	DEC	DI				;Decrement block count
	JNE	Next_DAC_Set			;Repeat for block length
;gdl	CALL	Enable_DAC_Video		;Enable the video
	RET
Set_Color_Register_Block ENDP

;****************************************************************
;   Function 13 - Write Palette Page Number
;****************************************************************

Set_Palette_Page	PROC	NEAR
	OR	BL,BL				;Test for sub-function 0
	JE	Set_Paging_Mode 		;Yes-Go select page mode
	MOV	BL,10H				;Read mode control register
	CALL	Read_Palette			;from attribute controller
	MOV	AL,BH_Stack			;Get page number
	AND	AL,0FH				;Isolate page number
	TEST	BH,80H				;Are we in 4 or 16 page mode
	JNE	Has_16_Pages			;Go if 16 page mode
	AND	AL,03H				;Otherwise isolate 4 pages
	SHL	AL,1				;Move page number
	SHL	AL,1				;to bits 2 and 3

Has_16_Pages:
	MOV	BL,14H				;Get color select register
	MOV	BH,AL				;Get page number
	CALL	Set_Palette			;Write to attribute controller
	RET

Set_Paging_Mode:
	MOV	BL,10H				;Read mode control register
	CALL	Read_Palette			;from attribute controller
	AND	BH,7FH				;Clear P5,P4 select
	CMP	BH_Stack,00			;Set 4 blocks of 64 regs
	JE	Set_Page_Mode			;Yes-Go write mode control
	OR	BH,80H				;No -Set 16 blocks of 16 regs

Set_Page_Mode:
	MOV	BL,10H				;Get mode control reg
	CALL	Set_Palette			;Write the attr register
	RET
Set_Palette_Page	ENDP

;****************************************************************
;   Function 15 - Read Color Register
;****************************************************************

Read_Color_Register	PROC	NEAR
	CALL	Read_Single_DAC 		;Read value from DAC
	MOV	DH_Stack,AH			;Save red DAC value
	MOV	CH_Stack,CH			;Save green DAC value
	MOV	CL_Stack,CL			;Save blue DAC value
	RET
Read_Color_Register	ENDP

;****************************************************************
;   Function 17 - Read Color Register Block
;****************************************************************

Read_Color_Register_Block PROC	  NEAR
;gdl	CALL	Disable_DAC_Video		;Disable the video
	MOV	DI,DX				;Get buffer offset
	MOV	SI,CX				;Get block length

Next_DAC_Read:
	CALL	Read_DAC			;Read DAC values
	MOV	AL,AH				;Get read value
	MOV	AH,CH				;Get green value
	STOSW					;Save in table
	MOV	AL,CL				;Get blue value
	STOSB					;Save in table
	DEC	SI				;Decrement block count
	JNE	Next_DAC_Read			;Repeat for block length
;gdl	CALL	Enable_DAC_Video		;Enable the video
	RET
Read_Color_Register_Block ENDP

;****************************************************************
;   Function 18 - Write DAC Pel Mask Register
;****************************************************************

Write_DAC_Pel_Mask	PROC	NEAR
	MOV	DX,DAC_Pel_Mask 		;Get pel mask register
	MOV	AL,BL				;Get pel mask value
	OUT	DX,AL				;Write to the register
	RET
Write_DAC_Pel_Mask	ENDP

;****************************************************************
;   Function 19 - Read DAC Pel Mask Register
;****************************************************************

Read_DAC_Pel_Mask	PROC	NEAR
	MOV	DX,DAC_Pel_Mask 		;Get pel mask register
	IN	AL,DX				;Get pel mask value
	XOR	AH,AH				;Extend to AX
	MOV	BX_Stack,AX			;Return in BX register
	RET
Read_DAC_Pel_Mask	ENDP

;****************************************************************
;   Function 1A - Read Page State
;****************************************************************

Read_Page_State PROC	NEAR
	MOV	BL,14H				;Get color select register
	CALL	Read_Palette			;from attribute controller
	MOV	CL,BH				;Get current page number
	AND	CL,0FH				;Isolate page number
	MOV	BL,10H				;Now read mode control
	CALL	Read_Palette			;from attribute controller
	MOV	BL,01H				;Assume 16 page mode
	TEST	BH,80H				;Are we 16 page mode
	JNE	In_16_Page_Mode 		;Yes-Return type and page #
	MOV	BL,00				;Set 4 page mode
	SHR	CL,1				;Shift page number
	SHR	CL,1				;down to bits 0 and 1

In_16_Page_Mode:
	MOV	BH,CL				;Get page number
	MOV	BX_Stack,BX			;Return type and page number
	RET
Read_Page_State ENDP

;****************************************************************
;   Function 1B - Sum to Gray Shades
;****************************************************************

Sum_To_Gray_Shades	PROC	NEAR
;gdl	CALL	Disable_DAC_Video		;Disable the DAC video
	MOV	SI,CX				;Get register count

Gray_Sum_Loop:
	CALL	Read_DAC			;Read the DAC values
	CALL	Gray_Sum_Always 		;Gray sum them
	DEC	BX				;Move back to DAC index
	CALL	Write_DAC			;Write the DAC register
	DEC	SI				;Decrement block count
	JNE	Gray_Sum_Loop			;Repeat for specified block
;gdl	JMP	Enable_DAC_Video		;Enable the video
	ret
Sum_To_Gray_Shades	ENDP

;****************************************************************
;   Read the specifid palette from the attribute controller after
;   waiting for the vertical retrace to start.
;
;	Entry:	BL - Address offset
;	Exit:	BH - Data read from palette
;****************************************************************

Read_Palette	PROC	NEAR
	PUSH	DX				;Save registers
;gdl:01/21/92 Get VGA's CRTC address, in case VGA is not active.
	call	get_crtc_addr			;Get CRTC address
;	MOV	DX,M6845_Address		;Get offset address
	ADD	DL,6				;Vertical retrace status

Read_Vert_Retrace:
	IN	AL,DX				;Get status
	AND	AL,08H				;Test for retrace active
	JE	Read_Vert_Retrace		;Wait for retrace
	PUSH	DX				;Save status register
	MOV	DX,Attribute_Controller 	;Get attribute controller
	MOV	AL,BL				;Get address to write
;gdl	CLI					;No interrupts now
	OUT	DX,AL				;Write to address
	JMP	SHORT $+2			;Delay briefly
	INC	DX				;Move to 3C1 (read)
	IN	AL,DX				;Read the data
	POP	DX				;Restore status register
	MOV	BH,AL				;Save results
	IN	AL,DX				;Clear flip flop
	MOV	DX,Attribute_Controller 	;And not re-enable the video
	MOV	AL,020H 			;Reenable palette
	OUT	DX,AL				;Write to reenable
;gdl	sti					;Allow interrupts again
	POP	DX				;Restore registers
	RET
Read_Palette	ENDP

;****************************************************************
;   Write the red, green, and blue values to the specified
;   DAC register.
;
;	Entry:	BX - Register offset
;		AH - Red value
;		CH - Green value
;		CL - Blue value
;****************************************************************

Set_Single_DAC PROC NEAR
	CALL	Gray_Sum
;gdl:01/21/92 Get VGA's CRTC address, in case VGA is not active.
	call	get_crtc_addr			;Get CRTC address
;	MOV	DX,M6845_Address		;Get offset address
	ADD	DL,6				;Vertical retrace status
	PUSHF
	CLI

Set_DAC_Vert_Retrace:
	IN	AL,DX				;Get status
	AND	AL,08H				;Test for retrace active
	JE	Set_DAC_Vert_Retrace		;Wait for retrace
	JMP	Write_DACF			;Write DAC register
Set_Single_DAC ENDP

;****************************************************************
;   Read the red, green, and blue values from the specified
;   DAC register.
;
;   Entry: BX - DAC Index register
;   Exit:  AH - Red DAC value
;	   CH - Green DAC value
;	   CL - Blue DAC value
;****************************************************************

Read_Single_DAC PROC NEAR
;gdl:01/21/92 Get VGA's CRTC address, in case VGA is not active.
	call	get_crtc_addr			;Get CRTC address
;	MOV	DX,M6845_Address		;Get offset address
	ADD	DL,6				;Vertical retrace status
	PUSHF
	CLI

Read_DAC_Vert_Retrace:
	IN	AL,DX				;Get status
	AND	AL,08H				;Test for retrace active
	JE	Read_DAC_Vert_Retrace		;Wait for retrace
	JMP	Read_DACF			;Read DAC register
Read_Single_DAC ENDP

;****************************************************************
;   Compute the appropriate DAC gray scale value using the
;   specified red, green, and blue DAC values. Gray shade
;   summing is achieved by using 30% of the red elements,
;   59% of the green elements, and 11% of the blue elements
;   to compute a value for all three DAC registers.
;
;   Entry: AH - Red value
;	   CH - Green value
;	   CL - Blue value
;
;   Exit:  AH/CH/CL contain gray shade if gray summing is active
;****************************************************************

Red_Sum 	DW	02666H
Green_Sum	DW	04B85H
Blue_Sum	DW	00E14H

Gray_Sum	PROC	NEAR
	TEST	VGA_StatusA,Gray_Shades OR VGA_Monochrome ;Are we summing
	JE	Exit_Gray_Sum			;No -Exit

Gray_Sum_Always:
	PUSH	BX
	PUSH	DX				;Save important registers
	AND	AX,03F00H			;Yes-Isolate red DAC value
	XCHG	AL,AH				;and put into AX
	MUL	Red_Sum 			;Compute red sum
	PUSH	DX				;Save high word of result
	PUSH	AX				;Save low word of result
	MOV	AL,CH				;Get green DAC value
	AND	AL,03FH 			;Mask unused bits
	XOR	AH,AH				;Extend to word
	MUL	Green_Sum			;Compute green sum
	PUSH	DX				;Save 32 bit value
	PUSH	AX				;on the stack
	MOV	AL,CL				;Get blue value
	AND	AL,03FH 			;Mask unused bits
	XOR	AH,AH				;Extend to word
	MUL	Blue_Sum			;Compute blue sum
	POP	BX				;Now start adding
	ADD	AX,BX				;them all together
	POP	BX				;Get high word
	ADC	DX,BX				;Add to high value with carry
	POP	BX				;Get low red word
	ADD	AX,BX				;Add to total
	POP	BX				;Get high red word
	ADC	DX,BX				;Add with carry
	ADD	AX,AX				;Multipy result
	ADC	DX,DX				;by two
	ADD	AX,8000H			;Add 8000 to the result
	ADC	DX,0000H			;And put the resul in
	MOV	AH,DL				;the red, green, and blue
	MOV	CL,DL				;DAC registers
	MOV	CH,DL
	POP	DX				;Restore callers registers
	POP	BX

Exit_Gray_Sum:
	RET
Gray_Sum	ENDP

;****************************************************************
;   AH = 11	Load character sets
;		AL = 0	Load character set
;			ES:BP - Character set pointer
;			DX	  - Character offset from start
;			CX	  - Number of characters
;			BL	  - Character set (0-3)
;			BH	  - Bytes per character
;		AL = 1	Load VGA 8x14 Character set
;			BL	  - Character set (0-3)
;		AH = 2	Load VGA 8x8 character set
;			BL	  - Character set (0-3)
;		AH = 3	Character set select
;			BL	  - Bits 0-1 first set
;				Bits 2-3 second set
;		AH = 4	Load VGA 8x16 Character set
;			BL    - Character set (0-3)
;		AL = 10 Load character set and recalculate
;			ES:BP - Character set pointer
;			DX	  - Character offset from start
;			CX	  - Number of characters
;			BL	  - Character set (0-3)
;			BH	  - Bytes per character
;		AL = 11 Load VGA Rom mono set and recalculate
;			BL	  - Character set (0-3)
;		AL = 12 Load VGA 8x8 char set and recalculate
;			BL	  - Character set (0-3)
;		AL = 14 Load VGA 8x16 char set and recalculate
;			BL    - Character set (0-3)
;		AL = 20 Set INT 1F to user 8x8 character set
;			ES:BP - Pointer to set
;		AL = 21 Set INT 43 to user character set
;			ES:BP - Pointer to set
;			CX	  - Bytes per character
;			DL	  - Video rows (if BL = 00)
;			BL	  - Code for video rows
;				00 - User specified (DL)
;				01 - 14 rows
;				02 - 25 rows
;				03 - 43 rows
;		AL = 22 Set INT 43 to BIOS 8x14 character set
;			DL	  - Video rows (if BL = 00)
;			BL	  - Code for video rows
;				00 - User specified (DL)
;				01 - 14 rows
;				02 - 25 rows
;				03 - 43 rows
;		AL = 23 Set INT 43 to BIOS 8x8 character set
;			DL	  - Video rows (if BL = 00)
;			BL	  - Code for video rows
;				00 - User specified (DL)
;				01 - 14 rows
;				02 - 25 rows
;				03 - 43 rows
;		AL = 24 Set INT 43 to BIOS 8x16 character set
;			DL    - Video rows (if BL = 00)
;			BL    - Code for video rows
;				00 - User specified (DL)
;				01 - 14 rows
;				02 - 25 rows
;				03 - 43 rows
;		AL = 30 Return Character Set Status
;			BH	  - Character set specifier
;				00 - INT 1F Address
;				01 - INT 43 Address
;				02 - BIOS 8x14 Set Address
;				03 - BIOS 8x8 Set Address
;				04 - BIOS 8x8 Address ( > 128)
;				05 - BIOS 9x14 Update Set Addr
;				06 - BIOS 8x16 Set Address
;				07 - BIOS 9x16 Update Set Addr
;			Exit:	ES:BP - Character Set Address
;				CX    - Bytes per Character
;				DL    - Video rows
;
;   Note: Load_Char_Set will be called from the mode set function
;	  with information in Bit 6 and 7 of BL. This information
;	  directs the load font routine to use the 9x14 or
;	  9x16 update fonts. These operations are unaccessible
;	  from function 11H.
;****************************************************************

;	ALIGN	4

Load_Character_Table	LABEL	WORD
	DW	Load_User_Set			;(0-3)
	DW	Load_Monochrome_Set
	DW	Load_8x8_Set
	DW	Define_Character_Attribute

	DW	Load_8x16_Set			;(4-7)
	DW	No_Function
	DW	No_Function
	DW	No_Function

	DW	Load_Recalc_User_Set		;(10-13)
	DW	Load_Recalc_Monochrome_Set
	DW	Load_Recalc_8x8_Set
	DW	No_Function


	DW	Load_Recalc_8x16_Set		;(14-17)
	DW	No_Function
	DW	No_Function
	DW	No_Function

	DW	Load_User_Graphics_8x8		;(20-23)
	DW	Select_Graphics
	DW	Load_VGA_Graphics_8x14
	DW	Load_VGA_Graphics_8x8

	DW	Load_VGA_Graphics_8x16		;(24-27)
	DW	No_Function
	DW	No_Function
	DW	No_Function

	DW	Return_Character_Info		;(30)
Table_Size		EQU	($-Load_Character_Table)/2

Video_Load_Character PROC NEAR
	MOV	SI,BP_Stack			;Get offset
	AND	BL,03FH 			;Mask upper bit

Load_Char_Set:

	MOV	AH,AL				;Get subfunction
	AND	AL,0FH				;Isolate low bits
	AND	AH,30H
	SHR	AH,1				;Shift down
	OR	AL,AH				;Or in bits
	CMP	AL,Table_Size			;Test for above
	JAE	No_Function			;Invalid function

IFDEF DIGITAL
	CMP	VGA_DCC_Index,00
	JE	Support8x16
	CMP	VGA_DCC_Index,07		;Are we a digital monitor
	JA	Support8x16			;Yes-Exit immediately
	CMP	AL,04
	JE	No_Function			;Dont support function 4
	CMP	AL,12
	JE	No_Function			;Dont support function 14
	CMP	AL,20
	JE	No_Function			;Dont support function 20

Support8x16:
ENDIF

	MOV	AH,00				;Reset high byte
	MOV	DI,AX				;Get function offset
	SHL	DI,1				;Make word offset
	JMP	CS:Load_Character_Table[DI]	;Vector to routine

No_Function:
	RET
Video_Load_Character ENDP

;****************************************************************
;   Sub-Function 00 - Load user graphics for alpha mode
;****************************************************************

Load_User_Set PROC NEAR
;v0.071{
	cmp	Video_Mode,5Fh			;For MicroSoft Hebrew's bug
	jz	No_Function
;v0.071}
	JMP	Build_Character_Set		;Build new character set
Load_User_Set ENDP

;****************************************************************
;   Sub-Function 01 - Load 8x14 character set for alpha mode
;****************************************************************

Load_Monochrome_Set PROC NEAR
	MOV	SI,OFFSET C8x14_Character_Set	;Get pointer to set
	MOV	AX,CS				;Get code segment
	MOV	ES,AX				;Set extra segment
	call	LoadTsrFont8X14			;v0.051
	XOR	DX,DX				;Reset offset
	MOV	CX,256				;Number of characters
	MOV	BH,14				;Scan lines/character
	JMP	Build_Character_Set		;Build new character set
Load_Monochrome_Set ENDP

;****************************************************************
;   Sub-Function 02 - Load 8x8 character set for alpha mode
;****************************************************************

Load_8x8_Set PROC NEAR
	MOV	SI,OFFSET C8x8_Character_Set	;Get pointer to set
	MOV	AX,CS				;Get code segment
	MOV	ES,AX				;Set extra segment
	XOR	DX,DX				;Reset offset
	MOV	CX,256				;Number of characters
	MOV	BH,8				;Scan lines/character
	JMP	Build_Character_Set		;Build new character set
Load_8x8_Set ENDP

;****************************************************************
;   Sub-Function 03 - Define bit 3 of character attribute
;****************************************************************

Define_Character_Attribute PROC NEAR
	MOV	AL,03H				;Address to write
	MOV	AH,BL				;Get byte
	MOV	DX,Sequencer			;Get sequencer base address
	OUT	DX,AX				;Write to sequencer
	RET
Define_Character_Attribute ENDP

;****************************************************************
;   Sub-Function 04 - Load 8x16 character set for alpha mode
;****************************************************************

Load_8x16_Set PROC NEAR
	MOV	SI,OFFSET C8x16_Character_Set	 ;Get pointer to set
	MOV	AX,CS				;Get code segment
	MOV	ES,AX				;Set extra segment
	XOR	DX,DX				;Reset offset
	MOV	CX,256				;Number of characters
	MOV	BH,16				;Scan lines/character
	JMP	Build_Character_Set		;Build new character set
Load_8x16_Set ENDP

;****************************************************************
;   Sub-Function 10 - Load user graphics for alpha mode & recalc
;****************************************************************

Load_Recalc_User_Set PROC	NEAR
	CALL	Build_Character_Set		;Build new character set
	JMP	short Recalculate_Variables	;Recalculate
Load_Recalc_User_Set ENDP

;****************************************************************
;   Sub-Function 11 - Load 8x14 char set for alpha mode & recalc
;****************************************************************

Load_Recalc_Monochrome_Set PROC NEAR
	MOV	SI,OFFSET C8x14_Character_Set	;Get pointer to set
	MOV	AX,CS				;Get code segment
	MOV	ES,AX				;Set extra segment
	call	LoadTsrFont8X14			;v0.051
	XOR	DX,DX				;Reset offset
	MOV	CX,256				;Number of characters
	MOV	BH,14				;Scan lines/character
	CALL	Build_Character_Set		;Build new character set
	JMP	short Recalculate_Variables	;Perform recalculation
Load_Recalc_Monochrome_Set ENDP

;****************************************************************
;   Sub-Function 12 - Load 8x8 char set for alpha mode & recalc
;****************************************************************

Load_Recalc_8x8_Set PROC NEAR
	MOV	SI,OFFSET C8x8_Character_Set	;Get pointer to set
	MOV	AX,CS				;Get code segment
	MOV	ES,AX				;Set extra segment
	XOR	DX,DX				;Reset offset
	MOV	CX,256				;Number of characters
	MOV	BH,8				;Scan lines/character
	CALL	Build_Character_Set		;Build new character set
	JMP	short Recalculate_Variables	;Perform recalculation
Load_Recalc_8x8_Set ENDP

;****************************************************************
;   Sub-Function 14 - Load 8x16 char set for alpha mode & recalc
;****************************************************************

Load_Recalc_8x16_Set PROC NEAR
	MOV	SI,OFFSET C8x16_Character_Set	;Get pointer to set
	MOV	AX,CS				;Get code segment
	MOV	ES,AX				;Set extra segment
	XOR	DX,DX				;Reset offset
	MOV	CX,256				;Number of characters
	MOV	BH,16				;Scan lines/character
	CALL	Build_Character_Set		;Build new character set
	JMP	short Recalculate_Variables	;Perform recalculation
Load_Recalc_8x16_Set ENDP

;****************************************************************
;   Recalculate the video variables after downloading the
;   character set.
;****************************************************************

Recalculate_Variables PROC NEAR
	MOV	BYTE PTR Char_Length,BH 	;Save character size

	call	get_crtc_addr		;Get VGA's CRTC addr
	mov	al,15h			; Read VBlankS to find max display
	call	getreg			; height.

	mov	bl,ah			;[7:0] of VBlankS in BL

	mov	al,07h			;Now get VBlankS[8]
	call	getreg			;Read it
	and	ah,08h			;Get VBlankS[8] bit
	shr	ah,1			;Shift it down into position
	shr	ah,1			;[0] of BH =
	shr	ah,1			; [8] of BX
	mov	bh,ah			;Put it in BX

	mov	al,09h			;Now get VBlankS[9]
	call	getreg			;Read it
	mov	cl,ah			;Save a copy for checking scandbl
	and	ah,20h			;Get VBlankS[9] bit
	shr	ah,1			;Shift it down into position
	shr	ah,1			;[1] of BH =
	shr	ah,1
	shr	ah,1			; [9] of BX
	or	bh,ah			;BX = VBlankS

;++ Check ER79 for extension vertical blank?

	test	cl,80h			;Scan doubled mode?
	jz	SkipScanDbl		;No, don't fudge screen height
	shr	bx,1			;Yes, divide by 2
SkipScanDbl:
	mov	cx,bx			;CX = screen height in scan lines
	mov	bx,200			;Assume it's 200 lines
	cmp	cx,200+10		;Is it around 200?
	jbe	Set_Scans		;Yes, around 200, so set it
	mov	bx,350			;Assume it's 350 lines
	cmp	cx,350+10		;Is it around 350?
	jbe	Set_Scans		;Yes, around 350, so set it
	mov	bx,400			;Assume it's 400 lines
	cmp	cx,400+10		;Is it around 400?
	jbe	Set_Scans		;Yes, around 400, so set it
	mov	bx,480			;Assume it's 480 lines
	cmp	cx,480+10		;Is it around 480?
	jbe	Set_Scans		;Yes, around 480, so set it
	mov	bx,cx			;Else use raw VBlankS value

if 0
;	MOV	BX,480				;Determine scan lines
	MOV	BX,400				;Done for compatibility only
	MOV	AL,Video_Mode			;Get video mode
	CMP	AL,11H				;Test for mode 11
	JE	Set_Scans			;Go if 480 lines
	CMP	AL,12H				;Test for mode 12
	JE	Set_Scans			;Go if 480 lines
	MOV	BX,200				;Handle 200 scan line modes
	CMP	AL,13H				;Are we mode 13
	JE	Set_Scans			;Yes-Set 200 line mode
	CMP	AL,04H				;Are we text mode
	JB	Text_Lines			;Yes-Go handle differently
	CMP	AL,06H				;Are we modes 4, 5 or 6
	JBE	Set_Scans			;Yes-Set to a 200 line mode
	CMP	AL,09H				;Are we 7 or 8
	JB	Text_Lines			;Yes-Handle as text mode
	CMP	AL,0EH				;Are we 9 through E
	JBE	Set_Scans			;Yes-Set 200 line mode
	MOV	BX,350				;Isolate modes F and 10
	CMP	AL,10H				;which are 350 scan lines
	JBE	Set_Scans			;Yes-Go set 350 lines

Text_Lines:
	MOV	BX,400				;No -Test for 400 lines
	TEST	VGA_StatusA,Scans_400		;Can we do 400 lines
	JNE	Set_Scans			;Yes-We have scan lines
	MOV	BX,350				;No -Can we do 350 lines
	TEST	EGA_StatusA,EGA_Monochrome	;Are we functioning as mono
	JNE	Set_Scans			;Yes-Return 350 scans
	MOV	AH,EGA_StatusB			;Get switch settings
	AND	AH,0FH				;Isolate switches
	CMP	AH,03H				;Check for VGA enhanced
	JE	Set_Scans			;Yes-We can do 350 lines
	CMP	AH,09H				;Check VGA enhanced primary
	JE	Set_Scans			;Yes-We can do 250 lines
	CMP	AL,07H				;Test for mode 7
	JE	Set_Scans			;Yes-Since mode 7 is mono
	MOV	BX,200				;Must use 200 line table
endif	;0

Set_Scans:
	MOV	AX,BX				;Get number of scan lines
	XOR	DX,DX
	DIV	Char_Length			;Divide by char_Length
	DEC	AL				;Compute rows - 1
	MOV	Video_Rows,AL			;Save Video rows
	INC	AL				;AL is actual row count
	MOV	CX,Video_Columns		;Get video columns
	SHL	CX,1				;Multiply by 2 for attr
	XOR	AH,AH				;and then by row to compute
	MUL	CX				;the video size
	ADD	AX,100H 			;Add 100H for end space
	MOV	Video_Length,AX 		;Save video length

	MOV	DX,M6845_Address		;Get base CRTC address
	MOV	AH,BYTE PTR Char_Length 	;Get character length
	DEC	AH				;Get char size - 1
	CMP	Video_Mode,7			;Are we mode 7
	JNE	Dont_Set_Underline		;No -Dont set underline reg
	MOV	AL,14H				;Yes-Write the underline
	OUT	DX,AX				;register

Dont_Set_Underline:
;gdl:12/10/91:Fix font load in scan doubled modes.
	MOV	CH,AH				;Save aside the font height-2
	MOV	AL,09				;Get maximum scan line reg
	call	getreg				;Preserve upper bits,
	and	ah,not 1Fh			; especially the scandbl
	or	ah,ch				;Combine in font size-1
	setreg					;Set it
	mov	ah,ch				;AH = font size-1 again

;	MOV	AL,09				;Get maximum scan line reg
;	OUT	DX,AX				;Also set max scan line
	MOV	CH,AH				;Now compute cursor size
	MOV	CL,AH				;Set start to char_length-2
	DEC	CH				;and end to char_length-1
	CMP	AH,0CH				;test if end is above C
	JBE	Set_Cursor_Size 		;No -Use existing size
	SUB	CX,0101H			;Yes-Lower cursor one line

Set_Cursor_Size:
	MOV	Cursor_Size,CX			;Save new cursor size
	MOV	AL,0AH				;Get cursor start scan reg
	MOV	AH,CH				;Get cursor start scan
	OUT	DX,AX				;Write CRT register
	INC	AL				;Advance register index
	MOV	AH,CL				;Get cursor end value
	OUT	DX,AX				;Write CRT end register
	MOV	AL,Video_Rows			;Get video rows
	INC	AL				;Compute actual rows
	MUL	BYTE PTR Char_Length		;Multipy by char size
	CMP	BX,200				;Are we double scanning?
	JNE	Set_CRTC12			;No -Dont double vertical total
	SHL	AX,1				;Do for double scanning modes

Set_CRTC12:
	DEC	AX				;to get scan lines
	MOV	AH,AL				;Prepare for word write
	MOV	AL,12H				;Adjust end display to
	OUT	DX,AX				;account for any half chars
	RET
Recalculate_Variables ENDP

;****************************************************************
;   Sub-Function 20 - Set INT 1F to user 8x8 character set
;****************************************************************

Load_User_Graphics_8x8 PROC NEAR
	MOV	DI,ES				;Set specified segment
	MOV	ES,INT_Address			;Get interrupt segment
	pushf
	CLI					;No interrupts
	MOV	ES:[01FH*4+0],SI		;Set offset for table
	MOV	ES:[01FH*4+2],DI		;Set segment for table
	popf					;Allow interrupts
	RET
Load_User_Graphics_8x8 ENDP

;****************************************************************
;   Sub-Function 22 - Set INT 43 to BIOS 8x14 character set
;****************************************************************

Load_VGA_Graphics_8x14 PROC NEAR
	MOV	ES,INT_Address			;Set interrupt segment
	MOV	SI,OFFSET C8x14_Character_Set	;Get character set
	MOV	DI,CS				;Get local segment
	call	LoadTsr8X14			;v0.051
	MOV	CX,14				;Number of character scans
	JMP	SHORT Set_Graphics		;Set graphics set
Load_VGA_Graphics_8x14 ENDP

;****************************************************************
;   Sub-Function 23 - Set INT 43 to BIOS 8x8 character set
;****************************************************************

Load_VGA_Graphics_8x8 PROC NEAR
	MOV	ES,INT_Address			;Set interrupt segment
	MOV	SI,OFFSET C8x8_Character_Set	;Get character set
	MOV	DI,CS				;Get local segment
	MOV	CX,8				;Number of character scans
	JMP	SHORT Set_Graphics		;Set graphics set
Load_VGA_Graphics_8x8 ENDP

;****************************************************************
;   Sub-Function 24 - Set INT 43 to BIOS 8x16 character set
;****************************************************************

Load_VGA_Graphics_8x16 PROC NEAR
	MOV	ES,INT_Address			;Set interrupt segment
	MOV	SI,OFFSET C8x16_Character_Set	;Get character set
	MOV	DI,CS				;Get local segment
	MOV	CX,16				;Number of character scans
	JMP	SHORT Set_Graphics		;Set graphics set
Load_VGA_Graphics_8x16 ENDP

;****************************************************************
;   Sub-Function 21 - Set INT 43 to user char set, set char_Length
;****************************************************************

Graphics_Rows	DB	13,24,42

Select_Graphics PROC NEAR
	MOV	DI,ES				;Get original ES
	MOV	ES,INT_Address			;Set Interrupt segment

Set_Graphics:
	pushf
	CLI					;No interrupts
	MOV	ES:[043H*4+0],SI		;Set offset for table
	MOV	ES:[043H*4+2],DI		;Set segment for table
	popf					;Allow interrupts
	CMP	BL,4				;Test for overflow
	JB	Test_Row			;Test for user specified
	MOV	BL,3				;Map to last value

Test_Row:
	DEC	DL				;Set last row value
	OR	BL,BL				;Test for user specified
	JE	Set_Row 			;Set the row value
	DEC	BL				;Make relative zero
	MOV	BH,00				;Reset high byte
	MOV	DL,CS:Graphics_Rows[BX] 	;Get rows byte

Set_Row:
	MOV	Char_Length,CX			;Set character length
	MOV	Video_Rows,DL			;Set video rows
	RET
Select_Graphics ENDP

;****************************************************************
;  Sub-Function 30 - Return Character Set Status
;****************************************************************

Character_Set_Table	LABEL	WORD
	DW	C8x14_Character_Set		;8x14 character set
	DW	C8x8_Character_Set		;8x8  character set
	DW	C8x8_Character_Set_High 	;8x8  top 128 character set
	DW	Mono_9x14_Characters		;9x14 character update set
	DW	C8x16_Character_Set		;8x16 character set
	DW	Mono_9x16_Characters		;9x16 character update set



Return_Character_Info PROC NEAR

IFDEF DIGITAL
	CMP	BH,05H				;Are we EGA function
	JBE	Valid_Digital11 		;Yes-Continue
	CMP	VGA_DCC_Index,07		;Are we a digital monitor
	JBE	Digital_Exit11			;Yes-Exit immediately

Valid_Digital11:
ENDIF

	MOV	ES,INT_Address			;Set interrupt segment
	OR	BH,BH				;Test for return INT 1F
	JNE	Not_1F				;Not return 1F
	LES	BX,ES:[01FH*4]			;Get vector
	JMP	SHORT Return_Char_Set		;Read the interrupt

Not_1F:
	DEC	BH				;Test for return 43 pointer
	JNE	Not_43				;Not return 43
	LES	BX,ES:[043H*4]			;Get vector
	JMP	SHORT Return_Char_Set		;Read the interrupt

Not_43:
	DEC	BH				;Map to relative zero
	CMP	BH,5				;Test for invalid
;gdl:01/02/92 Don't return character/rows information if it's not a valid call
	JA	Digital_Exit11			;Exit, don't trash registers
;gdl	JA	Get_Char_Length 		;Get character length
;v0.051MOV	AX,CS				;Get local segment
;v0.051MOV	ES,AX				;Set local segment
	MOV	BL,BH				;Get offset
	MOV	BH,00				;Set start
	ADD	BX,BX				;Make word offset
;v0.051{
	or	bx,bx
	jnz	short NoMoreCheck
	push	bx
	call	GetEnvPtr
	mov	ax,bx
	pop	bx
	jz	short NoMoreCheck
	mov	bx,ax
	jmp	short Return_Char_Set
NoMoreCheck:
	mov	ax,cs
	mov	es,ax
;v0.051}
	MOV	BX,CS:Character_Set_Table[BX]	;Get character set

Return_Char_Set:
	MOV	BP_Stack,BX			;Return on stack
	MOV	ES_Stack,ES			;Return segment

Get_Char_Length:
	MOV	AX,Char_Length			;Get character length
	MOV	CX_Stack,AX			;Store on stack
	MOV	AL,Video_Rows			;Get number of rows
	MOV	DL_Stack,AL			;Place byte on stack

Digital_Exit11:
	RET
Return_Character_Info ENDP

;****************************************************************
LoadTsrFont8X14	proc	near
	push	es
	push	bx
	call	GetEnvPtr
	mov	dx,bx			;dx = offset
	mov	cx,es			;cx = segment
	pop	bx
	pop	es
	jz	short NoTsrFont8X14
	mov	si,dx			;si = offset
	mov	es,cx			;es = segment
NoTsrFont8X14:
	ret
LoadTsrFont8X14	endp
;****************************************************************
LoadTsr8X14	proc	near
	push	ax
	push	es
	push	bx
	call	GetEnvPtr
	mov	ax,bx			;ax = offset
	mov	cx,es			;cx = segment
	pop	bx
	pop	es
	jz	short NoTsr8X14
	mov	si,ax			;si = offset
	mov	di,cx			;di = segment
NoTsr8X14:
	pop	ax
	ret
LoadTsr8X14	endp

;****************************************************************

VGA_Segment ENDS

	END

