;************************************************************************
;
; 	$Workfile:   vgadata.inc  $
; 
; 	Copyright 1989, 1990 Quadtel Corporation.
; 	All rights reserved.
; 
;	Contents:
;	The VGA BIOS Data Area module does not generate any code,
;	but contains Equates and variable references for the VGA
;	BIOS. Also included are hardware equates, and references
;	for the VGA environment.
; 
; 	Modification History:
; 	$Log:   E:/vcs/vga/vgadata.inv  $
;      
;         Rev 1.1   03 Jun 1991 17:00:32   Darryl
;      Added IO_DELAY macro.
;      
;         Rev 1.0   21 Dec 1990 11:03:08   Darryl
;      Initial checkin to VCS.
;
;	07/08/89  Speed optimizations made to the core VGA BIOS.
;
;****************************************************************

	%OUT	Assembling VGA BIOS Data Area

INCLUDE VERSION.INC

;****************************************************************
;		    General Equates
;****************************************************************

AX_Stack	EQU	WORD PTR [BP + 16]
AL_Stack	EQU	BYTE PTR [BP + 16]
AH_Stack	EQU	BYTE PTR [BP + 17]
BX_Stack	EQU	WORD PTR [BP + 14]
BL_Stack	EQU	BYTE PTR [BP + 14]
BH_Stack	EQU	BYTE PTR [BP + 15]
CX_Stack	EQU	WORD PTR [BP + 12]
CL_Stack	EQU	BYTE PTR [BP + 12]
CH_Stack	EQU	BYTE PTR [BP + 13]
DX_Stack	EQU	WORD PTR [BP + 10]
DL_Stack	EQU	BYTE PTR [BP + 10]
DH_Stack	EQU	BYTE PTR [BP + 11]
SI_Stack	EQU	WORD PTR [BP + 08]
DI_Stack	EQU	WORD PTR [BP + 06]
BP_Stack	EQU	WORD PTR [BP + 04]
ES_Stack	EQU	WORD PTR [BP + 02]
DS_Stack	EQU	WORD PTR [BP + 00]

;****************************************************************
;   General Extended Video Mode Definitions
;****************************************************************

EVM_Text	EQU	001H		;1=Text Mode, 0=Graphics Mode
EVM_Color	EQU	002H		;1=Color Mode,0=Mono Mode
EVM_Packed	EQU	004H		;1=Packed Pixel, 0=Planar
EVM_Reserved	EQU	008H		;Reserved
EVM_Font	EQU	070H		;0=8x8,1=8x14,2=9x14,3=8x16,4=9x16
EVM_8x8 	EQU	000H		;8x8 font type
EVM_8x14	EQU	010H		;8x14 font type
EVM_9x14	EQU	020H		;9x14 font type
EVM_8x16	EQU	030H		;8x16 font type
EVM_9x16	EQU	040H		;9x16 font type
EVM_OEM 	EQU	080H		;OEM Defined information

;****************************************************************
;			Macros
;****************************************************************

IO_DELAY MACRO
	JMP	SHORT $+2
ENDM

DB_DAC	MACRO	Red,Green,Blue
IFIDN	<Red>,<Green>				;Is red equal to green?
IFIDN	<Green>,<Blue>				;Yes-Is green equal to blue?
	DB	Red + 80H			;Yes-All three are same color
ELSE
	DB	Red + 40H,Blue			;No -Only red and green equal
ENDIF
ELSE
IFIDN <Green>,<Blue>				;red <> green. Is green = blue
	DB	Red, Green + 40H		;Yes-Set green and blue equal
ELSE
IFIDN <Red>,<Blue>
	DB	Red + 0C0H, Green
ELSE
	DB	Red, Green, Blue		;No -All three are different

ENDIF
ENDIF
ENDIF
ENDM

;khu
;*******************************************************************
; Cirrus Logic Additions
;*******************************************************************
NO  		equ	0
YES		equ	1

F8x8		equ	0
F8x16		equ	0
F8x14		equ	0
F9x14		equ	0
F9x16		equ	0

;*******************************************************************
; Debug Stuff
;*******************************************************************
VCP_CHKSUM		equ	NO

;****************************************************************
;		    Hardware Equates
;****************************************************************

Setup_102		EQU	0102H
Setup_103		EQU	0103H

Timer_Base		EQU	040H		;8253 Timer Controller
  Timer_Mode		EQU	003H		;8253 Channel Mode offset

Port_B			EQU	061H		;8255 Port B (Output)
  AT_IOCHK_Disable	EQU	008H		;AT parity disable/enable
  PC_IOCHK_Disable	EQU	020H		;PC/XT parity disable/enable

Miscellaneous		EQU	03C2H		;Miscellaneous output register
Feature_Control_3BA	EQU	03BAH		;Feature control for 3Bx
Feature_Control_3DA	EQU	03DAH		;Feature control for 3Dx
Sequencer		EQU	03C4H		;Sequencer index register
CRT_3B4 		EQU	03B4H		;Monochrome CRT index addr
CRT_3D4 		EQU	03D4H		;Monochrome CRT index addr
  CRT_VRT_11		EQU	011H		;Vertical Retrace End reg

Mode_Control_3B8	EQU	03B8H		;Monochrome mode control reg
Mode_Control_3D8	EQU	03D8H		;Color mode control reg
Color_Select_Reg	EQU	03D9H		;Color select register
Mode_Control_Herc	EQU	03BFH		;Hercules mode control reg

Graphics1_Pos		EQU	03CCH		;Graphics 1 position register
Graphics2_Pos		EQU	03CAH		;Graphics 2 position register
Read_Feature_Control	EQU	03CAH		;Feature Control read address
Read_Miscellaneous	EQU	03CCH		;Misc output read register

Graphics_Controller	EQU	03CEH		;Graphics controller index
Attribute_Controller	EQU	03C0H		;Attribute controller index

DAC_Pel_Mask		EQU	03C6H		;DAC Pel Mask Register
DAC_Read_Index		EQU	03C7H		;DAC Data Read Register
DAC_Write_Index 	EQU	03C8H		;DAC Index Register
DAC_Data_Reg		EQU	03C9H		;DAC Data Write Register

;****************************************************************
;		  System Interrupt Area
;****************************************************************

Interrupt_Vector_Area	SEGMENT AT 00H
		ORG	10H * 4
Interrupt_10		LABEL	DWORD
		ORG	1DH * 4
Video_Parameter_Table	LABEL	DWORD
		ORG	1FH * 4
Character_Table 	LABEL	DWORD
		ORG	42H * 4
Old_Interrupt_10	LABEL	DWORD
		ORG	43H * 4
Extended_Character_Table LABEL	DWORD
Interrupt_Vector_Area	ENDS

;****************************************************************
;		    VGA BIOS Data Area
;****************************************************************

VGA_Data_Area	SEGMENT AT 00H

		ORG	410H
Equipment_Installed	DW	?		;Equipment installed

		ORG	449H
Video_Mode		DB	?		;Current Video mode
Video_Columns		DW	?		;Number of video columns
Video_Length		DW	?		;Length of screen area
Video_Start		DW	?		;Regen buffer segment address
Cursor_Location 	DW	8 DUP(?)	;Cursor location for 8 pages
Cursor_Size		DW	?		;Cursor start and end location
Active_Page		DB	?		;Current video Page offset
M6845_Address		DW	?		;Address of 6845 controller
Video_Mode_Set		DB	?		;Video control register value
Video_Palette		DB	?		;Current palette setting

		ORG	472H
Soft_Reset_Flag 	DW	?		;Will be 1234H on soft boot

		ORG	484H
Video_Rows		DB	?		;Number of screen rows
Char_Length		DW	?		;Bytes used per character
EGA_StatusA		DB	?		;First VGA status byte
  No_Emulation		EQU	01H		;Emulate old cursor
  EGA_Monochrome	EQU	02H		;VGA attached to monochrome
  Retrace_Active	EQU	04H		;Use retrace to read/write
  EGA_Passive		EQU	08H		;VGA is not current monitor
						;*** Win/386 clears bit 4 ***
  EGA_Memory_Size	EQU	60H		;VGA memory 00 = 64K - 11=256K
  EGA_Screen_Clear	EQU	80H		;Video not cleared on mode
EGA_StatusB		DB	?		;Second VGA status byte

VGA_StatusA		DB	?		;VGA video options
  All_Active		EQU	01H		;1=All modes active
  Gray_Shades		EQU	02H		;1=Use gray shades
  VGA_Monochrome	EQU	04H		;1=Monchrome attached
  Default_Palette	EQU	08H		;1=Default palette loading
  Scans_400		EQU	10H		;1=400 Scan lines available
  Digital_Video 	EQU	20H		;1=Digital monitor attached
  Planar_Video		EQU	40H		;1=Planar board video active
  Double_Scan		EQU	80H		;1=Double scan 200 line modes

VGA_DCC_Index		DB	?		;DCC table index

		ORG	4A8H
Env_Ptr 		DD	?		;VGA Environment Pointer

		ORG	4CBH

NMI_Status		DB	?		;NMI capture status
Old_NMI 	LABEL	DWORD			;Backward compatibility
Old_NMI_Offset		DW	?		;support area (Auto Emulation)
OLD_NMI_Segment 	DW	?		;Defined by Quadtel

		ORG	500H

Print_Screen_Flag	DB	?		;Print screen status flag
			DB	0FH DUP (?)	;Unused
Print_Screen_Status	DB	?		;Print screen error status

VGA_Data_Area	ENDS

;****************************************************************
