	INCLUDE PAGE.INC
	SUBTTL	VGA BIOS Module B
;****************************************************************
;
;	$Workfile:   vgab.asm  $
;
;	Copyright 1989, 1990 Quadtel Corporation.
;	All rights reserved.
;
;	Contents:
;	This modules handles the video set mode command. After the
;	actual VGA mode set is performed, special handling is
;	done to handle all double scan modes.
;
;	Modification History:
;	$Log:   E:/vcs/vga/vgab.asv  $
;      
;         Rev 1.2   03 Jun 1991 16:59:52   Darryl
;      $UPDATE:VGA BIOS core revision 11 modifications.
;      VGA BIOS modifications for core hook support.
;      $
;      
;         Rev 1.1   28 Mar 1991 14:19:12   dale
;      The mode set routine was not calling Restore_Write_Protect
;      whenever vectoring the mode set operation through Int 42.
;
;	  Rev 1.0   21 Dec 1990 11:00:12   Darryl
;      Initial checkin to VCS.
;
;	11/29/89  Adjust_Video_State, in one condition, was
;		  clearing the upper byte of the equiment_installed
;		  information.
;
;	07/08/89  Speed optimizations made to the core VGA BIOS.
;		  No code changes to this module.
;
;****************************************************************

	.XLIST
	INCLUDE VGADATA.INC
	include config.inc
	include options.inc
	include struc.inc	;(V1.3b2)
	.LIST

	%OUT	Assembling VGA BIOS Module B

VGA_Segment	SEGMENT PUBLIC BYTE

	ASSUME	CS:VGA_Segment
	ASSUME	DS:VGA_Data_Area
	ASSUME	ES:NOTHING


	PUBLIC	Clear_Screen
	PUBLIC	Clear_Screen_Exit
	PUBLIC	Default_Char_Env
	PUBLIC	Default_Clear_Video
	PUBLIC	VGA_Variable_Init
	PUBLIC	Get_Env_Ptr
	PUBLIC	Video_Set_Mode
	public	GetEnvPtr			;v0.051
	public	DetectEnvPtr			;v0.051

	EXTRN	C8x8_Character_Set:BYTE
	EXTRN	C8x14_Character_Set:BYTE
	EXTRN	C8x16_Character_Set:BYTE
	EXTRN	Default_Mode_Table:NEAR
	EXTRN	Enable_DAC_Video:NEAR
	EXTRN	Extended_Clear_Video:NEAR
	EXTRN	Get_Extended_Mode:NEAR
	EXTRN	Get_Extended_Mode_Info:NEAR
	EXTRN	Get_Mode_Table:NEAR
	EXTRN	INT_Address:WORD
	EXTRN	Load_Char_Set:NEAR
	EXTRN	Mono_9x14_Characters:BYTE
	EXTRN	Program_Extended_Mode:NEAR
	EXTRN	Read_Reg:NEAR
	EXTRN	Read_Reg_NI:NEAR
	EXTRN	Set_DAC_Registers:NEAR
	EXTRN	Set_VGA_Registers:NEAR
	EXTRN	Video_Cursor_Type:NEAR
	EXTRN	Video_On:NEAR
	EXTRN	VGA_Options1:BYTE
	extrn	oemsi_tbl:near			;(V1.3b2)
	extrn	wait_vretrace:near
	extrn	Disable_DAC_Video:near
	extrn	use_switches:byte
	extrn	setscr:near
	extrn	getscr:near
	extrn	GetChipType:near
	extrn	avga_confbyte:byte
IFDEF EMULATE
	EXTRN	Check_Emulation_Mode:NEAR
ENDIF
	extrn	getreg:near
	extrn	Detect5430:near
	extrn	get_crtc_addr:near

;****************************************************************
;	   Compatible Video Mode values for Modes 0-7
;****************************************************************

Mode_Table	DB	02CH			;Mode 0
		DB	028H			;     1
		DB	02DH			;     2
		DB	029H			;     3
		DB	02AH			;     4
		DB	02EH			;     5
		DB	01EH			;     6
		DB	029H			;     7

;****************************************************************
;   AH = 00	Set standard or VGA video mode
;		AL - Mode value (0..13)
;		     0 = 40x25	 Black & White
;		     1 = 40x25	 Color
;		     2 = 80x25	 Black & White
;		     3 = 80x25	 Color
;		     4 = 320x200 Color
;		     5 = 320x200 Black & White
;		     6 = 640x200 Black & White
;		     7 = Monochrome only
;		     D = 320x200 16 Colors
;		     E = 640x200 16 Colors
;		     F = Monochrome 640x350 3 color
;		    10 = 640x350 16 Colors
;		    11 = 640x480  2 Colors
;		    12 = 640x480 16 Colors
;		    13 = 320x200 256 Colors
;
;		     If bit 7 of the mode is set then
;		     then the screen will not be cleared.
;****************************************************************

Video_Set_Mode	PROC	NEAR
;v1.10A3{					;clear CR1C
	push	ax
	push	dx
	call	get_crtc_addr
	mov	ax,001Ch
	out	dx,ax
	pop	dx
	pop	ax
;v1.10A3}

IFDEF EMULATE
	CALL	Check_Emulation_Mode		;Handle Emulation modes
	JNE	Exit_Mode_Set			;Exit if emulation in process
ENDIF

	MOV	AH,AL				;Save copy of new mode
	AND	AL,07FH 			;Mask dont clear bit from mode

IFDEF DIGITAL
	CMP	AL,10H
	JBE	Valid_Digital00
	CMP	VGA_DCC_Index,07		;Are we a digital monitor
	JBE	Digital_Exit00			;Yes-Exit immediately

Valid_Digital00:
ENDIF

	CMP	AL,13H				;Verify mode is valid
	JBE	Start_Video_Mode		;Continue if between 0-13
	CALL	Get_Extended_Mode		;Determine if valid extended mode
	JE	Start_Video_Mode		;Yes-Continue

Exit_Mode_Set:
Digital_Exit00:
	RET					;Otherwise just return

Start_Video_Mode:
	AND	EGA_StatusA,NOT 80H		;Clear 'Dont clear regen' bit
	AND	AH,80H				;Update EGA status byte A
	OR	EGA_StatusA,AH			;No -Dont clear regen on mode
	CALL	Adjust_Video_State		;Adjust base addr and switches

;gdl IFDEF ADAPTER
	CALL	Determine_Mode			;Determine who call is for
	JE	VGA_Init			;Go if it is for VGA BIOS
	AND	AL,NOT 20H			;Clear 132 column bit
	MOV	Video_Mode,AL			;Save new video mode
IFDEF EMULATE
	EXTRN	Restore_Write_Protect:NEAR

	CALL	Restore_Write_Protect		;Restore write protect value
ENDIF
	CALL	Old_Video			;Let int 42 do it
	RET

VGA_Init:
IFDEF  EMULATE
	PUSH	CX
ENDIF

	MOV	Video_Mode,AL		; Save current video mode
	mov	al,MONTYPE_R
	call	getscr
	push	ax			; save monitor type

VSM_001:
	MOV	al,Video_Mode		; Save current video mode

	CALL	VGA_Variable_Init		;Initialize all VGA variables
	AND	EGA_StatusA,NOT (EGA_Passive + Retrace_Active) ;Clear 2 bits
	CALL	Setup_Palette_Env		;Save palettes to environment

	CALL	Set_VGA_Registers		;Program VGA regsters

;v1.10A4{	NCR's monitors need the next waiting for avoiding noises.
	mov	bl,08h
	call	wait_vretrace
;v1.10A4}
	MOV	AL,Video_Mode			;Get new video mode
;(V1.3b2) {
	cmp	al, 13h
	ja	SkipProgramVCLK0_2
	mov	di, offset oemsi_tbl + ot_sr0B
	mov	cx, 3			;re-program VCLK0,1,2 with POST value
	mov	al, 0bh
ProgramVCLK:
	mov	ah, cs:[di]
	call	setscr
	inc	di
	add	al, 10h
	mov	ah, cs:[di]
	call	setscr
	sub	al, 0fh
	inc	di
	loop	ProgramVCLK
	MOV	AL,Video_Mode			;Get new video mode
SkipProgramVCLK0_2:
;(V1.3b2) }
	CALL	Program_Extended_Mode		;Program the extended mode

;v1.10A4{	NCR's monitors need the next waiting for avoiding noises.
	mov	bl,08h
	call	wait_vretrace
;v1.10A4}
	CALL	Set_DAC_Registers		;Load default DAC registers
	MOV	DX,M6845_Address		;Restore CRT base address
	MOV	AL,Video_Mode			;Get the current video mode
	CMP	AL,04				;Are we in text
	JB	Initialize_Text 		;Yes-Go perform text init
	CMP	AL,07				;How about monochrome text
	JE	Initialize_Text 		;Yes-Go do text mode
	CMP	AL,13H				;Check for standard graphics
	JBE	Initialize_Graphics		;Yes-Go do graphics mode
	CALL	Get_Extended_Mode_Info		;Get extended text mode info
	TEST	AL,EVM_Text			;Are we extended text mode
	JE	Initialize_Graphics		;No -Go do graphics mode

Initialize_Text:
	CALL	Default_Char_Env		;Use default character init
	MOV	AX,0BH				;Mode entry offset in env
	MOV	BX,08H				;Offset to aux char env.
	CALL	Check_Env_Mode			;Test if user env for mode
	JNE	Sec_Aux_Check			;No -Do our text mode
	CALL	User_Char_Env			;Yes-Use env to dictate mode

Sec_Aux_Check:
	MOV	BX,10H				;Now look for 2ndary Save area
	CALL	Get_Env_Ptr			;Get environment pointer
	JE	Video_Clear_Check		;Go if doesnt exists
	LES	BX,ES:[BX+06]			;Now get 2nd aux char set
	MOV	AX,ES				;Test if it exists
	OR	AX,BX				;If zero, it doesn't
	JE	Video_Clear_Check		;Go if doesnt exists
	MOV	AX,07H				;Mode list is at offset 07
	CALL	Check_2nd_Env_Mode		;Search for current mode
	JNE	Video_Clear_Check		;Go if not found
	CALL	Sec_User_Char_Env		;Load aux char set and info
	JMP	SHORT Video_Clear_Check 	;Go check for video clear

Initialize_Graphics:
	MOV	Cursor_Size,00			;Clear cursor size
	MOV	AX,07H				;Mode entry offset in env
	MOV	BX,0CH				;Offset to aux graphics env
	CALL	Check_Env_Mode			;Test if user env for mode
	JNE	Video_Clear_Check		;No -Dont do anything
	CALL	User_Graphic_Env		;Yes-Setup user graphics env

Video_Clear_Check:

ifdef TESTCRTCPROBLEM
%out "WARNING: Including Setmode INT 15h for register dumping."
	mov	ax,0448dh
	int	15h
endif	;TESTCRTCPROBLEM

	TEST	EGA_StatusA,080H		;Test if clearing video
	JNE	Keep_Video			;No -Skip this part
	MOV	AX,Video_Length 		;Get current video size
	OR	AX,AX				;Test if it is zero
	JE	Keep_Video			;Yes-Dont clear anything
	CALL	Clear_Screen			;Clear the screen

Keep_Video:
	CALL	Load_DAC_Env			;Load DAC and palette env
	CALL	Video_On			;Enable the video
	CALL	Enable_DAC_Video
	pop	ax			; restore monitor type
	call	setscr

IFDEF EMULATE
	EXTRN	Restore_Write_Protect:NEAR

	POP	CX				;Get write protect reg value
	CALL	Restore_Write_Protect		;Restore write protect value
ENDIF

if (SETMODE_SIGNAL eq YES)
	test	cs:use_switches,20h
	jnz	SkipSetModeSignal

	mov	ax,0F965h
	int	15h
SkipSetModeSignal:
endif	;(SETMODE_SIGNAL eq YES)

if PEACOCK eq YES
   if GRAM_CORRUPT_BUG eq YES
		call	is_peaven	; is peaven installed?
		jnz	vsm_001		; nope

		call	setup_gram	; reproram gray-scale rams
   endif
vsm_001:
endif

IFDEF	(PCI)
	mov	ax,0B101h		;PCI BIOS present?
	int	1Ah
	jnc	Continue
	jmp	All3Done
Continue:
	or	ah,ah
	jnz	All3Done
.386
	cmp	edx,20494350h		;EDX contains "Blank, I,   C, & P  "
.186
	jnz	All3Done		;             "20h, 49h, 43h, & 50h"
;
	call	get_crtc_addr
	mov	al,27h
	call	getreg			;read CR27 ID Register
	and	ah,0FCh
	cmp	ah,0A8h			;GD-5434?
	jnz	short All3Done
	mov	al,25h
	call	getreg			;read CR25 Part Status Register
	cmp	ah,26h			;AF?
	jz	short DisableByteMerge
	cmp	ah,2Ah			;AJ?
	jz	short DisableByteMerge
	cmp	ah,88h			;DH?
	jnz	short All3Done
DisableByteMerge:
	mov	ax,0B102h		;find PCI device
	mov	cx,04A3h
	mov	dx,8086h
	xor	si,si
	int	1Ah
;
	or	ah,ah			;successful?
	jnz	short MerNepDone	
	mov	ax,0B108h		;read configuration byte
	mov	di,007Dh
	int	1Ah
;
	or	ah,ah			;successful?
	jnz	short MerNepDone
	and	cl,0DFh			;reset b13 for Byte Merge Control
	mov	ax,0B10Bh		;write configuration byte
	mov	di,007Dh
	int	1Ah
MerNepDone:
	mov	ax,0B102h		;find PCI device
	mov	cx,0486h
	mov	dx,8086h
	xor	si,si
	int	1Ah
;
	or	ah,ah			;successful?
	jnz	short All3Done	
	mov	ax,0B108h		;read configuration byte
	mov	di,0040h
	int	1Ah
;
	or	ah,ah			;successful?
	jnz	short All3Done
	and	cl,0FEh			;reset b0 for Byte Merge Control
	mov	ax,0B10Bh		;write configuration byte
	mov	di,0040h
	int	1Ah
All3Done:
ENDIF

;v1.00B1{
	call	Detect5430		;if 5430 exists, BIOS clears SR17[2]
	jnz	Not5430
	mov	dx,3C4h
	mov	al,17h
	call	getreg
	and	ah,0FBh			;reset b2
	out	dx,ax
;
	mov	al,1Fh
	call	getreg
	and	ah,3Fh
	mov	bl,08h
	cmp	ah,20h
	jb	PgmSR16FIFO		; SR1F[5:0] < 20h
	mov	bl,06h
PgmSR16FIFO:
	mov	al,16h
	call	getreg
	and	ah,0F0h
	or	ah,bl			; FIFO Demand Threshold SR16[3:0]
	out	dx,ax			;  (all modes)
Not5430:
;v1.00B1}

	RET
Video_Set_Mode	ENDP


;****************************************************************
;****************************************************************
;   Adjust the current state of the VGA adapter to the mode
;   being set. If All_Active is reset, then the adapter cannot
;   switch to the alternate video address. Otherwise, depending
;   on the Equipment_Installed switches, the VGA should adapt
;   to the selected video mode.
;
;   Exit: BL - Equipment_Installed Video Type
;****************************************************************

Adjust_Video_State	PROC	NEAR
	MOV	BL,BYTE PTR Equipment_Installed ;Get current monitor type
	AND	BL,030H 			;Isolate video bits
	TEST	VGA_StatusA,All_Active		;Do we support all modes
	JE	Exit_Color_AVS			;No -No adapter switching
	CMP	Video_Mode,AL			;Are we changing modes
	JE	Exit_Color_AVS			;No -Wont need adapter switch
	MOV	AH,EGA_StatusB			;Get current switch settings
	AND	AH,0FH				;Isolate switches
	CMP	AL,07H				;Test for monochrome modes
	JE	New_Mono_Mode			;Go handle mono modes
	CMP	AL,0FH				;Check for mono graphics mode
	JE	New_Mono_Mode			;Yes-Go handle mono mode
	MOV	BH,AL				;Save video mode
	CALL	Get_Extended_Mode_Info		;Is it an extended mode
	JNE	New_Color_Mode			;Go if not supported-AL is OK
	TEST	AL,EVM_Color			;Is it a mono mode
	MOV	AL,BH				;Restore video mode
	JE	New_Mono_Mode			;Go if extended mono mode

New_Color_Mode:
	TEST	VGA_Options1,01 		;Are we doing ps/2 method
	JE	Adapter_Color_Mode		;No -Do adapter method
	JMP	PS2_Color_Mode			;Yes-Do like a PS/2

Adapter_Color_Mode:
	CMP	M6845_Address,CRT_3D4		;Is our CRT addr set for color
	JE	Exit_Color_AVS			;Yes-No base or switch adjust
	CMP	BL,030H 			;No -Is mono active display
	JE	Set_Mode7			;Yes-Video mode must be 7
	CMP	AH,05H				;Is primary non-VGA
	JBE	Exit_Color_AVS			;Yes-Exit,not handled by us
	CMP	AH,08H				;6-8 should never occur here
	JBE	Set_Color_678			;If so set it up as VGA mono
	CMP	AH,09H				;Test if VGA is enhanced
	JE	Set_Color_9			;Yes-Set color,toggle switches
	CMP	AH,0BH				;Test if VGA is monochrome
	JBE	Set_Color_AB			;Yes-Go toggle VGA switch

Exit_Color_AVS:
	RET

Set_Color_AB:
	MOV	BL,048H 			;Set VGA Enhanced RGB
	JMP	SHORT Set_Color

Set_Color_678:
	MOV	BL,08BH 			;Set VGA mono, 2ndary RGB
	JMP	short Set_Color

Set_Color_9:
	MOV	BL,0BH				;Set VGA mono, 2ndary Enhanced

Set_Color:
	AND	EGA_StatusA,NOT EGA_Monochrome	;Set VGA not attached to mono
	AND	EGA_StatusB,0F0H		;Clear old switches
	MOV	AH,VGA_StatusA			;Get Enhanced monitor bit
	NOT	AH				;Bit has inverted meaning
	AND	AH,080H 			;Isolate enhanced bit
	ROL	AH,1				;Move to bit 0
	OR	AH,BL				;OR into switch setting
	OR	EGA_StatusB,AH			;To set enhanced mon if avail
	AND	VGA_StatusA,07FH		;Now clear the enhanced bit
	TEST	VGA_Options1,01 		;Test for adapter or PS/2
	JE	Exit_Color_AVS			;Exit if adapter version

Set_Color_3D4:
	AND	BYTE PTR Equipment_Installed,0CFH ;Force current monitor system
	OR	Equipment_Installed,020H	  ;to color graphics
	RET

New_Mono_Mode:
	TEST	VGA_Options1,01
	JE	Adapter_Mono_Mode
	JMP	short PS2_Mono_Mode

Set_Mode7:
	MOV	AL,07H				;Set mode 7 if mon is mono,
	JMP	SHORT Exit_Color_AVS		;CRT base is mono & color set

Adapter_Mono_Mode:
	CMP	M6845_Address,CRT_3B4		;Are we currently monochrome
	JE	Exit_Mono_AVS			;Yes-No adapter switch needed
	CMP	BL,030H 			;Test if active mon is color
	JNE	Set_Mode0			;Yes-Handle invalid condition
	CMP	AH,05H				;Test if non-vga is primary
	JBE	Set_Mono_05			;Yes-Go make VGA monochrome
	CMP	AH,08H				;Test if VGA is RGB mode
	JBE	Set_Mono_68			;Yes-Go make VGA monochrome
	CMP	AH,09H				;Test if VGA is Enhanced
	JE	Set_Mono_9			;Yes-Go make VGA monochrome
	CMP	AH,0BH				;Test if VGA is monochrome
	JA	Exit_Mono_AVS			;No -Exit doing nothing

Set_Mono_AB:
	MOV	BL,08H				;Yes-Toggle to VGA Enh (RGB)
	JMP	SHORT Set_Mono

PS2_Color_Mode:
	CMP	M6845_Address,CRT_3D4		;Is our CRT addr set for color
	JE	Set_Color_3D4
	CMP	AH,05H				;Is primary non-VGA
	JBE	Set_Color_05			;Yes-Exit,not handled by us
	CMP	AH,08H				;6-8 should never occur here
	JBE	Set_Mono_68			;If so set it up as VGA mono

Set_Color_05:
	MOV	BL,08H				;Yes-Set 2ndary VGA Enh (RGB)
	JMP	Set_Color

Set_Mode0:
	MOV	AL,00H				;Set mode 0 if mon is color,
	JMP	SHORT Exit_Mono_AVS		;CRT base is CGA & mode 7 set

Set_Mono_05:
	OR	EGA_StatusA,EGA_Monochrome	;Set VGA attached to mono
	JMP	SHORT Exit_Mono_AVS

Set_Mono_68:
	OR	EGA_StatusA,EGA_Monochrome	;Set VGA attached to mono
	OR	VGA_StatusA,080H		;Set 2ndary color as RGB res.
	AND	EGA_StatusB,0F0H		;Clear existing switch value
	OR	EGA_StatusB,00BH		;Set VGA as monochrome
	TEST	VGA_Options1,01
	JE	Exit_Mono_AVS
	JMP	SHORT Set_Mono_3B4

Set_Mono_9:
	MOV	BL,0BH				;Set VGA monochrome switch

Set_Mono:
	OR	EGA_StatusA,EGA_Monochrome	;Set VGA attached to mono
	AND	VGA_StatusA,07FH		;Set color mode as enhanced
	AND	EGA_StatusB,0F0H		;Clear existing switches
	OR	EGA_StatusB,BL			;Set new switch setting

Exit_Mono_AVS:
	RET

PS2_Mono_Mode:
	CMP	M6845_Address,CRT_3B4		;Are we currently monochrome
	JE	Set_Mono_3B4			;Yes-No adapter switch needed
	CMP	AH,05H				;Test if non-vga is primary
	JBE	Set_Mono_059			;Yes-Go make VGA monochrome
	CMP	AH,08H				;Test if VGA is RGB mode
	JBE	Set_Mono_68			;Yes-Go make VGA monochrome

Set_Mono_059:
	OR	EGA_StatusA,EGA_Monochrome	;Set VGA attached to mono
	AND	VGA_StatusA,07FH		;Set color mode as enhanced
	AND	EGA_StatusB,0F0H		;Clear existing switches
	OR	EGA_StatusB,00BH		;Set new switch setting

Set_Mono_3B4:
	OR	Equipment_Installed,030H
	RET
Adjust_Video_State	ENDP

;gdl IFDEF ADAPTER
;****************************************************************
;   Determine if the current video call is to be performd by
;   the VGA for old interrupt 10 BIOS.
;
;   Entry: AL - Video Mode
;   Exit:   Z - Mode is for VGA Card
;		AH - Monitor type bits (from Equipment check)
;
;	   NZ - Mode not for VGA Card
;		AL - Bytes used per character (Scan lines)
;****************************************************************

Determine_Mode	PROC	NEAR
	MOV	AH,BYTE PTR Equipment_Installed ;Get current video switches
	AND	AH,30H				;Isolate monitor switches
	CMP	AH,30H				;Is it set to monochrome
	JNE	CG_Setup			;No -Go handle color graphics
	TEST	EGA_StatusA,EGA_Monochrome	;Yes-Is VGA attached to mono
	JNE	VGA_Mono_Mode			;Yes-It is for us
	OR	EGA_StatusA,EGA_Passive 	;No -VGA is not active
	MOV	AL,0EH				;Mono card uses 14 scan lines
	JMP	SHORT Not_Our_Set_Mode		;Let old card do the mode

CG_Setup:
	TEST	EGA_StatusA,EGA_Monochrome	;Is the VGA attached to mono
	JE	VGA_Color_Mode			;No -Call is for us
	MOV	AH,EGA_Passive			;Yes-VGA is not active
	CMP	AL,02				;Test if retrace bits needs
	JBE	Set_CG_Status			;to be set for modes 2,3
	CMP	AL,04				;Test againsts upper 80x25
	JAE	Set_CG_Status			;No -Only 80x25 text uses retr
	OR	AH,Retrace_Active		;Yes-Set retrace wait needed

Set_CG_Status:
	OR	EGA_StatusA,AH			;Set passive and maybe retrace
	MOV	AL,08H				;CG card uses 8 scans/char

Not_Our_Set_Mode:
	MOV	Video_Rows,24			;Both modes use 25 rows
	MOV	AH,00
	MOV	Char_Length,AX			;Set the character size
	RET					;Return NZ condition

VGA_Color_Mode:
	CMP	AL,0FH				;is not being attempted.
	JE	Bad_Color_Mode			;Set mode 0 if a monochrome
	CMP	AL,07H				;mode is detected.
	JE	Bad_Color_Mode
	MOV	BH,AL				;Save video mode
	CALL	Get_Extended_Mode_Info		;Is it an extended mode
	JNE	VGA_Mode			;Go handle as color mode
	TEST	AL,EVM_Color			;Is it a mono mode
	MOV	AL,BH				;Restore video mode
	JNE	VGA_Mode			;Go if extended color mode

Bad_Color_Mode:
	MOV	AL,00				;Otherwise set mode 0
	AND	EGA_StatusA,NOT 80H		;Clear 'Dont clear regen' bit
	JMP	SHORT VGA_Mode

VGA_Mono_Mode:
	CMP	AL,0FH				;Test if mode F
	JE	VGA_Mode			;Yes-Use mode F
	CMP	AL,07H				;Test if mode 7
	JE	VGA_Mode			;Yes-Mode 7 is ok
	MOV	BH,AL				;Save video mode
	CALL	Get_Extended_Mode_Info		;Is it an extended mode
	JNE	Bad_Extended_Mono_Mode		;Go if not supported
	TEST	AL,EVM_Color			;Is it a mono mode
	MOV	AL,BH				;Restore video mode
	JE	VGA_Mode			;Yes-It is Ok

Bad_Extended_Mono_Mode:
	MOV	AL,07H				;No -Set to mode 7
	AND	EGA_StatusA,NOT 80H		;Clear 'Dont clear regen' bit

VGA_Mode:
	CMP	AL,AL				;Set Z condition
	RET
Determine_Mode	ENDP

;****************************************************************
;   The mode set is to be performed by the old interrupt 10
;   and not the VGA BIOS. Restore destroyed registers and
;   call interrupt 42H (old interrupt 10) do perform the
;   function.
;****************************************************************

Old_Video	PROC	NEAR
	PUSH	DS				;Save BIOS data area
	PUSH	BP
	MOV	DS,INT_Address			;First setup interrupt 43
	pushf
	CLI					;to point to 8x8 256 char set
	MOV	WORD PTR DS:[43H*4],OFFSET C8x8_Character_Set
	MOV	DS:[43H*4+2],CS 		;Setup interrupt 43
	popf
	MOV	DS,DS_Stack			;Restore callers DS
	MOV	AX,AX_Stack			;Restore callers AX
	MOV	DX,DX_Stack			;Restore callers DX
	MOV	SI,SI_Stack			;Restore callers SI
	MOV	BP,BP_Stack			;Restore callers BP

ifdef ADAPTER
	INT	42H			;Let interrupt 42 do the work
else	;ADAPTER

	xor	bx,bx
	mov	ds,bx			;DS = 0 for BIOS data area
	mov	dx,CRT_3D4		;Assume color CRTC
	mov	ah,byte ptr Equipment_Installed	;Get current active flag
	and	ah,30h			;Get active display type
	cmp	ah,30h			;Are we monochrome?
	jne	SetMode6845Color	;No, we are color, don't set mode 7

	mov	al,07h			;Monochrome active: Set mode 7
	mov	dl,Low(CRT_3B4)		;We are mono CRTC

SetMode6845Color:
	mov	M6845_Address,dx	;Set CRTC addr in VCDA
	mov	Video_Mode,al		;Store mode in VCDA

	mov	ah,3Fh			;Now to figure out value for 0:466
	cmp	al,06h			;Mode 06h?
	je	SetMode6845ColorCtrl	;Yes, mode 6, so 3D9 = 3F
	mov	ah,30h			;For all other modes, 3D9 = 30
SetMode6845ColorCtrl:
	mov	Video_Palette,ah	;Store 6845 Color Ctrl in 0:466

	mov	ah,al			;Get mode number again


;	mov	bx,0F000h
;	mov	es,bx
	mov	bl,al
	xor	bh,bh
;	mov	al,es:[bx+0F0F4h]
	extrn	Mode6845CtrlParameters:byte
	mov	al,cs:[Mode6845CtrlParameters+bx]
	mov	Video_Mode_Set,al	;Store new 3X8 value in 0:465

	and	al,00110111b		;Mask out bits in 3X8 value
	add	dl,04h			;DX = 3X8
	set1reg				;Set 6845 Mode Ctrl
	sub	dl,04h			;DX = 3X4

	mov	bl,40d			;Assume 40-column mode
	test	ah,02h			;Check mode is 40 or 80 column
	jz	SetMode6845Columns	;Mode 0,1,4,5 are 40-column
	mov	bl,80d			;Mode 2,3,6,7 are 80-column
SetMode6845Columns:
	mov	Video_Columns,bx	;Set columns at 0:44A

	mov	bx,1000h		;4K page
	cmp	ah,07h			;Is it monochrome text mode?
	je	SetMode6845Page4K	;Yes, set page to 4K

	mov	bh,40h			;16K page
	cmp	ah,03h			;Is it a graphics mode with 16K regen?
	ja	SetMode6845RegenLen	;Yes, set page to 16K

SetMode6845Page4K:
	mov	bx,10h			;4K page
	cmp	ah,01h			;Is it mode 2,3,7?
	ja	SetMode6845RegenLen	;Yes, set 4K page

	mov	bh,08h			;2K page

SetMode6845RegenLen:
	mov	Video_Length,bx		;Set regen length

	xor	bx,bx
	mov	Video_Start,bx		;Regen ofs = 0 for first page
	mov	Active_Page,bl		;Active page = 0
	mov	cx,8			;Clear all 8 cursor locations
	mov	di,offset Cursor_Location
SetMode6845CPosLoop:
	mov	ds:[di],bx
	inc	di
	inc	di
	loop	SetMode6845CPosLoop

	les	si,ds:[Video_Parameter_Table]	;Get INT 1D parameters
	mov	bl,ah
	cmp	bl,06h			;Calculate mode 6 table slightly
	jne	SetMode6845Param	; differently
	dec	bl			;640x200 uses same as 320x200
SetMode6845Param:
	shr	bl,1			;bl = bl /2 (0/1, 2/3, 4/5/6 use same
					; mode table
	shl	bl,1
	shl	bl,1
	shl	bl,1
	shl	bl,1			;*16 bytes per table

	add	si,bx			;ES:SI -> 6845 parameter table
	mov	cx,10h			;Load 16 registers
					;NOTE: BH still equals 0 from above!
SetMode6845ProgLoop:
	mov	al,bh			;Set CRTC index
	set1reg
	inc	dx
	mov	al,es:[si]		;Get value
	inc	si
	set1reg				;Set CRTC data
	dec	dx
	inc	bh			;Next register
	loop	SetMode6845ProgLoop	;Until done

	mov	bx,es:[si-06h]		;Get cursor size from table
	xchg	bh,bl
	mov	Cursor_Size,bx		;Set cursor type in 0:460

	call	Clear_Screen

	mov	al,Video_Mode_Set	;Re-set 3X8
	mov	dx,M6845_Address	;Get CRTC addr in VCDA
	add	dl,04h
	set1reg

	mov	al,Video_Palette	;Re-set 3X9
	inc	dx
	set1reg
endif	;ADAPTER

	POP	BP				;Restore stack pointer
	POP	DS				;and BIOS data area
	MOV	AX_Stack,AX			;Return any AX results
	MOV	AL,BYTE PTR Equipment_Installed ;Test if sent to monochrome
	AND	AL,30H				;Isolate monitor bits
	CMP	AL,30H				;Was monochrome operation
	JNE	CG_Cursor_Size			;No -Dont do anything
	MOV	Cursor_Size,0B0CH		;Yes-Set the monocrome size

CG_Cursor_Size:
	RET
Old_Video	ENDP
;gdl ENDIF

;****************************************************************
;   Initialize the VGA parameters before performing the hard-
;   ware mode reset. Update variables such as video rows and
;   and columns to reflect the new video mode.
;
;   Entry: AL - New video mode
;****************************************************************

VGA_Variable_Init	PROC	NEAR
;v0.051MOV	ES,INT_Address			;Setup interrupt area
;v0.051MOV	DI,43H * 4			;Setup interrupt 43 to proper
	push	bp		;;;;
	mov	bp,cs		;;;;
	CMP	AL,13H				;Are we a standard VGA mode?
	JBE	Standard_VGA_Init		;Yes-Go handle VGA init
	push	bp		;;;;
	CALL	Get_Extended_Mode_Info		;Get extended mode info
	pop	bp		;;;;
	JNE	Standard_VGA_Init		;Not found-Continue as VGA
	MOV	BX,OFFSET C8x8_Character_Set	;character set depending on
	TEST	AL,EVM_Text			;Are we text mode
	JNE	Set_Interrupt_43		;Yes-Go set 8x8 for text
	AND	AL,EVM_Font			;Are we using 8x8 font
	JE	Set_Interrupt_43		;Yes-Go set interrupt 43
;
	call	GetEnvPtr			;v0.051
	jz	short ROM8x14Font		;v0.051
	mov	bp, es			;;;
	jmp	short Tsr8x14Font	;;;
ROM8x14Font:				;;;
	MOV	BX,OFFSET C8x14_Character_Set	;Assume 8x14 font size
Tsr8x14Font:					;v0.051
;
	CMP	AL,020H 			;Using 8x14 or 9x14
	JBE	Set_Interrupt_43		;Yes-Go set 8x14
	mov	bp, cs			;;;
	MOV	BX,OFFSET C8x16_Character_Set	;No -Must be 8x16
	JMP	SHORT Set_Interrupt_43		;Go setup font

Standard_VGA_Init:
	MOV	BX,OFFSET C8x8_Character_Set	;character set depending on
	CMP	AL,13H				;the video modes
	JE	Set_Interrupt_43		;modes 0-7,9-E,13 get 8x8
	CMP	AL,08				;character set
	JB	Set_Interrupt_43		;Modes 8,11,12 get 8x16
	MOV	BX,OFFSET C8x16_Character_Set	;Modes F and 10 get 8x14
	JE	Set_Interrupt_43		;Set 8x16 for mode 8
	CMP	AL,11H				;Set for mode 11 and 12
	JAE	Set_Interrupt_43		;Go set 8x16 for modes 11,12
;
	call	GetEnvPtr			;v0.051
	jz	short ROMFont8x14		;v0.051
	mov	bp, es			;;;
	jmp	short TsrFont8x14	;;;
ROMFont8x14:				;;;
	MOV	BX,OFFSET C8x14_Character_Set	;Now check for modes F, 10
TsrFont8x14:					;v0.051
;
	CMP	AL,0FH				;Use 8x14 for modes F,10
	JAE	Set_Interrupt_43		;Anything else is 8x8
	mov	bp,cs			;;;
	MOV	BX,OFFSET C8x8_Character_Set

Set_Interrupt_43:
	MOV	ES,INT_Address			;v0.051  Setup interrupt area
	MOV	DI,43H * 4			;v0.051  Setup interrupt 43 to proper
;
	MOV	AX,BX				;Get character set offset
	pushf
	CLI					;No interrupts when setting
	STOSW					;the interrupt vector
;;;	MOV	AX,CS				;Get code segment
	mov	ax, bp
;
;;;	call	GetEnvPtr			;v0.051
;;;	jz	short NoTsrFont8x14		;v0.051
;;;	mov	ax,es				;v0.051
;;;NoTsrFont8x14:					;v0.051
;;;	MOV	ES,INT_Address			;v0.051  Setup interrupt area
;
	STOSW					;Set segment address
	popf					;Ok for interrupts
	pop	bp		;;;
	MOV	AX,DS				;Get BIOS data area segment
	MOV	ES,AX				;Set ES to BIOS data area
	MOV	DI,OFFSET Cursor_Location	;Clear out cursor positions
	MOV	CX,08				;Space for 8 cursor positions
	XOR	AX,AX				;Clear row and col to zero
	REP	STOSW				;Clear them !
	MOV	Active_Page,AL			;Set active page to zero
	MOV	Video_Start,AX			;Set video start addr to zero
	MOV	AL,Video_Mode			;Get current mode
	CMP	AL,07				;Do we need to emulate values
	JA	Skip_CRT_Emulation		;No -Above old modes
	XOR	AH,AH				;Yes-Emulate mode register
	MOV	DI,AX				;value for modes 0-7
	MOV	AL,03FH 			;Palette value for mode 6
	CMP	DI,06				;Are we in mode 6
	JE	Set_Color_Select		;Yes-Go set color select reg
	MOV	AL,030H 			;Value for all other modes

Set_Color_Select:
	MOV	Video_Palette,AL		;Save the current palette set
	MOV	AL,CS:Mode_Table[DI]		;Get mode register from table
	MOV	Video_Mode_Set,AL		;Save old mode value

Skip_CRT_Emulation:
	CALL	Default_Mode_Table		;Get pointer to mode table
	PUSH	SI				;Save table pointer
	LODS	ES:BYTE PTR[SI] 		;Get video columns from table
	XOR	AH,AH				;Extend to AX
	MOV	Video_Columns,AX		;Save new video columns
	LODS	ES:BYTE PTR[SI] 		;Get number of rows from table
	MOV	Video_Rows,AL			;Save new video rows
;5434(11) {
	mov	al, Video_Mode
	cmp	al, 6Dh
	jz	is_6D6C
	cmp	al, 6Ch
	jnz	not_6D6C
is_6D6C:
	mov	ax, 0a0h
	MOV	Video_Columns,AX		;Save new video columns
	mov	al, 40h - 1
	MOV	Video_Rows,AL			;Save new video rows
not_6D6C:
;5434(11) }
	LODS	ES:BYTE PTR[SI] 		;Get new character size
	MOV	Char_Length,AX			;Save in BIOS data area
	LODS	ES:WORD PTR[SI] 		;Get video page length
	MOV	Video_Length,AX 		;Save in video area
	ADD	SI,0FH				;Move to CRT cursor size
	LODS	ES:WORD PTR[SI] 		;Read default cursor size
	XCHG	AL,AH				;Swap cause of CRT addressing
	MOV	Cursor_Size,AX			;Save current cursor size
	POP	SI				;Restore ptr to reg table
	RET
VGA_Variable_Init	ENDP

;****************************************************************
;   Save a copy of the current palette registers in the
;   environment if the environment exists. 16 palette values
;   and the overscan register are saved.
;****************************************************************

Setup_Palette_Env	PROC	NEAR
	PUSH	DS				;Save data area segment
	PUSH	ES				;Save mode table segment
	PUSH	SI				;Save mode table offset
	PUSH	ES				;Change DS to Mode table
	MOV	BX,04				;Offset to env pointer
	CALL	Get_Env_Ptr			;Get Palette env ptr
	POP	DS				;DS:SI = attribute table
	JE	No_Pal_Env			;Exit if no env exists
	ADD	SI,23H				;Advance to attribute values
	MOV	DI,BX				;Get destination location
	MOV	CX,08				;Move 16 palette values into
	REP	MOVSW				;Do the move
	INC	SI				;Advance to overscan register
	MOVSB					;Save overscan in environment

No_Pal_Env:
	POP	SI				;Restore mode table offset
	POP	ES				;Restore mode table segment
	POP	DS				;Restore BIOS data area
	RET
Setup_Palette_Env	ENDP

;****************************************************************
;   Check if the current video mode is support by the specified
;   environment table.
;
;   Entry:  BX - Offset into environment table
;	    AX - Offset to mode parameter in env exists
;   Exit:    Z - Environment supports current mode
;	    NZ - Current mode not in environment
;****************************************************************

Check_Env_Mode	PROC	NEAR
	CALL	Get_Env_Ptr			;Get environment ptr
	JNE	Check_2nd_Env_Mode		;Continue if env found
	OR	AL,0FFH 			;Set NZ condition
	RET					;Exit if no env exists

Check_2nd_Env_Mode:
	PUSH	BX
	ADD	BX,AX				;Advance to mode entries
	MOV	AL,Video_Mode			;Get current video mode

Next_Env_Mode:
	MOV	AH,ES:[BX]			;Get mode from env
	INC	BX				;Advance to next entry
	CMP	AH,0FFH 			;Reach end of table
	JE	No_Env_Mode			;Yes-Mode not found
	CMP	AL,AH				;Do the modes match
	JNE	Next_Env_Mode			;No -Try next mode
	POP	BX
	RET					;Yes-Return Z condition

No_Env_Mode:
	OR	AL,0FFH 			;No match-return NZ condition
	POP	BX
	RET
Check_Env_Mode	ENDP

;****************************************************************
;   Use the values from the environment to load the specified
;   auxillary character set. If the row value is FF then the
;   the value calculated by the character load routine will
;   be used, otherwise it will be overriden with the specified
;   row value.
;****************************************************************

User_Char_Env	PROC	NEAR
	MOV	AL,ES:[BX+0AH]			;Get row length
	PUSH	AX				;Save for after char set load
	MOV	CX,ES:[BX+2]			;Get number of char patterns
	MOV	DX,ES:[BX+4]			;Get character start offset
	MOV	SI,ES:[BX+6]			;Get font table offset
	MOV	AX,ES:[BX+8]			;Get font segment offset
	MOV	BX,ES:[BX]			;Get bytes/char and char
	XCHG	BL,BH				;set #. Switch for call
	AND	BL,3FH				;Clear high (used for 9x14)
	MOV	ES,AX				;Setup font segment address
	MOV	AL,10H				;Get command call
	CALL	Load_Char_Set			;Use function 12 to load set
	POP	AX				;Get row size
	ADD	AL,01				;Was it FF
	JE	Use_BIOS_Rows			;Use the rows we calculated
	SUB	AL,01				;Otherwise use specfied rows
	MOV	Video_Rows,AL			;Save new video rows

Use_BIOS_Rows:
	RET
User_Char_Env	ENDP

;****************************************************************
;   Use the information from the environment to load the 2nd
;   half of a total 512 byte set. If the the character size
;   specified in the environment does not match the size
;   of the current character then the operation is not
;   performed. Function 11, sub-function 00 is used to perform
;   the actual character set loading. After loading the
;   character set (no variable recalculation) the block
;   specified in the environment is selected as the 2nd
;   character block in the character map select register
;   of the sequencer.
;****************************************************************

Sec_User_Char_Env   PROC    NEAR
	MOV	AL,ES:[BX+0]			;Get character size
	XOR	AH,AH				;Extend to AX
	CMP	AX,Char_Length			;Is it same as current mode
	JNE	Not_Same_Size			;No -Cant do the function
	MOV	CX,100H 			;Always load 256 characters
	XOR	DX,DX				;Start at character 0
	MOV	SI,ES:[BX+3]			;Get font table offset
	MOV	AX,ES:[BX+5]			;Get font segment offset
	MOV	BX,ES:[BX]			;Get bytes/char and char
	XCHG	BL,BH				;set #. Switch for call
	AND	BL,3FH				;Clear high (used for 9x14)
	MOV	ES,AX				;Setup font segment address
	MOV	AL,00H				;Get command call
	PUSH	BX				;Save block to load
	CALL	Load_Char_Set			;Use function 12 to load set
	MOV	DX,Sequencer			;Now read current map select
	MOV	AL,03				;from the sequencer
	CALL	Read_Reg			;Since we wont to preserve
	AND	AH,013H 			;character generator B
	POP	BX				;Get block number
	MOV	BH,BL				;Make a copy
	AND	BL,03				;Isolate low 2 of 3 bits
	MOV	CL,02				;and move to generator A
	SHL	BL,CL
	AND	BH,04				;Isolate bit 3 of 3
	INC	CL				;and move to generator A
	SHL	BH,CL
	OR	AH,BL				;Merge low to bits with B
	OR	AH,BH				;Merge high bit with B
	MOV	AL,03				;Get map select register
	OUT	DX,AX				;Select generator A set

Not_Same_Size:
	RET
Sec_User_Char_Env   ENDP

;****************************************************************
;   Load the default character set for the current text video
;   mode. If the card switches are set to hi res then the 8x14
;   character set will be used, otherwise the 8x8 will be loaded.
;   If mode 7 is selected then the character set will be updated
;   to conform with standard monochrome character set.
;****************************************************************

Default_Char_Env	PROC	NEAR

	XOR	BL,BL				;Load into first block
	MOV	AL,01				;Assume were loading 8x14
	CMP	Char_Length,14			;Are we 8x14 character box
	JE	Check_8x14_Char 		;Yes-Go check if need 9x14
	MOV	AL,02				;No -Check for 8x8
	CMP	Char_Length,08			;Are we 8x8 character box
	JE	Load_New_Set			;Yes-Go load the char set
	MOV	AL,04				;Default to 9x16

	cmp	Video_Mode,13h			;Is it an extended mode?
	ja	Load_New_Set			;yes, skip 9 dot supplement

	OR	BL,40H				;Load 9x16 alternate
	JMP	SHORT Load_New_Set

Check_8x14_Char:
	CMP	Video_Mode,7			;Are we in mode 7
	JNE	Load_New_Set			;No -We are done
	OR	BL,80H				;Signal mono patch needed

Load_New_Set:
	CALL	Load_Char_Set			;Load the character set
	RET
;end
Default_Char_Env	ENDP

;****************************************************************
;   Setup interrupt 43, the current video rows, and character
;   size to the parameters specified in the auxillary graphics
;   environment.
;****************************************************************

User_Graphic_Env	PROC	NEAR
	MOV	AL,ES:[BX]			;Get user rows from env
	DEC	AL				;Make relative zero
	MOV	Video_Rows,AL			;Save as current rows
	MOV	AX,ES:[BX+1]			;Get bytes/character
	MOV	Char_Length,AX			;Save in BIOS data area
	MOV	AX,ES:[BX+3]			;Get offset to character set
	MOV	BX,ES:[BX+5]			;Get seg addr for char set
	MOV	ES,INT_Address			;Set ES to interrupt segment
	MOV	DI,43H * 4			;Set DI to interrupt 43H
	pushf
	CLI					;No interrupts here
	STOSW					;Store offset
	MOV	AX,BX				;Get segment address
	STOSW					;Save segment address
	popf					;Ok for interrupts now
	RET
User_Graphic_Env	ENDP

;****************************************************************
;    Check if the secondary save area exists, and if so, then
;    check if the 2ndary aux char set exists. If it does then
;    load the specified DAC and palette values (only if
;    Default_Palette is reset). If the palette values are
;    written then also update the environment if the save
;    palette environment exists.
;****************************************************************

Load_DAC_Env	PROC	NEAR
	MOV	BX,10H				;Now look for 2ndary Save area
	CALL	Get_Env_Ptr			;Get environment pointer
	JE	Exit_LDE			;Go if doesnt exists
	LES	BX,ES:[BX+0AH]			;Now get 2nd aux char set
	MOV	AX,ES				;Test if it exists
	OR	AX,BX				;If zero, it doesn't
	JE	Exit_LDE			;Go if doesnt exists
	MOV	AX,14H				;Mode list is at offset 0B
	CALL	Check_2nd_Env_Mode		;Search for current mode
	JE	DAC_Env_Exists			;Go if env exists

Exit_LDE:
	RET

DAC_Env_Exists:
	TEST	VGA_StatusA,Default_Palette	;Test if skip palettes
	JNE	Check_Underline 		;Yes-Go adjust underline
	MOV	DX,M6845_Address		;Clear attr flip-flop
	ADD	DX,06				;by reading status reg
	IN	AL,DX				;Clear flip flop
	PUSH	DS				;Save our DS
	PUSH	BX				;and env pointer offset
	MOV	AX,ES:[BX+0EH]			;Get DAC start index
	MOV	AH,AL				;Keep it in AH
	LDS	SI,ES:[BX+10H]			;Get pointer to DAC values
	MOV	BX,ES:[BX+0CH]			;Get number of entries
	OR	BX,BX				;Are there any DAC entries
	JE	No_DAC_Values			;No -Dont load DAC
	MOV	DX,DAC_Write_Index		;Get DAC write index

Next_DAC_Reg_Loop:
	MOV	AL,AH				;Get current index reg
	OUT	DX,AL				;Select DAC register
	INC	DX				;Move to DAC data reg
	MOV	CX,03				;Write red, green, blue

Write_DAC_Env_Loop:
	LODSB					;Get DAC value
	OUT	DX,AL				;Write to DAC register
	LOOP	Write_DAC_Env_Loop		;Repeat for red, green, blue
	INC	AH				;Advance to next DAC reg
	DEC	DX				;Move back to write index
	DEC	BX				;Decement register count
	JNE	Next_DAC_Reg_Loop		;Repeat until BX regs done

No_DAC_Values:
	POP	BX				;Restore env offset pointer
	MOV	AX,ES:[BX+06H]			;Get palette register index
	MOV	AH,AL				;Keep index in AH
	LDS	SI,ES:[BX+08H]			;Get pointer to palette table
	MOV	CX,ES:[BX+04H]			;Get # of palettes to write
	JCXZ	No_Palette_Env			;Go if count = 0
	MOV	DX,Attribute_Controller 	;Get attribute address

Write_Palette_Loop:
	MOV	AL,AH				;Get palette index
	OUT	DX,AL				;Select palette register
	JMP	SHORT $+2
	LODSB					;Get data from table
	OUT	DX,AL				;Write to palette register
	INC	AH				;Move to next register
	LOOP	Write_Palette_Loop		;Repeat for CX registers
	INC	AH				;Move to overscan register
	MOV	AL,AH				;Get index register
	OUT	DX,AL				;Select overscan
	JMP	SHORT $+2
	LODSB					;Get overscan value
	OUT	DX,AL				;Set overscan

No_Palette_Env:
	POP	DS				;Restore BIOS data area

Check_Underline:
	MOV	AL,ES:[BX+00]			;Get underline flag
	OR	AL,AL				;Are we to ignore
	JE	Exit_LDE1			;Yes-Were done
	TEST	AL,80H				;No -Is it to be off
	MOV	AL,01FH 			;Assume off position
	JNE	Write_Underline 		;Yes-Go turn it off
	MOV	AX,Char_Length			;No -Get size of char
	DEC	AL				;Back up to last line

Write_Underline:
	MOV	DX,M6845_Address		;Get base CRT address
	MOV	AH,AL
	MOV	AL,14H				;Get underline CRT reg
	OUT	DX,AX				;Write underline reg

Exit_LDE1:
	RET
Load_DAC_Env	ENDP

;****************************************************************
;   Clear the video memory for the current video mode.
;****************************************************************

Clear_Screen	PROC	NEAR

;gdl:03/31/92 Try to cope with FIFO/CRTC conflict
	call	Disable_DAC_Video

if (CHIP_FAMILY eq CONDOR)
  if (FLUSH_FIFO_PRE_CLS eq YES)
	mov	al,91h
	call	getext
	or	ah,20h
	setreg
  endif ;(FLUSH_FIFO_PRE_CLS eq YES)
endif ;(CHIP_FAMILY eq CONDOR)

	MOV	CX,4000H			;Fill 32K bytes
	MOV	BL,Video_Mode			;Get current video mode
	CMP	BL,13H				;Check for standard VGA mode
	JBE	Default_Clear_Video		;Go if standard clear operation
	MOV	AL,BL				;Get extende video mode
	CALL	Get_Extended_Mode_Info		;Get extended mode info
	JNE	Default_Clear_Video		;Go if not found
	MOV	BL,AL				;Save mode status
	MOV	BH,0B8H 			;Assume color mode
	MOV	AX,0720H			;Get data to write
	TEST	BL,EVM_Color			;Are we color mode?
	JNE	Extended_Color_Mode		;Yes-Use B800
	MOV	BH,0B0H 			;No -Use B000

Extended_Color_Mode:
	TEST	BL,EVM_Text			;Are we text mode
	JNE	Clear_Video			;Yes-Go clear regen
	JMP	Extended_Clear_Video		;No, special handling required

Default_Clear_Video:
	MOV	BH,0B0H 			;Start with monochrome seg
	MOV	AX,0720H			;Fill with blanks
	CMP	BL,07				;Are we mode 7
	JE	Clear_Video			;Yes-Go clear it
	MOV	BH,0B8H 			;Move to CGA segment
	CMP	BL,03H				;Are we in text modes
	JBE	Clear_Video			;Yes-Go clear video
	XOR	AX,AX				;No -Set graphic fill char
	CMP	BL,06				;Are we non-vga graphics
	JBE	Clear_Video			;Yes-Go clear video
	MOV	BH,0A0H 			;Move to hi res graphics seg
	MOV	CH,080H 			;Clear 64K always

Clear_Video:
	XOR	BL,BL				;Make low seg addr clear
	MOV	ES,BX				;Set ES to segment address
	XOR	DI,DI				;Start at segment beginning
	REP	STOSW				;Clear the video
Clear_Screen_Exit:

;gdl:03/31/92 Try to cope with FIFO/CRTC conflict

	call	Enable_DAC_Video

if (CHIP_FAMILY eq CONDOR)
  if (FLUSH_FIFO_PRE_CLS eq YES)
	mov	bl,01h
	call	wait_vretrace

	mov	al,91h
	call	getext
	and	ah,not 20h
	setreg
  endif  ;(FLUSH_FIFO_PRE_CLS eq YES)
endif ;(CHIP_FAMILY eq CONDOR)

	RET
Clear_Screen	ENDP

;****************************************************************
;   Get the specified environment pointer from the environment
;   table. Determine whether an environment for that entry
;   exists.
;
;   Exit:  Z	 - Environment doesnt exist
;	   ES:BX - Environment pointer (if exists)
;****************************************************************

Get_Env_Ptr	PROC	NEAR
	PUSH	DI				;Save callers registers
	LES	DI,Env_Ptr			;Get pointer to environment
	LES	BX,ES:[DI + BX] 		;Get entry from env table
	MOV	DI,ES				;Test if env exists for
	OR	DI,BX				;that feature
	POP	DI				;Restore callers registers
	RET
Get_Env_Ptr	ENDP

;****************************************************************
;v0.051	{
GetEnvPtr	proc	near
	push	di
	push	ds
	xor	di,di
	mov	ds,di
	les	bx,ds:[Env_Ptr]
	les	bx,es:[bx + 24]
	mov	di,es
	or	di,bx
	jz	short NoMoreCheck		;v0.083
	add	bx,06h				;v0.083
NoMoreCheck:					;v0.083
	pop	ds
	pop	di
	ret
GetEnvPtr	endp

;****************************************************************
DetectEnvPtr	proc	near
	push	di
	push	es
	push	bx
	push	ds
	xor	bx,bx
	mov	ds,bx
	les	bx,ds:[Env_Ptr]
	les	bx,es:[bx + 24]
	mov	di,es
	or	di,bx
	pop	ds
	pop	bx
	pop	es
	pop	di
	ret
DetectEnvPtr	endp
;v0.051	}

;****************************************************************

VGA_Segment	ENDS

		END
