	INCLUDE PAGE.INC
	SUBTTL	VGA BIOS Module A
;****************************************************************
;
;	$Workfile:   vgaa.asm  $
; 
; 	Copyright 1989, 1990 Quadtel Corporation.
; 	All rights reserved.
; 
;	Contents:
;	The VGA BIOS is a set of routines that extends the INT 10
;	code of the standard PC/XT/AT BIOS to support the addition-
;	al hardware modes available on the Enhanced Graphics
;	Adapter. In addition to additional commands and modes,
;	there is a power-on diagnostic that tests the board and
;	configures it based on the switch settings on the VGA card.
;
; 	Modification History:
; 	$Log:   E:/vcs/vga/vgaa.asv  $
;      
;         Rev 1.0   21 Dec 1990 11:00:08   Darryl
;      Initial checkin to VCS.
;
;	07/08/89  Modifications were made to enhance performance.
;		  The dispatcher was modified to special case
;		  case functions 0CH, 0DH, and 0EH. The dispatcher
;		  was also optimized.
;
;****************************************************************

;****************************************************************
;								*
;		   V G A   F U N C T I O N S			*
;								*
;   AH = 00	Set standard or VGA video mode			*
;		AL - Mode value (0..13) 			*
;		     0 = 40x25	 Black & White			*
;		     1 = 40x25	 Color				*
;		     2 = 80x25	 Black & White			*
;		     3 = 80x25	 Color				*
;		     4 = 320x200 Color				*
;		     5 = 320x200 Black & White			*
;		     6 = 640x200 Black & White			*
;		     7 = Monochrome only			*
;		     D = 320x200 16 Color			*
;		     E = 640x200 16 Color			*
;		     F = 640x350 4 Color Monochrome		*
;		    10 = 640x350 16 color			*
;		    11 = 640x480 2 color			*
;		    12 = 640x480 16 color			*
;		    13 = 320x200 256 Color			*
;		    23 = 132x25 Color				*
;		    27 = 132x25 Monochrome			*
;		     If bit 7 of the mode is set then		*
;		     then the screen will not be cleared.	*
;								*
;   AH = 01	Set cursor type (start and end) 		*
;		CL - Cursor end line				*
;		CH - Cursor start line				*
;								*
;   AH = 02	Set cursor position				*
;		BH - Page to set cursor 			*
;		DL - Character column position			*
;		DH - Character row position			*
;								*
;   AH = 03	Get cursor position of page			*
;		BH - Page to return cursor			*
;		Exit:	DL - Character column position		*
;			DH - Character row position		*
;			CL - Cursor end line			*
;			CH - Cursor start line			*
;								*
;   AH = 04	Return light pen position			*
;		Exit:	AH - 00 Light pen is not supported	*
;								*
;   AH = 05	Change displayed (active) page			*
;		AL - Page number to display			*
;								*
;   AH = 06	Scroll active page up				*
;		CL - Column of scroll upper left		*
;		CH - Row of scroll upper left			*
;		DL - Column of scroll lower right		*
;		DH - Row of scroll lower right			*
;		BH - Attribute for blanked space		*
;		AL - Number of lines to scroll			*
;								*
;   AH = 07	Scroll active page down 			*
;		CL - Column of scroll upper left		*
;		CH - Row of scroll upper left			*
;		DL - Column of scroll lower right		*
;		DH - Row of scroll lower right			*
;		BH - Attribute for blanked space		*
;		AL - Number of lines to scroll			*
;								*
;   AH = 08	Read character and attribute at cursor		*
;		BH - Video page to read character		*
;		Exit:	AL - Character				*
;			AH - Character attribute		*
;								*
;   AH = 09	Write character and attribute at cursor 	*
;		AL - Character to write 			*
;		BL - Character attribute for alpha modes	*
;		     Character color for graphics modes 	*
;		BH - Page to write character			*
;		CX - Count of characters to write		*
;								*
;   AH = 0A	Write character at cursor			*
;		BH - Page to write character			*
;		AL - Character to write 			*
;		CX - Count of characters to write		*
;								*
;   AH = 0B	Write color palette				*
;		BL - Color value for palette			*
;		BH - Palette color ID (0-127)			*
;								*
;   AH = 0C	Write graphics pixel				*
;		AL - Color value for pixel (XORed if bit7=1)	*
;		CX - Column to write pixel			*
;		DX - Row to write pixel 			*
;								*
;   AH = 0D	Read graphics pixel				*
;		CX - Column to read pixel			*
;		DX - Row to read pixel				*
;		Exit:	AL - Value of pixel read		*
;								*
;   AH = 0E	Teletype write character			*
;		AL - Character to write 			*
;		BL - Foreground color (graphics only)		*
;								*
;   AH = 0F	Return Current Video Parameters 		*
;		Exit:	AL - Current video mode 		*
;			AH - Number of character columns	*
;			BH - Active page			*
;								*
;   AH = 10	Set palette register values			*
;		AL = 0	Set single palette register		*
;			BH - Palette value to set		*
;			BL - Register number			*
;		AL = 1	Set overscan value			*
;		AL = 2	Set all palette registers to 17 byte	*
;			array pointed to by ES:DX.		*
;		AL = 3	Set blinking/intensity bit		*
;			BL = 0 (Intensity)			*
;			BL = 1 (Blinking)			*
;		AL = 4	Reserved				*
;		AL = 5	Reserved				*
;		AL = 6	Reserved				*
;		AL = 7	Read palette register			*
;			BL - Palette register to read		*
;			Exit: BH - Palette value		*
;		AL = 8	Read overscan register			*
;			Exit: BH - Overscan register		*
;		AL = 9	Read palette register and overscan	*
;			ES:DX - Pointer to save area (17 bytes) *
;			Exit: Bytes 0-F palette, 10 overscan	*
;		AL = A	Reserved				*
;		AL = B	Reserved				*
;		AL = C	Reserved				*
;		AL = D	Reserved				*
;		AL = E	Reserved				*
;		AL = F	Reserved				*
;		AL = 10 Set color register			*
;			BX - Register to set			*
;			DH - Red value				*
;			CH - Green value			*
;			CL - Blue value 			*
;		AL = 11 Reserved				*
;		AL = 12 Set color register block		*
;			ES:DX - Pointer to color block		*
;				(DB red,green,blue,...) 	*
;			BX    - First register to set		*
;			CX    - Number of registers to set	*
;		AL = 13 Select palette page			*
;			BL = 0 Select mode for paging		*
;			       BH = 0  4 blocks of 64 registers *
;			       BH = 1  16 blocks of 16 registers*
;			BL = 1 Select palette page		*
;			       BH = Page number (0-3 or 0-F)	*
;		AL = 14 Reserved				*
;		AL = 15 Read color register			*
;			BX - Color register to read		*
;			Exit: DH - Red value			*
;			      CH - Green value			*
;			      CL - Blue value			*
;		AL = 16 Reserved				*
;		AL = 17 Read color register block		*
;			ES:DX - Pointer to table		*
;			BX    - First register to read		*
;			CX    - Number of registers to read	*
;			Exit: ES:DX - (DB red,green,blue,...)	*
;		AL = 18 Reserved				*
;		AL = 19 Reserved				*
;		AL = 1A Read page state 			*
;			Exit: BL - Paging mode			*
;			      BH - Current page set		*
;		AL = 1B Sum to gray shades			*
;			BX - Starting register to sum		*
;			CX - Number of registers to sum 	*
;								*
;   AH = 11	Load character sets				*
;		AL = 0	Load character set			*
;			ES:BP - Character set pointer		*
;			DX    - Character offset from start	*
;			CX    - Number of characters		*
;			BL    - Character set (0-3)		*
;			BH    - Bytes per character		*
;		AL = 1	Load VGA Rom monochrome set		*
;			BL    - Character set (0-3)		*
;		AH = 2	Load VGA 8x8 character set		*
;			BL    - Character set (0-3)		*
;		AH = 3	Character set select			*
;			BL    - Bits 0-1 first set		*
;				Bits 2-3 second set		*
;		AH = 4	Load VGA 8x16 Character set		*
;			BL    - Character set (0-3)		*
;		AL = 10 Load character set and recalculate	*
;			ES:BP - Character set pointer		*
;			DX    - Character offset from start	*
;			CX    - Number of characters		*
;			BL    - Character set (0-3)		*
;			BH    - Bytes per character		*
;		AL = 11 Load VGA 9x14 char set and recalculate	*
;			BL    - Character set (0-3)		*
;		AL = 12 Load VGA 8x8 char set and recalculate	*
;			BL    - Character set (0-3)		*
;		AL = 14 Load VGA 8x16 char set and recalculate	*
;			BL    - Character set (0-3)		*
;		AL = 20 Set INT 1F to user 8x8 character set	*
;			ES:BP - Pointer to set			*
;		AL = 21 Set INT 43 to user character set	*
;			ES:BP - Pointer to set			*
;			CX    - Bytes per character		*
;			DL    - Video rows (if BL = 00) 	*
;			BL    - Code for video rows		*
;				00 - User specified (DL)	*
;				01 - 14 rows			*
;				02 - 25 rows			*
;				03 - 43 rows			*
;		AL = 22 Set INT 43 to BIOS 8x14 character set	*
;			DL    - Video rows (if BL = 00) 	*
;			BL    - Code for video rows		*
;				00 - User specified (DL)	*
;				01 - 14 rows			*
;				02 - 25 rows			*
;				03 - 43 rows			*
;		AL = 23 Set INT 43 to BIOS 8x8 character set	*
;			DL    - Video rows (if BL = 00) 	*
;			BL    - Code for video rows		*
;				00 - User specified (DL)	*
;				01 - 14 rows			*
;				02 - 25 rows			*
;				03 - 43 rows			*
;		AL = 24 Set INT 43 to BIOS 8x16 character set	*
;			DL    - Video rows (if BL = 00) 	*
;			BL    - Code for video rows		*
;				00 - User specified (DL)	*
;				01 - 14 rows			*
;				02 - 25 rows			*
;				03 - 43 rows			*
;		AL = 30 Return Character Set Status		*
;			BH    - Character set specifier 	*
;				00 - INT 1F Address		*
;				01 - INT 43 Address		*
;				02 - BIOS 8x14 Set Address	*
;				03 - BIOS 8x8 Set Address	*
;				04 - BIOS 8x8 Address ( > 128)	*
;				05 - BIOS 9x14 Update Set Addr	*
;				06 - BIOS 8x16 Set Address	*
;				07 - BIOS 9x16 Update Set Addr	*
;			Exit:	ES:BP - Character Set Address	*
;				CX    - Bytes per Character	*
;				DL    - Video rows		*
;								*
;   AH = 12	VGA System Information				*
;		BL = 10 Return VGA Information			*
;			Exit:	BH    - Adapter Type		*
;					0 - 3Dx Base Address	*
;					1 - 3Bx Base Address	*
;				BL    - Memory installed	*
;					0 - 64k 		*
;					1 - 128k		*
;					2 - 192k		*
;					3 - 256k		*
;				CH    - Feature bits		*
;				CL    - Switch settings 	*
;		BL = 20 Set INT 5 to 43 row print screen	*
;		BL = 30 Set scan lines for alpha modes		*
;			AL = 0	200 scan lines			*
;			AL = 1	350 scan lines			*
;			AL = 2	400 scan lines			*
;			Exit:	AL = 12 			*
;		BL = 31 Set default palette loading		*
;			AL = 0	Enable default palette on mode	*
;			AL = 1	Disable default palette 	*
;			Exit:	AL = 12 			*
;		BL = 32 Video enable/disable			*
;			AL = 0	Enable video			*
;			AL = 1	Disable video			*
;			Exit:	AL = 12 			*
;		BL = 33 Sum to gray shades enable/disable	*
;			AL = 0	Enable summing			*
;			AL = 1	Disable summing 		*
;			Exit:	AL = 12 			*
;		BL = 34 Enable/Disable cursor emulation 	*
;			AL = 0	Enable emulation		*
;			AL = 1	Disable emulation		*
;			Exit:	AL = 12 			*
;		BL = 35 Switch active displays			*
;			AL = 0	Adapter video off		*
;				ES:DX - Pointer to 128b buffer	*
;			AL = 1	System board video on		*
;			AL = 2	Active video off		*
;				ES:DX - Pointer to 128b buffer	*
;			AL = 3	Inactive video on		*
;				ES:DX - Pointer to 128b buffer	*
;			Exit:	AL = 12 			*
;		BL = 36 Video on/off				*
;			AL = 0 Video on 			*
;			AL = 1 Video off			*
;			Exit:	AL = 12 			*
;								*
;   AH = 13	Write string					*
;		ES:BP - Pointer to string			*
;		CX    - Length of string to display		*
;		DH    - Character row for display		*
;		DL    - Character column for display		*
;		BL    - Display attribute			*
;		AL    - Write string mode			*
;			0 - Characters only, no cursor update	*
;			1 - Characters only, update cursor	*
;			2 - Char, Attrib, no cursor update	*
;			3 - Char, Attrib, update cursor 	*
;								*
;   AH = 1A	Display Combination Code			*
;		AL = 0	Read display combination code		*
;			Exit:	AL = 1A 			*
;				BL - Active display		*
;				BH - Alternate display		*
;		AL = 1	Set display combination code		*
;			BL - Active display			*
;			BH - Alternate display			*
;			Exit: AL = 1A				*
;								*
;   AH = 1B	Return VGA state information			*
;		BX    - Implementation byte (zero)		*
;		ES:DI - Pointer to buffer			*
;			Exit: AL = 1C				*
;								*
;   AH = 1C	Save or restore video state			*
;		AL = 0	Return save/restore buffer size 	*
;			CX - Requested states to save		*
;			     Bit 0 - Video hardware state	*
;			     Bit 1 - BIOS data state		*
;			     Bit 2 - DAC state			*
;			Exit: AL = 1C				*
;			      BX - Number of 64b block required *
;		AL = 1	Save current state			*
;			CX - Requested states to save		*
;			     Bit 0 - Video hardware state	*
;			     Bit 1 - BIOS data state		*
;			     Bit 2 - DAC state			*
;			ES:BX - Pointer to buffer		*
;			Exit: AL = 1C				*
;		AL = 2	Restore current state			*
;			CX - Requested states to save		*
;			     Bit 0 - Video hardware state	*
;			     Bit 1 - BIOS data state		*
;			     Bit 2 - DAC state			*
;			ES:BX - Pointer to buffer		*
;			Exit: AL = 1C				*
;								*
;   AH = 5F	Extended BIOS Functions 			*
;		See extended BIOS specification 		*
;****************************************************************
;
;		      Primary			 Secondary
;  Switch Value       Adapter/Mode		 Monitor/Mode
;  ------------       -------			 ---------
;	0	      Monochrome		 VGA RGB/CGA 40x25
;	1	      Monochrome		 VGA RGB/CGA 80x25
;	2	      Monochrome		 VGA Enhanced/CGA 80x25
;	3	      Monochrome		 VGA Enhanced/VGA 80x25
;	4	      CGA 40x25 		 VGA Monochrome
;	5	      CGA 80x25 		 VGA Monochrome
;
;	6	      VGA RGB/CGA 40x25 	 Monochrome
;	7	      VGA RGB/CGA 80x25 	 Monochrome
;	8	      VGA Enhanced/CGA 80x25	 Monochrome
;	9	      VGA Enhanced/VGA 80x25	 Monochrome
;	A	      VGA Monochrome		 CGA 40x25
;	B	      VGA Monochrome		 CGA 80x25
;
;****************************************************************

	.XLIST
	INCLUDE VGADATA.INC
	include	config.inc
	include  options.inc
	.LIST

	%OUT	Assembling VGA BIOS Module A

VGA_Segment	SEGMENT PUBLIC WORD

	ASSUME	CS:VGA_Segment
	ASSUME	DS:VGA_Data_Area
	ASSUME	ES:NOTHING

	EXTRN	Extended_BIOS_Functions:NEAR
	EXTRN	INT_Address:WORD
	EXTRN	Video_Cursor_Type:NEAR
	EXTRN	Video_Get_Cursor:NEAR
	EXTRN	Video_Read_Char_Attr:NEAR
	EXTRN	Video_Write_Char_Attr:NEAR
	EXTRN	Video_Write_Char:NEAR
	EXTRN	Video_Write_String:NEAR
	EXTRN	Video_Select_Page:NEAR
	EXTRN	Video_Set_Cursor:NEAR
	EXTRN	Video_Read_Dot:NEAR
	EXTRN	Video_Teletype_Write:NEAR
	EXTRN	Video_Write_Dot:NEAR
	EXTRN	Video_Write_String:NEAR
	EXTRN	Video_VGA_Information:NEAR
	EXTRN	Video_Load_Character:NEAR
	EXTRN	Video_Set_Mode:NEAR
	EXTRN	Video_Light_Pen:NEAR
	EXTRN	Video_Scroll_Up:NEAR
	EXTRN	Video_Scroll_Down:NEAR
	EXTRN	Video_Set_Palette:NEAR
	EXTRN	Video_Parameters:NEAR
	EXTRN	Video_Palette_Values:NEAR
	EXTRN	Video_Combination_Code:NEAR
	EXTRN	Video_State_Information:NEAR
	EXTRN	Video_Save_Restore_State:NEAR

IFDEF ADAPTER
	PUBLIC	EGA_Video_Interface
ENDIF

	PUBLIC	VGA_Video_Interface
	PUBLIC	Video_Cmd_Table
	PUBLIC	Video_Cmd_Table_Size
;gdl
	PUBLIC	Direct_Video_Interface

;****************************************************************
;   Interrupt 10 Command Table
;****************************************************************

	;***ALIGN	4

Video_Cmd_Table LABEL	WORD
	DW	Video_Set_Mode			;Function 00
	DW	Video_Cursor_Type		;	  01
	DW	Video_Set_Cursor		;	  02
	DW	Video_Get_Cursor		;	  03
	DW	Video_Light_Pen 		;	  04
	DW	Video_Select_Page		;	  05
	DW	Video_Scroll_Up 		;	  06
	DW	Video_Scroll_Down		;	  07
	DW	Video_Read_Char_Attr		;	  08
	DW	Video_Write_Char_Attr		;	  09
	DW	Video_Write_Char		;	  0A
	DW	Video_Set_Palette		;	  0B
	DW	Video_Write_Dot 		;	  0C
	DW	Video_Read_Dot			;	  0D
	DW	Video_Teletype_Write		;	  0E
	DW	Video_Parameters		;	  0F
	DW	Video_Palette_Values		;	  10
	DW	Video_Load_Character		;	  11
	DW	Video_VGA_Information		;	  12
	DW	Video_Write_String		;	  13
	DW	Video_Invalid_Command		;	  14
	DW	Video_Invalid_Command		;	  15
	DW	Video_Invalid_Command		;	  16
	DW	Video_Invalid_Command		;	  17
	DW	Video_Invalid_Command		;	  18
	DW	Video_Invalid_Command		;	  19
	DW	Video_Combination_Code		;	  1A
	DW	Video_State_Information 	;	  1B
	DW	Video_Save_Restore_State	;	  1C
Video_Cmd_Table_Size	EQU	( $ - Video_Cmd_Table ) / 2

;****************************************************************
;   VGA interrupt 10 handler. If the function number is not
;   in the VGA range then the command is passed to the old
;   interrupt 10 handler (interrupt 42) for the Adapter BIOS,
;   or just ignored if for a planar board configuration.
;****************************************************************

	;***ALIGN	4

; Note: For strict compatibility, the following code should be enabled
; when using the VGA BIOS as an ADAPTER version. At this time, for
; performance reasons, this code has been commented out. The risk
; factor has been determined to be minimal.

IFDEF ADAPTER
EGA_Video_Interface	PROC	NEAR
	INT	06DH				;Transfer to VGA handler
	IRET
EGA_Video_Interface	ENDP

;	;***ALIGN	4
ENDIF

VGA_Video_Interface	PROC	NEAR
	STI
Direct_Video_Interface:			;Used at 0019h for SMI entry
	CLD					;Set to known state
	CMP	AH,0EH
	JE	Fast_Teletype_Write		;Go to teletype function
	CMP	AH,0CH
	JE	Fast_Write_Dot			;Goto write dot function
	CMP	AH,0DH
	JE	Fast_Read_Dot			;Goto read dot function
	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	SI
	PUSH	DI
	PUSH	BP

	PUSH	ES
	PUSH	DS				;Save callers registers
	MOV	BP,SP				;Use BP as stack mark
if (CHIP_FAMILY ne GenericVGA)
  if (SAVE_EXT_IDX eq YES)
    if (CHIP_FAMILY eq CONDOR)
	sub	sp,2		; save space for current 3c4 index 
	push	ax		; save registers
	push	dx
	mov	dx,EXTIDX	; extensions
	get1reg			; read index
	mov	[bp-2],al	; save it on the stack
	pop	dx		; restore registers
	pop	ax
    else   ;(CHIP_FAMILY eq CONDOR)
	sub	sp,4		; save space for current 3c4,3d4,3b4,3ce index 
	push	ax		; save registers
	push	dx
	mov	dx,SEQIDX	; sequencer
	get1reg			; read index
	xchg	ah,al		; save it in ah

	add	dl,010h		; Color CRTC
	get1reg			; read it
	mov	[bp-4],ax	; save it on stack

	sub	dl,020h		; Mono CRTC
	get1reg			; read it
	xchg	ah,al

	add	dl,01ah		; Graphics controller
	get1reg			; read index
	mov	[bp-2],ax	; save it on stack

	pop	dx		; restore registers
	pop	ax
    endif  ;(CHIP_FAMILY eq CONDOR)
  endif  ;(SAVE_EXT_IDX eq YES)
endif ;(CHIP_FAMILY ne GenericVGA)
	MOV	DS,INT_Address			;Setup to BIOS interrupt area
	MOV	SI,AX				;Save AX
	MOV	AL,AH				;Get function number in AL
	XOR	AH,AH				;Extend to AX
	CMP	AL,Video_Cmd_Table_Size 	;Test if command out of range
	JAE	Previous_Interrupt_10		;Go pass it to interrupt 42
	SHL	AX,1				;No -Double for table offset
	XCHG	AX,SI				;Prepare for function branch
	CALL	CS:Video_Cmd_Table[SI]		;Call the function

Exit_Video:
if (SAVE_EXT_IDX eq YES)
  if (CHIP_FAMILY eq CONDOR)
	push	ax		; save registers
	push	dx
	mov	dx,EXTIDX 	; extensions
	mov	al,[bp-2]	; get original index from stack
	set1reg			; restore original index

	pop	dx		; restore registers
	pop	ax
	add	sp,2		; restore stack
  else  ;(CHIP_FAMILY eq CONDOR)
	push	ax		; save registers
	push	dx
	mov	dx,GFXIDX	; Graphics Controller
	mov	ax,[bp-2]	; get original index from stack
	set1reg			; restore original index

	sub	dl,01ah		; Mono CRTC
	xchg	ah,al		; get index from stack
	set1reg			; restore

	add	dl,020h		; Color CRTC
	mov	ax,[bp-4]	; get index from stack
	set1reg			; restore

	sub	dl,010h		; Sequencer
	xchg	ah,al		; get index from stack
	set1reg			; restore

	pop	dx		; restore registers
	pop	ax
	add	sp,4		; restore stack
  endif	;(CHIP_FAMILY eq CONDOR)
endif	;(SAVE_EXT_IDX eq YES)
	POP	DS				;Restore callers registers
	POP	ES

	POP	BP
	POP	DI
	POP	SI
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	IRET

	;***ALIGN	4
Fast_Teletype_Write:
	JMP	Video_Teletype_Write

	;***ALIGN	4
Fast_Write_Dot:
	JMP	Video_Write_Dot

	;***ALIGN	4
Fast_Read_Dot:
	JMP	Video_Read_Dot

Previous_Interrupt_10:
	MOV	AX,SI				;Restore AX value
	CALL	Extended_BIOS_Functions 	;Go handle extended features
	JE	Exit_Video			;Exit if done else int 42

IFDEF ADAPTER
	MOV	AX,AX_Stack			;Restore contents of AX
	MOV	DS,DS_Stack			;Restore callers DS
	PUSH	BP
	MOV	BP,BP_Stack			;And callers BP
	INT	42H				;Call old interrupt 10
	POP	BP
	MOV	AX_Stack,AX			;Save returned AX
ENDIF
	JMP	SHORT Exit_Video

Video_Invalid_Command:
	RET					;Dont do anything on bad cmd
VGA_Video_Interface	ENDP

;****************************************************************

VGA_Segment	ENDS

	END

