	INCLUDE PAGE.INC
	SUBTTL	VGA BIOS Ram Version Utility
;****************************************************************
;
;	$Workfile:   ramvga.asm  $
; 
; 	Copyright 1989, 1990 Quadtel Corporation.
; 	All rights reserved.
; 
;	Contents:
;	This modules is used to run the vga bios in a ram
;	environment. All hard coded segment addresses are
;	patched by this module which then calls the VGA POST
;	for initialization of the video system.
;
; 	Modification History:
; 	$Log:   E:/vcs/vga/ramvga.asv  $
;      
;         Rev 1.1   03 Jun 1991 16:59:28   Darryl
;      $UPDATE:VGA BIOS core revision 11 modifications.
;      VGA BIOS modifications for core hook support.
;      $
;      
;         Rev 1.0   21 Dec 1990 11:01:18   Darryl
;      Initial checkin to VCS.
;
;	01/08/90  Support was added for the new VCP.
;
;****************************************************************

	%OUT	Assembling BIOS Ram Version Module

;****************************************************************

.XLIST
INCLUDE VGADATA.INC
.LIST

Stack_Segment	SEGMENT PARA STACK 'STACK'

		ASSUME	SS:STACK_SEGMENT

		DB	100 DUP(00)
Stack_Segment	ENDS

;****************************************************************

IFDEF DIGITAL
		EXTRN	Digital_Environment_Table:WORD
ENDIF

IFDEF ADAPTER
		EXTRN	EGA_Video_Interface:NEAR
ELSE
		EXTRN	Power_On_Diagnostics:FAR
ENDIF

;gdl		EXTRN	BIOS_Date:BYTE
		EXTRN	Module_Start:NEAR
		EXTRN	Module_End:NEAR
		EXTRN	VGA_Video_Interface:NEAR
;gdl		EXTRN	VCP_Date:BYTE
;gdl		EXTRN   VGA_Segment1:WORD
;		EXTRN	Video_Configuration_Parameters:BYTE

;****************************************************************

Make_Module	SEGMENT PARA

		ASSUME	CS:Make_Module
		ASSUME	ES:Make_Module
		ASSUME	DS:Make_Module

;****************************************************************
;
;		  M A I N     P R O G R A M
;
;****************************************************************

	JMP	Module_Maker_Near

;****************************************************************

EGA_Init	LABEL	DWORD
		DW	03
EGA_Seg 	DW	?

;***********************************************************************

Module_Maker	PROC	FAR
Module_Maker_Near:
	CLD
	CLI
	mov	ax,seg EGA_Init
	MOV	AX,SEG Module_Start		;Get EGA BIOS segment
	MOV	DS,AX				;Set DS to segment

if 0	;gdl:11/25/91
	MOV	CX,8				;There are 8 addresses
	MOV	BX,OFFSET VGA_Segment1		;starting with this label

Update_All:
	PUSH    BX				;Save the base address
	MOV	BX,DS:[BX]			;Load the offset
	CMP	BX,0				;If zero bypass the update
	JE 	No_Update			;but go on to check the rest
	MOV	DS:[BX],AX			;Move the new address

No_Update:
        POP     BX				;Get the base
  	ADD	BX,2				;Add 2 to get next word
   	LOOP	Update_All			;Continue the loop
endif	;0	;gdl:11/25/91

	MOV	AX,SEG Module_Start
	MOV	CS:EGA_Seg,AX

if 0	;gdl:11/25/91
	MOV	AH,2AH				;Get date from DOS funct 2A.
	INT	21H				;DH=month, DL=day, CX=year.
	MOV	SI,CX				;Temp storage for year.
	MOV	DI,OFFSET BIOS_Date		;Point to hi month digit place.
	MOV	AL,DH				;Put month in AL.
	CALL	ASCII_Write			;Convert to ASCII and write'em.
	MOV	BYTE PTR[DI],2FH		;Follow digits by "\".
	INC	DI				;Point to day place.
	MOV	AL,DL				;Put day in AL.
	CALL	ASCII_Write			;Write em.
	MOV	BYTE PTR[DI],2FH		;Follow day by \.
	INC	DI				;Point to year place.
	SUB	SI,1900 			;Subtract century from SI.
	MOV	AX,SI				;Put low year digits in AL.
	CALL	ASCII_Write			;Write them to memory.
						;Write date into VCP
	MOV	AH,2AH				;Get date from DOS funct 2A.
	INT	21H				;DH=month, DL=day, CX=year.
	MOV	SI,CX				;Temp storage for year.
	MOV	DI,OFFSET VCP_Date		;Point to hi month digit place.
	MOV	AL,DH				;Put month in AL.
	CALL	ASCII_Write			;Convert to ASCII and write'em.
	MOV	BYTE PTR[DI],2FH		;Follow digits by "\".
	INC	DI				;Point to day place.
	MOV	AL,DL				;Put day in AL.
	CALL	ASCII_Write			;Write em.
	MOV	BYTE PTR[DI],2FH		;Follow day by \.
	INC	DI				;Point to year place.
	SUB	SI,1900 			;Subtract century from SI.
	MOV	AX,SI				;Put low year digits in AL.
	CALL	ASCII_Write			;Write them to memory.
endif	;0	;gdl:11/25/91

if 0
	MOV	SI,OFFSET Video_Configuration_Parameters
	MOV	CX,[SI+02]			;Checksum VCP
	XOR	BL,BL

VCP_Loop:
	LODSB
	ADD	BL,AL
	LOOP	VCP_Loop
	NEG	BL
	MOV	Video_Configuration_Parameters + 04,BL
endif	;0

; Use this code to only capture INT 10 - No Init will be performed

;	XOR	AX,AX
;	MOV	ES,AX
;	MOV	DI,10H * 4
;	MOV	AX,OFFSET VGA_Video_Interface
;	STOSW
;	MOV	AX,SEG Module_Start
;	STOSW


IFDEF ADAPTER
	CALL	CS:EGA_Init			   ;Initialize power on diag
ELSE
	CALL	Power_On_Diagnostics
ENDIF

	MOV	AX,OFFSET Module_End		;Get module end
	MOV	CL,4				;Compute number of paragraphs
	SHR	AX,CL				;Divide by 16
	ADD	AX,30H				;Add for PSP and extra area
	MOV	DX,AX				;Set size in paras
	MOV	AX,3100H			;Terminate but stay resident
	INT	21H
Module_Maker	ENDP

;***************************************************************************
;   With AL containing the BCD digits to be converted and written and
;   DI pointing to destination, this converts first hi hex digit to
;   ASCII, and writes to [DI], increments DI, converts low digit in AL,
;   writes to [DI], increments DI, and returns.
;***************************************************************************

ASCII_Write	PROC	NEAR
	CALL	Hex_2_BCD			;Convert Hex value to BCD.
	MOV	AH,AL				;Put digits in AH.
	AND	AL,0F0H 			;Mask off low digit.
	SHR	AL,1				;Move hi digit to low position.
	SHR	AL,1
	SHR	AL,1
	SHR	AL,1
	ADD	AL,30H				;This is ASCII hi digit.
	MOV	[DI],AL 			;Write to end of segment.
	INC	DI				;Point to next location.
	AND	AH,0FH				;Mask off high digit.
	ADD	AH,30H				;Convert to ascii.
	MOV	[DI],AH 			;Write to position.
	INC	DI				;Point to next place
	RET					;Return.
ASCII_Write	ENDP

;*********************************************************************
;   Hex_2_BCD converts a hex byte to two BCD digits (in a byte).
;   Pass the byte in AL, and its returned in AL.
;   Uses AX, BX, CX.
;*********************************************************************

Hex_2_BCD	PROC	NEAR

	MOV	BL,AL				;Hex value in BL.
	XOR	AL,AL				;Zero result register.
	MOV	CX,08				;Loop for a byte.
	CLC					;

BCD_Loop:
	SHL	BL,1				;Shift hex hi bit into carry.
	ADC	AL,AL				;result reg * 2 + carry.
	DAA
	LOOP	BCD_Loop			;Do 8 times.

	RET

Hex_2_BCD	ENDP

;****************************************************************

Make_Module	ENDS

	END	Module_Maker
