bios_data	segment	at 0

extrn	prt_screen	:dword	; print screen vector
extrn	prt_scr_off	:word
extrn	prt_scr_seg	:word

extrn	vd_bios		:dword	; int 10h, video bios vector
extrn	vd_bios_off	:word
extrn	vd_bios_seg	:word

extrn	cmga_parms	:dword	; 6845 parameter tables
extrn	cmga_parm_off	:word
extrn	cmga_parm_seg	:word

extrn	hidd_ptr	:dword	; top half of double dot font
extrn	hidd_off	:word
extrn	hidd_seg	:word

extrn	sys_video	:dword	; int 42h, system video bios vector
extrn	sys_video_off	:word
extrn	sys_video_seg	:word

extrn	gfx_font	:dword	; int 43h, graphics mode font
extrn	gfx_font_off	:word
extrn	gfx_font_seg	:word

extrn	alt_video	:dword	; int 6dh, alternate video bios vector
extrn	alt_video_off	:word
extrn	alt_video_seg	:word

extrn	equip		:byte	; pc/xt equipment flag

extrn	con_mode	:byte	; current video mode
extrn	con_cols	:word	; # of columns on screen
extrn	con_len		:word	; length of screen buffer in bytes
extrn	con_start	:word	; starting offset of current page
extrn	cur_pos		:word	; cursor position (col,row), each page
extrn	cursor_mode	:word	; current cursor type setting
extrn	act_page	:byte	; current page being displayed
extrn	card_addr	:word	; base address of active crt
extrn	con_mode_set	:byte	; simulated value of 6845 3x8 register
extrn	con_palette	:byte	; simulated value of 6845 3x9 register

extrn	warm_boot	:word	; 1234h is warm boot

extrn	rows		:byte	; displayed rows - 1
extrn	points		:word	; word version of cell height
extrn	pts		:byte	; byte version of cell height
extrn	ega_info	:byte	; ega info byte
	PRESERVE_RAM	equ	80h	; preserve ram on set mode
	EGA_MEMORY	equ	60h	; amount of ega memory
	EGA_RESERVED	equ	10h	; reserved bit
	EGA_INACTIVE	equ	08h	; ega inactive bit
	EGA_WAIT	equ	04h	; cpu/crtc memory contention
	EGAMONO		equ	02h	; ega has mono mon attached
	EGA_CURS_EMUL	equ	01h	; disable cursor emulation
extrn	ega_info3	:byte	; ega feature bits + ega switches
	EGA_FEAT	equ	0f0h	; feature bits
	EGA_SWITCHES	equ	00fh	; ega switches
extrn	vga_info	:byte	; vga info byte
	VGA_200SCANS	equ	80h	; 3dx modes should have 200 scans
	VGA_SWITCH	equ	40h	; display switching enabled
	VGA_RESERVED	equ	20h	; reserved
	VGA_PLUSMODE	equ	10h	; 16 high font text modes
	VGA_SKIP_PAL	equ	08h	; skip palette load on set mode
	VGA_MONO_MON	equ	04h	; vga has mono mon attached
	VGA_SUM2GREY	equ	02h	; sum to grey scale enabled
	ALL_MODES	equ	01h	; all modes on all monitors
extrn	dcc_idx		:byte	; index into dcc table

extrn	save_ptr	:dword	; pointer to save area
extrn	save_ptr_off	:word
extrn	save_ptr_seg	:word

bios_data	ends
