;-----------------------------------------------------------------------
;
; This module contains the structures that define the tables found in
; 'regtbl.asm'.  For each table that is found in that file, there is a 
; corresponding structure in this file.  
;
;-----------------------------------------------------------------------


;-----------------------------------------------------------------------
; oemsi_rstruc
;
; This structure defines the oemsi_regs table.
;
;-----------------------------------------------------------------------
		public	oemsi_rstruc
oemsi_rstruc	struc
;			"idx"	"and_mask"
	oem_sr08	dw ?
			db ?,?		;EEPROM Ctrl
	oem_sr0B	dw ?
			db ?,?		;VCLK0 numerator
	oem_sr1B	dw ?
			db ?,?		;VCLK0 denominator
	oem_sr0C	dw ?
			db ?,?		;VCLK1 numerator
	oem_sr1C	dw ?
			db ?,?		;VCLK1 denominator
	oem_sr0D	dw ?
			db ?,?		;VCLK2 numerator
	oem_sr1D	dw ?
			db ?,?		;VCLK2 denominator
	oem_sr0F	dw ?
			db ?,?		;DRAM Ctrl
	oem_sr16	dw ?
			db ?,?		;performance tuning for mode 0 - 13h
	oem_sr1F	dw ?
			db ?,?		;MCLK Setting
	oem_sr17	dw ?		;(V1.3)
			db ?,?		;bit0, shadow DAC write on L. Bus
	oem_term	dw	?	; terminator
oemsi_rstruc	ends


;-----------------------------------------------------------------------
; oemsi_tstruc
;
; This structure defines the oemsi_tbl table.
;
;-----------------------------------------------------------------------
		public	oemsi_tstruc
oemsi_tstruc	struc
;			"or_mask"	
	ot_sr08		db ?		;EEPROM Ctrl
	ot_sr0B		db ?		;VCLK0 numerator
	ot_sr1B		db ?		;VCLK0 denominator
	ot_sr0C		db ?		;VCLK1 numerator
	ot_sr1C		db ?		;VCLK1 denominator
	ot_sr0D		db ?		;VCLK2 numerator
	ot_sr1D		db ?		;VCLK2 denominator
	ot_sr0F		db ?		;DRAM Ctrl
	ot_sr16		db ?		;performance tuning for mode 0 - 13h
	ot_sr1F		db ?		;MCLK Setting
	ot_sr17		db ?		;(V1.3)bit0, shadow DAC write on L. Bus
oemsi_tstruc	ends


;-----------------------------------------------------------------------
; xmode_struc
;
; This structure defines the extended mode table.
;
;-----------------------------------------------------------------------

SR_16Msk	equ	0f0h		;(V1.301)

		public	xmode_struc
xmode_struc	struc
;			"idx"	"and_mask"
	x_sr07		dw SEQIDX
			db 07h,not 0FFh		;Extd Sequ Ctrl #5434(7)#

ifdef	(NOR_STAR)
	x_sr0B		dw SEQIDX
			db 0Bh,not 080h		;VDCLK DIV. CONTROL1
	x_sr0C		dw SEQIDX		 
			db 0Ch,not 080h		;VDCLK DIV. CONTROL2
endif	; (NOR_STAR)
	x_sr0F		dw SEQIDX
			db 0Fh,not 060h		;5434(12)DRAM Ctrl
	x_sr0E		dw SEQIDX
			db 0Eh,not 0FFh		;VCLK3 numerator
	x_sr1E		dw SEQIDX
			db 1Eh,not 0FFh		;VCLK3 denominator
	x_gr0B		dw GFXIDX
			db 0Bh,not 03Fh		;Grfx Extensions
	x_cr19		dw CRTIDX
			db 19h,not 0FFh		;Interlace end
	x_cr1A		dw CRTIDX
			db 1Ah,not 0FFh		;Misc Ctrl
	x_cr1B		dw CRTIDX
			db 1Bh,not 0FFh		;Display Ctrl
	x_dacext	dw PELMASK
			db 0FFh,not 0FFh	;DAC hidden register
	x_sr16_70	dw SEQIDX		;(V1.3) SR16/70ns, performance
			db 16h,SR_16Msk		; tuning for each mode.
	x_sr16_60	dw SEQIDX		;(V1.3) SR16/60ns, performance
			db 16h,SR_16Msk		; tuning for each mode.
	x_term		dw	0000h		; terminator
xmode_struc	ends


supp_struc	struc
;			"or_mask" for xmode_struc
	s_mode		db	?		; video mode#
	s_vesa		dw	?		; vesa mode#
	s_horz		dw	?		; horiz res
	s_vert		dw	?		; vert res
	s_colors	db	?		; bits/color
	s_xchar		db	?		; char width
	s_ychar		db	?		; char height
	s_memmodel	db	?		; VESA memory model
	s_miscinfo	db	?		; Misc info
ifdef (ALP_NEW)
	s_ref		db	?		; Refresh rate fixup index
	s_param		db	?		; STD param list index
else	; (ALP_NEW)
	s_ref_param	db	?		; Refresh rate & param list
endif	; (ALP_NEW)
	s_msrvalue	db	?		; 3C2h value to write
	s_resrvd	db	?		; reserved
	s_memreq	db	?		; Min memory req'd, unit in 64K
;v1.00B1{
	s_SzMclk30	db	?		;For 5430 only
						; b0 --- MClk = 45Mhz; 512K
						; b1 --- MClk = 45Mhz; 1/2M
						; b2 --- MClk = 50Mhz; 512K
						; b3 --- MClk = 50Mhz; 1/2M
						; b4 --- MClk = 60Mhz; 512K
						; b5 --- MClk = 60Mhz; 1/2M
						; b6 & b7  Reserved
	s_SzMclk34	db	?		;For 5434 only
						; b0 --- MClk = 45Mhz;  1M
						; b1 --- MClk = 45Mhz; 2/4M
						; b2 --- MClk = 50Mhz;  1M
						; b3 --- MClk = 50Mhz; 2/4M
						; b4 & b7  Reserved
;v1.00B1}
ifdef (ALP_NEW)
	s_monlist	db	?		; [3:0] - Max. vertical resolution
						; [6:4] - Required Frequency for
						;	  800 x 600
						;	 1024 x 768
						;	 1280 x 1024
						; [7]	- reserved
else	; (ALP_NEW)
	s_monlist	db	?		; [1:0] - Required Freq. 1280x1024
						; [3:2] - Max. vertical resolution
						; [5:4] - Required Freq.  800x600
						; [7:6] - Required Freq. 1024x768
						
endif	; (ALP_NEW)

	XMODE_REGS_EXTRA equ	($ - offset supp_struc)

	s_sr07		db 	?		;Extd Sequ Ctrl
ifdef	(NOR_STAR)
	s_sr0B		db 	?		;VDCLK DIV. CONTROL1
	s_sr0C		db 	?		;VDCLK DIV. CONTROL2
endif	; (NOR_STAR)
	s_sr0F		db 	?		;DRAM Ctrl
	s_sr0E		db 	?		;VCLK3 numerator
	s_sr1E		db 	?		;VCLK3 denominator
	s_gr0B		db 	?		;Grfx Extensions
	s_cr19		db 	?		;Interlace end
	s_cr1A		db 	?		;Misc Ctrl
	s_cr1B		db 	?		;Display Ctrl
	s_dacext	db 	?		;DAC hidden register
	s_sr16_70	db	?		;(V1.3)SR16/70ns, performance tuning
	s_sr16_60	db	?		;(V1.3)SR16/60ns, performance tuning
supp_struc	ends


;-----------------------------------------------------------------------
; std_mode_struc
;
; This structure defines the generic VGA register set
;
;-----------------------------------------------------------------------
std_mode_struc	struc
	vga_std_columns			  db	?
	vga_std_height			  db	?
	vga_std_character_height	  db	?
	vga_std_page_size		  dw	?

;	sequencer
	vga_std_sr1			  db	?
	vga_std_sr2			  db	?
	vga_std_sr3			  db	?
	vga_std_sr4			  db	?

	vga_std_misc_output		  db	?

;	CRT controller		  		?
	vga_std_cr0			  db	?
	vga_std_cr1			  db	?
	vga_std_cr2			  db	?
	vga_std_cr3			  db	?
	vga_std_cr4			  db	?
	vga_std_cr5			  db	?
	vga_std_cr6			  db	?
	vga_std_cr7			  db	?
	vga_std_cr8			  db	?
	vga_std_cr9			  db	?
	vga_std_cra			  db	?
	vga_std_crb			  db	?
	vga_std_crc			  db	?
	vga_std_crd			  db	?
	vga_std_cre			  db	?
	vga_std_crf			  db	?
	vga_std_cr10			  db	?
	vga_std_cr11			  db	?
	vga_std_cr12			  db	?
	vga_std_cr13			  db	?
	vga_std_cr14			  db	?
	vga_std_cr15			  db	?
	vga_std_cr16			  db	?
	vga_std_cr17			  db	?
	vga_std_cr18			  db	?

;	attribute controller	  		
	vga_std_ar0			  db	?
	vga_std_ar1			  db	?
	vga_std_ar2			  db	?
	vga_std_ar3			  db	?
	vga_std_ar4			  db	?
	vga_std_ar5			  db	?
	vga_std_ar6			  db	?
	vga_std_ar7			  db	?
	vga_std_ar8			  db	?
	vga_std_ar9			  db	?
	vga_std_ara			  db	?
	vga_std_arb			  db	?
	vga_std_arc			  db	?
	vga_std_ard			  db	?
	vga_std_are			  db	?
	vga_std_arf			  db	?
	vga_std_ar10			  db	?
	vga_std_ar11			  db	?
	vga_std_ar12			  db	?
	vga_std_ar13			  db	?

;	graphics controller	  		
	vga_std_gr0			  db	?
	vga_std_gr1			  db	?
	vga_std_gr2			  db	?
	vga_std_gr3			  db	?
	vga_std_gr4			  db	?
	vga_std_gr5			  db	?
	vga_std_gr6			  db	?
	vga_std_gr7			  db	?
	vga_std_gr8			  db	?
std_mode_struc	ends
