page            60,132
title           Program Extensions via Tables
;****************************************************************
;
;       $Workfile:   regtbl.asm  $
; 
; 
;       Contents:
;
;       Modification History:
;       $Log:   M:/vcs/vga/64xx/regtbl.asv  $
;      
;      
;****************************************************************

;
; equates used by OEMSI utility
;

;
; is OEMSI configurable table?
; 
CONFIGURABLE    equ     00000001b       ; yes
xCONFIGURABLE   equ     00000000b       ; no

;
; is extra data in the table except regular register data?
;
EXTRA           equ     00000010b       ; yes
xEXTRA          equ     00000000b       ; no
;
; table type equates
;
INDEX_AND_OR    equ     00000000b       ; index/and + or tables
INDEX_AND       equ     00000100b       ; index/and table
INDEX_OR        equ     00001000b       ; index + or tables
OR_ONLY         equ     00001100b       ; pure register data (or) only
STDSUPSPLIT     equ     00100000b       ; extended modes are split
CNTSIZE         equ     01000000b       ; count size for special tables
REG_IDX_OR      equ     10000000b       ; special structure for mode optim

REGISTER        equ     00010000b       ; register data is in table also
xREGISTER       equ     00000000b       ; register data NOT in table

;
; hardwired value
;

cgroup          group   VGA_Segment

	.XLIST
	include         config.inc
	include         options.inc
	include         struc.inc
	INCLUDE VGADATA.INC
	.LIST

	%OUT    Assembling REGTBL

VGA_Segment     SEGMENT PUBLIC BYTE

	ASSUME  CS:VGA_Segment
	ASSUME  DS:VGA_Data_Area
	ASSUME  ES:NOTHING

		extrn   getreg  :near   ; read an extension regsiter
		extrn   get_crtc_addr:near
		extrn   avga_confbyte:byte
ifdef SCRIDX
		extrn   setscr:near     ; write an extension scratch register
		extrn   getscr:near     ; get a value from scratch reg
		extrn   use_switches:byte; in config table
		extrn   rom_opt1:byte   ; start of rom options
endif   ;SCRIDX
ifdef (MODE_OPTIMIZATION)
		extrn   OPTIM_X_MODES:abs
		extrn   Color_Depth_Data:byte
		extrn   Color_Depth_Registers:byte
		extrn   CRTC_Refresh_Data:byte
		extrn   CRTC_Refresh_Registers:byte
		extrn   NUM_REFRESH_TABLES:abs
		extrn   NUM_COLOR_TABLES:abs
endif   ;(MODE_OPTIMIZATION)
		extrn   X_MODES:abs     ;number of extended modes
		extrn   ana_ext_sup:word
		extrn   get_oemsi_value:near
;-----------------------------------------------------------------------
; Table_ptrs
;
; The following data structure is used by OEMSI to determine the types of
; tables that are defined for each BIOS product.  Each table represents 
; register I/O that is needed for functions such as POST, CRT/LCD/SIM
; operations, or extended mode sets.  The location of this table can be
; found through the BIOS POST entry point.
;
;-----------------------------------------------------------------------
table_ptrs      label   near
		public  table_ptrs

		;
		; extended mode supplement table, used at setmode
		;
		db      'XMODE',0       ; token
ifdef  (MODE_OPTIMIZATION)
		db      CONFIGURABLE or INDEX_AND_OR or EXTRA or REGISTER or STDSUPSPLIT
else   ;(MODE_OPTIMIZATION)
		db      CONFIGURABLE or INDEX_AND_OR or EXTRA or REGISTER
endif  ;(MODE_OPTIMIZATION)
		db      XMODE_REGS_EXTRA          ; size to skip if needed
		db      X_MODES                   ; Number of extended modes
		dw      offset cgroup:xmode_regs  ; index/and table offset
		dw      offset cgroup:ana_ext_sup ; or table offset
ifdef  (MODE_OPTIMIZATION)
		db      OPTIM_X_MODES             ; Number of extended modes
endif  ;(MODE_OPTIMIZATION)

		;
		; oemsi table - hardware configuration registers programmed
		; at POST
		;
		db      'HW',0          ; token
		db      CONFIGURABLE or INDEX_AND_OR or xEXTRA or REGISTER
		db      0               ; size to skip if extra
		db      1                         ; number of tables
		dw      offset cgroup:oemsi_regs  ; index/and table offset
		dw      offset cgroup:oemsi_tbl   ; or table offset

ifdef   (MODE_OPTIMIZATION)

		;
		; color fixup tables for mode size optimization
		;
		db      'XCLR',0        ; token
		db      CONFIGURABLE or REG_IDX_OR
		db      000h            ; skip this entry
		db      NUM_COLOR_TABLES
		dw      offset Color_Depth_Registers
		dw      offset Color_Depth_Data

		;
		; color fixup tables for mode size optimization
		;
		db      'FREQ',0        ; token
		db      CONFIGURABLE or INDEX_OR or CNTSIZE
		db      000h            ; skip this byte
		db      NUM_REFRESH_TABLES
		dw      offset CRTC_Refresh_Registers
		dw      offset CRTC_Refresh_Data
endif   ;(MODE_OPTIMIZATION)

		;
		; null-terminate sentinal value to end the tables
		;
		db      00h

;-----------------------------------------------------------------------
; oemsi_regs
;
; Oemsi_regs defines which registers are modified during post.  This table
; defines register values index and 'and' mask.  A corresponding table 
; will define the 'or' mask.  Both tables are used in conjuntion with 
; structures defined in 'struc.inc'.
;
;-----------------------------------------------------------------------
		public  oemsi_regs
oemsi_regs      label   byte
;                       "idx"   "and_mask"
		dw SEQIDX
		db 08h,not 040h                 ;EEPROM Ctrl
		dw SEQIDX
		db 0Bh,not 0FFh                 ;VCLK0 numerator
		dw SEQIDX
		db 1Bh,not 0FFh                 ;VCLK0 denominator
		dw SEQIDX
		db 0Ch,not 0FFh                 ;VCLK1 numerator
		dw SEQIDX
		db 1Ch,not 0FFh                 ;VCLK1 denominator
		dw SEQIDX
		db 0Dh,not 0FFh                 ;VCLK2 numerator
		dw SEQIDX
		db 1Dh,not 0FFh                 ;VCLK2 denominator
		dw SEQIDX
		db 0Fh,not 0FFh                 ;DRAM Ctrl
		dw SEQIDX
		db 16h,not 0FFh                 ;Local Bus Wait State/FIFO
		dw SEQIDX
		db 1Fh,not 0FFh                 ;MCLK Setting
		dw SEQIDX                       ;(V1.3)
		db 17h,not 001h                 ;bit0 shadow DAC write on L Bus
		dw      000h                    ; terminator

		
;-----------------------------------------------------------------------
; oemsi_tbl
;
; Oemsi_tbl defines which registers are modified during post.  This table
; defines register values index and 'or' mask.  The table above defines
; the 'and' mask.  Both tables are used in conjuntion with structures 
; defined in 'struc.inc'.
;
;-----------------------------------------------------------------------
		public  oemsi_tbl
oemsi_tbl       label   byte

;                       "or_mask"       
		db 000h                 ;Assume 16-bit for co-resident
		db 04Ah                 ;VCLK0 numerator
		db 02Bh                 ;VCLK0 denominator
		db 05Bh                 ;VCLK1 numerator
		db 02Fh                 ;VCLK1 denominator
		db 042h                 ;VCLK2 numerator
		db 01Fh                 ;VCLK2 denominator
		db 000h                 ;DRAM Ctrl
;v0.0401       db 031h                 ;#5434(4)#Local Bus Wait State/FIFO
		db 071h                 ;v0.0401  for SIS460 chip set
		db 01Ch                 ;MCLK Setting
		db 001h                 ;bit0, shadow DAC write on L Bus

;-----------------------------------------------------------------------
; xmode_regs
;
;
;-----------------------------------------------------------------------
		public  xmode_regs
xmode_regs xmode_struc < >              ; struc contains default values
					; programmed at set_mode

page
;-----------------------------------------------------------------------
;
;       setup_xmode()
;
;       Function:
;          Sets all bits that have an effect in extended video modes, but
;       are always 0 in standard VGA modes to zero.
;
;       Input:
;          DI = 0, for standard modes
;          DI = pointer to extended mode table 
;
;       Returns:
;          dx <- EXTIDX
;
;       Remarks:
;          cx,si are destroyed.
;
;-----------------------------------------------------------------------
setup_xmode     proc    near
		public  setup_xmode

		mov     si,offset cgroup:xmode_regs
		call    pgm_ext                 ; program extension regs
if (MEMCLK_FIXUP eq YES)
		mov     ax,0141Fh
		call    setscr
endif ;(MEMCLK_FIXUP eq YES)

		ret                             ; return to caller
setup_xmode     endp

page
;-----------------------------------------------------------------------
;
;       post_setup()
;
;       Function:
;          Setup extension registers at post time.
;
;       Input:
;          Nothing.
;
;       Returns:
;          dx <- EXTIDX
;
;       Remarks:
;          Note that the warmboot code will not skip this entire routine,
;       which would be easier.  The scratch pad registers must be reset
;       because in a microchannel environ, the chip will be reset during
;       warmboots, and the reset state of the scratch pads are all zero.
;       Thus the BIOS must reset all scratch pad values.  Note: This is 
;       not needed in laptop products.
;
;-----------------------------------------------------------------------
post_setup      proc    near
		public  post_setup

	call    get_oemsi_value         ; ah = default value
	mov     al,016h                 ;ah = oemsi POST sr16 value
	call    setscr

		extrn   warm_boot:word
		cmp     ds:warm_boot,1234h ; really a warm boot ?
		je      skip_post_setup    ; nope

		push    cs
		pop     es              ; ES to our code segment

		mov     si,offset cgroup:oemsi_regs;
		mov     di,offset cgroup:oemsi_tbl
		call    pgm_ext         ; program configuration bits

;v1.10A4{       If 5430 exists, program SR1F as default MClk5430!!!
	extrn   Detect5430:near
	extrn   MClk5430:byte

		call    Detect5430
		jnz     KeepCurrentMClk
		mov     al,1Fh
		call    getscr
		and     ah,0C0h
		or      ah,byte ptr MClk5430
		out     dx,ax
KeepCurrentMClk:
;v1.10A4}

if      (MEMCLK_FIXUP eq YES)
		mov     al,00Fh         ; Memclk = 10b
		extrn   getscr:near
		call    getscr
		and     ah,not 003h
		or      ah,002h
		call    setscr
		mov     ax,0141Fh       ; Memclk frequency
		call    setscr
endif  ;(MEMCLK_FIXUP eq YES)

		push    ds              ; save DS at 0
		push    cs              ; 
		pop     ds

		mov     ax,SCR_START    ; start of scratch pad
		mov     cx,SCR_LEN      ; length of scratch pad
		lea     si,rom_opt1     ; start of table

set_scr_pad:    mov     ah,byte ptr [si]; get it
		call    setscr          ; clear it
		inc     ax              ; next scratch pad register
		inc     si              ; 
		loop    set_scr_pad     ; more scratch pad registers ?
;v1.10B5{
		mov     ah,byte ptr [si]; default value of rom_opt3
		mov	al,14h		; Program default value to SR14
		call	setscr
;v1.10B5}
		jmp     short merge_point

skip_post_setup:

;
; set cold boot scratch pad registers
;
		push    ds              ; save DS at 0

ifdef MICROCHANNEL_ADAPTER              ;V1.204, for Microchannel only
		push    cs              ; 
		pop     ds

		mov     ax,SCR_START    ; start of scratch pad
		mov     cx,SCR_LEN      ; length of scratch pad
		lea     si,rom_opt1     ; start of table

setup_scr_pad:  mov     ah,byte ptr [si]; get it
		call    setscr          ; clear it
		inc     ax              ; next scratch pad register
		inc     si              ; 
		loop    setup_scr_pad   ; more scratch pad registers ?
endif   ;MICROCHANNEL_ADAPTER           ;V1.204

merge_point:                            ;V1.205
		pop     ds

		cmp     ds:warm_boot,1234h ; really a warm boot ?
		je      post_setup_exit ; yes

		xor     di,di           ; no "or_mask"
		call    setup_xmode     ; clear extended mode bits

post_setup_exit:
		ret                     ; return to caller
post_setup      endp


page
;-----------------------------------------------------------------------
;
;       pgm_ext()
;
;       Function:
;          Programs extension register from a table in our code segment.
;
;       Input:
;          cs:si-> offset of table with "idx and_mask" 
;          es:di-> offset of table with "or_mask"
;
;       Returns:
;          dx <- EXTIDX
;          ax, bx, ds preserved
;
;       Remarks:
;          DI=NULL if NO or_mask table is supplied, therefore we skip
;       or'ing it.
;
;
;-----------------------------------------------------------------------
pgm_ext         proc    near
		public  pgm_ext

		push    ax              ; save register
		push    bx
		push    ds              

		push    cs              ; our code segment
		pop     ds              ;   to data segment
clr_x_loop:
	lodsw
	or      ax,ax           ; terminator?
	jz      pgm_ext_done    ; yup,done

	mov     dx,ax

	lodsw                   ; index to al, and_mask to ah

	cmp     dl,Low(CRTIDX)
	jne     PgmExtCheckPelMask

	call    get_crtc_addr
	jmp     short clr_x_do_it
;
pgm_ext_done:   pop     ds              ; restore data seg
		pop     bx
		pop     ax

		ret                     ; return to caller
;
PgmExtCheckPelMask:
	cmp     dl,Low(PELMASK)
	jne     clr_x_do_it

; write 00h to pixel mask register before accessing hidden register
; so that we are able to access it more reliably.
	xor     al,al           ; 0
	set1reg                 ;done

	call    setup_hidden    ;setup hidden register access
				;Note: AND mask is not applied for this reg.
	xor     al,al

	or      di,di           ; or_mask present?
	jz      PgmExtCheckPelMaskDoIt  ; nope
	mov     al,byte ptr es:[di]; or on the data
	inc     di              ; next OR mask

PgmExtCheckPelMaskDoIt:
	set1reg                 ;Set hidden DAC register

	mov     al,0FFh
	set1reg
	jmp     short clr_x_loop

clr_x_do_it:
	mov     bh,ah           ; save and_mask
	call    getreg          ; read the register
	and     ah,bh           ; apply and_mask

	or      di,di           ; or_mask present?
	jz      l1              ; nope, 
	or      ah,byte ptr es:[di]; or on the data
	inc     di              ; next or mask

	cmp     dx,SEQIDX
	jne     set_register
	cmp     al, 16h
	jnz     check_SR0f
	call    chk_mode
	jbe     set_register            ;jump if mode <= 13h with SR16
xmode_sr16_case:
	push    ax
	mov     al,00Fh                 ; if (sr0f[2] = 0)
	call    getscr
	test    ah,004h                 ; is it 70ns dram?
	pop     ax                      ;AL=16, DX=3c4h, AH=value
	jz      is_70ns
	mov     ah,byte ptr es:[di]     ;take SR16/60ns OR data from supp. table
is_70ns:                                ;(V1.301)
	mov     bh, ah                  ;OR_mask value
	and     bh, not SR_16Msk
	call    getscr
	and     ah,SR_16Msk             ;AND_mask
	or      ah, bh                  ;final value for SR16
	setreg                          ; and set it.
	add     si,4                    ;skip SR16/60ns AND table item
	inc     di                      ;skip SR16/60ns OR table item
	jmp     clr_x_loop              ; more extensions ?
;
l1:
	cmp     dx,SEQIDX
	jne     set_register
	cmp     al, 0eh
	je      case_srE_sr1E
	cmp     al, 1eh
	jne     chk_SR16
case_srE_sr1E:
	call    chk_mode
	jbe     skip_setting            ;skip srE,sr1E program if mode <= 13h
	jmp     short set_register

chk_SR16:
	cmp     al, 16h
	jnz     check_SR0f
	call    chk_mode
	ja      set_register            ;jump if mode > 13h with SR16
	mov     bx, offset cgroup:oemsi_tbl + ot_sr16   ;get POST 'OR' table
	mov     ah, byte ptr cs:[bx]            ;AH=final value, AL=index
	mov     bh, ah                  ;OR_mask value
	and     bh, not SR_16Msk
	call    getscr
	and     ah,SR_16Msk             ;AND_mask
	or      ah, bh                  ;final value for SR16
	jmp     short set_register
;
check_SR0f:                             ;ah=final value, al=index
;
;(V1.3) }
	cmp     dl,low(SEQIDX)          ; SR0F being modified?
	jne     set_register            ; no
	cmp     al,00Fh
	jne     set_register

comment %
;##5434(1)## {
	mov     bh, ah                  ;save SRF value
	mov     al, 1fh
	call    getreg
	push    ax                      ;save SR1F value

	mov     ah, bh                  ;set SRF value
	mov     al, 0fh
	setreg

	push    cx                      ;** delay is necessary SRF or SR1F??
	mov     cx, 800h
	loop    $
	pop     cx

	pop     ax                      ;restore SR1F value
;##5434(1)## }
%

set_register:
	setreg                          ; and set it.

skip_setting:

	jmp     clr_x_loop      ; more extensions ?

;
chk_mode:
	push    ds
	push    00h
	pop     ds
assume  ds:VGA_DATA_area
	cmp     video_mode, 13h
	pop     ds
	ret
;
pgm_ext         endp

; This routine sets up access to hidden register
;
setup_hidden    proc    near
		public  setup_hidden

	get1reg                 ;#1
	jmp     short $+2
	jmp     short $+2
	get1reg                 ;#2
	jmp     short $+2
	jmp     short $+2
	get1reg                 ;#3
	jmp     short $+2
	jmp     short $+2
	get1reg                 ;#4
	ret

setup_hidden    endp

VGA_Segment     ENDS
		end


