	INCLUDE PAGE.INC
	SUBTTL	Extensions to VGA Module
;****************************************************************
;
;	$Workfile:   ext.asm  $
; 
; 	Copyright 1989, 1990 Quadtel Corporation.
; 	All rights reserved.
; 
;	Contents:
;	This module supports all of the features or hardware
;	dependent of the VGA BIOS. Features such as backward
;	compatibility, extended video modes, and extended BIOS
;	functions are located within this module.
;
; 	Modification History:
; 	$Log:   M:/vcs/vga/64xx/ext.asv  $
;      
;****************************************************************


	.XLIST
	INCLUDE VGADATA.INC
	include	config.inc
	include	options.inc
	include	biosdata.inc
	include	struc.inc
	.LIST

	%OUT	Assembling Standard EXT Module

cgroup	group	VGA_Segment

VGA_Segment	SEGMENT PUBLIC BYTE

	ASSUME	CS:VGA_Segment
	ASSUME	DS:bios_data
	ASSUME	ES:NOTHING

	extrn	getreg:near
;	extrn	set_user_opts:near
	EXTRN	Disable_DAC_Video:NEAR
	EXTRN	Enable_DAC_Video:NEAR
	extrn	Direct_Video_Interface:near
  ifdef (XGA_BUG)
	extrn	Is_Chip_Unlocked:near
  endif  ;(XGA_BUG)
	extrn	avga_confbyte:byte
	extrn	set_force8:near
	extrn	setup_xmode:near
	extrn	post_setup:near
if (HIGHREFRESHVGA eq YES)
	extrn	get_crtc_addr:near
;	extrn	get_option:near
endif	;(HIGHREFRESHVGA eq YES)
ifdef SCRIDX
	extrn	getscr		:near	; get a value from scratch reg
endif	;SCRIDX
	extrn	ext_alt_sel:near	; our extended functions entry point

	extrn	get_tbl_ptr:near

	extrn	oemsi_tbl:near		; oemsi table

ifdef (MODE_OPTIMIZATION)
	extrn	getchiptype:near
	extrn	setscr:near
	Public is_ram_modetbls
	public Set_refresh_and_pixel_depth
	Public NUM_COLOR_TABLES
	Public Color_Depth_Data
	Public Color_Depth_Registers
	Public CRTC_Refresh_Data
	Public CRTC_Refresh_Registers
	Public NUM_REFRESH_TABLES
NUM_REFRESH_TABLES equ ((offset Color_Depth_Registers - offset CRTC_Refresh_Data)/(offset CRTC_Refresh_Data - offset CRTC_Refresh_Registers))
NUM_COLOR_TABLES equ (offset set_refresh_and_pixel_depth - offset Color_Depth_Data)/((offset Color_Depth_Data - offset Color_Depth_Registers - 1)/2)
endif   ;(MODE_OPTIMIZATION)
	Public get_ext_mode_idx	
;5434	Public is_70Mhz_mode


;-----------------------------------------------------------------------
;
;	Init_Extended_Regs()
;
;	Function:
;	   Called from POST to initialize the chip.
;
;	Input:
;	   DS -> bios data area == 0
;
;	Returns:
;	   Nothing.
;
;-----------------------------------------------------------------------
Init_Extended_Regs	proc	near
		public	Init_Extended_Regs

  if (INT13_FLOPPY_WAKE eq YES)
		push	di
		push	es

		xor	ax,ax			; re-vector int 13h to video
		mov	es,ax			; BIOS

    if (COMPASS_METHOD eq NO)
		push	si			; copy int 13 to int 60h
		mov	si,04Ch
		mov	di,0180h
		movs	word ptr es:[si],es:[di]
		movs	word ptr es:[si],es:[di]
		pop	si
    endif ;(COMPASS_METHOD eq NO)

		mov	di,04Ch
		mov	ax,offset Int13_Handler
		stosw
		mov	ax,cs
		stosw

		pop	es
		pop	di
  endif ;(INT13_FLOPPY_WAKE eq YES)
		mov	dx,SEQIDX	; extensions
		mov	ax,01206h	; extensions enable
		setreg			; enable the extensions

ifdef (XGA_BUG)
		mov	dx,SEQIDX	; enable extention regs
		mov	ax,1206h
		setreg
endif 	;(XGA_BUG)

ifdef Port80Status
	mov	al,85h
	out	80h,al
endif	;Port80Status

		call	post_setup	; setup ALL post registers

		ret
Init_Extended_Regs	endp


if (INT13_FLOPPY_WAKE eq YES)
;-----------------------------------------------------------------------
;
;	Int13_Handler()
;
;	Function:
;		This routine will re-awaken the 46E8h based chip after
;	    every int 13h to cover up the problem with the CL-GD6426.
;
;	Input:
;
;	Returns:
;
;-----------------------------------------------------------------------
if (COMPASS_METHOD eq YES)
disk	label	dword
	dw	0EC59h,0F000h
Int13_Handler:
	pushf
	call	disk			; service int 13h call
else  ;(COMPASS_METHOD eq YES)
Int13_Handler:
	int	60h
endif  ;(COMPASS_METHOD eq YES)

	push	ax
	push	dx
	pushf
	test	dl,080h			; Hard disk request?
	jnz	skip_floppy_bugfix	; yes, no fixup

  if (BIOS_PRODUCT eq BIOS_3C3)
	mov	dx,03C3h		; no, re-awaken video system
	mov	al,1
  else  ;(BIOS_PRODUCT eq BIOS_3C3)
	mov	dx,046e8h		; no, re-awaken video system
	mov	al,8
  endif	;(BIOS_PRODUCT eq BIOS_3C3)
	out	dx,al

skip_floppy_bugfix:
	popf
	pop	dx
	pop	ax
	retf 	2

endif ;(INT13_FLOPPY_WAKE eq YES)

;-----------------------------------------------------------------------
;
;	Get_Extended_Mode()
;
;	Function:
;	   Determine if the specified extended video mode is supported.
;       Standard VGA does not support any extended video modes.
;
;	Input:
;	   AL = Extended Video Mode.
;
;	Returns:
;	   NZ - Mode not supported
;	    Z - Mode supported
;	   ES:SI - Offset to extended mode table
;
;-----------------------------------------------------------------------
Get_Extended_Mode	proc	near
			public	Get_Extended_Mode

	push	ax			; save video mode
	call	get_ext_mode_std	; get extended mode standard table
	mov	si,di			; wants offset in SI!!!!!
	pop	ax			; recover video mode
	ret				; return to caller, AL=return value
Get_Extended_Mode	endp

;-----------------------------------------------------------------------
;
;	Get_Extended_Mode_Info()
;
;	Function:
;	   Get the extended mode information about the specified
;       extended video mode.
;
;	Input:
;	   AL = Extended Video Mode.
;
;	Returns:
;	   AL - Extended mode info
;		D0    = 1=Text mode,  0=Graphics mode
;		D1    = 1=Color mode, 0=Mono mode
;		D2    = 1=Packed pixel, 0=Planar
;		D3    = Reserved
;		D4-D6 = Mode Font
;			00=8x8,  01=8x14, 02=9x14
;			03=8x16, 04=9x16
;		D7    = OEM Reserved Bit
;
;-----------------------------------------------------------------------
Get_Extended_Mode_Info	proc	near
			public	Get_Extended_Mode_Info

		push	bx
		push	cx
		push	dx
		push	ds
		push	es			; save registers
		push	di
		push	si
		call	Get_Extended_Mode	; return ES:DI -> std parms
		jnz	GEM_fail		; not found
		xor	al,al			; init return value
		test	es:vga_std_gr6[di],01h	; graphics mode?
		jnz	chk_color		; nope
		or	al,01h			; set text mode flag
chk_color:	test	es:vga_std_misc_output[di],01h; 3dx addressing?
		jz	chk_packed		; nope
		or	al,02h			; set 3dx addressing
chk_packed:
ifdef	(MODE_OPTIMIZATION)
		call	is_ram_modetbls
		jne	table_is_in_ram
		push	ax			; must read fixup register
		mov	dx,SEQIDX		; directly, and not rely on
		mov	al,004h			; the table setting
		call	getreg
		test	ah,08h
		pop	ax
		jmp	short table_was_in_rom
table_is_in_ram:
endif	;(MODE_OPTIMIZATION)
  		test 	es:vga_std_sr4[di],08h	; chain4 enabled?
table_was_in_rom:
		jz	chk_height		; nope
		or	al,04h			; set packed pixel flag
chk_height:	cmp	es:vga_std_character_height[di],08h; 8x8 char cell?
		je	GEM_done		; yup
		cmp	es:vga_std_character_height[di],14; 8x14 char cell?
		jne	chk_16			; nope 
		or	al,10h			; set 8x14 flag
		jmp	short GEM_done		; done
chk_16:		or	al,30h			; set 8x16 flag
GEM_done:	cmp	al,al			;set Z conditions
		jmp	short GEM_exit
GEM_fail:	push	ax
		or	al,0ffh			;failure
		pop	ax
GEM_exit:	pop	si
		pop	di			; restore registers
		pop	es
		pop	ds
		pop	dx
		pop	cx
		pop	bx
		ret				;return to caller
Get_Extended_Mode_Info	endp


;-----------------------------------------------------------------------
;
;	Get_Curent_Mode_Info()
;
;	Function:
;	   Get the extended mode information about the current
;       extended video mode.
;
;	Input:
;	   AL = Extended Video Mode.
;
;	Returns:
;	   AL - Extended mode info
;		D0    = 1=Text mode,  0=Graphics mode
;		D1    = 1=Color mode, 0=Mono mode
;		D2    = 1=Packed pixel, 0=Planar
;		D3-D7 = Reserved
;
;-----------------------------------------------------------------------
Get_Current_Mode_Info	proc	near
	public	Get_Current_Mode_Info

	push	dx
	push	cx
	push	bx
	mov	bh,ah		;Save entry AH
	xor	bl,bl		;Prepare exit AL value

	mov	dx,3CEh		;Check Grfx:06h Mode
	in	al,dx
	mov	ch,al
	mov	al,06h
	call	getreg
	mov	al,ch
	out	dx,al
	test	ah,01h		;Text/graphics mode?
	jnz	GCMI_Color	;Grfx
	or	bl,EVM_Text	;Text
GCMI_Color:
	mov	dl,Low(3CCh)	;Check MiscOutp 3BX/3DX
	get1reg
	test	al,01h		;3BX/3DX?
	jz	GCMI_Packed	;3BX
	or	bl,EVM_Color	;3DX
GCMI_Packed:
	mov	dl,Low(3C4h)	;Check Sequ:04h Mode
	in	al,dx
	mov	ch,al
	mov	al,04h
	call	getreg
	mov	al,ch
	out	dx,al
	test	ah,08h		;Chain-4 enable?
	jz	GCMI_Done	;16-color 4-plane
	or	bl,EVM_Packed	;flat planar
GCMI_Done:
	mov	ax,bx		;BH = entry AH, BL = flags
;	cmp	ax,ax		;ZF, function successful
GCMI_Exit:
	pop	bx
	pop	cx
	pop	dx
	ret

Get_Current_Mode_Info	endp

;-----------------------------------------------------------------------
;
;	Program_Extended_Mode()
;
;	Function:
;	   Program any extra I/O registers for the specified
;   	extended video mode.
;
;	Input:
;	   AL = Extended Video Mode.
;
;	Returns:
;	   Nothing.
;
;-----------------------------------------------------------------------
Program_Extended_Mode	proc	near
	public	Program_Extended_Mode

ifdef (XGA_BUG)
	call	Is_Chip_Unlocked	; is chipset SVGA?
	je	allow_extended_modes	; yes, allow modes
	jmp	sm_virtual	; no, act like std VGA
allow_extended_modes:
else 	;(XGA_BUG)
	push	ax			; enable extended registers
	mov	dx,SEQIDX
	mov	ax,1206h
	setreg
	pop	ax
endif 	;(XGA_BUG)

	xor	di,di			; assume standard VGA mode
	cmp	al,13h			; standard VGA mode?
	push	ax
	jbe	PEM_std			; yup
	call	get_ext_mode_idx	; return supp parms in ES:DI

ifdef (MODE_OPTIMIZATION)
	call	set_refresh_and_pixel_depth
endif   ;(MODE_OPTIMIZATION)


	add	di,XMODE_REGS_EXTRA	; start of registers

PEM_std:

out_and_done:
;(V1.3) {
	call	get_oemsi_value		; ah = default value
	push	bx
comment %
	push	ax			;al = oemsi POST sr17 value
	call	get_crtc_addr		; read CR27, ID
	mov	al,27h
	call	getreg			;ah=ID
	and	ah, 0fch
	cmp	ah, 0A4h		; 5428 ID?
	pop	ax			;al = oemsi POST sr17 value
	jnz	short skip_sr17_bit0
%
	mov	bl, al			;bl=oemsi sr17 value
	mov	al, 17h			;read sr17
	call	getscr
	and	ah, 0feh		;current reg value
	and	bl, 1			;oemsi sr17 bit0 value
	or	ah, bl
	call	setscr			;program bit0 of sr17
skip_sr17_bit0:
	pop	bx
;(V1.3) }

skip_fine_tuner:

	call	setup_xmode		; program extension registers
	pop	ax

	push	cx			

;	call	getchiptype		; detect chipset

dont_fixup_mode_14:
;	cmp	cl,Avga3b and 0Fh	; is it a 5426/5428?
;	jne	dont_clear_blt_engine	; no, skip this blt terminator
;5434(14){
	mov	al, 17h
	call	getscr
	and	ah, NOT 4		;BLT memory map I/O off
	push	ax			;ah=SR17 value, al = 17h
       ASSUME	DS:VGA_Data_Area
	mov	al, Video_Mode
       ASSUME	DS:bios_data
	cmp	al, 13h
	jbe	no_DAC_down
	call	get_ext_mode_idx	; return supp parms in ES:DI
	cmp	es:[di].s_colors, 8	;8-bit colors
	jbe	no_DAC_down
	pop	ax
	and	ah, NOT 2		;DAC power-down
	jmp	short reset_SR17
no_DAC_down:
	pop	ax
reset_SR17:
	call	setscr
;
	mov	ax, 000Fh		;GRF = 0
	mov	dl, low(GFXIDX)
	setreg
	call	get_crtc_addr
;v1.10A3mov	ax, 001Ch		;CR1C=0
;v1.10A3setreg
	mov	ax, 001Dh		;CR1D=0
	setreg
;5434(14)}
	mov	ax,00031h		; yes, terminate blt @ end of scanline
	mov	dl,low(GFXIDX)
	setreg
	mov	cx,0ffffh		; set loop terminator
wait_till_status_clear:
	dec	cx			; decrement loop terminator
	cmp	cx,0			; is it zero?
	je	dont_clear_blt_engine	; yes, break out of look
	call	getreg			; no, wait until blt is done
	test	ah,1
	jnz	wait_till_status_clear
dont_clear_blt_engine:
	pop	cx

ifdef (MODE_OPTIMIZATION)
	call	clear_hdw_cursor_and_page_reg
endif   ;(MODE_OPTIMIZATION)

if (HIGHREFRESHVGA eq YES)
	call	HighRefSetup
endif	;(HIGHREFRESHVGA eq YES)

;#5434(7)# {
       ASSUME	DS:VGA_Data_Area
	mov	al, Video_Mode
       ASSUME	DS:bios_data
	cmp	al, 6Dh
	jz	is_mode6D6C
	cmp	al, 6Ch
	jnz	not_Mode6D6C_60hz
is_mode6D6C:
;5434(13+){
	call	get_ext_mode_idx	; return supp parms in ES:DI
ifdef (ALP_NEW)
	test	es:[di].s_monlist,030h	; check if 87i
else	; (ALP_NEW)
	test	es:[di].s_monlist,03h	; check if 87i
endif	; (ALP_NEW)
	jz	not_Mode6D6C_60hz	; jump if 87i
;
	mov	dl, 0d4h
       ASSUME	DS:VGA_Data_Area
	mov	al, Video_Mode
       ASSUME	DS:bios_data
	cmp	al, 6dh
	jz	is_6Dh
is_6Ch:
	mov	ax, 5013h
	out	dx, ax
	mov	ax, 9f01h
	out	dx, ax
	mov	ax, 0a002h
	out	dx, ax
	jmp	short is_6Ch_6Dh
is_6Dh:
ifdef (ALP_NEW)
	mov	al, es:[di].s_monlist
	and	al, 070h
	cmp	al, 10h
	je	short ItIs60Hz
else	; (ALP_NEW)
	test	es:[di].s_monlist,02h
	jz	short ItIs60Hz
endif	; (ALP_NEW)
;v1.10A3mov	ax,5204h
;v1.10A3out	dx,ax
;v1.10A3mov	ax,1D05h
;v1.10A3out	dx,ax
comment	%
;v0.041{
	push	dx
	mov	dl,0C4h
	mov	ax,3816h
	out	dx,ax
	pop	dx
;v0.041}
%
ItIs60Hz:
	mov	ax, 0a013h
	out	dx, ax
	mov	ax, 4F01h
	out	dx, ax
	mov	ax, 05002h
	out	dx, ax
is_6Ch_6Dh:
	mov	ax, 0E717h
	out	dx, ax
;
	mov	al,011h				; write protect regs
	call	getreg
	or	ah, 80h
	setreg
not_Mode6D6C_60hz:
;
;#5434(7)# }
;

;	call	set_user_opts		; set the user options

sm_virtual:
	ret		    		; to caller
Program_Extended_Mode	endp


;-----------------------------------------------------------------------
;
;	get_oemsi_value()
;
;	Function:
;	   This local procedure will grab the value for sr16 in the oemsi
;	   table used at post time.
;
;	Input:
;
;	Returns:
;	   AH = oemsi value for sr16
;
;	Remarks:
;	   
;-----------------------------------------------------------------------
	public	get_oemsi_value
get_oemsi_value proc near
	push	di			; set default value
	mov	di,offset oemsi_tbl
	mov	ah,cs:ot_sr16[di]
	mov	al,cs:ot_sr17[di]	;(V1.3)
	pop	di
	ret
get_oemsi_value endp

;-----------------------------------------------------------------------
;
;	is_70Mhz_mode()
;
;	Function:
;	   This function will determine if the mode pointed to by es:di
;	   is a mode that requires > 70MHz dot clock.
;
;	Input:
;	   ES:DI = ptr to extended mode table
;
;	Returns:
;	   Flags showing the comparison of the modes clock value and 70mhz
;
;	Remarks:
;	   ax,dx - Soiled
;	   
;-----------------------------------------------------------------------
comment %
is_70Mhz_mode proc near
	push	cx
	mov	al,es:[di].s_msrvalue	; find out which clock
	and	al,00Ch			
	cmp	al,00Ch			; is it the extended clock?
	mov	al,0			; default < 70Mhz
	jne	return_mhz_detect	; no, must not be > 70MHz

	mov	ch,es:[di].s_sr1E	; get denominator
	test	ch,1			; multiply by 2?
	jnz	mult_by_2		; yes, double denominator
	shr	ch,1			; no, use current value
	jmp	short denominator_done
mult_by_2:
	and	ch,0FEh			; mult by 2 value 
denominator_done:

	mov	al,es:[di].s_sr0E	; al = numerator
	xor	ah,ah
	div	ch			; al will contain the dot clock
return_mhz_detect:
	cmp	al,005h			; is the dot clock > 70MHz?
	pop	cx
	ret
is_70Mhz_mode endp
%

ifdef (MODE_OPTIMIZATION)
;-----------------------------------------------------------------------
;
;	is_ram_modetbls()
;
;	Function:
;	   This function will determine if the current pointers to the 
;	   supplemental structure is in ram or rom.
;
;	Input:
;	   ES: = Segment of this mode's supplemental structure entry
;
;	Returns:
;	   Flags showing the comparison of CS and ES
;
;	Remarks:
;	   
;-----------------------------------------------------------------------
is_ram_modetbls proc near
	push	ax
	push	bx
	mov	ax,cs
	mov	bx,es
	cmp	ax,bx
	pop	bx
	pop	ax
	ret
is_ram_modetbls	endp


;-----------------------------------------------------------------------
;
;	Set_Refresh_Rate_and_Pixel_Depth()
;
;	Function:
;	   This function will fixup the current mode currently being 
;       displayed.  Pixel depth and refresh rate fixups will be made, as well
;       as resetting the msr value and the palette.
;
;	Input:
;	   ES:DI = Pointer to this mode's supplemental structure entry
;
;	Returns:
;	   Nothing.
;
;	Remarks:
;	   The refresh rates of 36.0 and 45.0 are not needed, as those are
;       the values in the standard mode parameters in ana_ext.inc.  Same
;       idea holds true for the x16 color fixups.  The parameter tables used
;	in this scheme are ordered as follows:
;
;	   Offset 0 : Standard mode 12h (640 x 480 x 16 x 25MHz)
;	   Offset 1 : Standard mode 13h (320 x 200 x 256, not used)
;	   Offset 2 : (132 x 25 Text)
;	   Offset 3 : (132 x 43 Text)
;	   Offset 4 : (132 x 25 Text)
;	   Offset 5 : (800 x 600 x 16 x 36MHz)
;	   Offset 6 : (1024 x 768 x 16 x 44.9MHz)
;	   Offset 7 : (1280 x 1024 x 16 x 75MHz)
;	   Offset 8 : (320 x 200 x 16M x 25MHz)
;
;	   This design calls for the useage of s_ref_param in the supplemental
;   	structure for each mode.  The most significant nibble determines 
;	which CRTC_Refresh_Data to use, while the least significant nibble
;	determines what mode entry in the parameter list to use (described
; 	above).  A value of 0Fh in either nibble directs this routine to make
;	no fixup (as in the case of 36.0 MHz).  Pixel depth fixup is based
;	upon s_colors in the supplemental structure.  
;
;	   The code below ALWAYS relies on the high refresh table at offset
; 	5.  This must always be kept true.
;
;	Note that the entry for 76Hz isnt used by anyone.  This is to allow 
;	oemsi users to modify modes with special parameters.  This space will
;	accomidate that need.
;	   
;-----------------------------------------------------------------------

   db	offset CRTC_Refresh_Data - $ - 1
CRTC_Refresh_Registers:
   db   000h,003h,004h,005h,006h,007h,009h,010h,012h,015h,016h,011h,01Ch

CRTC_Refresh_Data:
;??db	064h,088h,053h,09Bh,0F2h,01Fh,040h,0E0h,0DFh,0DFh,0F3h,083h,000h ;75Hz   /640*480*64K-#0
;B1db	064h,087h,054H,09CH,0F2H,01FH,040H,0E1h,0DFh,0E7h,0EBh,004h,000h ;75Hz   /640*480
   db	064h,088h,053H,09BH,0F2H,01FH,040H,0E0h,0DFh,0DFh,0F3h,083h,002h ;75Hz   /640*480
   db	064h,087h,054H,09CH,0F2H,01FH,040H,0E1h,0DFh,0E7h,0EBh,004h,005h ;75Hz   /640*480
   db	05Fh,082h,054H,09FH,00BH,03EH,040H,0EAh,0DFh,0E7h,004h,08Ch,000h ;60 Hz  /640*480*16M(*64K)-#2
   db	07Bh,09Eh,068h,091h,06Fh,0F0h,060h,058h,057h,058h,06Fh,08Ah,000h ;56 Hz/800*600*64K-#3
   db	05Fh,082h,053h,09Fh,00Bh,03Eh,040h,0EAh,0DFh,0E7h,004h,08Ch,000h ;60 Hz/640x480x16M-#4
;
   db	07Fh,082h,06Bh,01Bh,072h,0F0h,060h,058h,057h,058h,072h,08Ch,004h ;60 Hz/800*600*64k-#5
   db	07Dh,080h,06Dh,01Ch,098h,0F0h,060h,07Ch,057h,05Fh,091h,082h,000h ;72 Hz/800*600*16-#6
   db	07Fh,082h,068h,012h,06Fh,0F0h,060h,058h,057h,057h,06Fh,08Bh,000h ;75 Hz/800*600*16-#7
   db	0A3h,086h,085h,096h,024h,0FDh,060h,002h,0FFh,000h,024h,088h,000h ;60 Hz/1024*768-#8
   db	0A1h,084h,085h,096h,024h,0FDh,060h,002h,0FFh,000h,024h,088h,000h ;70 Hz/1024*768-#9
;
   db	0A1h,084h,085h,093h,02Ah,0FDh,060h,012h,0FFh,000h,02Ah,089h,000h ;72 Hz/1024*768*256-#A
   db	09Fh,082h,084h,090h,01Eh,0F5h,060h,000h,0FFh,0FFh,01Eh,093h,000h ;75 Hz/1024*768*256-#B
   db   099h,09Ch,084h,01Ah,096h,01Fh,040h,080h,07Fh,080h,096h,084h,000h ;87i  /1024*768*64K-#C
   db   0BDh,080h,0A5h,01Ah,02Ah,0B2h,060h,00Bh,0FFh,000h,02Ah,080h,000h ;87i   /1280*1K*256-#D
   db	0D2h,095h,0A2h,081h,014h,0B2h,060h,005h,0FFh,000h,012h,00Bh,000h ;60  Hz/1280*1K*16-#E(#5434(7)#)
;
   db	063h,09Ah,053h,01Eh,014h,0B2h,060h,003h,0FFh,000h,012h,007h,004h ;60  Hz/1280*1K*256-#F(#5434(7)#)
   db	063h,09Ah,052h,01Eh,014h,0B2h,060h,003h,0FFh,000h,012h,007h,001h ;71.2Hz/1280*1K*256-#10
   db	064h,09Ah,052h,01Bh,015h,0B2h,060h,000h,0FFh,000h,012h,001h,007h ;75  Hz/1280*1K*256-#11 5434CK
;B1db	063h,086h,055h,09Ah,006h,03Eh,040h,0E8h,0DFh,0E7h,0FFh,00Bh,000h ;72 Hz/640x480x32K/64K-#12
   db	063h,086h,054h,099h,006h,03Eh,040h,0E9h,0DFh,0E8h,0FFh,08Ch,003h ;72 Hz/640x480x32K/64K-#12
;??db	064h,086h,055h,09Ah,006h,03Eh,040h,0E8h,0DFh,0E7h,0FFh,08Bh,000h ;72 Hz/640x480x2/16/256/16M+ -#13
   db	07Fh,082h,06Ah,01Ah,072h,0F0h,060h,058h,057h,058h,072h,08Ch,000h ;60 Hz/800*600*32K/64K-#13 v1.10B5
   db	05Fh,082h,053h,09Fh,00Bh,03Eh,040h,0EAh,0DFh,0E7h,004h,08Ch,004h ;60 Hz/640*480-#14 v1.11B1

;; db   000h,003h,004h,005h,006h,007h,009h,010h,012h,015h,016h,011h,01Ch

Color_Depth_Registers:
	db	0C4h,004h	; SR04
	db	0CEh,005h	; GR5
	db	0CEh,006h	; GR6
	db	0D4h,013h	; CR13 (shift left value)
	db	000h		; terminator

Color_Depth_Data:
;	db	006h,000h,005h,000h  ; x16
	db	00Eh,040h,005h,001h  ; x256
;v0.073db	00Eh,040h,007h,002h  ; xDirect
	db	00Eh,040h,005h,002h  ; xDirect  ;v0.073
	db	00Eh,000h,005h,008h  ; x16M

set_refresh_and_pixel_depth proc near
	push	ax
	push	cx
	push	dx
	push	si

	call	is_ram_modetbls			; ES pointing to RAM?
	je	continue_with_table_fixups	; no, fix color and refresh
	jmp	mode_fixup_done			; yes, load normal table

continue_with_table_fixups:
	mov	dh,003h				; all io is on 3xxh

;-----------------------------------------------------------------------
;  Fixup Pixel Depth
;-----------------------------------------------------------------------
	mov	al,es:[di].s_colors		; al = bits per color
	cmp	al,4				; depth > 16 colors?
	jbe	no_color_fixup_needed		; no, skip fixup
	push	di				; preserve di
	mov	si,offset Color_Depth_Registers ; si = ptr to registers
	mov	di,offset Color_Depth_Data	; di = ptr to data
	mov	cx,00002h			; set data offset to 16M
	cmp	al,018h				; 16 Million colors?
	je	got_offset			; yes, found depth
	dec	cx				; no, set 64K/32K colors
	cmp	al,008h				; Direct Color ?
	ja	got_offset			; yes, found depth
	dec	cx				; no, set 256 colors
got_offset:
	mov	al,004h 			; ax = width of data entries
	mul	cl				; ax = offset to add to di
	add	di,ax				; add it!
	mov	cx,00003h 			; write out three values
	
pixel_depth_loop_head:
	lods	byte ptr cs:[si]		; dl = io address to write
	mov	dl,al
	mov	ah,byte ptr cs:[di]
	inc	di
	lods	byte ptr cs:[si]		; al = index to write
	setreg					; do the out
	loop	pixel_depth_loop_head
;5434(15){
	mov	dl,0D4h				; AX = CR13 data and index
	mov	al,13h
       ASSUME	DS:VGA_Data_Area
	mov	cl, Video_Mode
       ASSUME	DS:bios_data
	mov	ah, 0A0h			;0A0h for offset reg (CR13+CR1B)
	cmp	cl, 76h				;640*480*32bit mode?
	jz	set_CRT13
	mov	ah, 0C8h			;0C8h for offset reg
	cmp	cl, 72h				;800*600*32bit mode?
	jz	set_CRT13
;5434(15)}
	mov	cl,byte ptr cs:[di]
	call	getreg
	shl	ah,cl				; shift the value in ah
set_CRT13:
	setreg					; and write it out
	pop	di	
no_color_fixup_needed:

;-----------------------------------------------------------------------
;  Fixup Refresh Rate
;-----------------------------------------------------------------------
ifdef (ALP_NEW)
	mov	al,es:[di].s_ref	; get the freqency param from table
	and	al,0FFh			; mask off the table offset bits
	cmp	al,0FFh			; is a valid freqency value there?
else	; (ALP_NEW)
	mov	al,es:[di].s_ref_param	; get the freqency param from table
	and	al,0F0h			; mask off the table offset bits
	cmp	al,0F0h			; is a valid freqency value there?
endif	; (ALP_NEW)
	je	no_refresh_fixup_needed	; no, skip the fixup
	call	output_new_refresh	; yes, do the fixup
no_refresh_fixup_needed:

;-----------------------------------------------------------------------
;  Fixup Miscellaneous Register
;-----------------------------------------------------------------------
	mov	dl,0C2h
	mov	al,es:[di].s_msrvalue
	set1reg

;-----------------------------------------------------------------------
;  Fixup Attribute Controller regs
;-----------------------------------------------------------------------
	cmp	es:[di].s_colors,4	; depth > 16 colors?
	jbe	skip_palette_fixup	; no, skip the fixup

	mov	dl,0DAh			; all modes are color
	in	al,dx			; reset flip flop
	mov	cl,00Ah
	mov	al,006h
	mov	dl,0C0h
palette_loop_head:
	set1reg				; set palette index
	set1reg				; set data to index value
	inc	ax			; and bump it up one
	loop	palette_loop_head

	mov	al,10h			; Index 10
	set1reg
	mov	al,41h			; gets 41h
	set1reg
skip_palette_fixup:

;-----------------------------------------------------------------------
;  Fixup 5420r1 Clock Divide Problem
;-----------------------------------------------------------------------
mode_fixup_done:
	pop	si
	pop	dx
	pop	cx
	pop	ax
	ret
set_refresh_and_pixel_depth endp
 

;
;
ifdef (ALP_NEW)

;-----------------------------------------------------------------------
;
;	output_new_refresh()
;
;	Function:
;
;	Input:
;	   AL = 00000000b, 
;
;	Returns:
;	   AX = Soiled
;	   DL = Soiled
;
;	Remarks:
;	   
;-----------------------------------------------------------------------
output_new_refresh proc near
	push	cx
	push	di
	call	get_crtc_addr
;	mov	dl,0D4h				; all modes are color
	mov	si,offset CRTC_Refresh_Registers
	mov	di,offset CRTC_Refresh_Data
	mov	cx,offset CRTC_Refresh_Data - offset CRTC_Refresh_Registers
	mul	cl
	add	di,ax				; di = di + offset

	mov	al,011h				; un-write protect regs
	call	getreg
	and	ah,not 080h
	setreg
refresh_loop_head:
	mov	ah,byte ptr cs:[di]		; buzz the table
	inc	di
	lods	byte ptr cs:[si]
	setreg					; and write out the value
	loop	refresh_loop_head

	pop	di	
	pop	cx
	ret
output_new_refresh endp
;
else	; (ALP_NEW)
;-----------------------------------------------------------------------
;
;	output_new_refresh()
;
;	Function:
;
;	Input:
;	   AL = 0000xxxxb, where x = dont care and 0 = table offset
;	   DH = 003h
;
;	Returns:
;	   AX = Soiled
;	   DL = Soiled
;
;	Remarks:
;	   
;-----------------------------------------------------------------------
output_new_refresh proc near
	push	cx
	mov	cl,004h				; shift value for al
	shr	al,cl				; [7:4] -> [3:0]
	push	di
	mov	dl,0D4h				; all modes are color
	mov	si,offset CRTC_Refresh_Registers
	mov	di,offset CRTC_Refresh_Data
	mov	cx,offset CRTC_Refresh_Data - offset CRTC_Refresh_Registers
	mul	cl
	add	di,ax				; di = di + offset

	mov	al,011h				; un-write protect regs
	call	getreg
	and	ah,not 080h
	setreg
refresh_loop_head:
	mov	ah,byte ptr cs:[di]		; buzz the table
	inc	di
	lods	byte ptr cs:[si]
	setreg					; and write out the value
	loop	refresh_loop_head

	pop	di	
	pop	cx
	ret
output_new_refresh endp
endif	; (ALP_NEW)

;-----------------------------------------------------------------------
;
;	clear_hdw_cursor_and_page_reg()
;
;	Function:
;	   This function will clear out SR10-SR13, and GR09-GR0A.  It should
;	be called during every setmode.
;
;	Input:
;	   Nothing.
;
;	Returns:
;	   Nothing.
;
;	Remarks:
;	   
;-----------------------------------------------------------------------
clear_hdw_cursor_and_page_reg proc near
	push	ax
	push	cx
	push	dx

	mov	dx,SEQIDX 			; clear SR10 through SR13
	mov	ax,00010h
	mov	cx,4
blast_seqencer:
	setreg
	inc	ax
	loop	blast_seqencer

	mov	cl,2				; clear GR09 and GR0A
	mov	dl,Low(GFXIDX)
	mov	al,9
blast_graphics_controller:
	setreg
	inc	ax
	loop	blast_graphics_controller

	pop	dx
	pop	cx
	pop	ax
	ret
clear_hdw_cursor_and_page_reg endp
endif   ;(MODE_OPTIMIZATION)

if (HIGHREFRESHVGA eq YES)
;-----------------------------------------------------------------------
;
;	HighRefSetup()
;
;	Function:
;
;	Input:
;
;	Returns:
;
;-----------------------------------------------------------------------
HighRefSetup	proc	near
	call	is_640x480		; skip if not 640x480 modes
	jnz	HighRefExit		; nope, set normal refresh 
	mov	al,HIGHREF_R
	call	getscr
	and	ah,01h			;Check high-refresh bit (bit0)
	jz	HighRefExit

	mov	dl,Low(SEQIDX)
	mov	al,07h			;Get SR07
	call	getreg
	and	ah,0Eh
	cmp	ah,04h			;24-bit mode?
	jz	HighRefExit		;We don't do highref on 24-bit

      ASSUME	DS:VGA_Data_Area
	mov	al,00h			; Set table entry #0; 75Hz
	call	Detect72Hz75Hz
	jnz	ItIs75Hz
	mov	al,12h			; Set table entry #12; 72Hz
ItIs75Hz:
	cmp	Video_Mode,064h		; Is mode 640x480x64K?
	jz	SetHighRef
	cmp	Video_Mode,066h		; Is mode 640x480x32K?
	jz	SetHighRef
      ASSUME	DS:bios_data

	mov	al,01h			; Set table entry #1; 75Hz
	call	Detect72Hz75Hz
	jnz	SetHighRef
;v1.10B4mov	al,13h			; Set table entry #13; 72Hz
	mov	al,12h			;v1.10B4
SetHighRef:
	call	output_new_refresh	; Set table entry #5
;v1.11B1{
	call	Detect72Hz75Hz
	jz	Not75Hz
	mov	ax,221Bh
	out	dx,ax			; CR1B = 22h
Not75Hz:
;v1.11B1}
	mov	dl,Low(3CCh)		; Fixup SR0E/1E if needed
	get1reg
	and	al,00Ch			; Get clock bits only
	cmp	al,00Ch			; is it clock 3?
	je	must_be_clk3		; yes, must have been mode 64/66
	get1reg				; no, re-read the register
	and	al,0F3h			; Select clk0
	or	al,008h			; Select clk2
	mov	dl,Low(3C2h)
	set1reg
	jmp	short HighrefExit
must_be_clk3:
	shr	al,1			; Now convert clk3 for highrefresh
	shr	al,1
;	cmp	al,01h			; ClkSel 1 or 2?
;	jbe	HighRefExit		; yes, for get the fixup
	add	al,1Bh			; no, setup xDh or xEh

	mov	dl,Low(SEQIDX)		; read the register
	call	getreg

	mov	bx,ax
	and	ah,3Eh
	mov	al,80*256/100		; Divide denominator by .8, which
					; boosts clock by 1.25
	mul	ah			; AH = new D
	inc	ah			; Round up
	and	ah,3Eh			; Get it in bits [5:1]
	and	bh,01h			; Restore /2 bit
	or	ah,bh
	mov	al,bl			; Get back index
	setreg			 	; Set new clock

HighRefExit:
	ret

HighRefSetup	endp

;-----------------------------------------------------------------------
;v1.10A3{
public	Detect72Hz75Hz

Detect72Hz75Hz	proc	near
	push	dx
	push	ax
	mov	al,14h
	mov	dx,3C4h
	call	getreg
	and	ah,18h
	pop	ax
	pop	dx
	ret
Detect72Hz75Hz	endp
;v1.10A3}

;-----------------------------------------------------------------------
;
;	is_640x480()
;
;	Function:
; 		This routine checks if we are running at 640x480 mode to
;	support high refresh parameters.
;
;	Input:
;
;	Returns:
;		ZR	Yes
;		NZ	No
;
;-----------------------------------------------------------------------
is_640x480 	proc	near

	mov	al,con_mode		; get current mode in al
	cmp	al,13h
	jbe	i64_001			; standard VGA modes

	; extended modes
	call	get_ext_mode_idx	; return supp parms in ES:DI
	cmp	es:[di].s_horz,640	; horizonal resolution=640?
	jnz	i64_exit		; nope

	cmp	es:[di].s_vert,480	; vertical resolution=480?
	jmp	short i64_exit		; set zero flag anyway

i64_001:
	; check if VGA modes 11h/12h
	cmp	al,12h			; mode 12h
	jz	i64_exit		; yes

	cmp	al,11h			; mode 11h

i64_exit:	ret	

is_640x480	endp
endif	;(HIGHREFRESHVGA eq YES)

;-----------------------------------------------------------------------
;
;	Extended_Altsel()
;
;	Function:
;	   Our extended BIOS functions support.
;
;	Input:
;	   INT 10h entry point args.
;
;	Returns:
;	   Nothing.
;
;-----------------------------------------------------------------------
Extended_Altsel proc	near
		public	Extended_Altsel

	ret		; return to caller, handled in Video_VGA_Information

Extended_Altsel endp

;-----------------------------------------------------------------------
;
;	get_ext_mode_idx()
;
;	Function:
;	   Compute the parameter table number to use on mode set
;
;	Input:
;	   al -> extended video mode number
;	   ds -> 0
;
;	Returns:
;gdl	   al 	-> the table number
;	   es:di-> pointer to extended mode supplemental parameters
;
;	   Z  for success	
;	   NZ for failure
;
;	Remarks:
;
;-----------------------------------------------------------------------
get_ext_mode_idx	proc	near
		push	cx		; save register
		push	dx
if EXT_VIDMODES eq YES	  
		mov	cl,al		; mode number
		and	cl,7fh		; just the mode number

		cmp	cl,13h		; standard vga mode?
		jbe	chk_sv		; yes

ext_enabled:	mov	ah,12h		; xaltsel
		mov	al,cl		; mode# requested
 		push	bx
		mov	bl,0a0h		; query video mode availability
		push	ds		; save ds (bl=a0h returns ds)
		pushf
		push	cs
		call	Direct_Video_Interface
		pop	ds		; restore ds
		pop	bx
		test	ah,01h		; is the mode available ?
		jz	ext_fail	; no

chk_sv:
		mov	al,000h		;Assume it's a valid table
		cmp	di,0FFFFh	;See if DI = valid table
		jne	ext_exit	;Yes, it's valid

endif
ext_fail:      	or	al,0ffh		; failure
ext_exit:	mov	ah,00h		; byte return value

		or	al,al		;gdl:0 = valid, FF = invalid

		pop	dx		; restore registers
		pop	cx		; restore registers
		ret			; return to caller
get_ext_mode_idx        endp


;-----------------------------------------------------------------------
;
;	get_ext_mode_std()
;
;	Function:
;	   Compute the parameter table number to use on mode set
;
;	Input:
;	   al -> extended video mode number
;	   ds -> 0
;
;	Returns:
;	   es:di-> pointer to extended mode supplemental parameters
;
;	   Z  for success	
;	   NZ for failure
;
;	Remarks:
;
;-----------------------------------------------------------------------
			public	get_ext_mode_std
get_ext_mode_std	proc	near
if EXT_VIDMODES eq YES	  
		push	ax
		call	get_ext_mode_idx; index number returned in AL
		pop	ax
		jnz	get_ems_exit	; not found

		push	cx
		push	bx
		mov	ch,al		;CH = mode to get
		mov	bh,00h		;Get standard parameter tables
		call	get_tbl_ptr	;Get ES:DI = standard mode table
		pop	bx
		pop	cx

		cmp	al,al		;ZF true.  Mode is found.

else
		or	al,0ffh		; NZ == failure
endif
get_ems_exit:	ret			; return to caller
get_ext_mode_std        endp


;-----------------------------------------------------------------------
;
;	Configure_Chip_Options()
;
;	Function:
;	   Called from post to at the beginning.
;
;	Input:
;	   Nothing.
;
;	Returns:
;	   Nothing.
;
;	Remarks:
;
;-----------------------------------------------------------------------
	Public	Configure_Chip_Options
Configure_Chip_Options	proc	near

		ret
Configure_Chip_Options        endp


;-----------------------------------------------------------------------
;
;	GetMemSize()
;
;	Function: Returns the amount of memory installed on the card.
;
;	Entry:	none
;	Exit:	AL = number of 64K blocks of memory
;
;-----------------------------------------------------------------------
		public	GetMemSize
GetMemSize	proc	near
	push	dx
	push	cx

	mov	ch,ah		;Preserve entry AH

;	mov	al,04h

ifdef (ALP_NEW)
	mov	al,MEM_SIZE_R	;SP_OPT4
else	; (ALP_NEW)
	mov	al,0Ah		;SR0a:scratch pad 1
endif	; (ALP_NEW)
	call	getscr
ifdef (ALP_NEW)
	and	ah,00Fh		;#5434(9)# only bit 3:5
else	; (ALP_NEW)
	and	ah,38h		;#5434(9)# only bit 3:5
	mov	cl,3
	shr	ah,cl
endif	; (ALP_NEW)

	mov	cl,ah		;Prepare shift count for calculation
	mov	al,04h		;256K
	shl	al,cl		;Shift left to calc total memory size
GetMemSizeDone:

	mov	ah,ch		;Retrieve entry AH
	pop	cx
	pop	dx
	ret
GetMemSize	endp

;-----------------------------------------------------------------------

VGA_Segment	ENDS
	END

