	INCLUDE PAGE.INC	    
	SUBTTL	Standard VGA BIOS OEM Module
;****************************************************************
;
;	$Workfile:   54xx.asm  $
; 
; 	Copyright 1989, 1990 Quadtel Corporation.
; 	All rights reserved.
; 
;	Contents:
;	This module supports all of the features or hardware
;	dependent of the VGA BIOS. Features such as backward
;	compatibility, extended video modes, and extended BIOS
;	functions are located within this module.
;
; 	Modification History:
; 	$Log:   M:/vcs/vga/54xx/54xx.asv  $
;      
;         Rev 1.2   23 Jul 1991 20:38:24   dale
;      A Hook was added for Font Fixup.
;      
;         Rev 1.1   03 Jun 1991 17:15:44   Darryl
;      $UPDATE:VGA BIOS core revision 11 modifications.
;      Added the following core hook stubs:
;      
;      	Extended_Altsel
;      	Extended_Restore_State
;      	Extended_Save_Size
;      	Extended_Save_State
;      $
;      
;         Rev 1.0   21 Dec 1990 14:03:50   Darryl
;      Initial checkin to VCS.
;      
;****************************************************************

	.XLIST
	INCLUDE VGADATA.INC
	include	config.inc
	include	biosdata.inc
	include options.inc
	include	struc.inc
	.LIST

	%OUT	Assembling Standard VGA Chip Set Module

cgroup	group	VGA_Segment

VGA_Segment	SEGMENT PUBLIC BYTE

	ASSUME	CS:VGA_Segment
	ASSUME	DS:VGA_Data_Area
	ASSUME	ES:NOTHING

	PUBLIC	Enable_8Bit_Memory
	PUBLIC	Enable_VGA
	PUBLIC	Extended_Scroll_Up
	PUBLIC	Extended_Scroll_Down
	PUBLIC	Extended_Read_Dot
	PUBLIC	Extended_Write_Dot
	PUBLIC	Extended_Write_Char
	PUBLIC	Extended_Write_Char_Attr
	PUBLIC	Extended_Read_Char
	PUBLIC	Extended_Clear_Video
ifndef	(REMOVE_MEMORY_TEST)
	PUBLIC	Extended_Test_Video_Memory
endif	;(REMOVE_MEMORY_TEST)
	PUBLIC	Monitor_Type
	PUBLIC	Scroll_Up_One_Line

	EXTRN	Clear_DAC_Video:NEAR
	EXTRN	Clear_Screen:NEAR
	extrn	Clear_Screen_Exit:near
	EXTRN	Default_VGA_Scroll_Up:NEAR
	EXTRN	Default_VGA_Scroll_Down:NEAR
	EXTRN	VGA_Scroll_Up:NEAR		;gdl:12/03/91
	EXTRN	VGA_Scroll_Down:NEAR
	EXTRN	Default_VGA_Read_Dot:NEAR
	EXTRN	Default_VGA_Write_Dot:NEAR
	EXTRN	Default_VGA_Write_Char:NEAR
	EXTRN	Default_VGA_Write_Char_Attr:NEAR
	EXTRN	Default_VGA_Read_Char:NEAR
	EXTRN	Default_Clear_Video:NEAR
	EXTRN	Default_CGA_Write_Char:NEAR
	EXTRN	Default_CGA_Write_Char_Attr:NEAR
	EXTRN	Default_CGA_Read_Char:NEAR
	EXTRN	VGA_Read_Dot:NEAR
	EXTRN	VGA_Write_Dot:NEAR

	EXTRN	Determine_Analog_Monitor:NEAR
	EXTRN	Disable_DAC_Video:NEAR
	EXTRN	Enable_DAC_Video:NEAR
	EXTRN	Gate_Timer:NEAR
	EXTRN	POD_Video_Off:NEAR
	EXTRN	Quadtel_Msg:BYTE
	EXTRN	Read_Reg:NEAR
	EXTRN	Read_Reg_NI:NEAR
	EXTRN	Write_DAC:NEAR
	extrn	Direct_Video_Interface:near
	extrn	Get_Extended_Mode_Info:near
	EXTRN	Get_Current_Mode_Info:NEAR
ifndef	(REMOVE_MEMORY_TEST)
	extrn	Test_Video_Memory:near
endif	;(REMOVE_MEMORY_TEST)
	extrn	GetMemSize:near
	extrn	getreg:near
	extrn	is_graphics:near
	EXTRN	INT_Address:WORD
	EXTRN	Segment_A000:WORD
	EXTRN	BIOS_Address:WORD
	extrn	avga_confbyte:byte
	extrn	GetChipType:near
	extrn	setscr:near
	extrn	getscr:near
	extrn	Video_Set_Mode:near
if (MAXMEMSIZE gt 256)
	extrn	Set64KPage:near
	extrn	Inc64KPage:near
endif	;(MAXMEMSIZE gt 256)
ifdef VESAVBEVERSION
	extrn	VesaVBE:near
endif	;VESAVBEVERSION
	extrn	get_extended_mode:near
	extrn	program_extended_mode:near
	extrn	set_vga_registers:near
 	extrn	xmode_regs:near
	extrn	get_ext_mode_idx:near
ifdef	(MODE_OPTIMIZATION)
	extrn 	set_refresh_and_pixel_depth:near
endif	;(MODE_OPTIMIZATION)


;****************************************************************
;		P O S T   S U P P O R T
;****************************************************************

;-----------------------------------------------------------------------
;
;	Enable_8bit_Memory()
;
;	Function:
;	   This routine will disable 16-bit memory.
;
;	Input:
;	   Nothing
;
;	Returns:
;	   Nothing
;
;-----------------------------------------------------------------------
Enable_8bit_Memory	PROC	NEAR
	mov	al,1
	extrn	set_force8:near
	call	set_force8
	RET
Enable_8bit_Memory	ENDP

;****************************************************************
;   Enable the VGA adapter. On power-up, the VGA system is
;   disabled.
;****************************************************************

Enable_VGA	PROC	NEAR

	PUSHF
	CLI

if (VSEnable eq 3C3h)
  if (LOCAL_BUS_WAKE eq YES)
	mov	dx,VSEnable
	mov	al,018h
	out	dx,al

	mov	DX,Setup_102			;by writing POS2
	mov	al,001h
	out	dx,al

	mov	dx,VSEnable
	mov	al,008h
	out	dx,al
  else  ;(LOCAL_BUS_WAKE eq YES)
    ifndef (ADAPTER)				;if BIOS is on the motherboard
	MOV	DX,094H 			;Enable System board VGA
	MOV	AL,0DFH 			;Disable and select
	OUT	DX,AL				;VGA for setup
	MOV	AL,0FFH 			;Clear VGA sleep mode
	MOV	DX,Setup_102			;by writing POS2
	OUT	DX,AL
	MOV	DX,094H 			;by writing System board
	OUT	DX,AL				;select
    endif ;(ADAPTER)
	mov	dx,VSEnable
	mov	al,01h
	out	dx,al
  endif  ;(LOCAL_BUS_WAKE eq YES)
else	;(VSEnable eq 3C3h)
	MOV	BX,VSEnable			;Enable Adapter VGA
	MOV	DX,BX
	MOV	AX,0016H
	OUT	DX,AX
	MOV	DX,Setup_102			;Access global control reg
	MOV	Al,01H				;Wake up the VGA chip
	OUT	DX,AX				;and set VGA ID 0
	MOV	Al,0EH
	MOV	DX,BX
	OUT	DX,AX
	XOR	Al,Al
	MOV	DX,04AE8H
	OUT	DX,AX
endif	;(VSEnable eq 3C3h)

	POPF
	RET
Enable_VGA	ENDP

;****************************************************************
;   Monitor detection circuitry exists on the VGA adapter to
;   detect  if either a color, monochrome, or no monitor is
;   attached. The circuitry uses the approximate equations
;   for determining color and monochrome monitors:
;   ____
;   Mono	=  G/3 or R/2 or B/2
;   _____
;   Color	=  G/3 or R/3 or B/3
;   __________
;   No monitor	=  G/2 or R/2 or B/2
;
;   If the gun line is not present then Gun/2 will be driven
;   by the circuitry on the VGA adapter. If the gun is driven
;   by the monitor then Gun/3 will be present. Assuming a
;   threshold of approximately 5, test values can be written
;   to the red, green, and blue guns to determine if the gun
;   is used, thus determining the monitor type.
;
;   Exit:  Z - Valid monitor detected
;	  NZ - Monitor type not detected
;****************************************************************

Monitor_Type	PROC	NEAR
	CALL	Clear_DAC_Video 		;Clear DAC registers
	CALL	Determine_Analog_Monitor	;Determine Analog monitor type

;gdl:Do this here instead of in Determine_Analog so it can be more general.
	pushf
	cmp	bl,01h				;Mono monitor detected?
	jne	Monitor_Type_Done		;No, don't touch mono/gray
	OR	VGA_StatusA,VGA_Monochrome + Gray_Shades ;Assume monochrome
Monitor_Type_Done:
	popf
	RET					;Return Z/NZ
Monitor_Type	ENDP

;****************************************************************
;	   E X T E N D E D    M O D E	 S U P P O R T
;****************************************************************

if CL_SAVE_RESTORE eq NO
;****************************************************************
;   Restore extended registers
;
;   Entry:    CX - Requested States
;          ES:BX - Pointer to the buffer
;****************************************************************

Extended_Restore_State   PROC    NEAR
;        RET					;No support in this chipset
Extended_Restore_State   ENDP

;****************************************************************
;   Calculate the new size for saving extended registers
;
;   Entry: CX - Requested States
;          AX - Size already determined
;****************************************************************

Extended_Save_Size   PROC    NEAR
;        RET					;No support in this chipset
Extended_Save_Size   ENDP

;****************************************************************
;   Save extended registers
;
;   Entry:    CX - Requested States
;          ES:BX - Pointer to the buffer
;****************************************************************

Extended_Save_State   PROC    NEAR
        RET					;No support in this chipset
Extended_Save_State   ENDP

endif	;CL_SAVE_RESTORE eq NO

;****************************************************************
;   Text Scroll Up One Line
;****************************************************************
Text_Scroll_Up_One_Line:

	push	es
	mov	di,Video_Start			;Regen buffer segment address
	mov	si,Video_Columns		;get #columns
	mov 	dx,si				;save #columns
	shl	si,1				;2 bytes per character
	add	si,di				;add reglen
	mov	al,Video_Rows			;get #rows-1
	mov	ah,byte ptr Video_Columns	;get #columns
	mul	ah				;columns * rows
	mov	cx,ax				;#words to move
	
	mov	ax,0b800h			;video memory for color text
	cmp	Video_Mode,7			;monochrome mode?
	jne	Text_Do_Scroll_Up 		;no, prepare to scroll
	mov	ah,0b0h				;video memory for mono mode 

Text_Do_Scroll_Up:
	mov	es,ax				;ES = video memory
	mov	ds,ax				;DS = video memory
	rep	movsw				;start scrolling

Text_Clear_Last_Line:
	mov	cx,dx				;#words to fill
	mov	al,' '                          ;Fill with blank space
	mov	ah,bh				;screen attribute
	rep	stosw				;fill it quickly

	pop	es
	ret
;	jmp	Scroll_Up_One_Line_Done

;****************************************************************
;   Scroll Up One Line
;****************************************************************
Scroll_Up_One_Line PROC NEAR

	call	is_graphics			;graphics modes ?
	jz	Text_Scroll_Up_One_Line		;no, go handle text modes

	mov	dx,3C4h			;Check SR04:Memory Mode
	mov	al,04h
	call	getreg
	push	ax			;Save SR04.

	mov	si,Video_Columns	;get #columns

	test	ah,08h			;16-color or 256-color mode?
	jz	Scroll16OneLine		;16-color

Scroll256OneLine:
	cmp	Video_Mode,13h
	jne	Scroll16OneLine

	shl	si,1			;*2 for 256-color
	shl	si,1			;*4 for 256-color
	shl	si,1			;*8 for 256-color
;***	shft_l	si,2
	jmp	short PrepScroll

Scroll16OneLine:
	and	ah,not 08h		;Force to 4-plane memory organization
	setreg

	mov	dl,Low(3CEh)		;Get GR05:Write Mode
	mov	al,05h
	call	getreg
	push	ax			;Save GR05:Write Mode
	and	ah,not 03h
	or	ah,01h			;Set Write Mode 1 for screen-to-screen
	setreg

	mov	ch,ah			;Save GR05

  if (SCROLL_BANDWIDTH_BUG eq YES)
	mov	dx,SEQIDX
	mov	al,08h		;SR08:EEPROM Ctrl
      	call	getreg		;Read it
	push	dx
	push	ax
	or	ah,40h		;disable 16-bit RAM decode
	setreg			;Set it
  endif ; (SCROLL_BANDWIDTH_BUG eq YES)

	mov	dx,GFXIDX
	mov	al,09h			;Set GR09: Memory Window A Control
	call	getreg
	push	ax			;Save old contents
	xor	ah,ah			;Start at first 64K
	setreg

	mov	al,0Bh
	call	getreg
	push	ax

	test	ch,40h
	jz	PrepScrollSetMapMask
	mov	ah,0Eh
	setreg
PrepScrollSetMapMask:
	mov	dl,Low(SEQIDX)
	mov	ax,0FF02h
	setreg

PrepScroll:
	mov	di,Video_Start		;Regen buffer segment address
;	xor	di,di			;di = offset of upper left 

	mov	ax,si			;get #columns
	mul	Char_Length		;Multiply by char length
	mov	si,ax			;si = offset of 2nd line

	push	si			;Save size of a row
	add	si,di			;SI points to regen buffer

	mov	cl,Video_Rows		;get #rows-1
	xor	ch,ch
	mul	cx			;DL:AX = 4-byte groups to move
	mov	bp,ax
	mov	bl,dl			;BL:BP = 4-byte groups to move
					;si = offset of 2nd line
					;di = offset of upper left
	xor	ah,ah			;ah = starting page = 0
	mov	dx,GFXIDX		;DX is loaded for paging, etc

	mov	cx,0A000h		;DS: and ES: set to screen memory
	mov	es,cx
	mov	ds,cx

DoScrollLoop:
	mov	cx,si			;Calc how far to end of 64K window
	neg	cx			; which is 10000h - SI
	or	bl,bl			;Check to see if we have a BIG count
	jnz	DoScrollMove		;Yep, big, so adjust count and move

	cmp	cx,bp			;We have a small count.  Figure out
	jbe	DoScrollMove		; how much is left

	mov	cx,bp			;We are doing the last leg now.

DoScrollMove:
	sub	bp,cx			;Adjust huge count in BL:BP
	sbb	bl,0

	rep	movsb			;Move a chunk

	or	bl,bl			;Any more left?
	jnz	ScrollMoveAdjust	;Yes, adjust and continue
	or	bp,bp			;Any more left?
	jz	DoScrollDone		;No, prepare to clear last line

ScrollMoveAdjust:
	add	ah,0Fh			;Slide window by 64K-4K
	call	is_16k_granularity
	jz	forget_2mb_mode
	sub	ah,12
forget_2mb_mode:
	mov	al,09h
	setreg

	mov	si,1000h		;SI is adjusted to new source
	and	di,0FFFh		;DI is adjusted to new destination

	jmp	short DoScrollLoop	;Go around again

DoScrollDone:
	pop	cx			;CX = 4-byte groups to clear
					;DI = line to clear
	mov	bx,di			;Figure out how close we are to the
	add	bx,cx			;Segment boundary.
	jnc	DoScrollOneClear1Seg	;Not even close. Just fill it.

	inc	ah			;Slide by another 4K to get a
	mov	al,09h			; contiguous window
	setreg
	sub	di,1000h		;Adjust fill offset appropriately

DoScrollOneClear1Seg:
;v0.08B5	comment % #5434(6)#{
;	mov	dx,3CEh
;	mov	al,05h			;GR05: Write Mode
;	call	getreg
;	push	ax			;v0.08B5
;	and	ah,not 03h		;Write Mode 0 for filling memory
;	setreg
;v0.08B5	#5434(6)#} %
	xor	ax,ax			;Fill with 0
	mov	ds,ax
	rep	stosb			;Clear line
;v0.08B5{
;	pop	ax
;	setreg
;v0.08B5}
	cmp	Video_Mode,13h
	je	CleanUpScoll

	mov	dl,Low(GFXIDX)

	pop	ax			;Restore GR0B
	setreg

	pop	ax			;Restore GR09
	setreg

  if (SCROLL_BANDWIDTH_BUG eq YES)
  	pop	ax		;restore SR08
	pop	dx
	setreg			;Set it
  endif ; (SCROLL_BANDWIDTH_BUG eq YES)

	mov	dl,Low(3CEh)
	pop	ax			;Restore GR05
	setreg

CleanUpScoll:

if not((CHIP_TYPE eq CL6410) or (CHIP_TYPE eq GenericVGA))
	mov	dl,Low(3C4h)
	pop	ax			;Restore SR04
	setreg
endif	;not((CHIP_TYPE eq CL6410) or (CHIP_TYPE eq GenericVGA))

	ret

Scroll_Up_One_Line ENDP

;****************************************************************
;   Extended Video Scroll Up function
;****************************************************************

Extended_Scroll_Up:
if (MAXMEMSIZE gt 256)
	test	bl,EVM_Packed
	jnz	Extended_256_Color_Scroll_Up
endif	;(MAXMEMSIZE gt 256)
	JMP	Default_VGA_Scroll_Up

if (MAXMEMSIZE gt 256)
Extended_256_Color_Scroll_Up:
	jmp	VGA_Scroll_Up
endif	;(MAXMEMSIZE gt 256)

;****************************************************************
;   Extended Video Scroll Down Function
;****************************************************************

Extended_Scroll_Down:
if (MAXMEMSIZE gt 256)
	test	bl,EVM_Packed
	jnz	Extended_256_Color_Scroll_Down
endif	;(MAXMEMSIZE gt 256)
	JMP	Default_VGA_Scroll_Down

if (MAXMEMSIZE gt 256)
Extended_256_Color_Scroll_Down:
	jmp	VGA_Scroll_Down 
endif	;(MAXMEMSIZE gt 256)

;****************************************************************
;   Extended Read Dot Function
;****************************************************************

ERD_Unknown_Mode:
	MOV	AH,0DH				;Restore function number
	POP	DS				;Restore global register
	IRET

Extended_Read_Dot:
	XCHG	AL,AH				;Get mode number in AL
	call	Get_Current_Mode_Info		;Get info on current mode
	XCHG	AL,AH				;Restore AL
	TEST	AH,EVM_Text			;Is it extended text mode?
	JNE	ERD_Unknown_Mode		;Yes, bail out
if (MAXMEMSIZE eq 256)
	JMP	VGA_Read_Dot
else	;(MAXMEMSIZE eq 256)
	test	ah,EVM_Packed			;Packed pixel mode ?
	jne	Extended_Packed_Read_Dot	;yes

;****************************************************************
;  Extended 16-color Read Dot
;****************************************************************
Extended_Planar_Read_Dot:
	PUSH	SI
	PUSH	BX
	PUSH	CX
	PUSH	DX				;Save Read Dot registers

EDefault_VGA_Read_Dot:
	MOV	SI,CX				;Compute offset in SI
	SHR	SI,1				;Divide by 8 since
	SHR	SI,1				;there are eight pixels
	SHR	SI,1				;per byte
	OR	BH,BH				;Are we page zero
	JNE	EAdd_PageRD			;No -Compute page offset

ECont_PageRD:
	MOV	AX,Video_columns		;Get row position
	MUL	DX				;Compute row offset
	ADD	SI,AX				;Add row offset into BX
	adc	dl,0
	call	Set64KPage			;set the page

EDo_Extended_Read_Dot:
	AND	CL,07				;Mask lower bits
	MOV	BL,080H 			;Shift to position
	SHR	BL,CL				;Shift down to position
	MOV	DS,Segment_A000 		;Setup DS to video regen
	MOV	DX,Graphics_Controller
	XOR	CL,CL				;CL will contain color
	MOV	AX,0304H			;Read from plane 3 to plane 0

ERead_VGA_Bits:
	OUT	DX,AX				;Write map select register
	MOV	CH,[SI] 			;Read the pixel
	AND	CH,BL				;Isolate the bit
	NEG	CH				;Set carry if bit is a one
	ROL	CX,1				;Roll into return value
	DEC	AH				;Decrement plane count
	JNS	ERead_VGA_Bits			;Repeat for 4 planes
	MOV	AL,CL				;Return pixel color in AL
	MOV	AH,0DH				;Restore function number in AH
	POP	DX				;Restore registers
	POP	CX
	POP	BX
	POP	SI
	POP	DS				;Restore global register
	IRET


EAdd_PageRD:
	ADD	SI,Video_Length 		;Add for next page
	DEC	BH				;Decrement counter
	JNE	EAdd_PageRD			;Repeat for each page
	JMP	SHORT ECont_PageRD

;****************************************************************
;  Extended 256-color Read Dot
;****************************************************************
Extended_Packed_Read_Dot:

	push	es				; save registers
	push	di
	push	dx

	mov	ax,0a000h			; video memory segment
	mov	es,ax				; setup for ES:DI read
	mov	ax,Video_Columns   		; get bytes/scanline
	shl	ax,1				; multiply #columns
	shl	ax,1				; by 8 to get the 
	shl	ax,1				; bytes per scanline
;** use macro to shift to save spaces
;***	shft_l	ax,3

	mul	dx				; compute start of line
	add	ax,cx				; add offset to pixel
	adc	dl,0
	call	Set64KPage			; set the page
	mov	di,ax				; set for read
	mov	al,es:[di] 			; get pixel
	mov	ah,0Dh				; Restore function number

	pop	dx				; restore registers
	pop	di
	pop	es
	POP	DS				; restore global DS
	IRET
endif	;(MAXMEMSIZE eq 256)

;****************************************************************
;   Extended Write Dot Function
;****************************************************************

EWD_Unknown_Mode:
	MOV	AH,0CH				;Restore function number
	POP	DS				;Restore callers DS
	IRET

Extended_Write_Dot:
	XCHG	AL,AH				;Get mode number in AL
	call	Get_Current_Mode_Info		;Get info on current mode
	XCHG	AL,AH				;Restore AL
	TEST	AH,EVM_Text			;Is it extended text mode?
	JNE	EWD_Unknown_Mode		;Yes, bail out
if (MAXMEMSIZE eq 256)
	JMP	VGA_Write_Dot
else	;(MAXMEMSIZE eq 256)

	test	ah,EVM_Packed			;Packed pixel mode ?
	jne	Extended_Packed_Write_Dot	;yes

;****************************************************************
;  Extended 16-color Write Dot
;****************************************************************
Extended_Planar_Write_Dot:

	PUSH	BX
	PUSH	CX
	PUSH	DX				;Save Write Dot registers

EDefault_VGA_Write_Dot:
	XCHG	BX,CX				;Keep offset in BX
	MOV	CL,BL				;CL=bit position, CH=Page number
	SHR	BX,1				;Divide offset by
	SHR	BX,1				;eight since there
	SHR	BX,1				;are 8 pixels/byte

	OR	CH,CH				;Are we page zero
	JNE	EAdd_PageWD			;No -Go compute page offset

ECont_PageWD:
	MOV	CH,AL				;Save pixel value in CH
	MOV	AX,Video_columns		;Get row position
	MUL	DX				;Compute row offset
	ADD	BX,AX				;Add row offset into BX
	adc	dl,0
	call	Set64KPage			;Set the page

EDo_Extended_Write_Dot:
	MOV	DX,SEQIDX			; Must set all pages every 
	MOV	AL,02h				; time!
	CALL	GETREG
	OR	AH,0Fh
	SETREG
	MOV	DX,Graphics_Controller
	XOR	AX,AX
	OUT	DX,AX				;Clear set/reset register
	MOV	AX,00F01H
	OUT	DX,AX				;Enable all Set/Reset Regs
	AND	CL,07H				;Isolate offset within byte
	MOV	AX,08008H			;Get mask and bit mask reg
	SHR	AH,CL				;Adjust bit mask
	OUT	DX,AX				;Set bit mask register
	MOV	AX,0A000H			;THIS ALSO SETS AL=00
	MOV	DS,AX				;Setup DS to video regen
	OR	CH,CH				;Test for XOR function
	JS	EDo_XOR_Dot			;Yes-Go to XOR function
	OR	[BX],AL 			;Clear old color
	MOV	AH,CH				;Get new color
	OUT	DX,AX				;Select new mask
	OR	[BX],AL 			;Set new color

EExit_Write_VGA_Dot:
	MOV	AX,0FF08H
	OUT	DX,AX				;Set bit mask back to FFH
	XOR	AX,AX				;Set set/reset bits to zero
	OUT	DX,AX
	INC	AL
	OUT	DX,AX				;Clear enable set/reset reg
	MOV	AL,CH				;Return dot in AL
	MOV	AH,0CH				;Restore Function number
	POP	DX				;Restore registers
	POP	CX
	POP	BX
	POP	DS				;Restore global DS
	IRET


EAdd_PageWD:
	ADD	BX,Video_Length 		;Add for next page
	DEC	CH				;Decrement counter
	JNE	EAdd_PageWD			;Next page
	JMP	SHORT ECont_PageWD


EDo_XOR_Dot:
	MOV	AX,01803H
	OUT	DX,AX				;Set XOR operation
	MOV	AH,CH				;Get current pixel value
	XOR	AL,AL				;Get set/reset reg index
	OUT	DX,AX				;Put color in Set/reset reg
	OR	[BX],AL 			;XOR the bits in color patern
	MOV	AX,0003H			;Clear XOR function from
	OUT	DX,AX				;the Data Rotate reg
	JMP	EExit_Write_VGA_Dot

;****************************************************************
;  Extended 256-color Write Dot
;****************************************************************
Extended_Packed_Write_Dot:

	push	es
	push	di
	push	ax
	push	dx

	mov	di,ax				; Save dot to write
	mov	ax,0a000h			; video memory segment
	mov	es,ax				; setup for ES:DI write
	mov	ax,Video_Columns		; get bytes/scanline
	shl	ax,1				; multiply #columns
	shl	ax,1				; by 8 to get the 
	shl	ax,1				; bytes per scanline

	mul	dx				; compute start of line
	add	ax,cx				; add offset to pixel
	adc	dl,0
	call	Set64KPage			; set the page
	xchg	di,ax				; get ready to write dot
	mov	es:[di],al			; and write it

	pop	dx
	pop	ax
	pop	di
	pop	es
	pop	ds				; restore global DS
	IRET
endif	;(MAXMEMSIZE eq 256)

;****************************************************************
;   Extended Write Char Function
;****************************************************************

Extended_Write_Char:
	XCHG	AL,AH				;Get mode number in AL
	call	Get_Current_Mode_Info		;Get info on current mode
	XCHG	AL,AH				;Restore char to AL
	TEST	AH,EVM_Text			;Is it extended text mode?
	JE	EWC_Graphics			;No, handle extended graphics

EWC_Text:
	MOV	AH,3				;Yes, pretend it's mode 3
	JMP	Default_CGA_Write_Char		;and let standard code
						;handle it.
EWC_Unknown_Mode:
	JMP	Default_VGA_Write_Char		;Default to standard code
EWC_Graphics:
if (MAXMEMSIZE eq 256)
	JMP	Default_VGA_Write_Char
else	;(MAXMEMSIZE eq 256)
	test	ah,EVM_Packed			;Packed pixel mode ?
	je	Extended_Planar_Write_Char	;no
	jmp	Extended_Packed_Write_Char	;yes

;****************************************************************
;  Extended 16-color Write Char
;****************************************************************
Extended_Planar_Write_Char:
	MOV	SI,AX				;Save char code to write
	MOV	BP,CX				;Save character count

	MOV	AX,0A000H			;High res mode page
	MOV	ES,Segment_A000 		;Set high res
	MOV	AL,BH				;Get page number
	XOR	AH,AH				;Reset high byte
	SHL	AX,1				;Make word offset
	MOV	DI,AX				;Get page number
	MOV	AX,Cursor_Location[DI]		;Get cursor location
	MOV	DI,AX
	AND	DI,0FFH 			;Reset high byte
	MOV	AL,BYTE PTR Video_Columns	;Get number of columns
	MUL	AH				;Multiply by rows
	MUL	Char_Length			;Multiply by length
	ADD	DI,AX				;Set starting scan line
if (HAS_PAGED_MODES eq YES)
	adc	dl,0				;get the bank#
	push	dx				;save page # for later
endif ;(HAS_PAGED_MODES eq YES)
	MOV	DL,BL				;Save attribute byte

	MOV	CX,Char_Length			;Get length of character
	MOV	BX,Video_Columns		;Get width of line
	DEC	BX				;Decrement for add
	MOV	AX,SI				;Get character code
	MUL	BYTE PTR Char_Length		;Compute table position
	LDS	SI,DS:[43H*4]			;Get pointer to graphics
	ADD	SI,AX				;Add character offset

	MOV	AH,DL				;Get attribute color
	XOR	AL,AL				;Set bits to clear in set/reset reg
	MOV	DX,Graphics_Controller		;Setup graphics controller
	OUT	DX,AX				;Write set/reset reg
	INC	AL				;Move to enable reg
	NOT	AH				;Invert color for mask
	OUT	DX,AX				;Set enable for clear bits only

	MOV	DX,Sequencer
	MOV	AX,0F02H			;Enable all maps
	OUT	DX,AX				;Write to sequencer
if (HAS_PAGED_MODES eq YES)
	POP 	DX				;get page register value
Write_VGA_Character:
	call	Set64KPage			;and set it
	PUSH	SI				;Save font position
	PUSH	DI				;Save screen position
	MOV	AX,CX				;save character length

	MOVSB					;manually write first char out
	DEC	CX				;so last write doesnt inc page
Write_VGA_Char:
	cmp 	di,0				;did we just cross a boundry?
	jne 	no_inc_page			;no, dont increment page
	call	Inc64KPage			;yes, set the next bank
no_inc_page:
	ADD	DI,BX				;Next position
	jnc	L1				;we're still in the same bank
	call	Inc64KPage			;set the next bank
L1:	MOVSB					;Store byte
else  ;(HAS_PAGED_MODES eq YES)
Write_VGA_Character:
	PUSH	SI				;Save font position
	PUSH	DI				;Save screen position
	MOV	AX,CX				;save character length

Write_VGA_Char:
	MOVSB					;Store byte
	ADD	DI,BX				;Next position
endif ;(HAS_PAGED_MODES eq YES)
	LOOP	Write_VGA_Char			;Write character

	MOV	CX,AX				;restore the # of bytes
	POP	DI
	POP	SI
	INC	DI
	DEC	BP				;Decrement number of chars
	JNE	Write_VGA_Character		;Write the VGA next character
	MOV	AX,0003H			;Restore controller
	MOV	DX,Graphics_Controller
	OUT	DX,AX				;Write to graphics controller
	XOR	AX,AX
	OUT	DX,AX
	INC	AX
	OUT	DX,AX
	MOV	DS,INT_Address			;It wasn't-Check for user
	RET

;****************************************************************
;  Extended 256-color Write Char
;****************************************************************
Extended_Packed_Write_Char:
	push	bx
	xor	bh,bh				;no carry adjustment
	MOV	BP,CX				;Save number of chars
	MOV	CX,AX
	MOV	AX,0A000H			;High res mode page
	MOV	ES,AX				;Set high res
	MOV	AX,Cursor_Location[00]		;Get cursor location
	MOV	DI,AX				;Get column
	AND	DI,0FFH 			;Reset high byte
	MOV	AL,BYTE PTR Video_Columns
	MUL	AH
	MUL	Char_Length			;Multiply by length
	jnc	WNoCR
if (HAS_PAGED_MODES eq YES)
	mov	bh,dl				; BH = carry adjustment
	shl	bh,1				; adj may be > 1
	shl	bh,1				; (1 => 8, 2 => 10)
	shl	bh,1
else  ;(HAS_PAGED_MODES eq YES)
	mov	bh,8				;carry adjustment
endif ;(HAS_PAGED_MODES eq YES)
WNoCR:	ADD	DI,AX				;Set starting scan line
	mov	ax,8
	mov	dx,di
	mul	dx				;multiply by #bytes/char
	add	dl,bh				;adjust the bank
	mov	di,ax				;char offset
	pop	bx
if (HAS_PAGED_MODES eq YES)
	push 	dx				;save the bank #
endif ;(HAS_PAGED_MODES eq YES)

	MOV	AX,Char_Length			;Get size of character
	MOV	DX,AX				;DX is # of lines to write
	MUL	CL				;Compute char table offset
	MOV	DS,INT_Address			;No more access to BIOS data
	LDS	SI,DS:[43H*4]			;Get interrupt 43 pointer
	ADD	SI,AX				;Compute start of char

if (HAS_PAGED_MODES eq YES)
	pop 	ax				;ax = bank #
Write_Char_13_Loop:
	PUSH	DI				;Save regen offset
	PUSH	DX				;Save bytes per character
	push 	dx				;set the initial bank #
	mov 	dx,ax
	call 	set64kpage
	pop 	dx
	push 	ax				; and save value in ax
else  ;(HAS_PAGED_MODES eq YES)
Write_Char_13_Loop:
	PUSH	DI				;Save regen offset
	PUSH	DX				;Save bytes per character
endif ;(HAS_PAGED_MODES eq YES)
	
Write13_Line_Loop:
	MOV	CX,08				;Character is eight bytes wide
	MOV	AH,[SI] 			;Get byte from char table
	INC	SI				;Advance table pointer

Write13_Bit_Loop:
	RCL	AH,1				;Shift bit into carry
	MOV	AL,BL				;If set write forground
	JC	Write13_Forground		;Yes-Go write foreground
	MOV	AL,BH				;Otherwise write background

Write13_Forground:
	STOSB					;Write one dot of character
	LOOP	Write13_Bit_Loop		;Repeat for entire line
if (HAS_PAGED_MODES eq YES)
	or	di,di				;did we switched bank?
	jnz	W13F				;no,proceed then
	call	Inc64KPage			;set the next bank
W13F:
endif ;(HAS_PAGED_MODES eq YES)
	push	ds				;save DS
	push	ax
	xor	ax,ax
	mov	ds,ax
	mov	ax,Video_Columns		;get #columns
	dec	ax				;#columns -1
	shl	ax,1
	shl	ax,1
	shl	ax,1				;multiply by char_width

	add	di,ax				;next scanline
	pop	ax
	pop	ds				;restore DS
if (HAS_PAGED_MODES eq YES)
	jnc	Wr13				;we're still in the same bank

	cmp	dx,1				;Are we on last line?
	je	Wr13				;Don't skip to next page

	call	Inc64KPage			;set the next bank
Wr13:	DEC	DX				;Decrement line counter
	JNE	Write13_Line_Loop		;Write Char_Length lines
	POP 	AX				;Restore the current page #
else  ;(HAS_PAGED_MODES eq YES)
	DEC	DX				;Decrement line counter
	JNE	Write13_Line_Loop		;Write Char_Length lines
endif ;(HAS_PAGED_MODES eq YES)
	POP	DX				;Restore bytes per character
	POP	DI				;Restore regen pointer
	SUB	SI,DX
	ADD	DI,08				;Advance to next char pos
	DEC	BP				;Any characters left to write
	JNE	Write_Char_13_Loop		;Yes-Repeat for CX characters
	MOV	DS,INT_Address			;It wasn't-Check for user
	RET
endif	;(MAXMEMSIZE eq 256)

;****************************************************************
;   Extended Write Char and Attr Function
;****************************************************************

Extended_Write_Char_Attr:
	XCHG	AL,AH				;Get mode number in AL
	call	Get_Current_Mode_Info		;Get info on current mode
	XCHG	AL,AH				;Restore char to AL
	TEST	AH,EVM_Text			;Is it extended text mode?
	JE	EWCA_Graphics			;No, handle extended graphics

EWCA_Text:
	MOV	AH,3				;Yes, pretend it's mode 3
	JMP	Default_CGA_Write_Char_Attr	;and let standard code
						;handle it.
EWCA_Unknown_Mode:
	JMP	Default_VGA_Write_Char_Attr
EWCA_Graphics:
if (MAXMEMSIZE eq 256)
	JMP	Default_VGA_Write_Char_Attr
else	;(MAXMEMSIZE eq 256)
	test	ah,EVM_Packed			;Packed pixel mode ?
	je	Extended_Planar_Write_Char_Attr	;no
	jmp	short Extended_Packed_Write_Char_Attr	;yes

;****************************************************************
;  Extended 16-color Write Char Attr
;****************************************************************
Extended_Planar_Write_Char_Attr:
	jmp	Extended_Planar_Write_Char

;****************************************************************
;  Extended 256-color Write Char Attr
;****************************************************************
Extended_Packed_Write_Char_Attr:
	jmp	Extended_Packed_Write_Char
endif	;(MAXMEMSIZE eq 256)

;****************************************************************
;   Extended Read Char Function
;****************************************************************

Extended_Read_Char:
	XCHG	AL,AH				;Get mode number in AL
	call	Get_Current_Mode_Info		;Get info on current mode
	XCHG	AL,AH				;Restore char to AL
	TEST	AH,EVM_Text			;Is it extended text mode?
	JE	ERC_Graphics			;No, handle extended graphics

ERC_Text:
	MOV	AH,3				;Yes, pretend it's mode 3
	JMP	Default_CGA_Read_Char		;and let standard code
						;handle it.
ERC_Unknown_Mode:
	JMP	Default_VGA_Read_Char
ERC_Graphics:
	ret

;****************************************************************
;   Extended Mode Set Clear Screen Function
;****************************************************************

Extended_Clear_Video:
;BL = flags from Get_Extended_Mode_Info
;	D0    = 1=Text mode,  0=Graphics mode
;	D1    = 1=Color mode, 0=Mono mode
;	D2    = 1=Packed pixel, 0=Planar
;Upon entry here, we assume it's a sequential (16-color) or chain-4 (256-
;color) mode at A000.

if (MAXMEMSIZE eq 256)
	JMP	Default_Clear_Video
else	;(MAXMEMSIZE eq 256)
	call	GetMemSize		;al = # of 64K blocks
	test	bl,EVM_Packed		;4-planes or 1-plane?
	jnz	ECV_SetupClear		;1-plane => do each 64K block

	shr	al,1			;4-plane => do 256K blocks
	shr	al,1

ECV_SetupClear:
	mov	bx,0A000h		;Screen at A000:0000
	mov	es,bx
	xor	di,di			;ES:DI = A000:0000
	mov	bl,al			;BL = # of blocks to clear
	xor	bh,bh			;BH = first block (0)

	mov	cl,10h			; CL = normal incremental value
	call	is_16k_granularity
	jz	its_a_normal_mode	; no, use normal value
	mov	cl,004h			; CL = 2MB incremental value
its_a_normal_mode:

	mov	dx,GFXIDX		;DX = Extension index for paging
	mov	al,09h			;SR09: Addr Map Reg A
	call	getreg			;Get current
	push	ax			;Save SR09

ECV_ClearLoop:
	mov	al,09h			;SR09: Addr Map Reg A
	mov	ah,bh			;Get block number to index to
	setreg				;Set first 32K
	push	cx

	xor	ax,ax			;Fill with 00h
	mov	cx,8000h		;32K words

	rep	stosw			;Clear 32K words

	pop	cx
	add	bh,cl
	sub	bl,1			;Decrement loop count
	jnb	ECV_ClearLoop		;Go til < 0

	pop	ax			;Retrieve saved SR09
	setreg				;Restore it
	jmp	Clear_Screen_Exit
endif	;(MAXMEMSIZE eq 256)

;****************************************************************
;   This hook is called from the Mode Set (AH=00). Check if
;   emulation is active. If VGA or EGA is in effect let the
;   video BIOS handle the operation, otherwise emulate the
;   CGA/MDA/Hercules mode set operation.
;
;   Exit:  Z - VGA or EGA operation
;	  NZ - CGA/MDA/Hercules emulation (mode complete)
;****************************************************************
;****************************************************************
;   Called at the end of the mode command to restore the
;   write protected registers.
;****************************************************************

	PUBLIC	Check_Emulation_Mode
	PUBLIC	Restore_Write_Protect

Check_Emulation_Mode:
Restore_Write_Protect:
	ret

if 0
;-----------------------------------------------------------------------
;
;	save_stuc_bits()
;
;	Function:
;	   This function saves bits [4:3] of SR0F in SR0A[2:1].
;
;	Input:
;	   AH = SR0F Data
;	   AL = 0Fh
;	   DX = SEQIDX
;
;	Returns:
;	   Nothing
;
;	Remarks:
;
;-----------------------------------------------------------------------
	PUBLIC save_stuc_bits
save_stuc_bits proc near
	push	bx
	mov	bh,ah			; save value in BH
	and	bh,018h			; Save bits in scratch register
	shr	bh,1			; 00Ah[2:1] for future read, modify
	shr	bh,1			; write operations
	mov	al,SP_OPT2
	call	getreg
	and	ah,not 006h
	or	ah,bh
	setreg
	pop	bx
	ret
save_stuc_bits endp
endif	; 0

;-----------------------------------------------------------------------
;
;	Is_16K_Granularity()
;
;	Function:
;	   This function will test to see if GR0B[5] is set, indicating
;	wheather or not a 2MB mode with a different granularity is set.
;
;	Input:
;	   NOTHING
;
;	Returns:
;	   NZ - It is a 16K granularity
;	   Z - It is NOT a 16K granularity
;
;-----------------------------------------------------------------------
	Public Is_16K_Granularity
Is_16K_Granularity proc near
	push	ax
	push	dx
	mov	dx,GFXIDX
	mov	al,00Bh
	call	getreg
	test	ah,020h
	pop	dx
	pop	ax
	ret
Is_16K_Granularity endp

ifndef	(REMOVE_MEMORY_TEST)
  ifdef (MICROCHANNEL_ADAPTER)
	db	0		; dont have 55AA on offset 800
  endif ;(MICROCHANNEL_ADAPTER)
;****************************************************************
;   Test the extended memory on the video card. Memory is banked into
;   four planes and tested plane-wise for speed. A preliminary
;   check for memory is done before the complete test is done.
;
;   The first 256k will have been tested by the standard BIOS code
;   before we are called. We will test the 2nd, 3rd, etc. 256k pages
;   of video RAM.
;
;	Entry:	SI - 8000H
;		ES - A000H
;
;		Graphics Controller set for color-compare reads.
;
;	Exit:	 Z - Passed Test
;		NZ - Failed Test
;		BH - Total video memory passing tests
;		     0 -  256k (No extended pages available)
;		     1 -  512k (1 extended page)
;		     2 -  768k (2 extended page)
;		     3 - 1024k (3 extended page)
;****************************************************************
Extended_Test_Video_Memory	PROC	NEAR
	mov	dl,Low(SEQIDX)
	mov	al, 7
	call	getreg
	or	ah, 1			;ensure bit0 of SR07 is 1
	setreg
;
	mov	ch, 98h			;set to 64-bit, 4MB
	call	SetSR0F
	mov	ax, 0aa55h
	mov	word ptr es:[4],ax
	mov	word ptr es:[0],0	;flush buffer

	mov	ax,word ptr es:[4]	; read value
	cmp	ax, 0aa55h
	jz	Is2MBOr4MB

	mov	ch, 02h			;set to 1MB on scratch reg.
	call	AdjFor5430		;v1.10A4  512K for 5430
	call	SetSR15			;set to default 1MB in scratch reg.

	mov	ch, 10h			;set to 32-bit
	call	AdjFor5430		;v1.10A4  16-bit for 5430
	call	SetSR0F
;v1.10B	{
	mov	dl,Low(SEQIDX)
	mov	al, 7
	call	getreg
	and	ah,0FEh			;ensure b0 of SR07 is 0
	setreg
;v1.10B	}
	mov	si, 8000h		;32k words test
	call	Test_V_Memory
	ret				;return with ZF to tell if ok or not.
;
Is2MBOr4MB:
	mov	ch, 04h			;set to 4MB on scratch reg.
	call	Detect5430		;v1.10A4
	jnz	ItIs5434		;v1.10A4
	mov	ch, 03h			;v1.10A4  set 2MB for 5430
ItIs5434:				;v1.10A4
	call	SetSR15

	push	es
;;;;;;;;;;{ 11/24/93
	mov	al, 60h			;v0.05 1
	call	get_extended_mode	;v0.05 1  Is mode valid?
;v1.10A4mov	di, 0004h		;v0.05 1  points to odd dword
;;;;;;;;;;} 11/24/93
	mov	al, 60h			;set to test mode 60h
	call	set_mode_quietly
	pop	es

	mov	ch, 98h			;set to 64-bit, 4MB
	call	SetSR0F

	mov	dl, low(SEQIDX)
	mov	ax, 0F02h		;SR2, map 3-0 write enable
	setreg

	mov	dl, low(GFXIDX)
	mov	al, 0bh			;GR0B
	call	getreg
	push	ax			;save original GR0B index/value
	and	ah, not 3		; bit 1,0 = 0,0
	or	ah, 20h			;set to 16KB granularity
	setreg
					; Assume DX = GFXIDX
	mov	ax, 8009h		;GR9, points to start of 2MB
	call	Detect5430		;v1.10A4
	jnz	Is5434			;v1.10A4
	mov	ax, 4009h		;v1.10A4  bypass 1st meg. for 5430
Is5434:					;v1.10A4
	setreg
	mov	ax, 0001h		;GR1, disable SR
	setreg
	mov	ax, 0003h		;GR3, no rotate for write
	setreg

	mov	si,8			; 8 words
	call	Test_V_Memory		; Test validity of memory
;v1.10B5jz	Is4MBMem
;v1.10B5{
.386
	jnz	DoNextDataWidth
	mov	ax,0009h		; GR09 = 0
	out	dx,ax
	mov	si,8
	mov	eax,0BB66CC77h		; different pattern
	call	TestVideoRam
	jnz	DoNextDataWidth
	mov	ax,8009h		; GR09, points to start of 2MB
	call	Detect5430
	jnz	PgmGR09
	mov	ax,4009h		; bypass 1st meg. for 5430
PgmGR09:
	out	dx,ax
	mov	eax,dword ptr es:[0]	; read value
	cmp	eax,0AA55BB66h
	jz	Is4MBMem
DoNextDataWidth:
;v1.10B5}
	mov	ch, 03h			;set to 2MB on scratch reg.
	call	Detect5430		;v1.10A4
	jnz	It5434			;v1.10A4
	mov	ch, 02h			;v1.10A4  set 1MB for 5430
It5434:					;v1.10A4
	call	SetSR15
	mov	ch, 18h			;set to 64-bit, 2MB
	call	Detect5430		;v1.10A4
	jnz	Alpine5434		;v1.10A4
	mov	ch, 10h			;v1.10A4  set 32-bit for 5430
Alpine5434:				;v1.10A4
	call	SetSR0F

Is4MBMem:
	pop	ax			;restore GRB index/value
	mov	dl, low(GFXIDX)
	setreg

	mov	al, 9h			;GR9
	mov	ah, 00h			;points 00
	setreg

	xor	al, al			;return with successful flag
	ret	

;****************************************************************
SetSR15:
	mov	al,15h
	call	getscr
	and	ah,0F0h			;#5434(9)# clear MEMSIZE bitS
	or	ah,ch			; setup memory size 
	call	setscr			; done
	ret

;****************************************************************
SetSR0F:
  	mov	dx,SEQIDX
;#5434(1)# {
	mov	al, 1fh
	call	getreg
	push	ax
;#5434(1)# }
	mov	al,0Fh			; SR0F: DRAM Ctrl
	call	getreg			; Get memory width bits
	and	ah,not 98h		; mask off [7,4:3]
	or	ah,ch			; 
	setreg
;#5434(1)# {
	pop	ax
	setreg
;#5434(1)# }
	mov	cx, 800h
	loop	$			; a little delay
	ret

;****************************************************************
;v1.10A4{
AdjFor5430	proc	near
	call	Detect5430
	jnz	ItIsAlpine
	shr	ch,01h
ItIsAlpine:
	ret
AdjFor5430	endp
;v1.10A4}

;****************************************************************
Test_V_Memory:
;v1.10B5mov	ax,0AA55h
	mov	eax,0AA55BB66h
TestVideoRam:
	XOR	DI,DI				;Start at zero
	mov	cx,si
	shr	cx,1				;v1.10B5
;v1.10B5rep	stosw
	rep	stosd				;v1.10B5
;
	XOR	DI,DI				;Start at zero
	mov	cx,si
	shr	cx,1				;v1.10B5
;v1.10B5repe	scasw
	repe	scasd				;v1.10B5
TestRamDone:					;ZF = 1, pass
VideoRamFailed:
	ret
Extended_Test_Video_Memory	ENDP
.186
;-----------------------------------------------------------------------
;	Detect5430
;
;	Function: Detect if 5430 exists
;
;	Input:    Nothing
;	Returns:  ZF = 1 --- CL-GD5430 exists
;                 ZF = 0 --- CL-GD5430 does not exist
;-----------------------------------------------------------------------
public	Detect5430

Detect5430	proc	near
	push	dx
	push	ax
	mov	dx,03D4h
	mov	al,27h
	call	getreg
	and	ah,0FCh
	cmp	ah,0A0h			;5430's CR27 = A0h
	pop	ax
	pop	dx
	ret
Detect5430	endp

;-----------------------------------------------------------------------
;
;	set_mode_quietly()
;
;	Function:
;	   This function will do most of the work in a setmode but no
;	video enable will occur, thus allowing to test memory under the cover
;	of a black screen.
;
;	Input:
; 	   AL = Mode Number to set
;	   ES:SI = points to vid params
;
;	Returns:
;	   Nothing
;
;	Remarks:
;
;-----------------------------------------------------------------------
set_mode_quietly  proc near
	push	di
	push	ax			; presrve mode number
	call	set_vga_registers	; set std video parameters
	pop	ax

	call	get_ext_mode_idx	; return supp parms in ES:DI

	call	set_refresh_and_pixel_depth  ; fixup extended mode

	add	di,XMODE_REGS_EXTRA	; ptr to start of ext registers
 	mov	si,offset cgroup:xmode_regs

	push	ds			; program the extneded table
	push	cs			; our code segment
	pop	ds			; to data segment
clr_x_loop:
	lodsw
	cmp	al,Low(PELMASK)		; pixel mask?
	je	pgm_ext_done		; yes, dont turn video back on
	
	mov	dx,ax
	lodsw				; index to al, and_mask to ah

	mov	bh,ah			; save and_mask
	call	getreg			; read the register
	and	ah,bh			; apply and_mask
	or	ah,byte ptr es:[di]	; or on the data
	inc	di			; next or mask
	setreg
	jmp	short clr_x_loop	
pgm_ext_done:
	pop	ds			; restore data seg
	pop	di
	ret
set_mode_quietly  endp
endif	;(REMOVE_MEMORY_TEST)


;-----------------------------------------------------------------------
;
;	check_mem_size()
;
;	Input:
;	   ES =	A000
;
;	Returns:
;	   NZ  512K
;	   ZR  1MB
;
;	Remarks:
; 		This routine do a very basic memory R/W to figure out 
;		memory size for AVGA2M.
;		
;-----------------------------------------------------------------------
check_mem_size	proc	near

	push	es
	mov	ax,0a000h	;write 1st pattern A05A to first 512K
	mov	es,ax
	mov	al,5ah	
	mov	es:[0],ax

  	mov	dx,GFXIDX	;set to 2nd 512K
	mov	ax,8009h 	;gr09:offset register 0
	setreg			;try to address first word above 512K

	mov	es:[0],ax	;write 2nd pattern 55AA to 2nd 512K
	mov	ax,es:[0]
	cmp	ax,8009h	;physical memory exist?
	jnz	cms_ret		;nope, assume 512K

	; there is physical memory and try to identify memory wrap around
	xor	ah,ah 		;gr09:offset register 0
	setreg		

	mov	ax,es:[0]	;read it back
	cmp	ax,0a05ah	;same as 1st pattern?

cms_ret:
	pop	es
	ret

check_mem_size	endp

;****************************************************************
;	E X T E N D E D    B I O S     F U N C T I O N S
;****************************************************************
;   This is the extended BIOS function handler. All extended
;   VGA BIOS functions are handled through function 5FH. In
;   the standard VGA BIOS environment, there are not extended
;   BIOS functions.
;
;   Exit: Z  - Suppoted Extended BIOS function
;	  NZ - Unsupported extended BIOS function
;
;   Standard VGA does not support any extended functions
;****************************************************************

	PUBLIC	Extended_BIOS_Functions

Extended_BIOS_Functions PROC	NEAR
ifdef VESAVBEVERSION
	cmp	ah,4Fh
	jne	NotVesaFn
	jmp	VesaVBE
NotVesaFn:
endif	;VESAVBEVERSION
	OR	AL,0FFH
	RET
Extended_BIOS_Functions ENDP

;****************************************************************

VGA_Segment	ENDS

	END
