#if defined(PC_AT)
#define ESCSEQSTRSIZE 1024
#endif
#if defined(SUN) || defined(S32) || defined(PMAX) || defined(SUN3) || defined(SUN4)
#define ESCSEQSTRSIZE 512
#endif




/**************************************************************/
/*  ESCAPE SEQUENCE CODES                                     */
/**************************************************************/

/* These codes must match in the Pascal and the C code! */
/* these are pseudo-sequences; low numbers reserved for these.  ESCERROR
should always be 0 because then uninitialized things will probably map
to it.  ESCLOWEST is used for loops. */
#define ESCLOWEST 0
#define ESCERROR 0
#define ESCTEXT 1
#define ESCEOF 2

/* regular sequences, in alphabetical order. */
#define ESCCMD 3
#define ESCCPP 4
#define ESCCPR 5
#define ESCCUB 6
#define ESCCUD 7
#define ESCCUF 8
#define ESCCUP 9
#define ESCCUU 10
#define ESCDCH 11
#define ESCDCS 12
#define ESCDL 13
#define ESCED 14
#define ESCEL 15
#define ESCEND 16
#define ESCERRMSG 17
#define ESCICH 18
#define ESCIL 19
#define ESCIQUIT 20
#define ESCMC 21
#define ESCPL 22
#define ESCPPR 23
#define ESCPROMPT 24
#define ESCPUTINMENU 25
#define ESCRM 26
#define ESCRSM 27
#define ESCRVM 28
#define ESCSD 29
#define ESCSM 30
#define ESCST 31
#define ESCSU 32
#define ESCSVM 33
#define ESCWAKEUP 34
#define ESCGETFROMMENU 35

/* ESCHIGHEST is used in loops and is the same as the highest code. */
#define ESCHIGHEST 35

/**************************************************************/


/**************************************************************/



/* special characters */
#define ESCAPE ((char) 0x1B)

struct EscSeqBuf {
    int es_dataType;
    int es_x1;
    int es_x2;
    int es_y1;
    int es_y2;
    int es_num;
    int es_strlen;
    char *es_str;
};


