






#ifndef ER_EXPRESSION_H
#define ER_EXPRESSION_H
#include <stream.h>
#include "Clib/basictypes.h"
#ifdef PASCAL_XFACE
#include "pascal.h"
#else
#include "extern_global.h"
#endif

// The following is a define because const* generates an external ref instead of
// the static ref that it should.  I'm tired of the complaints from ld.
#define ERULE_DEFAULT_EXPRESSION  ((char*)(-1))

/*
    A selection expression.  Note --  null  expressions  and
    DEFAULT expressions always evaluate TRUE -- so check for
    default first.
*/
class erule_expression {
    friend ostream& operator<<(ostream&, const erule_expression&);
        // For debugging
    char* _expression;
public:
    erule_expression();
    erule_expression(const char*);
    ~erule_expression();
    const erule_expression& operator=(const char*);
    const erule_expression& operator=(const erule_expression&);
    boolean is_default();
    int evaluate();
    char* message();            // Suitable for error message -- xtring for
                                // PASCAL_XFACE, else char*.  Never null.
};

inline erule_expression::erule_expression() { _expression = 0; }
inline erule_expression::erule_expression(const char* e)
    { _expression = 0;  *this = e; }

inline boolean erule_expression::is_default()
    { return _expression == ERULE_DEFAULT_EXPRESSION; }

inline char* erule_expression::message()
#ifdef PASCAL_XFACE
    { return is_default() ? " 07DEFAULT" : _expression ? _expression : ""; }
#else
    { return is_default() ? "DEFAULT" : _expression ? _expression : ""; }
#endif


inline int erule_expression::evaluate()
{
#ifdef PASCAL_XFACE












    return _expression ? is_default() ? 1 : pascal_expression(_expression) : 1;
#else
    return _expression ? is_default() ? 1 : boolean_expression_evaluator(_expression) : 1;
#endif
}

#endif





















































