#ifndef STACK_M_INCLUDED
#define STACK_M_INCLUDED

#include "../misc/constants.h"
#include "stack.s.h"
#include "bds.m.h"

/*                M A N I P U L A T I N G      M A C R O S                    */

/*----------------------------------------------------------------------------*/

/* Null an SH_STACK; Null a DH_STACK */

#define SH_STACK_NULL SH_NULL
#define DH_STACK_NULL DH_NULL

/*----------------------------------------------------------------------------*/

/* Null an SSS structure */

#define SSS_NULL SL_NULL

/*----------------------------------------------------------------------------*/

/* Push onto the top of a simple-stack:

   rec_sss      ==> name within record of SSS member linking the stack.
   rec          ==> -> to the record containg the SSS member which is to be 
		    pushed onto the stack.
   hd_sh        ==> name within head record of SH member. 
   hd           ==> -> to the head record containing the SH.                 */

#define SH_SL_PUSH(rec_sss,rec,hd_sh,hd)\
{\
ADRCK(rec);\
as(!((rec)->rec_sss.fpl));\
ADRCK(hd);\
(rec)->rec_sss.fpl=(hd)->hd_sh.fp;\
(hd)->hd_sh.fp = (rec);\
}

#define SHO_SLO_PUSH(rec_sss,rec,type,hd_sh,hd)\
SH_SL_PUSH(rec_sss,rec,hd_sh,hd)


/*----------------------------------------------------------------------------*/

/* Pop a record from a simple-stack:

   rec_sss      ==> name within record of SSS member linking the stack.
   rec_type     ==> Type of record containing SSS member, i.e. name of 
		    structure.
   hd_sh        ==> name within head record of SH head. 
   hd           ==> -> to the head record containing the SH.

   NOTE: This can be used inside an "if" ex: if(top=SH_SL_POP(..))
   the expression returns the value of found (redundantly)

***Not assertion proofed.
                                                                              */
#define SH_SL_POP(rec_sss,found,hd_sh,hd)\
((\
    ((found) = (hd)->hd_sh.fp) ? \
	(((hd)->hd_sh.fp = (found)->rec_sss.fpl),(found)->rec_sss.fpl=NULL) :\
	0\
),found)

#define SHO_SLO_POP(rec_sss,found,type,hd_sh,hd)\
SH_SL_POP(rec_sss,found,hd_sh,hd)

/*----------------------------------------------------------------------------*/

/*
    SL operations -- operations on simple linked list (treated as a list,
    not a stack).
*/

#define SH_SL_FQUE(rec_sl, rec, rec_hd, hd)\
    SH_SL_PUSH(rec_sl, rec, rec_hd, hd)

/* prev -> previous record in the list, or NULL if rec is the first element */
#define SH_SL_PICK(rec_sl, rec, prev, rec_hd, hd) {\
    ADRCK(rec);  ADRCK(hd);\
    if (prev) {\
        as((prev)->rec_sl.fpl == (rec));\
	(prev)->rec_sl.fpl = (rec)->rec_sl.fpl;\
	}\
    else {\
        as((hd)->rec_hd.fp == (rec));\
	(hd)->rec_hd.fp = (rec)->rec_sl.fpl;\
	}\
    (rec)->rec_sl.fpl = NULL;\
}


/*----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Push onto the top of a simple-stack:

   rec_sss      ==> name within record of SSS member linking the stack.
   rec          ==> -> to the record containg the SSS member which is to be 
		    pushed onto the stack.
   hd_s_stack   ==> name within head record of S_STACK member. 
   hd           ==> -> to the head record containing the S_STACK.           */

#define DH_SL_TPUSH(rec_sss,rec,hd_s_stack,hd)\
{\
as(rec E);\
as(rec->rec_sss.fpl DNE);\
as(hd E);\
rec->rec_sss.fpl=hd->hd_s_stack.fp;\
hd->hd_s_stack.fp=rec;\
if(hd->hd_s_stack.bp DNE) hd->hd_s_stack.bp=rec;\
}

/*----------------------------------------------------------------------------*/

/* Push onto the bottom of a simple-stack:

   rec_sss      ==> name within record of SSS member linking the stack.
   rec          ==> -> to the record containg the SSS member which is to be 
		    pushed onto the stack.
   hd_s_stack   ==> name within head record of S_STACK head. 
   hd           ==> -> to the head record containing the S_STACK.

   Note: rec may be a list, being pushed onto the bottom of the stack. */

#define DH_SL_BPUSH(rec_sss,rec,hd_s_stack,hd)\
{\
as(rec E);\
as(hd E);\
hd->hd_s_stack.bp=hd->hd_s_stack.bp->rec_sss=rec;\
if(hd->hd_s_stack.fp DNE) hd->hd_s_stack.fp=rec;\
}

/*----------------------------------------------------------------------------*/

/* Pops a record from a simple-stack:

   rec_sss      ==> name within record of SSS member linking the stack.
   rec_type     ==> Type of record containing SSS member, i.e. name of 
		    structure.
   hd_s_stack   ==> name within head record of S_STACK head. 
   hd           ==> -> to the head record containing the S_STACK.

   NOTE: This must be used outside an if, ie top=S_POP(); not if(top=S_POP()) 

***Not assertion proofed.
                                                                              */
#define DH_SL_POP(rec_sss,rec_type,hd_s_stack,hd)\
\
hd->hd_s_stack.fp;\
{\
register struct rec_type *poped_rec;\
if((poped_rec=hd->hd_s_stack.fp) E) {\
     hd->hd_s_stack.fp=poped_rec->rec_sss.fpl;\
     poped_rec->rec_sss.fpl=NULL;\
     }\
else hd->hd_s_stack.bp=NULL;\
}

/*----------------------------------------------------------------------------*/

/* Null an M_STACK structure

   rec_m_stack    ==> name within record of M_STACK member (variable) to be
		      nulled.
   rec            ==> -> to record containing the M_STACK structure to be
		      nulled.
   null           ==> enumerated kind equivalent to a null value */

#define M_STACK_NULL(rec_m_stack,rec,null)\
{\
as(rec E);\
rec->rec_m_stack.fpl = rec->rec_m_stack.bp = NULL;\
rec->rec_m_stack.stru.f = rec->rec_m_stack.stru.b = null;\
}

/*----------------------------------------------------------------------------*/

/* Null an SMS structure

   rec_sms ==> name within record of SMS member (variable) to be nulled.
   rec     ==> -> to record containing the SMS structure to be nulled.
   null    ==> enumerated kind equivalent to a null value */

#define SMS_NULL(rec_sms,rec,null)\
{\
as(rec E);\
rec->rec_sms.fpl = NULL; rec->rec_sms.f = null;\
}

/*----------------------------------------------------------------------------*/

/* Push onto an M_STACK, ie one of any number of different record types 
			    onto the top of a stack.
   
   rec_sms     ==> name within record of SMS member linking the stack.
   rec         ==> -> to the record containing the SMS member to be pushed.
   rec_typ     ==> enumerated type of this record which is to be pushed 
		   onto the top of the stack:
		   This is one of the enumerated kinds of the SMS member.
   hd_m_stack  ==> name within head record of M_STACK head. 
   hd          ==> -> to the head record containing the M_STACK.*/

#define T_M_PUSH(rec_sms,rec,rec_typ,hd_m_stack,hd)\
{\
as(rec E);\
as(rec->rec_sms.fpl DNE);\
as(hd E);\
rec->rec_sms.fpl = hd->hd_m_stack.fp;\
rec->rec_sms.f = hd->hd_m_stack.stru.f;\
hd->hd_m_stack.fp = (struct anything *)rec;\
hd->hd_m_stack.stru.f = rec_typ;\
if(hd->hd_m_stack.bp DNE) {\
     hd->hd_m_stack.bp = (struct anything *)rec;\
     hd->hd_m_stack.stru.b = rec_typ;\
     }\
}

/*----------------------------------------------------------------------------*/

/* Push onto an M_STACK, ie one of any number of different record types 
			    onto the bottom of a stack.
   
   rec_sms    ==> name within record of SMS member linking the stack.
   rec        ==> -> to the record containing the SMS member to be pushed.
   rec_typ    ==> enumerated type of this record which is to be pushed 
		  onto the bottom of the stack:
		  This is one of the enumerated kinds of the SMS member.
   rec_str    ==> name of the record structure of the last record in
	          the stack.
   hd_m_stack ==> name within head record of M_STACK head. 
   hd         ==> -> to the head record containing the M_STACK.

   Note: The record being pushed may be a list.                         */

#define B_M_PUSH(rec_sms,rec,rec_typ,rec_str,hd_m_stack,hd)\
{\
as(rec E); as(hd E);\
((struct rec_str *)(hd->hd_m_stack.bp))->rec_sms.fpl = (struct anything *)rec;\
((struct rec_str *)(hd->hd_m_stack.bp))->rec_sms.f = rec_typ;\
hd->hd_m_stack.bp = (struct anything *)rec;\
hd->hd_m_stack.stru.b = rec_typ;\
if(hd->hd_m_stack.fp DNE) {\
     hd->hd_m_stack.fp = (struct anything *)rec;\
     hd->hd_m_stack.stru.f = rec_typ;\
     }\
}

/*----------------------------------------------------------------------------*/

/* Pop a record from a stack which may contain any number of different kinds
   of records.

   rec_sms    ==> name within record of SMS member linking the stack.
   rec_str    ==> name of the record structure which will be popped from
	          the stack.
   hd_m_stack ==> name within head record of M_STACK head. 
   hd         ==> -> to the head record containing the M_STACK.

***Not assertion proofed.
                                                                              */
#define M_POP(rec_sms,rec_str,hd_m_stack,hd)\
\
(struct rec_str *)(hd->hd_m_stack.fp);\
{\
register struct rec_str *xmtop;\
if((xmtop=(struct rec_str *)(hd->hd_m_stack.fp)) E) {\
     hd->hd_m_stack.stru.f=xmtop->rec_sms.f;\
     if((hd->hd_m_stack.fp=xmtop->rec_sms.fpl) DNE) {\
	  hd->hd_m_stack.stru.b=xmtop->rec_sms.f;\
          hd->hd_m_stack.bp=NULL;\
	  }\
     xmtop->rec_sms.fpl=NULL;\
     }\
}

/*----------------------------------------------------------------------------*/

/* Get the kind of record on the top of a m_stack stack

   hd_m_stack ==> name within head record of M_STACK head. 
   hd         ==> -> to the head record containing the M_STACK.

***Not assertion proofed.
                                                                              */
#define T_KINDM(hd_m_stack,hd)\
\
hd->hd_m_stack.stru.f

/*----------------------------------------------------------------------------*/

/* Get the kind of record on the bottom of a m_stack stack

   hd_m_stack ==> name within head record of M_STACK head. 
   hd         ==> -> to the head record containing the M_STACK.

***Not assertion proofed.
                                                                              */
#define B_KINDM(hd_m_stack,hd)\
\
hd->hd_m_stack.stru.b

/*----------------------------------------------------------------------------*/

/* stack memory manager

   stru_allocate ==> name of the allocate procedure made by this macro.
   rec_stk       ==> name within record of SSS member which links free records
		     in the stack.
   rec_type      ==> type of record to allocate.
   hd_pool        ==> name within head record of POOL member to which free
		     records will be stacked.
   hd_type       ==> type of the head record.
   Note: stru_allocate(has_one_parameter_which_is_a_->_to_the_record_which_the_pool_is_in)
									    */
#define Xallocate(stru_allocate,rec_stk,rec_type,hd_pool,hd_type,nalloc,cmemory,spop,spush,rv,voadrck,dirty)\
\
rec_type *stru_allocate(hd,arena)\
register hd_type  *hd;\
char             **arena;\
{\
char *cmemory();\
register char     **array;\
register rec_type  *rec;\
   voadrck(arena);\
   spop(rec_stk,rec,hd_pool,hd);\
   if (rec DNE) {\
	register int i;\
        array=(char **)cmemory(1,(unsigned)(nalloc*sizeof(*rec)+sizeof(char *)),arena);\
	if (array DNE)\
	     return(NULL);\
        *array = hd->hd_pool.pool;\
	rv((char *)array,hd->hd_pool.pool,char);\
        rec=(rec_type *)(array+1);\
        for(i=1; i<nalloc; i++) {\
	   spush(rec_stk,(rec+i),hd_pool,hd);\
	   }\
	}\
   return(rec);\
}

#define ALLOCATE(stru_allocate,rec_stk,rec_type,hd_pool,hd_type,nalloc,cmemory)\
\
Xallocate(stru_allocate,rec_stk,rec_type,hd_pool,hd_type,nalloc,cmemory,SH_SL_POP,SH_SL_PUSH,R_V,ADRCK,NOP)

#define ALLOCATEO(stru_allocate,rec_stk,rec_type,hd_pool,hd_type,nalloc,cmemory)\
ALLOCATE(stru_allocate,rec_stk,rec_type,hd_pool,hd_type,nalloc,cmemory)

/*----------------------------------------------------------------------------*/

/* Note: stru_deallocate(has_two_parameters_the_first_of_which_is_the_->_to
			 the_record_to_deallocate,
			 the_second_of_which_is_a_->_to_the_record_which_the
			 pool_is_in)                                          */

#define Xdeallocatenc(stru_deallocate,rec_stk,rec_type,hd_pool,hd_type,spush,roadrck,dirty)\
\
stru_deallocate(rec,hd)\
register rec_type *rec;\
register hd_type  *hd;\
{\
   spush(rec_stk,rec,hd_pool,hd);\
}

#define DEALLOCATENC(stru_deallocate,rec_stk,rec_type,hd_pool,hd_type)\
\
Xdeallocatenc(stru_deallocate,rec_stk,rec_type,hd_pool,hd_type,SH_SL_PUSH,ADRCK,NOP)

#define DEALLOCATENCO(stru_deallocate,rec_stk,rec_type,hd_pool,hd_type)\
DEALLOCATENC(stru_deallocate,rec_stk,rec_type,hd_pool,hd_type)

#ifdef DEBUGI
#define Xdeallocate(stru_deallocate,rec_stk,rec_type,hd_pool,hd_type,spush,roadrck,dirty)\
\
stru_deallocate(rec,hd)\
register rec_type *rec;\
register hd_type  *hd;\
{\
register int i;\
   roadrck(rec);\
   roadrck(hd);\
   for (i=0; i<sizeof(*rec)/sizeof(int); i++) {\
      as(((int *)rec)[i] == NULL);\
      }\
   spush(rec_stk,rec,rec_type,hd_pool,hd);\
}
#else
#define Xdeallocate Xdeallocatenc
#endif DEBUGI

#define DEALLOCATE(stru_deallocate,rec_stk,rec_type,hd_pool,hd_type)\
\
Xdeallocate(stru_deallocate,rec_stk,rec_type,hd_pool,hd_type,SH_SL_PUSH,ADRCK,NOP)

#define DEALLOCATEO(stru_deallocate,rec_stk,rec_type,hd_pool,hd_type)\
DEALLOCATE(stru_deallocate,rec_stk,rec_type,hd_pool,hd_type)

/*----------------------------------------------------------------------------*/

#define Xpool_free(hd_pool,hd,free,arena,vr,unlock)\
\
{\
register char **temp;\
while((temp=(char **)hd->hd_pool.pool) E) {\
   vr(temp,temp,char *,RO);\
   hd->hd_pool.pool= *temp;\
   free(temp,arena);\
   unlock(temp);\
   }\
}

#define POOL_FREE(hd_pool,hd,free,arena)\
\
Xpool_free(hd_pool,hd,free,arena,V_R,NOP)

#define POOL_FREEO(hd_pool,hd,free,arena)\
\
Xpool_free(hd_pool,hd,free,arena,VO_RO,UNLOCK)
   
/*----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
#endif
