.DS L
.PV
#ifndef ER_SPECIAL_H
#define ER_SPECIAL_H
#include "Clib/gring.h"
#include "Clib/stringt.h"
#include "er_heap.h"
.EP

.BC
Table of "special" models in which we are interested.
This is currently a ring (rather than an AVL tree) as we expect the number
of entries to be very small -- probably less than 3.
.EC
.PV
gring_define(_next,erule_special);
.EP
class erule_special {
.PV
    string _name;
    gring_inst(_next,erule_special);
.EP
public:
    erule_special(const string&);
    ~erule_special() { fault("~erule_special()"); }
    const string& name() { return _name; }

    void dump(ostream&);
};
.PV

#ifndef VAX
gring_inline(_next,erule_special);
#else
gring_functions(_next,erule_special,static);
#endif

inline erule_special::erule_special(const string& name) 
{
    AS(!this);
    this = (erule_special*)erule_heap.mem(sizeof(*this));
    _name = name;
}
#endif
.EP
.DE
