






#ifndef ER_LEX_H
#define ER_LEX_H
#include "Clib/smallset.h"
#include "Clib/parsebuf.h"
#include "Clib/GrowingBuf.h"
#include "er_heap.h"
#include "error.h"

/*
    Lexical analyzer for directives-type file -- does not do
    text macros.  Understands only END as a keyword.
*/
enum erule_symbol { LEX_EOF = 0,
                    LEX_END,
                    LEX_ID,
                    LEX_STRING,
                    LEX_INT,
                    LEX_COMMA,
                    LEX_EQ,
                    LEX_NE,
                    LEX_GT,
                    LEX_GE,
                    LEX_LT,
                    LEX_LE,
                    LEX_DOT,
                    LEX_SEMI,
                    LEX_LPAREN,
                    LEX_RPAREN,
                    LEX_COLON,
                    LEX_PLUS,
                    LEX_PERCENT,
                    LEX_MINUS,
                    LEX_DOTDOT,
                    LEX_COLONCOLON,
                    LEX_SENTINEL };

enum erule_lex_upshift { DONT_UPSHIFT = 0, UPSHIFT = 1 };

// Note there can be at most sizeof(unsigned long) different symbol kinds
// with the following class, as a "smallset" represents a set of symbols.

class erule_lex : parsebuf {
    int _max_id_length;
    erule_symbol token;
    GrowingBuf tok_buf;
    int _int_val;
    void double_token(char, char to_find, erule_symbol if_found);
    void double_token(char, char to_find1, erule_symbol if_found1,
                            char to_find2, erule_symbol if_found2);
    void char_error(int);
public:
    erule_lex(int max_id_length = 16);
    ~erule_lex() {}












    erule_lex* parse(const char* filename);
    const char* scald_file_type();      // Parses FILE_NAME=stuff and returns
                                        // stuff, with stuff being the current
                                        // token (for error messages)
    erule_symbol next_token(erule_lex_upshift upshift = UPSHIFT);
    erule_symbol operator erule_symbol();       // Current token value
    const char* val();                  // Good until next call to lex object
    int int_val();

    // For error handline
    void error(int);            // Reports error re. current token
    void assert(int);           // Reports assertion failure re. current token
                                // (for syntax errors in GED files)
    void skip(smallset);        // LEX_END and LEX_EOF are automatically added
    void skip_past(smallset);   // skip, then next_token() if in original set
    void skip_to_id(const char*);// Skips to specified identifier value (or
                                // LEX_END or LEX_EOF)
    void skip_past_id(const char*);// skip_to_id, then next_token() if there
    const char* line() { return current_line(); }
    int column() { return current_column(); }
    int lineno() { return current_lineno(); }
};

inline erule_lex* erule_lex::parse(const char* name)
{
    erule_lex* _val = (erule_lex*)parsebuf::open(name);
    if (_val) next_token();
    return _val;
}

inline const char* erule_lex::val() { return tok_buf; }
inline erule_lex::operator erule_symbol() { return token; }

inline void erule_lex::skip_past(smallset s)
    { skip(s); if (s[token]) next_token(); }
inline void erule_lex::skip_past_id(const char* id)
    { skip_to_id(id);  if (token == LEX_ID) next_token(); }

inline void erule_lex::error(int n)
    { erule_err.parse(n, filename(), line(), lineno(), column()); }
inline void erule_lex::assert(int n)
    { erule_err.assert(n, filename(), line(), lineno(), column()); }

inline int erule_lex::int_val() { return _int_val; }
#endif















