.DS L
.PV
#ifndef ER_ERULE_H
#define ER_ERULE_H
#include <stream.h>
#include "dwg_page.h"
.EP

.BC
This is the programmatic interface to the expansion rules package.
Including this .h file provides everything needed by a C++ user.
.EC
enum erule_filetype {	ERULE_UNDEF_FILETYPE,
			ERULE_CONNECTIVITY,
			ERULE_EXPANSION,
			ERULE_LIST,
			ERULE_LINKER_LIST,
			ERULE_SPECIAL,
			ERULE_SCHEMA };
class erule_selection {
.PV
    class erule_drawing_entry* _drawing;
    class erule_drawing_extension* _extension;
    boolean _extension_forced_to_primitive;
    class erule_drawing_special* _special;
.EP
public:
    erule_selection(char* drawing_name, class text_macro_table* context);
    ~erule_selection();
    char* special(); // 0 if no special selected
    char* extension(); // 0 if no drawing selected
    int version();

    char* filename(erule_filetype, unsigned page, char* context);

    erule_drawing_page* first_page();
    erule_drawing_page* next_page(erule_drawing_page*);

    boolean force_to_primitive();
	// TRUE iff non-PRIM/PART extension that is to be forced to primitive
    boolean is_primitive();
	// TRUE iff PRIM/PART || forced_to_primitive || has special model
    int is_simple_primitive();
	// TRUE iff PRIM/PART extension and single-versioned and single-paged
	// Return 0 iff FALSE, page number iff TRUE

    boolean same_directory(erule_selection* other);
	// TRUE iff same drawing from same SCALD directory
};


.BC
This class sets up the table.  For now a compile type must be specified
at setup.  Later it may become part of the selection criteria, with all
understood types being entered in the table.
.EC
class erule {
public:
    erule(const string& compile_type);
    boolean read(char* filename);
    boolean except(const string& compile_type, const string& drawing, 
		   const string& extension, const string& attribute);

    void dump(ostream&); // Dump tables for debugging purposes 
};
.PV

inline boolean erule_selection::force_to_primitive()
    { return _extension_forced_to_primitive; }

#ifdef PASCAL_XFACE
#ifndef INLINE_ERULE_XFACE
//#define INLINE_ERULE_XFACE 1
#endif
#endif

#if ERULE_C || INLINE_ERULE_XFACE
#include "er_heap.h"
#include "dwg_special.h"
#include "dwg_page.h"
#include "dwg_extension.h"
#include "dwg_version.h"	// Needed for _extension->version_number below
#ifdef INLINE_ERULE_XFACE
#define inline_or_not inline
#else
#define inline_or_not
#endif
inline_or_not char* erule_selection::special()
    { string v;  if (_special) v = _special->name();  return v; }

inline_or_not char* erule_selection::extension()
    { string v;  if (_extension) v = _extension->name();  return v; }

inline_or_not int erule_selection::version()
    { return _extension ? _extension->version_number() : 0; }

inline_or_not erule_drawing_page* erule_selection::first_page()
{ 
    return _extension ? _extension->first_page() : 0;
}

inline_or_not erule_drawing_page*
erule_selection::next_page(erule_drawing_page *page)
{ 
    return _extension ? _extension->next_page(page) : 0;
}

inline_or_not
erule_selection::~erule_selection()
    { erule_heap.memfree(this, sizeof(*this));  this = 0; }
#undef inline_or_not
#endif
#endif
.EP
.DE
